/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.potions.ModelOverlayRenderer;
import com.emoniph.witchery.brewing.potions.PotionResizing;
import com.emoniph.witchery.client.TransformBat;
import com.emoniph.witchery.client.TransformOtherPlayer;
import com.emoniph.witchery.client.TransformWolf;
import com.emoniph.witchery.client.TransformWolfman;
import com.emoniph.witchery.client.model.ModelGrotesque;
import com.emoniph.witchery.client.renderer.RenderOtherPlayer;
import com.emoniph.witchery.client.renderer.RenderVillagerBed;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.ExtendedVillager;
import com.emoniph.witchery.common.Shapeshift;
import com.emoniph.witchery.dimension.WorldProviderDreamWorld;
import com.emoniph.witchery.entity.EntityVillageGuard;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.InfusionOtherwhere;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.RenderUtil;
import com.emoniph.witchery.util.TransformCreature;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class ClientEvents {
    private static final ResourceLocation BLOODDROP_BG = new ResourceLocation("witchery:textures/gui/bdropfaded.png");
    private static final ResourceLocation BLOODDROP = new ResourceLocation("witchery:textures/gui/bdrop.png");
    private static final ModelGrotesque DEMON_HEAD_MODEL = new ModelGrotesque();
    private static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/entities/Demon.png");
    TransformWolf wolf = new TransformWolf();
    TransformWolfman wolfman = new TransformWolfman();
    TransformBat bat = new TransformBat();
    TransformOtherPlayer otherPlayer = new TransformOtherPlayer();
    RenderVillagerBed renderBed = new RenderVillagerBed();
    private static final ResourceLocation wolfSkin = new ResourceLocation("witchery", "textures/entities/werewolf_man.png");

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        Minecraft mc = Minecraft.getMinecraft();
        ExtendedPlayer playerEx = ExtendedPlayer.get((EntityPlayer)mc.thePlayer);
        if (playerEx.isVampire() && event.dwheel != 0) {
            int MAXPOWER = playerEx.getMaxAvailablePowerOrdinal();
            if (mc.thePlayer.inventory.currentItem == 0) {
                int power = playerEx.getSelectedVampirePower().ordinal();
                if (event.dwheel > 0) {
                    if (power == MAXPOWER) {
                        playerEx.setSelectedVampirePower(ExtendedPlayer.VampirePower.NONE, true);
                    } else {
                        playerEx.setSelectedVampirePower(ExtendedPlayer.VampirePower.values()[power + 1], true);
                        event.setCanceled(true);
                    }
                } else if (power > 0) {
                    playerEx.setSelectedVampirePower(ExtendedPlayer.VampirePower.values()[power - 1], true);
                    event.setCanceled(true);
                }
            } else if (mc.thePlayer.inventory.currentItem == 8 && event.dwheel < 0) {
                playerEx.setSelectedVampirePower(ExtendedPlayer.VampirePower.values()[MAXPOWER], true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        switch (event.type) {
            case HOTBAR: {
                GUIOverlay.INSTANCE.renderHotbar(event);
                break;
            }
            case TEXT: {
                int i;
                EntityPlayer targetPlayer;
                ExtendedPlayer targetPlayerEx;
                MovingObjectPosition movingPosition;
                int j;
                EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
                ExtendedPlayer playerEx = ExtendedPlayer.get((EntityPlayer)player);
                if (!playerEx.isVampire()) break;
                float left = Config.instance().guiOnLeft ? 10.0f : (float)(event.resolution.getScaledWidth() - 10);
                float top = (float)event.resolution.getScaledHeight() * 0.5f + 16.0f;
                int maxBlood = playerEx.getMaxBloodPower();
                int pscale = 250;
                Minecraft.getMinecraft().renderEngine.bindTexture(BLOODDROP_BG);
                for (j = 0; j < maxBlood / 250; ++j) {
                    ClientEvents.drawTexturedRect(left, top - (float)(j * 8), 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                }
                Minecraft.getMinecraft().renderEngine.bindTexture(BLOODDROP);
                int pblood = playerEx.getBloodPower();
                for (j = 0; j < pblood / 250; ++j) {
                    ClientEvents.drawTexturedRect(left, top - (float)(j * 8), 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                }
                if (pblood % 250 > 0) {
                    float remainder = 8.0f * ((float)pblood % 250.0f) / 250.0f;
                    ClientEvents.drawTexturedRect(left, top - (float)(j * 8) + 8.0f - remainder, 0.0f, 8.0f - remainder, 8.0f, remainder, 8.0f, 8.0f);
                }
                if ((movingPosition = InfusionOtherwhere.raytraceEntities((World)Minecraft.getMinecraft().theWorld, (EntityPlayer)Minecraft.getMinecraft().thePlayer, true, 5.0)) == null || movingPosition.entityHit == null) break;
                int blood = -1;
                if (movingPosition.entityHit instanceof EntityVillager) {
                    EntityVillager villager = (EntityVillager)movingPosition.entityHit;
                    ExtendedVillager villagerEx = ExtendedVillager.get(villager);
                    if (villagerEx.isClientSynced()) {
                        blood = villagerEx.getBlood();
                    }
                } else if (movingPosition.entityHit instanceof EntityVillageGuard) {
                    EntityVillageGuard guard = (EntityVillageGuard)movingPosition.entityHit;
                    blood = guard.getBlood();
                } else if (movingPosition.entityHit instanceof EntityPlayer && !(targetPlayerEx = ExtendedPlayer.get(targetPlayer = (EntityPlayer)movingPosition.entityHit)).isVampire()) {
                    blood = targetPlayerEx.getHumanBlood();
                }
                if (blood < 0) break;
                int tscale = 25;
                int percent = (int)((float)blood / 500.0f * 100.0f);
                float midX = event.resolution.getScaledWidth() / 2;
                float midY = event.resolution.getScaledHeight() / 2;
                Minecraft.getMinecraft().renderEngine.bindTexture(BLOODDROP_BG);
                for (i = 0; i < 4; ++i) {
                    ClientEvents.drawTexturedRect(midX - 16.0f + (float)(i * 8), midY + 10.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                }
                Minecraft.getMinecraft().renderEngine.bindTexture(BLOODDROP);
                for (i = 0; i < percent / 25; ++i) {
                    ClientEvents.drawTexturedRect(midX - 16.0f + (float)(i * 8), midY + 10.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                }
                if (percent % 25 > 0) {
                    float remainder = 8.0f * ((float)percent % 25.0f) / 25.0f;
                    float scale = remainder / 8.0f;
                    float offset = 8.0f - remainder;
                    ClientEvents.drawTexturedRect(midX - 16.0f + (float)(i * 8), midY + 10.0f + offset, 0.0f, offset, 8.0f, remainder, 8.0f, 8.0f);
                }
                if (!Config.instance().hudShowVampireTargetBloodText) break;
                float scale = 0.5f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                String text = String.format("%d/%d", blood, 500);
                int width = RenderManager.instance.getFontRenderer().getStringWidth(text);
                RenderManager.instance.getFontRenderer().drawString(text, (int)((float)(event.resolution.getScaledWidth() / 2 - width / 4) / scale), (int)((float)(event.resolution.getScaledHeight() / 2 + 22) / scale), 0xCC0000);
                GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
                break;
            }
        }
    }

    private static void drawTexturedRect(float p_146110_0_, float p_146110_1_, float p_146110_2_, float p_146110_3_, float p_146110_4_, float p_146110_5_, float p_146110_6_, float p_146110_7_) {
        float f4 = 1.0f / p_146110_6_;
        float f5 = 1.0f / p_146110_7_;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)p_146110_0_, (double)(p_146110_1_ + p_146110_5_), 0.0, (double)(p_146110_2_ * f4), (double)((p_146110_3_ + p_146110_5_) * f5));
        tessellator.addVertexWithUV((double)(p_146110_0_ + p_146110_4_), (double)(p_146110_1_ + p_146110_5_), 0.0, (double)((p_146110_2_ + p_146110_4_) * f4), (double)((p_146110_3_ + p_146110_5_) * f5));
        tessellator.addVertexWithUV((double)(p_146110_0_ + p_146110_4_), (double)p_146110_1_, 0.0, (double)((p_146110_2_ + p_146110_4_) * f4), (double)(p_146110_3_ * f5));
        tessellator.addVertexWithUV((double)p_146110_0_, (double)p_146110_1_, 0.0, (double)(p_146110_2_ * f4), (double)(p_146110_3_ * f5));
        tessellator.draw();
    }

    @SubscribeEvent
    public void onSetArmorModel(RenderPlayerEvent.SetArmorModel event) {
        EntityPlayer player = event.entityPlayer;
        if (!player.isInvisible() && Infusion.getNBT((Entity)player).hasKey("witcheryGrotesque")) {
            GL11.glPushMatrix();
            Minecraft mc = Minecraft.getMinecraft();
            mc.getTextureManager().bindTexture(TEXTURE);
            float par9 = event.partialRenderTick;
            float f6 = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * par9;
            float f2 = this.interpolateRotation(player.prevRenderYawOffset, player.renderYawOffset, par9);
            float f3 = this.interpolateRotation(player.prevRotationYawHead, player.rotationYawHead, par9);
            DEMON_HEAD_MODEL.render((Entity)event.entityPlayer, 0.0f, 0.0f, 0.0f, f3 - f2, f6, 0.0625f);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            Shapeshift.INSTANCE.updateJump(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerPreRender(RenderLivingEvent.Pre event) {
        if (event.entity instanceof EntityVillager) {
            ExtendedVillager ext = ExtendedVillager.get((EntityVillager)event.entity);
            GL11.glPushMatrix();
            if (ext != null && ext.isSleeping()) {
                GL11.glTranslated((double)event.x, (double)event.y, (double)event.z);
                this.renderBed.render((float)event.x, (float)event.y, (float)event.z, 0);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslated((double)0.5, (double)-1.25, (double)0.0);
                event.entity.setRotationYawHead(90.0f);
                GL11.glTranslated((double)(-event.x), (double)(-event.y), (double)(-event.z));
            }
        } else if (event.entity instanceof EntityPlayer) {
            ExtendedPlayer playerEx;
            int creatureType;
            EntityPlayer player = (EntityPlayer)event.entity;
            if (WorldProviderDreamWorld.getPlayerIsGhost(Infusion.getNBT((Entity)player))) {
                RenderUtil.blend(true);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.51f);
            }
            if ((creatureType = (playerEx = ExtendedPlayer.get(player)).getCreatureTypeOrdinal()) > 0 && !(event.renderer instanceof RenderOtherPlayer)) {
                float partialTicks;
                event.setCanceled(true);
                PotionEffect pe = player.getActivePotionEffect(Witchery.Potions.RESIZING);
                if (pe != null) {
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)event.x, (double)event.y, (double)event.z);
                    float scale = PotionResizing.getModifiedScaleFactor((EntityLivingBase)player, pe.getAmplifier());
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    GL11.glTranslated((double)(-event.x), (double)(-event.y), (double)(-event.z));
                }
                boolean gui = player.rotationYawHead == player.rotationYaw && player.prevRotationYawHead == player.rotationYaw && RenderManager.instance.playerViewY == 180.0f && Minecraft.getMinecraft().currentScreen != null;
                float f = partialTicks = gui ? 0.0f : ModelOverlayRenderer.getRenderPartialTicks();
                if (creatureType == 1) {
                    this.wolf.render(event.entity.worldObj, event.entity, event.x, event.y, event.z, event.renderer, partialTicks, gui);
                } else if (creatureType == 2) {
                    this.wolfman.render(event.entity.worldObj, event.entity, event.x, event.y, event.z, event.renderer, partialTicks, gui);
                } else if (creatureType == 3) {
                    this.bat.render(event.entity.worldObj, event.entity, event.x, event.y, event.z, event.renderer, partialTicks, gui);
                } else if (creatureType == 4 && playerEx.getOtherPlayerSkin() != null && !playerEx.getOtherPlayerSkin().equals("")) {
                    this.otherPlayer.render(event.entity.worldObj, event.entity, event.x, event.y, event.z, event.renderer, partialTicks, gui);
                }
                if (pe != null) {
                    GL11.glPopMatrix();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingSpecialsPre(RenderLivingEvent.Specials.Pre event) {
        EntityPlayer player;
        ExtendedPlayer playerEx;
        if (!event.isCanceled() && Config.instance().allowNameplateMasquerading && event.entity instanceof EntityPlayer && (playerEx = ExtendedPlayer.get(player = (EntityPlayer)event.entity)).getCreatureType() == TransformCreature.PLAYER) {
            event.setCanceled(true);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            EntityLivingBase p_77033_1_ = event.entity;
            double p_77033_2_ = event.x;
            double p_77033_4_ = event.y;
            double p_77033_6_ = event.z;
            RenderManager renderManager = RenderManager.instance;
            if (Minecraft.isGuiEnabled() && p_77033_1_ != renderManager.livingPlayer && !p_77033_1_.isInvisibleToPlayer((EntityPlayer)Minecraft.getMinecraft().thePlayer) && p_77033_1_.riddenByEntity == null) {
                float f2;
                float f = 1.6f;
                float f1 = 0.016666668f * f;
                double d3 = p_77033_1_.getDistanceSqToEntity((Entity)renderManager.livingPlayer);
                float f3 = f2 = p_77033_1_.isSneaking() ? 32.0f : 64.0f;
                if (d3 < (double)(f2 * f2)) {
                    String skin = playerEx.getOtherPlayerSkin();
                    if (skin == null || skin.isEmpty()) {
                        return;
                    }
                    String s = new ChatComponentText(skin).getFormattedText();
                    if (p_77033_1_.isSneaking()) {
                        FontRenderer fontrenderer = renderManager.getFontRenderer();
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)((float)p_77033_2_ + 0.0f), (float)((float)p_77033_4_ + p_77033_1_.height + 0.5f), (float)((float)p_77033_6_));
                        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(-renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                        GL11.glDisable((int)2896);
                        GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                        GL11.glDepthMask((boolean)false);
                        GL11.glEnable((int)3042);
                        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                        Tessellator tessellator = Tessellator.instance;
                        GL11.glDisable((int)3553);
                        tessellator.startDrawingQuads();
                        int i = fontrenderer.getStringWidth(s) / 2;
                        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                        tessellator.addVertex((double)(-i - 1), -1.0, 0.0);
                        tessellator.addVertex((double)(-i - 1), 8.0, 0.0);
                        tessellator.addVertex((double)(i + 1), 8.0, 0.0);
                        tessellator.addVertex((double)(i + 1), -1.0, 0.0);
                        tessellator.draw();
                        GL11.glEnable((int)3553);
                        GL11.glDepthMask((boolean)true);
                        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                        GL11.glEnable((int)2896);
                        GL11.glDisable((int)3042);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                    } else {
                        this.func_96449_a(p_77033_1_, p_77033_2_, p_77033_4_, p_77033_6_, s, f1, d3);
                    }
                }
            }
        }
    }

    protected void func_96449_a(EntityLivingBase p_96449_1_, double p_96449_2_, double p_96449_4_, double p_96449_6_, String p_96449_8_, float p_96449_9_, double p_96449_10_) {
        if (!p_96449_1_.isPlayerSleeping()) {
            this.func_147906_a((Entity)p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_, p_96449_6_, 64);
        }
    }

    protected void func_147906_a(Entity p_147906_1_, String p_147906_2_, double p_147906_3_, double p_147906_5_, double p_147906_7_, int p_147906_9_) {
        RenderManager renderManager = RenderManager.instance;
        double d3 = p_147906_1_.getDistanceSqToEntity((Entity)renderManager.livingPlayer);
        if (d3 <= (double)(p_147906_9_ * p_147906_9_)) {
            FontRenderer fontrenderer = renderManager.getFontRenderer();
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)p_147906_3_ + 0.0f), (float)((float)p_147906_5_ + p_147906_1_.height + 0.5f), (float)((float)p_147906_7_));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.instance;
            int b0 = 0;
            if (p_147906_2_.equals("deadmau5")) {
                b0 = -10;
            }
            GL11.glDisable((int)3553);
            tessellator.startDrawingQuads();
            int j = fontrenderer.getStringWidth(p_147906_2_) / 2;
            tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
            tessellator.addVertex((double)(-j - 1), (double)(-1 + b0), 0.0);
            tessellator.addVertex((double)(-j - 1), (double)(8 + b0), 0.0);
            tessellator.addVertex((double)(j + 1), (double)(8 + b0), 0.0);
            tessellator.addVertex((double)(j + 1), (double)(-1 + b0), 0.0);
            tessellator.draw();
            GL11.glEnable((int)3553);
            fontrenderer.drawString(p_147906_2_, -fontrenderer.getStringWidth(p_147906_2_) / 2, b0, 0x20FFFFFF);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            fontrenderer.drawString(p_147906_2_, -fontrenderer.getStringWidth(p_147906_2_) / 2, b0, -1);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onPlayerPostRender(RenderLivingEvent.Post event) {
        EntityPlayer player;
        if (event.entity instanceof EntityVillager) {
            GL11.glPopMatrix();
        } else if (event.entity instanceof EntityPlayer && WorldProviderDreamWorld.getPlayerIsGhost(Infusion.getNBT((Entity)(player = (EntityPlayer)event.entity)))) {
            RenderUtil.blend(false);
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        Minecraft mc = Minecraft.getMinecraft();
        ExtendedPlayer playerEx = ExtendedPlayer.get((EntityPlayer)mc.thePlayer);
        TransformCreature creatureType = playerEx.getCreatureType();
        if (creatureType != TransformCreature.NONE && (mc.thePlayer.getHeldItem() == null || creatureType != TransformCreature.WOLFMAN && creatureType != TransformCreature.PLAYER)) {
            event.setCanceled(true);
            this.renderArm(event.renderPass, event.partialTicks, mc, mc.thePlayer.getHeldItem() != null, creatureType, playerEx);
        }
    }

    public void renderArm(int renderPass, float partialTicks, Minecraft mc, boolean hasItem, TransformCreature creatureType, ExtendedPlayer playerEx) {
        GL11.glClear((int)256);
        float farPlaneDistance = mc.gameSettings.renderDistanceChunks * 16;
        double cameraZoom = 1.0;
        double cameraYaw = 0.0;
        double cameraPitch = 0.0;
        if (mc.entityRenderer.debugViewDirection <= 0) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            float f1 = 0.07f;
            if (mc.gameSettings.anaglyph) {
                GL11.glTranslatef((float)((float)(-(renderPass * 2 - 1)) * f1), (float)0.0f, (float)0.0f);
            }
            if (cameraZoom != 1.0) {
                GL11.glTranslatef((float)((float)cameraYaw), (float)((float)(-cameraPitch)), (float)0.0f);
                GL11.glScaled((double)cameraZoom, (double)cameraZoom, (double)1.0);
            }
            Project.gluPerspective((float)this.getFOVModifier(partialTicks, mc.entityRenderer, mc), (float)((float)mc.displayWidth / (float)mc.displayHeight), (float)0.05f, (float)(farPlaneDistance * 2.0f));
            if (mc.playerController.enableEverythingIsScrewedUpMode()) {
                float f2 = 0.6666667f;
                GL11.glScalef((float)1.0f, (float)f2, (float)1.0f);
            }
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            if (mc.gameSettings.anaglyph) {
                GL11.glTranslatef((float)((float)(renderPass * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
            }
            GL11.glPushMatrix();
            this.hurtCameraEffect(partialTicks, mc);
            if (mc.gameSettings.viewBobbing) {
                this.setupViewBobbing(partialTicks, mc);
            }
            if (!(mc.gameSettings.thirdPersonView != 0 || mc.renderViewEntity.isPlayerSleeping() || mc.gameSettings.hideGUI || mc.playerController.enableEverythingIsScrewedUpMode())) {
                mc.entityRenderer.enableLightmap((double)partialTicks);
                if (hasItem && (creatureType == TransformCreature.WOLF || creatureType == TransformCreature.BAT)) {
                    if (mc.thePlayer.getItemInUseCount() == 0) {
                        GL11.glTranslatef((float)-0.4f, (float)0.1f, (float)0.0f);
                        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    mc.entityRenderer.itemRenderer.renderItemInFirstPerson(partialTicks);
                } else if (creatureType == TransformCreature.WOLF || creatureType == TransformCreature.PLAYER || creatureType == TransformCreature.WOLFMAN) {
                    this.renderEmptyHand(mc, partialTicks, creatureType, playerEx);
                }
                mc.entityRenderer.disableLightmap((double)partialTicks);
            }
            GL11.glPopMatrix();
            if (mc.gameSettings.thirdPersonView == 0 && !mc.renderViewEntity.isPlayerSleeping()) {
                mc.entityRenderer.itemRenderer.renderOverlays(partialTicks);
                this.hurtCameraEffect(partialTicks, mc);
            }
            if (mc.gameSettings.viewBobbing) {
                this.setupViewBobbing(partialTicks, mc);
            }
        }
    }

    private void renderEmptyHand(Minecraft mc, float p_78440_1_, TransformCreature creatureType, ExtendedPlayer playerEx) {
        float f1 = 1.0f;
        EntityClientPlayerMP entityclientplayermp = mc.thePlayer;
        float f2 = entityclientplayermp.prevRotationPitch + (entityclientplayermp.rotationPitch - entityclientplayermp.prevRotationPitch) * p_78440_1_;
        GL11.glPushMatrix();
        GL11.glRotatef((float)f2, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(entityclientplayermp.prevRotationYaw + (entityclientplayermp.rotationYaw - entityclientplayermp.prevRotationYaw) * p_78440_1_), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        EntityClientPlayerMP entityplayersp = entityclientplayermp;
        float f3 = entityplayersp.prevRenderArmPitch + (entityplayersp.renderArmPitch - entityplayersp.prevRenderArmPitch) * p_78440_1_;
        float f4 = entityplayersp.prevRenderArmYaw + (entityplayersp.renderArmYaw - entityplayersp.prevRenderArmYaw) * p_78440_1_;
        GL11.glRotatef((float)((entityclientplayermp.rotationPitch - f3) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((entityclientplayermp.rotationYaw - f4) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!entityclientplayermp.isInvisible()) {
            GL11.glPushMatrix();
            float f13 = 0.8f;
            float f5 = entityclientplayermp.getSwingProgress(p_78440_1_);
            float f6 = MathHelper.sin((float)(f5 * (float)Math.PI));
            float f7 = MathHelper.sin((float)(MathHelper.sqrt_float((float)f5) * (float)Math.PI));
            GL11.glTranslatef((float)(-f7 * 0.3f), (float)(MathHelper.sin((float)(MathHelper.sqrt_float((float)f5) * (float)Math.PI * 2.0f)) * 0.4f), (float)(-f6 * 0.4f));
            GL11.glTranslatef((float)(0.8f * f13), (float)(-0.75f * f13 - (1.0f - f1) * 0.6f), (float)(-0.9f * f13));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            f5 = entityclientplayermp.getSwingProgress(p_78440_1_);
            f6 = MathHelper.sin((float)(f5 * f5 * (float)Math.PI));
            f7 = MathHelper.sin((float)(MathHelper.sqrt_float((float)f5) * (float)Math.PI));
            GL11.glRotatef((float)(f7 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f6 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            if (creatureType == TransformCreature.WOLF) {
                float scale = 1.5f;
                GL11.glRotatef((float)30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)-0.3f, (float)0.1f, (float)-0.5f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)2.0f);
                mc.getTextureManager().bindTexture(wolfSkin);
            } else if (creatureType == TransformCreature.WOLFMAN) {
                mc.getTextureManager().bindTexture(wolfSkin);
            } else if (creatureType == TransformCreature.PLAYER) {
                mc.getTextureManager().bindTexture(playerEx.getLocationSkin());
            }
            GL11.glTranslatef((float)-1.0f, (float)3.6f, (float)3.5f);
            GL11.glRotatef((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)5.6f, (float)0.0f, (float)0.0f);
            Render render = RenderManager.instance.getEntityRenderObject((Entity)mc.thePlayer);
            RenderPlayer renderplayer = (RenderPlayer)render;
            float f10 = 1.0f;
            GL11.glScalef((float)f10, (float)f10, (float)f10);
            renderplayer.renderFirstPersonArm((EntityPlayer)mc.thePlayer);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
    }

    private void hurtCameraEffect(float p_78482_1_, Minecraft mc) {
        float f2;
        EntityLivingBase entitylivingbase = mc.renderViewEntity;
        float f1 = (float)entitylivingbase.hurtTime - p_78482_1_;
        if (entitylivingbase.getHealth() <= 0.0f) {
            f2 = (float)entitylivingbase.deathTime + p_78482_1_;
            GL11.glRotatef((float)(40.0f - 8000.0f / (f2 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (f1 >= 0.0f) {
            f1 /= (float)entitylivingbase.maxHurtTime;
            f1 = MathHelper.sin((float)(f1 * f1 * f1 * f1 * (float)Math.PI));
            f2 = entitylivingbase.attackedAtYaw;
            GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f1 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void setupViewBobbing(float p_78475_1_, Minecraft mc) {
        if (mc.renderViewEntity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)mc.renderViewEntity;
            float f1 = entityplayer.distanceWalkedModified - entityplayer.prevDistanceWalkedModified;
            float f2 = -(entityplayer.distanceWalkedModified + f1 * p_78475_1_);
            float f3 = entityplayer.prevCameraYaw + (entityplayer.cameraYaw - entityplayer.prevCameraYaw) * p_78475_1_;
            float f4 = entityplayer.prevCameraPitch + (entityplayer.cameraPitch - entityplayer.prevCameraPitch) * p_78475_1_;
            GL11.glTranslatef((float)(MathHelper.sin((float)(f2 * (float)Math.PI)) * f3 * 0.5f), (float)(-Math.abs(MathHelper.cos((float)(f2 * (float)Math.PI)) * f3)), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.sin((float)(f2 * (float)Math.PI)) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.cos((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private float getFOVModifier(float partialTicks, EntityRenderer er, Minecraft mc) {
        Block block;
        if (er.debugViewDirection > 0) {
            return 90.0f;
        }
        EntityLivingBase entityplayer = mc.renderViewEntity;
        float f1 = 70.0f;
        if (entityplayer.getHealth() <= 0.0f) {
            float f2 = (float)entityplayer.deathTime + partialTicks;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((block = ActiveRenderInfo.getBlockAtEntityViewpoint((World)mc.theWorld, (EntityLivingBase)entityplayer, (float)partialTicks)).getMaterial() == Material.water) {
            f1 = f1 * 60.0f / 70.0f;
        }
        return f1;
    }

    private float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    public static class GUIOverlay
    extends GuiIngame {
        public static final GUIOverlay INSTANCE = new GUIOverlay();
        private static final ResourceLocation WIDGITS = new ResourceLocation("textures/gui/widgets.png");
        private static final ResourceLocation TEETH = new ResourceLocation("witchery", "textures/items/vteeth.png");
        private static final ResourceLocation EYE = new ResourceLocation("witchery", "textures/items/veye.png");
        private static final ResourceLocation BAT = new ResourceLocation("witchery", "textures/items/vbat.png");
        private static final ResourceLocation RUN = new ResourceLocation("witchery", "textures/items/vspeed.png");
        private static final ResourceLocation FIST = new ResourceLocation("witchery", "textures/items/vfist.png");
        private static final ResourceLocation STORM = new ResourceLocation("witchery", "textures/items/vstorm.png");
        private static final ResourceLocation COFFIN = new ResourceLocation("witchery", "textures/items/vcoffin.png");
        private static final int WHITE = 0xFFFFFF;

        public GUIOverlay() {
            super(Minecraft.getMinecraft());
        }

        public void renderHotbar(RenderGameOverlayEvent.Pre event) {
            ExtendedPlayer playerEx = ExtendedPlayer.get((EntityPlayer)this.mc.thePlayer);
            if (playerEx.isVampire()) {
                int width = event.resolution.getScaledWidth();
                int height = event.resolution.getScaledHeight();
                this.mc.mcProfiler.startSection("actionBar");
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.renderEngine.bindTexture(WIDGITS);
                InventoryPlayer inv = this.mc.thePlayer.inventory;
                this.drawTexturedModalRect(width / 2 - 91, height - 22, 0, 0, 182, 22);
                int vpower = playerEx.getSelectedVampirePower().ordinal();
                if (vpower != 0) {
                    this.drawTexturedModalRect(width / 2 - 91 - 1 + -vpower * 20, height - 22 - 1, 0, 22, 24, 22);
                } else {
                    this.drawTexturedModalRect(width / 2 - 91 - 1 + inv.currentItem * 20, height - 22 - 1, 0, 22, 24, 22);
                }
                GL11.glDisable((int)3042);
                GL11.glEnable((int)32826);
                RenderHelper.enableGUIStandardItemLighting();
                this.zLevel += 50.0f;
                int x = width / 2 - 90 + -20 + 2;
                int z = height - 16 - 3;
                if (playerEx.getVampireLevel() >= 1) {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.mc.renderEngine.bindTexture(TEETH);
                    GUIOverlay.func_146110_a((int)x, (int)z, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                    if (playerEx.getVampireLevel() >= 2) {
                        x = width / 2 - 90 + -40 + 2;
                        this.mc.renderEngine.bindTexture(EYE);
                        GUIOverlay.func_146110_a((int)x, (int)z, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                        if (playerEx.getVampireLevel() >= 4) {
                            x = width / 2 - 90 + -60 + 2;
                            this.mc.renderEngine.bindTexture(RUN);
                            GUIOverlay.func_146110_a((int)x, (int)z, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                            if (playerEx.getVampireLevel() >= 7) {
                                x = width / 2 - 90 + -80 + 2;
                                this.mc.renderEngine.bindTexture(BAT);
                                GUIOverlay.func_146110_a((int)x, (int)z, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                                if (playerEx.getVampireLevel() >= 10) {
                                    x = width / 2 - 90 + -100 + 2;
                                    switch (playerEx.getVampireUltimate()) {
                                        case FARM: {
                                            this.mc.renderEngine.bindTexture(COFFIN);
                                            break;
                                        }
                                        case STORM: {
                                            this.mc.renderEngine.bindTexture(STORM);
                                            break;
                                        }
                                        default: {
                                            this.mc.renderEngine.bindTexture(FIST);
                                        }
                                    }
                                    if (playerEx.getVampireUltimateCharges() == 0 || playerEx.getVampireUltimate() == ExtendedPlayer.VampireUltimate.NONE) {
                                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                                        GUIOverlay.func_146110_a((int)x, (int)z, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                                    } else {
                                        GUIOverlay.func_146110_a((int)x, (int)z, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                                    }
                                }
                            }
                        }
                    }
                    GL11.glDisable((int)3042);
                }
                this.zLevel -= 50.0f;
                for (int i = 0; i < 9; ++i) {
                    x = width / 2 - 90 + i * 20 + 2;
                    z = height - 16 - 3;
                    this.renderInventorySlot(i, x, z, event.partialTicks);
                }
                RenderHelper.disableStandardItemLighting();
                GL11.glDisable((int)32826);
                this.mc.mcProfiler.endSection();
                this.renderToolHightlight(playerEx, width, height);
                event.setCanceled(true);
            }
        }

        protected void renderToolHightlight(ExtendedPlayer playerEx, int width, int height) {
            Minecraft mc = Minecraft.getMinecraft();
            if (mc.gameSettings.heldItemTooltips && --playerEx.highlightTicks > 0) {
                String name = "";
                switch (playerEx.getSelectedVampirePower()) {
                    case DRINK: {
                        name = Witchery.resource("witchery.vampirepower.feed");
                        break;
                    }
                    case MESMERIZE: {
                        name = Witchery.resource("witchery.vampirepower.eye");
                        break;
                    }
                    case SPEED: {
                        name = Witchery.resource("witchery.vampirepower.speed");
                        break;
                    }
                    case BAT: {
                        name = Witchery.resource("witchery.vampirepower.bat");
                        break;
                    }
                    case ULTIMATE: {
                        switch (playerEx.getVampireUltimate()) {
                            case NONE: {
                                name = String.format(Witchery.resource("witchery.vampirepower.unone"), playerEx.getVampireUltimateCharges());
                                break;
                            }
                            case FARM: {
                                name = String.format(Witchery.resource("witchery.vampirepower.uteleport"), playerEx.getVampireUltimateCharges());
                                break;
                            }
                            case SWARM: {
                                name = String.format(Witchery.resource("witchery.vampirepower.ubats"), playerEx.getVampireUltimateCharges());
                                break;
                            }
                            case STORM: {
                                name = String.format(Witchery.resource("witchery.vampirepower.ustorm"), playerEx.getVampireUltimateCharges());
                            }
                        }
                        break;
                    }
                }
                if (name.equals("")) {
                    return;
                }
                int opacity = (int)((float)playerEx.highlightTicks * 256.0f / 10.0f);
                if (opacity > 255) {
                    opacity = 255;
                }
                if (opacity > 0) {
                    int y = height - 69;
                    if (!mc.playerController.shouldDrawHUD()) {
                        y += 14;
                    }
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                    FontRenderer font = RenderManager.instance.getFontRenderer();
                    if (font != null) {
                        int x = (width - font.getStringWidth(name)) / 2;
                        font.drawStringWithShadow(name, x, y, 0xFFFFFF | opacity << 24);
                    }
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
            }
        }

        protected void renderExtraInventorySlot(ItemStack itemstack, int p_73832_2_, int p_73832_3_, float p_73832_4_) {
            if (itemstack != null) {
                float f1 = (float)itemstack.animationsToGo - p_73832_4_;
                if (f1 > 0.0f) {
                    GL11.glPushMatrix();
                    float f2 = 1.0f + f1 / 5.0f;
                    GL11.glTranslatef((float)(p_73832_2_ + 8), (float)(p_73832_3_ + 12), (float)0.0f);
                    GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
                    GL11.glTranslatef((float)(-(p_73832_2_ + 8)), (float)(-(p_73832_3_ + 12)), (float)0.0f);
                }
                itemRenderer.renderItemAndEffectIntoGUI(this.mc.fontRenderer, this.mc.getTextureManager(), itemstack, p_73832_2_, p_73832_3_);
                if (f1 > 0.0f) {
                    GL11.glPopMatrix();
                }
                itemRenderer.renderItemOverlayIntoGUI(this.mc.fontRenderer, this.mc.getTextureManager(), itemstack, p_73832_2_, p_73832_3_);
            }
        }
    }
}

