/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.model;

import com.emoniph.witchery.entity.EntityToad;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelToad
extends ModelBase {
    ModelRenderer head;
    ModelRenderer body;
    ModelRenderer armRight;
    ModelRenderer armLeft;
    ModelRenderer legRight;
    ModelRenderer legLeft;

    public ModelToad() {
        this.textureWidth = 32;
        this.textureHeight = 32;
        this.setTextureOffset("head.nose", 0, 5);
        this.setTextureOffset("head.eyeRight", 0, 0);
        this.setTextureOffset("head.eyeLeft", 8, 0);
        this.setTextureOffset("legRight.thighRight", 0, 20);
        this.setTextureOffset("legRight.footRight", 0, 26);
        this.setTextureOffset("legLeft.thighLeft", 11, 20);
        this.setTextureOffset("legLeft.footLeft", 0, 26);
        this.head = new ModelRenderer((ModelBase)this, "head");
        this.head.setRotationPoint(0.0f, 20.0f, -1.0f);
        this.setRotation(this.head, 0.0f, 0.0f, 0.0f);
        this.head.mirror = true;
        this.head.addBox("nose", -2.0f, -1.0f, -4.0f, 4, 2, 4);
        this.head.addBox("eyeRight", -2.5f, -3.0f, -3.0f, 2, 2, 2);
        this.head.addBox("eyeLeft", 0.5f, -3.0f, -3.0f, 2, 2, 2);
        this.body = new ModelRenderer((ModelBase)this, 0, 12);
        this.body.addBox(-2.0f, -1.0f, 0.0f, 4, 2, 5);
        this.body.setRotationPoint(0.0f, 20.0f, -1.0f);
        this.body.setTextureSize(32, 32);
        this.body.mirror = true;
        this.setRotation(this.body, -0.4833219f, 0.0f, 0.0f);
        this.armRight = new ModelRenderer((ModelBase)this, 13, 26);
        this.armRight.addBox(-1.0f, 0.0f, 0.0f, 1, 4, 1);
        this.armRight.setRotationPoint(-2.0f, 20.0f, -1.0f);
        this.armRight.setTextureSize(32, 32);
        this.armRight.mirror = true;
        this.setRotation(this.armRight, -0.3346075f, 0.0f, 0.0f);
        this.armLeft = new ModelRenderer((ModelBase)this, 18, 26);
        this.armLeft.addBox(0.0f, 0.0f, 0.0f, 1, 4, 1);
        this.armLeft.setRotationPoint(2.0f, 20.0f, -1.0f);
        this.armLeft.setTextureSize(32, 32);
        this.armLeft.mirror = true;
        this.setRotation(this.armLeft, -0.3346075f, 0.0f, 0.0f);
        this.legRight = new ModelRenderer((ModelBase)this, "legRight");
        this.legRight.setRotationPoint(-2.0f, 23.0f, 3.0f);
        this.setRotation(this.legRight, 0.0f, 0.0f, 0.0f);
        this.legRight.mirror = true;
        this.legRight.addBox("thighRight", -2.0f, -1.0f, -2.0f, 2, 2, 3);
        this.legRight.addBox("footRight", -3.0f, 1.0f, -4.0f, 3, 0, 3);
        this.legLeft = new ModelRenderer((ModelBase)this, "legLeft");
        this.legLeft.setRotationPoint(2.0f, 23.0f, 3.0f);
        this.setRotation(this.legLeft, 0.0f, 0.0f, 0.0f);
        this.legLeft.mirror = true;
        this.legLeft.addBox("thighLeft", 0.0f, -1.0f, -2.0f, 2, 2, 3);
        this.legLeft.addBox("footLeft", 0.0f, 1.0f, -4.0f, 3, 0, 3);
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.render(entity, f, f1, f2, f3, f4, f5);
        this.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        this.head.rotateAngleY = f3 / 57.295776f;
        this.head.rotateAngleX = f4 / 57.295776f;
        if (this.isChild) {
            float p6 = 2.0f;
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.5f / p6), (float)(1.5f / p6), (float)(1.5f / p6));
            GL11.glTranslatef((float)0.0f, (float)(10.0f * f5), (float)0.0f);
            this.head.render(f5);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / p6), (float)(1.0f / p6), (float)(1.0f / p6));
            GL11.glTranslatef((float)0.0f, (float)(24.0f * f5), (float)0.0f);
            this.body.render(f5);
            this.armRight.render(f5);
            this.armLeft.render(f5);
            this.legRight.render(f5);
            this.legLeft.render(f5);
            GL11.glPopMatrix();
        } else {
            this.head.render(f5);
            this.body.render(f5);
            this.armRight.render(f5);
            this.armLeft.render(f5);
            this.legRight.render(f5);
            this.legLeft.render(f5);
        }
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    }

    public void setLivingAnimations(EntityLivingBase par1EntityLivingBase, float par2, float par3, float par4) {
        EntityToad toad = (EntityToad)par1EntityLivingBase;
        if (toad.isSitting()) {
            this.legRight.rotateAngleX = this.legLeft.rotateAngleX = -0.3926991f;
        } else {
            this.legRight.rotateAngleX = this.legLeft.rotateAngleX = MathHelper.cos((float)(par2 * 0.6662f)) * 1.4f * par3 + ((double)par3 > 0.1 || (double)par3 < -0.1 ? 0.5f : 0.0f);
            this.armLeft.rotateAngleX = MathHelper.cos((float)(par2 * 0.6662f + (float)Math.PI)) * 1.4f * par3;
            this.armRight.rotateAngleX = MathHelper.cos((float)(par2 * 0.6662f)) * 1.4f * par3;
        }
    }
}

