/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.model;

import com.emoniph.witchery.entity.EntityReflection;
import com.emoniph.witchery.entity.EntityWolfman;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public class ModelWolfman
extends ModelBase {
    public ModelRenderer headMain;
    public ModelRenderer bodyUpper;
    public ModelRenderer legRightUpper;
    public ModelRenderer legLeftUpper;
    public ModelRenderer armLeft;
    public ModelRenderer armRight;
    public ModelRenderer tail;
    public ModelRenderer bodyLower;
    public ModelRenderer legRightLower;
    public ModelRenderer legLeftLower;
    public int heldItemLeft;
    public int heldItemRight;
    public boolean isSneak;
    public boolean aimedBow;

    public ModelWolfman() {
        this(0.0f);
    }

    public ModelWolfman(float scale) {
        this.textureWidth = 64;
        this.textureHeight = 64;
        float headScale = 0.05f;
        this.headMain = new ModelRenderer((ModelBase)this, 0, 0);
        this.headMain.addBox(-3.0f, -6.0f, -2.0f, 6, 6, 4, 0.05f);
        this.headMain.setRotationPoint(0.0f, 0.0f, -2.0f);
        float f = 0.0f;
        this.headMain.setTextureOffset(16, 14).addBox(-3.0f, -8.0f, 1.0f, 2, 2, 1, 0.0f);
        this.headMain.setTextureOffset(16, 14).addBox(1.0f, -8.0f, 1.0f, 2, 2, 1, 0.0f);
        this.headMain.setTextureOffset(0, 10).addBox(-1.5f, -3.1f, -5.0f, 3, 3, 4, 0.0f);
        this.bodyUpper = new ModelRenderer((ModelBase)this, 0, 35);
        this.bodyUpper.setRotationPoint(0.0f, -0.1f, -2.0f);
        this.bodyUpper.addBox(-5.0f, 0.0f, -3.9f, 10, 7, 8, scale);
        this.setRotateAngle(this.bodyUpper, 0.4098033f, 0.0f, 0.0f);
        this.bodyLower = new ModelRenderer((ModelBase)this, 3, 50);
        this.bodyLower.setRotationPoint(0.0f, 5.0f, -1.5f);
        this.bodyLower.addBox(-4.0f, 2.0f, -2.3f, 8, 7, 5, scale);
        this.bodyUpper.addChild(this.bodyLower);
        this.tail = new ModelRenderer((ModelBase)this, 55, 52);
        this.tail.setRotationPoint(0.0f, 11.9f, 3.6f);
        this.tail.addBox(-1.0f, 0.0f, -1.0f, 2, 10, 2, scale);
        this.setRotateAngle(this.tail, 0.59184116f, 0.0f, 0.0f);
        this.legLeftUpper = new ModelRenderer((ModelBase)this, 38, 0);
        this.legLeftUpper.mirror = true;
        this.legLeftUpper.setRotationPoint(2.0f, 12.0f, 0.0f);
        this.legLeftUpper.addBox(-2.0f, 0.0f, -2.0f, 4, 7, 4, scale);
        this.setRotateAngle(this.legLeftUpper, -0.4098033f, 0.0f, 0.0f);
        this.legLeftLower = new ModelRenderer((ModelBase)this, 38, 13);
        this.legLeftLower.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legLeftLower.addBox(-2.0f, 3.5f, 2.0f, 4, 8, 4, scale);
        this.legLeftUpper.addChild(this.legLeftLower);
        this.legRightUpper = new ModelRenderer((ModelBase)this, 38, 0);
        this.legRightUpper.setRotationPoint(-2.0f, 12.0f, 0.0f);
        this.legRightUpper.addBox(-2.0f, 0.0f, -2.0f, 4, 7, 4, scale);
        this.setRotateAngle(this.legRightUpper, -0.4098033f, 0.0f, 0.0f);
        this.legRightLower = new ModelRenderer((ModelBase)this, 38, 13);
        this.legRightLower.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legRightLower.addBox(-2.0f, 3.5f, 2.0f, 4, 8, 4, scale);
        this.legRightUpper.addChild(this.legRightLower);
        this.armLeft = new ModelRenderer((ModelBase)this, 38, 46);
        this.armLeft.mirror = true;
        this.armLeft.setRotationPoint(6.0f, 2.0f, 0.0f);
        this.armLeft.addBox(-1.0f, -2.0f, -2.0f, 4, 14, 4, scale);
        this.armRight = new ModelRenderer((ModelBase)this, 38, 46);
        this.armRight.setRotationPoint(-5.8f, 2.0f, 0.0f);
        this.armRight.addBox(-3.0f, -2.0f, -2.0f, 4, 14, 4, scale);
    }

    public void render(Entity entity, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float p_78088_7_) {
        this.setRotationAngles(p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, p_78088_7_, entity);
        this.headMain.render(p_78088_7_);
        this.bodyUpper.render(p_78088_7_);
        this.armRight.render(p_78088_7_);
        this.legLeftUpper.render(p_78088_7_);
        this.tail.render(p_78088_7_);
        this.armLeft.render(p_78088_7_);
        this.legRightUpper.render(p_78088_7_);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.rotateAngleX = x;
        modelRenderer.rotateAngleY = y;
        modelRenderer.rotateAngleZ = z;
    }

    public void setLivingAnimations(EntityLivingBase entity, float par2, float par3, float par4) {
        float i = 0.0f;
        if (entity instanceof EntityWolfman) {
            EntityWolfman wolfman = (EntityWolfman)entity;
            i = wolfman.getAttackTimer();
            this.isRiding = wolfman.isSitting();
        } else if (entity instanceof EntityReflection) {
            EntityReflection wolfman = (EntityReflection)entity;
            i = wolfman.getAttackTimer();
        }
        if (i > 0.0f) {
            this.armRight.rotateAngleX = -2.0f + 1.5f * this.interpolateRotation(i - par4, 10.0f);
            this.armLeft.rotateAngleX = -1.0f + 0.9f * this.interpolateRotation(i - par4, 10.0f);
        } else {
            this.armRight.rotateAngleX = MathHelper.cos((float)(par2 * 0.6662f + (float)Math.PI)) * 2.0f * par3 * 0.5f;
            this.armLeft.rotateAngleX = MathHelper.cos((float)(par2 * 0.6662f)) * 2.0f * par3 * 0.5f;
        }
    }

    private float interpolateRotation(float par1, float par2) {
        return (Math.abs(par1 % par2 - par2 * 0.5f) - par2 * 0.25f) / (par2 * 0.25f);
    }

    public void setRotationAngles(float p_78087_1_, float p_78087_2_, float p_78087_3_, float p_78087_4_, float p_78087_5_, float p_78087_6_, Entity p_78087_7_) {
        float f7;
        float f6;
        this.headMain.rotateAngleY = p_78087_4_ / 57.295776f;
        this.headMain.rotateAngleX = p_78087_5_ / 57.295776f;
        this.armRight.rotateAngleZ = 0.0f;
        this.armLeft.rotateAngleZ = 0.0f;
        this.legRightUpper.rotateAngleX = Math.max(-0.4098033f + MathHelper.cos((float)(p_78087_1_ * 0.6662f)) * 1.4f * p_78087_2_, -0.8f);
        this.legLeftUpper.rotateAngleX = Math.max(-0.4098033f + MathHelper.cos((float)(p_78087_1_ * 0.6662f + (float)Math.PI)) * 1.4f * p_78087_2_, -0.8f);
        this.legRightUpper.rotateAngleY = 0.0f;
        this.legLeftUpper.rotateAngleY = 0.0f;
        if (this.isRiding) {
            this.armRight.rotateAngleX += -0.62831855f;
            this.armLeft.rotateAngleX += -0.62831855f;
            this.legRightUpper.rotateAngleX = -1.2566371f;
            this.legLeftUpper.rotateAngleX = -1.2566371f;
            this.legRightUpper.rotateAngleY = 0.31415927f;
            this.legLeftUpper.rotateAngleY = -0.31415927f;
        }
        if (this.heldItemLeft != 0) {
            this.armLeft.rotateAngleX = this.armLeft.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemLeft;
        }
        if (this.heldItemRight != 0) {
            this.armRight.rotateAngleX = this.armRight.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemRight;
        }
        this.armRight.rotateAngleY = 0.0f;
        this.armLeft.rotateAngleY = 0.0f;
        if (this.onGround > -9990.0f) {
            f6 = this.onGround;
            this.bodyUpper.rotateAngleY = MathHelper.sin((float)(MathHelper.sqrt_float((float)f6) * (float)Math.PI * 2.0f)) * 0.2f;
            this.armRight.rotationPointZ = MathHelper.sin((float)this.bodyUpper.rotateAngleY) * 5.0f;
            this.armRight.rotationPointX = -MathHelper.cos((float)this.bodyUpper.rotateAngleY) * 5.0f;
            this.armLeft.rotationPointZ = -MathHelper.sin((float)this.bodyUpper.rotateAngleY) * 5.0f;
            this.armLeft.rotationPointX = MathHelper.cos((float)this.bodyUpper.rotateAngleY) * 5.0f;
            this.armRight.rotateAngleY += this.bodyUpper.rotateAngleY;
            this.armLeft.rotateAngleY += this.bodyUpper.rotateAngleY;
            this.armLeft.rotateAngleX += this.bodyUpper.rotateAngleY;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            f7 = MathHelper.sin((float)(f6 * (float)Math.PI));
            float f8 = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -(this.headMain.rotateAngleX - 0.7f) * 0.75f;
            this.armRight.rotateAngleX = (float)((double)this.armRight.rotateAngleX - ((double)f7 * 1.2 + (double)f8));
            this.armRight.rotateAngleY += this.bodyUpper.rotateAngleY * 2.0f;
            this.armRight.rotateAngleZ = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -0.4f;
        }
        if (this.isSneak) {
            this.bodyUpper.rotateAngleX = 0.5f;
            this.armRight.rotateAngleX += 0.4f;
            this.armLeft.rotateAngleX += 0.4f;
            this.legRightUpper.rotationPointZ = 4.0f;
            this.legLeftUpper.rotationPointZ = 4.0f;
            this.legRightUpper.rotationPointY = 9.0f;
            this.legLeftUpper.rotationPointY = 9.0f;
            this.headMain.rotationPointY = 0.0f;
        } else {
            this.setRotateAngle(this.bodyUpper, 0.4098033f, 0.0f, 0.0f);
            this.legRightUpper.rotationPointZ = 0.1f;
            this.legLeftUpper.rotationPointZ = 0.1f;
            this.legRightUpper.rotationPointY = 12.0f;
            this.legLeftUpper.rotationPointY = 12.0f;
            this.headMain.rotationPointY = 0.0f;
        }
        this.setRotateAngle(this.tail, 0.59184116f, 0.0f, 0.0f);
        if ((double)p_78087_2_ > 0.1) {
            this.tail.rotateAngleX = (float)((double)this.tail.rotateAngleX + ((double)p_78087_2_ - 0.1));
            this.tail.rotateAngleZ += 5.0f * MathHelper.cos((float)(p_78087_3_ * 0.09f)) * 0.05f + 0.05f;
        } else {
            this.tail.rotateAngleZ += 3.0f * MathHelper.cos((float)(p_78087_3_ * 0.09f)) * 0.05f + 0.05f;
        }
        this.armRight.rotateAngleZ += MathHelper.cos((float)(p_78087_3_ * 0.09f)) * 0.05f + 0.05f;
        this.armLeft.rotateAngleZ -= MathHelper.cos((float)(p_78087_3_ * 0.09f)) * 0.05f + 0.05f;
        this.armRight.rotateAngleX += MathHelper.sin((float)(p_78087_3_ * 0.067f)) * 0.05f;
        this.armLeft.rotateAngleX -= MathHelper.sin((float)(p_78087_3_ * 0.067f)) * 0.05f;
        if (this.aimedBow) {
            f6 = 0.0f;
            f7 = 0.0f;
            this.armRight.rotateAngleZ = 0.0f;
            this.armLeft.rotateAngleZ = 0.0f;
            this.armRight.rotateAngleY = -(0.1f - f6 * 0.6f) + this.headMain.rotateAngleY;
            this.armLeft.rotateAngleY = 0.1f - f6 * 0.6f + this.headMain.rotateAngleY + 0.4f;
            this.armRight.rotateAngleX = -1.5707964f + this.headMain.rotateAngleX;
            this.armLeft.rotateAngleX = -1.5707964f + this.headMain.rotateAngleX;
            this.armRight.rotateAngleX -= f6 * 1.2f - f7 * 0.4f;
            this.armLeft.rotateAngleX -= f6 * 1.2f - f7 * 0.4f;
            this.armRight.rotateAngleZ += MathHelper.cos((float)(p_78087_3_ * 0.09f)) * 0.05f + 0.05f;
            this.armLeft.rotateAngleZ -= MathHelper.cos((float)(p_78087_3_ * 0.09f)) * 0.05f + 0.05f;
            this.armRight.rotateAngleX += MathHelper.sin((float)(p_78087_3_ * 0.067f)) * 0.05f;
            this.armLeft.rotateAngleX -= MathHelper.sin((float)(p_78087_3_ * 0.067f)) * 0.05f;
        }
    }
}

