/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.renderer;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockGrassper;
import com.emoniph.witchery.client.model.ModelGrassper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGrassper
extends TileEntitySpecialRenderer {
    final ModelGrassper model = new ModelGrassper();
    private RenderItem renderItems = new RenderItem(){

        public byte getMiniItemCountForItemStack(ItemStack stack) {
            return 1;
        }

        public byte getMiniBlockCountForItemStack(ItemStack stack) {
            return 1;
        }

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    private static final ResourceLocation TEXTURE_URL = new ResourceLocation("witchery", "textures/blocks/grassper.png");

    public RenderGrassper() {
        this.renderItems.setRenderManager(RenderManager.instance);
    }

    public void renderTileEntityAt(TileEntity tileEntity, double d, double d1, double d2, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        BlockGrassper.TileEntityGrassper tileEntityYour = (BlockGrassper.TileEntityGrassper)tileEntity;
        this.renderGrassper(tileEntityYour, tileEntity.getWorldObj(), tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord, Witchery.Blocks.GRASSPER);
        GL11.glPopMatrix();
    }

    public void renderGrassper(BlockGrassper.TileEntityGrassper te, World world, int x, int y, int z, Block block) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.bindTexture(TEXTURE_URL);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        if (world != null) {
            int meta = world.getBlockMetadata(x, y, z);
            float rotation = 0.0f;
            switch (meta) {
                case 2: {
                    rotation = 0.0f;
                    break;
                }
                case 3: {
                    rotation = 180.0f;
                    break;
                }
                case 4: {
                    rotation = 270.0f;
                    break;
                }
                case 5: {
                    rotation = 90.0f;
                }
            }
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        if (world != null) {
            ItemStack newStack = null;
            float rotational = (float)Minecraft.getSystemTime() / 3000.0f * 300.0f;
            EntityItem ei = new EntityItem(world);
            ei.hoverStart = 0.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)170.0f, (float)170.0f);
            GL11.glTranslatef((float)0.0f, (float)0.6f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            float yShift = -0.15f;
            float zShift = 0.65f;
            float xShift = 0.65f;
            boolean fancy = Witchery.proxy.getGraphicsLevel();
            for (int i = 0; i < te.getSizeInventory() && i <= 46; ++i) {
                if (te.getStackInSlot(i) == null) continue;
                newStack = te.getStackInSlot(i).copy();
                newStack.stackSize = 1;
                ei.setEntityItemStack(newStack);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)xShift, (float)yShift, (float)zShift);
                if (fancy) {
                    GL11.glRotatef((float)(rotational / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glPushMatrix();
                this.renderItems.doRender(ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

