/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.crafting;

import com.emoniph.witchery.Witchery;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RecipeShapelessAddKeys
implements IRecipe {
    final ItemStack prototype;
    final ItemStack[] pattern;

    public RecipeShapelessAddKeys(ItemStack result, ItemStack ... pattern) {
        this.prototype = result;
        this.pattern = pattern;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public boolean matches(InventoryCrafting par1InventoryCrafting, World par2World) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>(Arrays.asList(this.pattern));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = par1InventoryCrafting.getStackInRowAndColumn(j, i);
                if (itemstack == null) continue;
                boolean flag = false;
                for (ItemStack itemstack1 : arraylist) {
                    if (itemstack.getItem() != itemstack1.getItem() || itemstack.getItem().getHasSubtypes() && itemstack.getItemDamage() != itemstack1.getItemDamage()) continue;
                    flag = true;
                    arraylist.remove(itemstack1);
                    break;
                }
                if (flag) continue;
                return false;
            }
        }
        return arraylist.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack ring = this.findRecipeItemStack(inv, this.prototype.getItem(), this.prototype.getItemDamage());
        ItemStack result = ring != null ? ring.copy() : this.prototype.copy();
        for (int j = 0; j < inv.getSizeInventory(); ++j) {
            ItemStack key = inv.getStackInSlot(j);
            if (key == null || !Witchery.Items.GENERIC.itemDoorKey.isMatch(key) || !key.hasTagCompound()) continue;
            if (!result.hasTagCompound()) {
                result.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound sourceTag = key.getTagCompound();
            int sourceX = sourceTag.getInteger("doorX");
            int sourceY = sourceTag.getInteger("doorY");
            int sourceZ = sourceTag.getInteger("doorZ");
            boolean sourceHasD = sourceTag.hasKey("doorD") && sourceTag.hasKey("doorDN");
            NBTTagCompound nbtTag = result.getTagCompound();
            if (!nbtTag.hasKey("doorKeys")) {
                nbtTag.setTag("doorKeys", (NBTBase)new NBTTagList());
            }
            NBTTagList keyList = nbtTag.getTagList("doorKeys", 10);
            for (int i = 0; i < keyList.tagCount(); ++i) {
                boolean doorHasD;
                NBTTagCompound keyTag = keyList.getCompoundTagAt(i);
                if (keyTag == null || !keyTag.hasKey("doorX") || !keyTag.hasKey("doorY") || !keyTag.hasKey("doorZ")) continue;
                int doorX = keyTag.getInteger("doorX");
                int doorY = keyTag.getInteger("doorY");
                int doorZ = keyTag.getInteger("doorZ");
                boolean bl = doorHasD = keyTag.hasKey("doorD") && keyTag.hasKey("doorDN");
                if (doorX != sourceX || doorY != sourceY || doorZ != sourceZ || sourceHasD != doorHasD || sourceHasD && sourceTag.getInteger("doorD") != keyTag.getInteger("doorD")) continue;
                return result;
            }
            NBTTagCompound nbtNewKey = new NBTTagCompound();
            nbtNewKey.setInteger("doorX", sourceX);
            nbtNewKey.setInteger("doorY", sourceY);
            nbtNewKey.setInteger("doorZ", sourceZ);
            if (sourceHasD) {
                nbtNewKey.setInteger("doorD", sourceTag.getInteger("doorD"));
                nbtNewKey.setString("doorDN", sourceTag.getString("doorDN"));
            }
            keyList.appendTag((NBTBase)nbtNewKey);
        }
        return result;
    }

    private ItemStack findRecipeItemStack(InventoryCrafting inv, Item itemToFind, int meta) {
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || stack.getItem() != itemToFind || stack.getItemDamage() != meta) continue;
            return stack;
        }
        return null;
    }

    public int getRecipeSize() {
        return this.pattern.length;
    }
}

