/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.infusion.infusions.InfusionOtherwhere;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityAttackBat
extends EntityBat {
    private EntityPlayer ownerPlayer;
    private GameProfile owner;

    public EntityAttackBat(World world) {
        super(world);
    }

    protected void collideWithNearbyEntities() {
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.canBePushed()) continue;
                this.collideWithEntity(entity);
            }
        }
    }

    protected void collideWithEntity(Entity entity) {
        if (!this.worldObj.isRemote && entity instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)entity;
            if (this.ownerPlayer == null) {
                this.ownerPlayer = this.getOwner();
            }
            if (target != this.ownerPlayer && !(target instanceof EntityBat) && !target.isDead) {
                target.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)this.ownerPlayer), 4.0f);
                ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, entity, entity.width, entity.height, 16);
                this.setDead();
            }
        }
    }

    protected void updateAITasks() {
        if (!this.worldObj.isRemote) {
            boolean done = false;
            if (this.ticksExisted > 300) {
                ParticleEffect.SMOKE.send(SoundEffect.NONE, (Entity)this, this.width, this.height, 16);
                this.setDead();
            } else {
                MovingObjectPosition mop;
                if (this.ownerPlayer == null) {
                    this.ownerPlayer = this.getOwner();
                }
                if (this.ownerPlayer != null && this.ownerPlayer.dimension == this.dimension && (mop = InfusionOtherwhere.raytraceEntities(this.worldObj, this.ownerPlayer, true, 32.0)) != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit instanceof EntityLivingBase && !(mop.entityHit instanceof EntityBat)) {
                    double d0 = mop.entityHit.posX - this.posX;
                    double d1 = mop.entityHit.posY - this.posY;
                    double d2 = mop.entityHit.posZ - this.posZ;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (this.isCourseTraversable(mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, d3 = (double)MathHelper.sqrt_double((double)d3))) {
                        this.motionX += d0 / d3 * 0.1;
                        this.motionY += d1 / d3 * 0.1;
                        this.motionZ += d2 / d3 * 0.1;
                        float f = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) - 90.0f;
                        float f1 = MathHelper.wrapAngleTo180_float((float)(f - this.rotationYaw));
                        this.moveForward = 0.5f;
                        this.rotationYaw += f1;
                        done = true;
                    }
                    this.renderYawOffset = this.rotationYaw = -((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / (float)Math.PI;
                }
            }
            if (!done) {
                super.updateAITasks();
            }
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.posX) / par7;
        double d5 = (par3 - this.posY) / par7;
        double d6 = (par5 - this.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.worldObj.getCollidingBoundingBoxes((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player.getGameProfile();
    }

    public EntityPlayer getOwner() {
        return this.owner != null ? this.worldObj.func_152378_a(this.owner.getId()) : null;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (this.owner != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbttagcompound1, (GameProfile)this.owner);
            nbtRoot.setTag("Owner", (NBTBase)nbttagcompound1);
        }
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        if (nbtRoot.hasKey("Owner", 10)) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbtRoot.getCompoundTag("Owner"));
        }
    }
}

