/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityWitchProjectile;
import com.emoniph.witchery.entity.IOwnable;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBabaYaga
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob,
IEntitySelector,
IOwnable,
IHandleDT {
    private static final UUID field_110184_bp = UUID.fromString("ab0df555-0786-4951-a8df-ca61749f164e");
    private static final AttributeModifier field_110185_bq = new AttributeModifier(field_110184_bp, "Drinking speed penalty", -0.25, 0).setSaved(false);
    private static final int[] witchDrops = new int[]{Witchery.Items.GENERIC.itemSpectralDust.damageValue, Witchery.Items.GENERIC.itemBatWool.damageValue, Witchery.Items.GENERIC.itemToeOfFrog.damageValue, Witchery.Items.GENERIC.itemOwletsWing.damageValue, Witchery.Items.GENERIC.itemDogTongue.damageValue, Witchery.Items.GENERIC.itemBrewOfVines.damageValue, Witchery.Items.GENERIC.itemBrewOfSprouting.damageValue, Witchery.Items.GENERIC.itemBrewOfHitchcock.damageValue, Witchery.Items.GENERIC.itemBrewOfCursedLeaping.damageValue, Witchery.Items.GENERIC.itemBrewOfFrogsTongue.damageValue};
    private int witchAttackTimer;
    private static final double MAX_HEALTH = 500.0;
    long ticksSinceTeleport = 0L;

    public EntityBabaYaga(World par1World) {
        super(par1World);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, (IEntitySelector)this));
        this.experienceValue = 70;
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(21, (Object)0);
        this.dataWatcher.addObject(17, (Object)"");
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        if (this.getOwnerName() == null) {
            par1NBTTagCompound.setString("Owner", "");
        } else {
            par1NBTTagCompound.setString("Owner", this.getOwnerName());
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        String s = par1NBTTagCompound.getString("Owner");
        if (s.length() > 0) {
            this.setOwner(s);
        }
    }

    @Override
    public String getOwnerName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    @Override
    public void setOwner(String par1Str) {
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    @Override
    public EntityPlayer getOwnerEntity() {
        return this.worldObj.getPlayerEntityByName(this.getOwnerName());
    }

    public boolean isEntityApplicable(Entity entity) {
        if (entity != null && entity instanceof EntityPlayer) {
            String ownerName = this.getOwnerName();
            boolean isOwned = ((EntityPlayer)entity).getCommandSenderName().equalsIgnoreCase(ownerName);
            return !isOwned;
        }
        return true;
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.babayaga.name");
    }

    public int getTotalArmorValue() {
        return 4;
    }

    protected String getLivingSound() {
        return "witchery:mob.baba.baba_living";
    }

    protected String getHurtSound() {
        return "mob.witch.hurt";
    }

    protected String getDeathSound() {
        return "witchery:mob.baba.baba_death";
    }

    public void setAggressive(boolean par1) {
        this.getDataWatcher().updateObject(21, (Object)((byte)(par1 ? 1 : 0)));
    }

    public boolean getAggressive() {
        return this.getDataWatcher().getWatchableObjectByte(21) == 1;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(500.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void fall(float par1) {
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void onLivingUpdate() {
        if (!this.worldObj.isRemote) {
            EntityPlayer owner;
            if (this.getAggressive()) {
                if (this.witchAttackTimer-- <= 0) {
                    List list;
                    this.setAggressive(false);
                    ItemStack itemstack = this.getHeldItem();
                    this.setCurrentItemOrArmor(0, null);
                    if (itemstack != null && itemstack.getItem() == Items.potionitem && (list = Items.potionitem.getEffects(itemstack)) != null) {
                        for (PotionEffect potioneffect : list) {
                            this.addPotionEffect(new PotionEffect(potioneffect));
                        }
                    }
                    this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).removeModifier(field_110185_bq);
                }
            } else {
                int short1 = -1;
                if (this.rand.nextFloat() < 0.15f && this.isBurning() && !this.isPotionActive(Potion.fireResistance)) {
                    short1 = 16307;
                } else if (this.rand.nextFloat() < 0.01f && this.getHealth() < this.getMaxHealth()) {
                    short1 = 16341;
                } else if (this.rand.nextFloat() < 0.25f && this.getAttackTarget() != null && !this.isPotionActive(Potion.moveSpeed) && this.getAttackTarget().getDistanceSqToEntity((Entity)this) > 121.0) {
                    short1 = 16274;
                } else if (this.rand.nextFloat() < 0.25f && this.getAttackTarget() != null && !this.isPotionActive(Potion.moveSpeed) && this.getAttackTarget().getDistanceSqToEntity((Entity)this) > 121.0) {
                    short1 = 16274;
                }
                if (short1 > -1) {
                    this.setCurrentItemOrArmor(0, new ItemStack((Item)Items.potionitem, 1, short1));
                    this.witchAttackTimer = this.getHeldItem().getMaxItemUseDuration() - 20;
                    this.setAggressive(true);
                    IAttributeInstance attributeinstance = this.getEntityAttribute(SharedMonsterAttributes.movementSpeed);
                    attributeinstance.removeModifier(field_110185_bq);
                    attributeinstance.applyModifier(field_110185_bq);
                }
            }
            if (this.rand.nextFloat() < 7.5E-4f) {
                this.worldObj.setEntityState((Entity)this, (byte)15);
            }
            if ((this.getNavigator().noPath() || this.worldObj.rand.nextDouble() < 0.02) && this.getAttackTarget() != null && (long)this.ticksExisted - this.ticksSinceTeleport > 100L) {
                this.ticksSinceTeleport = this.ticksExisted;
                this.teleportToEntity((Entity)this.getAttackTarget());
            }
            if (this.worldObj.rand.nextDouble() < 0.05 && this.getAttackTarget() != null && (this.getAttackTarget().isAirBorne || this.getAttackTarget() instanceof EntityPlayer && ((EntityPlayer)this.getAttackTarget()).capabilities.isFlying) && !this.getAttackTarget().isPotionActive(Potion.moveSlowdown)) {
                this.getAttackTarget().addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 200, 5));
            }
            if ((owner = this.getOwnerEntity()) != null) {
                double distance = this.getDistanceSqToEntity((Entity)owner);
                if (distance < 64.0 && this.ticksExisted % 100 == 0) {
                    int l = this.rand.nextInt(3);
                    int i1 = witchDrops[this.rand.nextInt(witchDrops.length - 3)];
                    for (int j1 = 0; j1 < l; ++j1) {
                        this.entityDropItem(new ItemStack((Item)Witchery.Items.GENERIC, 1, i1), 0.0f);
                    }
                }
                if (this.ticksExisted > 600) {
                    this.setDead();
                    ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 2.0, 16);
                }
            }
        }
        super.onLivingUpdate();
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX - par1Entity.posX), (double)(this.boundingBox.minY + (double)(this.height / 2.0f) - par1Entity.posY + (double)par1Entity.getEyeHeight()), (double)(this.posZ - par1Entity.posZ));
        vec3 = vec3.normalize();
        double d0 = 8.0;
        double d1 = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.xCoord * d0;
        double d2 = this.posY + (double)(this.rand.nextInt(16) - 8) - vec3.yCoord * d0;
        double d3 = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.zCoord * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.posX;
        double d4 = this.posY;
        double d5 = this.posZ;
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        boolean flag = false;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.blockExists(i, j = MathHelper.floor_double((double)this.posY), k = MathHelper.floor_double((double)this.posZ))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.worldObj.getBlock(i, j - 1, k);
                if (block.getMaterial().blocksMovement()) {
                    flag1 = true;
                    continue;
                }
                this.posY -= 1.0;
                --j;
            }
            if (flag1) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.setPosition(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.posX - d3) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d8 = d4 + (this.posY - d4) * d6 + this.rand.nextDouble() * (double)this.height;
            double d9 = d5 + (this.posZ - d5) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.worldObj.spawnParticle("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.worldObj.playSoundEffect(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.playSound("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected float applyPotionDamageCalculations(DamageSource par1DamageSource, float par2) {
        par2 = super.applyPotionDamageCalculations(par1DamageSource, par2);
        if (par1DamageSource.getEntity() == this) {
            par2 = 0.0f;
        }
        if (par1DamageSource.isMagicDamage()) {
            par2 = (float)((double)par2 * 0.15);
        }
        return par2;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 15) {
            for (int i = 0; i < this.rand.nextInt(35) + 10; ++i) {
                this.worldObj.spawnParticle("witchMagic", this.posX + this.rand.nextGaussian() * (double)0.13f, this.boundingBox.maxY + 0.5 + this.rand.nextGaussian() * (double)0.13f, this.posZ + this.rand.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        EntityLiving attacker;
        boolean result = super.attackEntityFrom(source, Math.min(damage, 15.0f));
        if (!this.worldObj.isRemote && source.getEntity() != null && source.getEntity() instanceof EntityLiving && ((attacker = (EntityLiving)source.getEntity()).getCreatureAttribute() == EnumCreatureAttribute.UNDEAD || attacker instanceof EntityTameable && !((EntityTameable)attacker).isTamed())) {
            EntityCaveSpider spider = new EntityCaveSpider(this.worldObj);
            spider.setLocationAndAngles(attacker.posX, attacker.posY, attacker.posZ, attacker.rotationPitch, attacker.rotationYaw);
            EntityLivingBase target = this.getAttackTarget();
            spider.setAttackTarget(target);
            spider.setRevengeTarget(target);
            spider.setTarget((Entity)target);
            this.worldObj.spawnEntityInWorld((Entity)spider);
            ParticleEffect.MOB_SPELL.send(SoundEffect.RANDOM_POP, (Entity)spider, 2.0, 2.0, 16);
            attacker.setDead();
        }
        if (!this.worldObj.isRemote && source.getEntity() != null && source.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.getEntity();
            if (!CreatureUtil.isWoodenDamage(source)) {
                player.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)player), damage * 0.25f);
            }
        }
        return result;
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return 15.0f;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (!this.worldObj.isRemote) {
            ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 2.0, 16);
        }
        this.setDead();
    }

    protected void dropFewItems(boolean par1, int par2) {
        int j = this.rand.nextInt(3) + 2;
        for (int k = 0; k < j; ++k) {
            int l = this.rand.nextInt(3) + 1;
            int i1 = witchDrops[this.rand.nextInt(witchDrops.length)];
            if (par2 > 0) {
                l += this.rand.nextInt(par2 + 1);
            }
            for (int j1 = 0; j1 < l; ++j1) {
                this.entityDropItem(new ItemStack((Item)Witchery.Items.GENERIC, 1, i1), 0.0f);
            }
        }
        Enchantment enchantment = Enchantment.enchantmentsBookList[this.rand.nextInt(Enchantment.enchantmentsBookList.length)];
        int k = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 2, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack = Items.enchanted_book.getEnchantedItemStack(new EnchantmentData(enchantment, k));
        this.entityDropItem(itemstack, 0.0f);
        this.entityDropItem(new ItemStack((Item)Witchery.Items.BABAS_HAT), 0.0f);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase par1EntityLivingBase, float par2) {
        if (!this.getAggressive()) {
            if (this.worldObj.rand.nextInt(3) == 0) {
                ItemGeneral.SubItem brew = null;
                switch (this.worldObj.rand.nextInt(12)) {
                    case 0: 
                    case 1: {
                        brew = Witchery.Items.GENERIC.itemBrewOfWebs;
                        break;
                    }
                    case 2: 
                    case 3: {
                        brew = Witchery.Items.GENERIC.itemBrewOfThorns;
                        break;
                    }
                    case 4: 
                    case 5: {
                        brew = Witchery.Items.GENERIC.itemBrewOfFrogsTongue;
                        break;
                    }
                    case 6: 
                    case 7: {
                        brew = Witchery.Items.GENERIC.itemBrewOfInk;
                        break;
                    }
                    case 8: 
                    case 9: {
                        brew = Witchery.Items.GENERIC.itemBrewOfHitchcock;
                        break;
                    }
                    case 10: {
                        brew = Witchery.Items.GENERIC.itemBrewOfBats;
                        break;
                    }
                    case 11: {
                        brew = Witchery.Items.GENERIC.itemBrewOfWasting;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                EntityWitchProjectile entitypotion = new EntityWitchProjectile(this.worldObj, (EntityLivingBase)this, brew);
                entitypotion.rotationPitch -= -20.0f;
                double d0 = par1EntityLivingBase.posX + par1EntityLivingBase.motionX - this.posX;
                double d1 = par1EntityLivingBase.posY + (double)par1EntityLivingBase.getEyeHeight() - (double)1.1f - this.posY;
                double d2 = par1EntityLivingBase.posZ + par1EntityLivingBase.motionZ - this.posZ;
                float f1 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2));
                entitypotion.setThrowableHeading(d0, d1 + (double)(f1 * 0.2f), d2, 0.75f, 8.0f);
                this.worldObj.spawnEntityInWorld((Entity)entitypotion);
            } else {
                EntityPotion entitypotion = new EntityPotion(this.worldObj, (EntityLivingBase)this, 32732);
                entitypotion.rotationPitch -= -20.0f;
                double d0 = par1EntityLivingBase.posX + par1EntityLivingBase.motionX - this.posX;
                double d1 = par1EntityLivingBase.posY + (double)par1EntityLivingBase.getEyeHeight() - (double)1.1f - this.posY;
                double d2 = par1EntityLivingBase.posZ + par1EntityLivingBase.motionZ - this.posZ;
                float f1 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2));
                if (f1 >= 8.0f && !par1EntityLivingBase.isPotionActive(Potion.moveSlowdown)) {
                    entitypotion.setPotionDamage(32698);
                } else if (par1EntityLivingBase.getHealth() >= 8.0f && !par1EntityLivingBase.isPotionActive(Potion.poison)) {
                    entitypotion.setPotionDamage(32660);
                } else if (f1 <= 3.0f && !par1EntityLivingBase.isPotionActive(Potion.weakness) && this.rand.nextFloat() < 0.25f) {
                    entitypotion.setPotionDamage(32696);
                }
                entitypotion.setThrowableHeading(d0, d1 + (double)(f1 * 0.2f), d2, 0.75f, 8.0f);
                this.worldObj.spawnEntityInWorld((Entity)entitypotion);
            }
        }
    }
}

