/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.entity.EntitySummonedUndead;
import com.emoniph.witchery.item.ItemEarmuffs;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.TimeUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityBanshee
extends EntitySummonedUndead {
    public EntityBanshee(World par1World) {
        super(par1World);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setAvoidSun(true);
        this.getNavigator().setBreakDoors(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 0.3, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.2);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(0.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        boolean startedScreaming = false;
        if (!this.worldObj.isRemote && (TimeUtil.secondsElapsed(5, this.ticksExisted) || this.isScreaming() && TimeUtil.ticksElapsed(20, this.ticksExisted))) {
            double RADIUS = 6.0;
            double RADIUS_SQ = 36.0;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - 6.0), (double)(this.posY - 6.0), (double)(this.posZ - 6.0), (double)(this.posX + 6.0), (double)(this.posY + 6.0), (double)(this.posZ + 6.0));
            List players = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, bounds);
            boolean playersFound = false;
            for (Object obj : players) {
                EntityLivingBase player = (EntityLivingBase)obj;
                if (!(this.getDistanceSqToEntity((Entity)player) <= 36.0) || player != this.getAttackTarget() && player != this.entityToAttack && !(player instanceof EntityPlayer)) continue;
                playersFound = true;
                if (!this.isScreaming()) {
                    this.setScreaming(true);
                    startedScreaming = true;
                }
                if (player instanceof EntityPlayer && ItemEarmuffs.isHelmWorn((EntityPlayer)player)) continue;
                float maxHealth = player.getMaxHealth();
                boolean flag = EntityUtil.touchOfDeath((Entity)player, (EntityLivingBase)this, Math.max(0.1f * maxHealth, 1.0f));
            }
            if (!playersFound && this.isScreaming()) {
                this.setScreaming(false);
            }
        }
        if ((startedScreaming || TimeUtil.secondsElapsed(3, this.ticksExisted)) && this.isScreaming()) {
            this.playSound("witchery:mob.banshee.banshee_scream", 1.0f, this.worldObj.rand.nextFloat() * 0.3f + 0.7f);
        }
    }

    public void onUpdate() {
        super.onUpdate();
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        boolean flag = super.attackEntityAsMob(par1Entity);
        return flag;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "witchery:mob.spectre.spectre_hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.spectre.spectre_hit";
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.banshee.name");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData par1EntityLivingData1 = super.onSpawnWithEgg(par1EntityLivingData);
        return par1EntityLivingData1;
    }
}

