/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.infusion.InfusedBrewEffect;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class EntityBroom
extends Entity {
    private boolean isBoatEmpty = true;
    private double speedMultiplier = 0.07;
    private int broomPosRotationIncrements;
    private double broomX;
    private double broomY;
    private double broomZ;
    private double broomYaw;
    private double broomPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    boolean riderHasOwlFamiliar = false;
    boolean riderHasSoaringBrew = false;

    public EntityBroom(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setSize(1.2f, 0.5f);
        this.yOffset = this.height / 2.0f;
    }

    public EntityBroom(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y + (double)this.yOffset, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(10, (Object)"");
        this.dataWatcher.addObject(16, (Object)-1);
        this.dataWatcher.addObject(17, (Object)new Integer(0));
        this.dataWatcher.addObject(18, (Object)new Integer(1));
        this.dataWatcher.addObject(19, (Object)new Float(0.0f));
    }

    protected void dealFireDamage(int par1) {
    }

    public void setBrushColor(int color) {
        this.dataWatcher.updateObject(16, (Object)((byte)color));
    }

    public int getBrushColor() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void setCustomNameTag(String par1Str) {
        this.dataWatcher.updateObject(10, (Object)par1Str);
    }

    public String getCustomNameTag() {
        return this.dataWatcher.getWatchableObjectString(10);
    }

    public boolean hasCustomNameTag() {
        return this.dataWatcher.getWatchableObjectString(10).length() > 0;
    }

    public AxisAlignedBB getCollisionBox(Entity par1Entity) {
        return par1Entity.boundingBox;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public boolean canBePushed() {
        return true;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.55;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        if (!this.worldObj.isRemote && !this.isDead) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + par2 * 10.0f);
            this.setBeenAttacked();
            boolean bl = flag = par1DamageSource.getEntity() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.getEntity()).capabilities.isCreativeMode;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (this.riddenByEntity != null) {
                    this.riddenByEntity.mountEntity((Entity)this);
                }
                if (!flag) {
                    int brushColor;
                    ItemStack broomStack = Witchery.Items.GENERIC.itemBroomEnchanted.createStack();
                    if (this.hasCustomNameTag()) {
                        broomStack.setStackDisplayName(this.getCustomNameTag());
                    }
                    if ((brushColor = this.getBrushColor()) >= 0 && brushColor <= 15) {
                        Witchery.Items.GENERIC.setBroomItemColor(broomStack, brushColor);
                    }
                    this.entityDropItem(broomStack, 0.0f);
                }
                this.setDead();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void performHurtAnimation() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean canBeCollidedWith() {
        return !this.isDead && this.riddenByEntity == null;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int par9) {
        if (this.isBoatEmpty) {
            this.broomPosRotationIncrements = par9 + 5;
        } else {
            double d3 = x - this.posX;
            double d4 = y - this.posY;
            double d5 = z - this.posZ;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.broomPosRotationIncrements = 3;
        }
        this.broomX = x;
        this.broomY = y;
        this.broomZ = z;
        this.broomYaw = yaw;
        this.broomPitch = pitch;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double x, double y, double z) {
        this.velocityX = this.motionX = x;
        this.velocityY = this.motionY = y;
        this.velocityZ = this.motionZ = z;
    }

    public void onUpdate() {
        double d5;
        double newHorzVelocity;
        super.onUpdate();
        if (this.ticksExisted % 100 == 0 && this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer) {
            this.riderHasSoaringBrew = InfusedBrewEffect.Soaring.isActive((EntityPlayer)this.riddenByEntity);
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int b0 = 5;
        double d0 = 0.0;
        double initialHorzVelocity = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        if (initialHorzVelocity > 0.26249999999999996) {
            newHorzVelocity = Math.cos((double)this.rotationYaw * Math.PI / 180.0);
            double d = Math.sin((double)this.rotationYaw * Math.PI / 180.0);
        }
        if (this.worldObj.isRemote && this.isBoatEmpty) {
            if (this.broomPosRotationIncrements > 0) {
                newHorzVelocity = this.posX + (this.broomX - this.posX) / (double)this.broomPosRotationIncrements;
                d5 = this.posY + (this.broomY - this.posY) / (double)this.broomPosRotationIncrements;
                double d11 = this.posZ + (this.broomZ - this.posZ) / (double)this.broomPosRotationIncrements;
                double d10 = MathHelper.wrapAngleTo180_double((double)(this.broomYaw - (double)this.rotationYaw));
                this.rotationYaw = (float)((double)this.rotationYaw + d10 / (double)this.broomPosRotationIncrements);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.broomPitch - (double)this.rotationPitch) / (double)this.broomPosRotationIncrements);
                --this.broomPosRotationIncrements;
                this.setPosition(newHorzVelocity, d5, d11);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                newHorzVelocity = this.posX + this.motionX;
                d5 = this.posY + this.motionY;
                double d11 = this.posZ + this.motionZ;
                this.setRotation((float)((double)this.rotationYaw + (this.broomYaw - (double)this.rotationYaw)), (float)((double)this.rotationPitch + (this.broomPitch - (double)this.rotationPitch)));
                this.setPosition(newHorzVelocity, d5, d11);
                this.motionX *= (double)0.99f;
                this.motionZ *= (double)0.99f;
            }
        } else {
            double d11;
            if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityLivingBase) {
                newHorzVelocity = ((EntityLivingBase)this.riddenByEntity).moveForward;
                if (newHorzVelocity > 0.0) {
                    d5 = -Math.sin(this.riddenByEntity.rotationYaw * (float)Math.PI / 180.0f);
                    d11 = Math.cos(this.riddenByEntity.rotationYaw * (float)Math.PI / 180.0f);
                    this.motionX += d5 * this.speedMultiplier * (0.1 + (this.riderHasSoaringBrew ? 0.1 : 0.0) + (this.riderHasOwlFamiliar ? 0.2 : 0.0));
                    this.motionZ += d11 * this.speedMultiplier * (0.1 + (this.riderHasSoaringBrew ? 0.1 : 0.0) + (this.riderHasOwlFamiliar ? 0.2 : 0.0));
                    double pitch = -Math.sin(this.riddenByEntity.rotationPitch * (float)Math.PI / 180.0f);
                    if (pitch > -0.5 && pitch < 0.2) {
                        pitch = 0.0;
                    } else if (pitch < 0.0) {
                        pitch *= 0.5;
                    }
                    this.motionY = pitch * this.speedMultiplier * 2.0;
                } else if (newHorzVelocity == 0.0 && (this.riderHasOwlFamiliar || this.riderHasSoaringBrew)) {
                    this.motionX *= 0.9;
                    this.motionZ *= 0.9;
                }
            } else if (this.riddenByEntity == null) {
                this.riderHasOwlFamiliar = false;
                double moX = this.motionX * 0.9;
                double moZ = this.motionZ * 0.9;
                this.motionX = Math.abs(moX) < 0.01 ? 0.0 : moX;
                double d = this.motionZ = Math.abs(moZ) < 0.01 ? 0.0 : moZ;
                if (!this.onGround) {
                    this.motionY = -0.2;
                }
            }
            newHorzVelocity = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            double SPEED_LIMIT = 0.9 + (this.riderHasOwlFamiliar ? 0.3 : 0.0) + (this.riderHasSoaringBrew ? 0.3 : 0.0);
            if (newHorzVelocity > SPEED_LIMIT) {
                d5 = SPEED_LIMIT / newHorzVelocity;
                this.motionX *= d5;
                this.motionZ *= d5;
                this.motionY *= d5;
                newHorzVelocity = SPEED_LIMIT;
            }
            double MAX_ACCELERATION = this.riderHasSoaringBrew || this.riderHasOwlFamiliar ? 0.35 : 0.35;
            double MAX_ACCELERATION_FACTOR = MAX_ACCELERATION * 100.0;
            if (newHorzVelocity > initialHorzVelocity && this.speedMultiplier < MAX_ACCELERATION) {
                this.speedMultiplier += (MAX_ACCELERATION - this.speedMultiplier) / MAX_ACCELERATION_FACTOR;
                if (this.speedMultiplier > MAX_ACCELERATION) {
                    this.speedMultiplier = MAX_ACCELERATION;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.07) / MAX_ACCELERATION_FACTOR;
                if (this.speedMultiplier < 0.07) {
                    this.speedMultiplier = 0.07;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.99f;
            this.motionY *= (double)0.99f;
            this.motionZ *= (double)0.99f;
            this.rotationPitch = 0.0f;
            d5 = this.rotationYaw;
            d11 = this.prevPosX - this.posX;
            double d10 = this.prevPosZ - this.posZ;
            if (d11 * d11 + d10 * d10 > 0.001) {
                d5 = (float)(Math.atan2(d10, d11) * 180.0 / Math.PI);
            }
            double d12 = MathHelper.wrapAngleTo180_double((double)(d5 - (double)this.rotationYaw));
            this.rotationYaw = (float)((double)this.rotationYaw + d12);
            this.setRotation(this.rotationYaw, this.rotationPitch);
            if (!this.worldObj.isRemote) {
                List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand((double)0.2f, 0.0, (double)0.2f));
                if (list != null && !list.isEmpty()) {
                    for (int l = 0; l < list.size(); ++l) {
                        Entity entity = (Entity)list.get(l);
                        if (entity == this.riddenByEntity || !entity.canBePushed() || !(entity instanceof EntityBroom)) continue;
                        entity.applyEntityCollision((Entity)this);
                    }
                }
                if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
                    this.riddenByEntity = null;
                }
            }
        }
    }

    public void updateRiderPosition() {
        super.updateRiderPosition();
    }

    protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setString("CustomName", this.getCustomNameTag());
        int brushColor = this.getBrushColor();
        if (brushColor >= 0) {
            par1NBTTagCompound.setByte("BrushColor", Byte.valueOf((byte)brushColor).byteValue());
        }
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound.hasKey("CustomName") && par1NBTTagCompound.getString("CustomName").length() > 0) {
            this.setCustomNameTag(par1NBTTagCompound.getString("CustomName"));
        }
        if (par1NBTTagCompound.hasKey("BrushColor") && par1NBTTagCompound.getByte("BrushColor") >= 0) {
            this.setBrushColor(par1NBTTagCompound.getByte("BrushColor"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public boolean interactFirst(EntityPlayer player) {
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != player) {
            return true;
        }
        if (!this.worldObj.isRemote && player.getHeldItem() != null && player.getHeldItem().getItem() == Items.dye) {
            ItemStack itemstack = player.getHeldItem();
            int i = BlockColored.func_150032_b((int)itemstack.getItemDamage());
            this.setBrushColor(i);
            if (!player.capabilities.isCreativeMode) {
                --itemstack.stackSize;
            }
            if (itemstack.stackSize <= 0) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
            }
            return true;
        }
        if (!this.worldObj.isRemote) {
            this.riderHasOwlFamiliar = Familiar.hasActiveBroomMasteryFamiliar(player);
            this.riderHasSoaringBrew = InfusedBrewEffect.Soaring.isActive(player);
            player.mountEntity((Entity)this);
        }
        return true;
    }

    public void setDamageTaken(float par1) {
        this.dataWatcher.updateObject(19, (Object)Float.valueOf(par1));
    }

    public float getDamageTaken() {
        return this.dataWatcher.getWatchableObjectFloat(19);
    }

    public void setTimeSinceHit(int par1) {
        this.dataWatcher.updateObject(17, (Object)par1);
    }

    public int getTimeSinceHit() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public void setForwardDirection(int par1) {
        this.dataWatcher.updateObject(18, (Object)par1);
    }

    public int getForwardDirection() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsBoatEmpty(boolean par1) {
        this.isBoatEmpty = par1;
    }

    public static class EventHooks {
        @SubscribeEvent
        public void onLivingFall(LivingFallEvent event) {
            EntityPlayer player;
            if (event.entityLiving instanceof EntityPlayer && (player = (EntityPlayer)event.entityLiving).isRiding() && player.ridingEntity instanceof EntityBroom) {
                event.distance = 0.0f;
            }
        }
    }
}

