/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.dimension.WorldProviderDreamWorld;
import com.emoniph.witchery.util.Config;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityCorpse
extends EntityLiving {
    private ThreadDownloadImageData downloadImageSkin;
    private ResourceLocation locationSkin;

    public EntityCorpse(World world) {
        super(world);
        this.setSize(1.2f, 0.5f);
    }

    public boolean canBePushed() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return super.canBeCollidedWith();
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    public void moveEntity(double par1, double par3, double par5) {
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
    }

    protected boolean interact(EntityPlayer par1EntityPlayer) {
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (!this.worldObj.isRemote) {
            if (par1DamageSource.getSourceOfDamage() != null && par1DamageSource.getSourceOfDamage() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.getSourceOfDamage()).capabilities.isCreativeMode) {
                return super.attackEntityFrom(par1DamageSource, par2);
            }
            String username = this.getOwnerName();
            for (WorldServer world : MinecraftServer.getServer().worldServers) {
                EntityPlayer player = world.getPlayerEntityByName(username);
                if (player == null) continue;
                return super.attackEntityFrom(par1DamageSource, par2);
            }
            return false;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.body.name");
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (this.getOwnerName() == null) {
            nbtRoot.setString("Owner", "");
        } else {
            nbtRoot.setString("Owner", this.getOwnerName());
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        String s = nbtRoot.getString("Owner");
        if (s.length() > 0) {
            this.setOwner(s);
        }
    }

    public String getOwnerName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwner(String username) {
        this.func_110163_bv();
        this.dataWatcher.updateObject(17, (Object)username);
    }

    protected void setupCustomSkin() {
        String username = this.getOwnerName();
        this.locationSkin = AbstractClientPlayer.getLocationSkin((String)username);
        this.downloadImageSkin = AbstractClientPlayer.getDownloadImageSkin((ResourceLocation)this.locationSkin, (String)username);
    }

    public EntityPlayer getOwnerEntity() {
        return this.worldObj.getPlayerEntityByName(this.getOwnerName());
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (!this.worldObj.isRemote) {
            String username = this.getOwnerName();
            for (WorldServer world : MinecraftServer.getServer().worldServers) {
                EntityPlayer player = world.getPlayerEntityByName(username);
                if (player == null) continue;
                if (player.dimension == Config.instance().dimensionDreamID) {
                    WorldProviderDreamWorld.returnPlayerToOverworld(player);
                    break;
                }
                if (!WorldProviderDreamWorld.getPlayerIsGhost(player)) break;
                WorldProviderDreamWorld.returnGhostPlayerToSpiritWorld(player);
                WorldProviderDreamWorld.returnPlayerToOverworld(player);
                break;
            }
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public ResourceLocation getLocationSkin() {
        if (this.locationSkin == null) {
            this.setupCustomSkin();
        }
        if (this.locationSkin != null) {
            return this.locationSkin;
        }
        return AbstractClientPlayer.locationStevePng;
    }
}

