/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.brewing.TileEntityCauldron;
import com.emoniph.witchery.entity.ai.EntityAIMoveToRestrictionAndSit;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.network.PacketSound;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TameableUtil;
import com.emoniph.witchery.util.TargetPointUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityCovenWitch
extends EntityTameable
implements IRangedAttackMob {
    private static final UUID field_110184_bp = UUID.fromString("DA2E2747-8768-4F9A-9135-258E93B077A4");
    private static final AttributeModifier field_110185_bq = new AttributeModifier(field_110184_bp, "Drinking speed penalty", -0.25, 0).setSaved(false);
    private static final Item[] witchDrops = new Item[]{Items.glowstone_dust, Items.sugar, Items.redstone, Items.spider_eye, Items.glass_bottle, Items.gunpowder, Items.stick, Items.stick};
    private int witchAttackTimer;
    private String questOfferedTo = "";
    private boolean questAccepted = false;
    private int questType = 0;
    private int questItemsNeeded = 0;
    private int timeToLive = -1;
    public static final String COVEN_KEY = "WITCCoven";
    private static final int MAX_COVEN_SIZE = 6;
    private static final Quest[] QUESTS = new Quest[]{new FightPetQuest(Witchery.resource("witchery.witch.quest.fightspider"), ""), new FightZombiePetQuest(Witchery.resource("witchery.witch.quest.fightzombie"), ""), new FetchQuest(Witchery.resource("witchery.witch.quest.getdemonheart"), Witchery.resource("witchery.witch.quest.go"), Witchery.Items.GENERIC.itemDemonHeart.createStack()), new FetchQuest(Witchery.resource("witchery.witch.quest.makecrystalball"), Witchery.resource("witchery.witch.quest.go"), new ItemStack(Witchery.Blocks.CRYSTAL_BALL)), new FetchQuest(Witchery.resource("witchery.witch.quest.getbones"), Witchery.resource("witchery.witch.quest.go"), new ItemStack(Items.bone, 30)), new FetchQuest(Witchery.resource("witchery.witch.quest.makegrotesquebrew"), Witchery.resource("witchery.witch.quest.go"), Witchery.Items.GENERIC.itemBrewGrotesque.createStack(5)), new FetchQuest(Witchery.resource("witchery.witch.quest.makenecrostone"), Witchery.resource("witchery.witch.quest.go"), Witchery.Items.GENERIC.itemNecroStone.createStack())};
    private static final String[] FIRST_NAMES = new String[]{"Abigail", "Agatha", "Agony", "Alcina", "Alcyone", "Alexandra", "Alexandria", "Alvira", "Amanita", "Amaranth", "Amarantha", "Ambrosia", "Amelia", "Amethyst", "Anastasia", "Andromeda", "Angel", "Angela", "Angelica", "Angelique", "Anna", "Arachne", "Aradia", "Aria", "Arianna", "Ariadne", "Ariel", "Artemis", "Artemisia", "Astrea", "Astrid", "Astoria", "Autumn", "Aurora", "Beatrix", "Bella", "Belladonna", "Belle", "Bernadette", "Beryl", "Bianca", "Blanche", "Bliss", "Calliope", "Callypso", "Calpurnia", "Camilla", "Carlotta", "Carmilla", "Caroline", "Carrie", "Cassandra", "Cassiopeia", "Catherine", "Cathy", "Cecelia", "Celeste", "Celia", "Charlotte", "Christine", "Circe", "Clara", "Claudia", "Cleopatra", "Columbia", "Coraline", "Cordelia", "Cornelia", "Crystal", "Daphne", "Daria", "Darla", "Delia", "Delilah", "Della", "Demetria", "Demonica", "Desdemona", "Desire", "Dolores", "Dora", "Dove", "Drusilla", "Dusk", "Ebony", "Echo", "Eden", "Elanore", "Electra", "Eldora", "Elena", "Eliza", "Eloise", "Elphaba", "Elspeth", "Elsinore", "Elvira", "Ember", "Emilie", "Ephemera", "Eranthe", "Eris", "Esmerelda", "Estrella", "Esther", "Eterna", "Eternity", "Eudora", "Euphemia", "Eva", "Evalina", "Evangeline", "Eve", "Granny", "Gabriella", "Gabrielle", "Garnet", "Genevieve", "Godiva", "Hathor", "Hecate", "Hecuba", "Helena", "Hepzibah", "Hesperia", "Hippolita", "Ianthe", "Icie", "Icy", "Inez", "Infinity", "Ione", "Iris", "Isabeau", "Isabella", "Isabelle", "Isadora", "Isis", "Isolde", "Istar", "Ivy", "Izora", "Jane", "Jeanette", "Jinx", "Jocasta", "Juliet", "Katrina", "Lavinia", "Layla", "Leona", "Lenora", "Lenore", "Leona", "Libitina", "Ligeia", "Lilah", "Lilith", "Lillian", "Lily", "Lolita", "Lorraine", "Lucinda", "Lucretia", "Luna", "Lydia", "Lyra", "Madeline", "Magdalena", "Magenta", "Mara", "Marcella", "Margaret", "Marguerita", "Maria", "Marie", "Marissa", "Martha", "Matilda", "Medea", "Medusa", "Melanie", "Melantha", "Melanthe", "Melinda", "Mercedes", "Merula", "Mildred", "Mina", "Minerva", "Miranda", "Miriam", "Moira", "Mordea", "Morgan", "Morgana", "Morticia", "Nadia", "Nadine", "Nerezza", "Nora", "Nyx", "Obsidia", "Octavia", "Odessa", "Olivia", "Opal", "Ophelia", "Pandora", "Patience", "Pearl", "Penelope", "Perenelle", "Permelia", "Persephone", "Pixie", "Phoenix", "Poppy", "Priscilla", "Prudence", "Rachel", "Rain", "Raven", "Regina", "Rita", "Rosa", "Rose", "Rosemary", "Rowena", "Ruby", "Sabrina", "Salem", "Samantha", "Sangria", "Scarlet", "Selena", "Selene", "Sephora", "Seraphina", "Serena", "Serenity", "Shannon", "Silver", "Simone", "Sophia", "Sybella", "Sybil", "Sylvia", "Tabitha", "Tempest", "Theda", "Theresa", "Thora", "Threnody", "Trinity", "Twilight", "Umbra", "Vaitiare", "Valerie", "Vanessa", "Verna", "Verona", "Veronica", "Vesta", "Victoria", "Violet", "Whisper", "Willow", "Winter", "Xenobia", "Zillah", "Zinnia"};
    private static final String[] SURNAMES = new String[]{"Adams", "Addams", "Argent", "Ashwood", "Balfour", "Barker", "Batby", "Bathory", "Batsford", "Batson", "Batstone", "Batt", "Baudelaire", "Black", "Blackbird", "Blackburn", "Blackcat", "Blacklock", "Blackmoore", "Blackstone", "Blackthorn", "Blackwell", "Blackwing", "Blackwolf", "Blackwood", "Blair", "Blood", "Bloodgood", "Bloodhart", "Bloodmoore", "Bloodsaw", "Bloodstone", "Bloodsworth", "Bloodwine", "Bloodworth", "Boggart", "Boggarty", "Bonebrake", "Bonehart", "Bonehill", "Bonella", "Boneman", "Bones", "Bonesmith", "Bonewits", "Borden", "Broom", "Broomwood", "Burton", "Byron", "Cackler", "Cain", "Calamity", "Castle", "Castleton", "Cemetary", "Chill", "Chillingwood", "Cobweb", "Coffin", "Coffinberry", "Coffins", "Cold", "Coldbridge", "Coldeman", "Coldstone", "Coldwell", "Cole", "Collins", "Constantine", "Corbett", "Corbin", "Corpse", "Corpseley", "Creak", "Creakey", "Creep", "Creeper", "Creeps", "Crepsley", "Crimson", "Cross", "Crossway", "Crosswicks", "Crow", "Crowden", "Crowe", "Crowley", "Darcy", "Dark", "Darke", "Darken", "Darkenwald", "Darkes", "Darkmoore", "Darkwell", "Darkwood", "Deadman", "Deadmond", "Deadmore", "Deadrick", "Deadwood", "DeAngelus", "Dearborn", "Death", "Deathridge", "Deathrow", "December", "Delambre", "DeLioncourt", "Demond", "Demonde", "Demonte", "DeMort", "DeRavin", "Devall", "Devane", "DeVille", "DeWinter", "Dracul", "Drago", "Drake", "Dread", "Drear", "Dreary", "Drelincourt", "DuLac", "Dumaine", "Dunsany", "Eldritch", "Fang", "Fanger", "Fate", "Faust", "February", "Fear", "Fearfield", "Fears", "Frankenstein", "Frost", "Fury", "Gautier", "Ghoul", "Ghoulson", "Ghost", "Ghosten", "Ghostley", "Giger", "Goblin", "Goth", "Gotham", "Gothard", "Gothberg", "Gravedigger", "Gravemaker", "Graves", "Gravesen", "Gravesgard", "Grey", "Greyson", "Greystone", "Grimmauld", "Grimm", "Grimmer", "Grimmes", "Grimmins", "Grimsbro", "Grimsby", "Grimsman", "Grimwood", "Harker", "Hart", "Haunt", "Haunter", "Haunton", "Haunty", "Hawk", "Hawke", "Havelock", "Heart", "Heartstrom", "Hemlock", "Hex", "Hexem", "Hexter", "Hexwood", "Hollow", "Holmes", "Holmwood", "Hugo", "Hunter", "Hyde", "January", "Jekyll", "Kenrick", "Kilgore", "Killar", "Killewich", "Killings", "LaCroix", "Lapidus", "LaRue", "LeFay", "LeStrange", "LeStrange", "Locke", "London", "Loveless", "Lovelock", "Lovett", "Lycan", "MacBeth", "Mandrake", "Marrow", "Masters", "Mist", "Misteri", "Moan", "Moon", "Moones", "Moonie", "Moonly", "Monet", "Monster", "Monstery", "Montague", "Montresor", "Morgan", "Morgue", "Moriarty", "Murdoc", "Murray", "Morrow", "Mort", "Mortella", "Munster", "Mysterios", "Night", "Nightchase", "Nightengale", "Nightingdale", "Nightman", "Nightwalker", "Nightwine", "Nocton", "Nox", "October", "Odd", "Odder", "Oddman", "Oddson", "Owl", "Owley", "Owlford", "Owlsey", "Pale", "Pale", "Paine", "Pains", "Payne", "Plague", "Poe", "Poe", "Poe", "Pyre", "Pyre", "Pyre", "Radcliffe", "Rain", "Raven", "Ravencraft", "Ravendale", "Ravenhorst", "Ravensloft", "Ravenway", "Rayne", "Reaper", "Redbone", "Redcross", "Redd", "Redfern", "Redgrave", "Redmond", "Redwine", "Redwolf", "Renfield", "Riven", "Rookwood", "Roth", "Ripley", "Ripper", "Salvatore", "Scar", "Scare", "Scarebrook", "Scares", "Scarey", "Scarlati", "Setzer", "Seward", "Shade", "Shademoore", "Shadow", "Shadows", "Shadowton", "Shelley", "Skeleton", "Skelinen", "Skellington", "Skelton", "Skull", "Skullman", "Specter", "Spectre", "Spellman", "Spider", "Spinner", "Spirite", "Spook", "Spook", "Spook", "Song", "Snow", "St. Claire", "St. Germaine", "Steele", "Sterling", "Stoker", "Storm", "Storme", "Stormfelt", "Stormwind", "Stormyr", "Stone", "Stonewall", "Strange", "Strangeman", "Strangeway", "Striker", "Swan", "Swann", "Teeth", "Tombs", "Tombstone", "Towers", "Trick", "Valancourt", "Valdemar", "Valentine", "Valentino", "Vamper", "Vamplers", "Vampouille", "Vamprine", "Vampyr", "Van Allen", "Van Gogh", "Van Halen", "Van Helgen", "Van Helsing", "Voorhees", "Webb", "Weird", "Weird", "West", "Westenra", "White", "Whitebone", "Whitemoon", "Whitewing", "Widdowes", "Wild", "Wildblood", "Wilde", "Winchester", "Windgate", "Windholm", "Windward", "Wing", "Wingblade", "Wingfield", "Winter", "Winterford", "Winterrose", "Winterwood", "Winters", "Witche", "Witcher", "Witchery", "Witchey", "Witchman", "Wither", "Wolf", "Wolfen", "Wolfmann", "Wolfram", "Wolfstone", "Wolftooth"};

    public EntityCovenWitch(World world) {
        super(world);
        this.setSize(0.6f, 1.95f);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)this.aiSit);
        this.tasks.addTask(2, (EntityAIBase)new EntityAIMoveToRestrictionAndSit(this, 0.6));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.setTameSkin(this.rand.nextInt(5));
        this.setTamed(false);
    }

    public boolean getCanSpawnHere() {
        boolean living = this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox);
        int i = MathHelper.floor_double((double)this.posX);
        int j = MathHelper.floor_double((double)this.boundingBox.minY);
        int k = MathHelper.floor_double((double)this.posZ);
        boolean creature = living && this.getBlockPathWeight(i, j, k) >= 0.0f && (Config.instance().covenWitchSpawnWeight == 1 || this.worldObj.rand.nextInt(Config.instance().covenWitchSpawnWeight) == 0);
        return creature;
    }

    public void setCustomNameTag(String par1Str) {
    }

    private void setInnerCustomNameTag(String s) {
        this.dataWatcher.updateObject(10, (Object)s);
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        this.setTameSkin(this.worldObj.rand.nextInt(5));
        return super.onSpawnWithEgg(par1EntityLivingData);
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(18, (Object)0);
        this.getDataWatcher().addObject(21, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("SkinType", this.getTameSkin());
        nbtRoot.setString("QuestOffered", this.questOfferedTo);
        nbtRoot.setBoolean("QuestAccepted", this.questAccepted);
        nbtRoot.setInteger("QuestType", this.questType);
        nbtRoot.setInteger("QuestItemsNeeded", this.questItemsNeeded);
        nbtRoot.setInteger("SuicideIn", this.timeToLive);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setTameSkin(nbtRoot.getInteger("SkinType"));
        this.questOfferedTo = nbtRoot.getString("QuestOffered");
        this.questAccepted = nbtRoot.getBoolean("QuestAccepted");
        this.questType = nbtRoot.getInteger("QuestType");
        this.questItemsNeeded = nbtRoot.getInteger("QuestItemsNeeded");
        this.timeToLive = nbtRoot.hasKey("SuicideIn") ? nbtRoot.getInteger("SuicideIn") : -1;
        if (nbtRoot.hasKey("CustomName") && nbtRoot.getString("CustomName").length() > 0) {
            this.setInnerCustomNameTag(nbtRoot.getString("CustomName"));
        }
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.covenwitch.name");
    }

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public void updateAITick() {
        super.updateAITick();
        if (this.worldObj != null && !this.isDead && !this.worldObj.isRemote && this.timeToLive != -1) {
            if (this.timeToLive > 0) {
                --this.timeToLive;
            }
            if (this.getAttackTarget() == null && this.timeToLive == 0) {
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 1.0, 16);
                this.setDead();
            }
        }
    }

    public void onDeath(DamageSource damageSource) {
        EntityPlayer player;
        NBTTagCompound nbtPlayer;
        EntityLivingBase owner;
        if (!this.worldObj.isRemote && this.isTamed() && (owner = this.getOwner()) != null && owner instanceof EntityPlayer && (nbtPlayer = Infusion.getNBT((Entity)(player = (EntityPlayer)owner))).hasKey(COVEN_KEY)) {
            NBTTagList nbtCovenList = nbtPlayer.getTagList(COVEN_KEY, 10);
            for (int i = 0; i < nbtCovenList.tagCount(); ++i) {
                NBTTagCompound nbtWitch = nbtCovenList.getCompoundTagAt(i);
                if (!nbtWitch.getString("WitchName").equalsIgnoreCase(this.getCustomNameTag())) continue;
                nbtCovenList.removeTag(i);
                break;
            }
        }
        super.onDeath(damageSource);
    }

    public int getTameSkin() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void setTameSkin(int par1) {
        this.dataWatcher.updateObject(18, (Object)((byte)par1));
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "mob.witch.hurt";
    }

    protected String getDeathSound() {
        return "mob.witch.death";
    }

    public void setAggressive(boolean aggressive) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(21);
        b0 = aggressive ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.dataWatcher.updateObject(21, (Object)b0);
    }

    public boolean getAggressive() {
        return (this.dataWatcher.getWatchableObjectByte(21) & 1) != 0;
    }

    public void setQuestOffered(boolean aggressive) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(21);
        b0 = aggressive ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB);
        this.dataWatcher.updateObject(21, (Object)b0);
    }

    public boolean isQuestOffered() {
        return (this.dataWatcher.getWatchableObjectByte(21) & 2) != 0;
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void onLivingUpdate() {
        if (!this.worldObj.isRemote) {
            if (this.getAggressive()) {
                if (this.witchAttackTimer-- <= 0) {
                    List list;
                    this.setAggressive(false);
                    ItemStack itemstack = this.getHeldItem();
                    this.setCurrentItemOrArmor(0, null);
                    if (itemstack != null && itemstack.getItem() == Items.potionitem && (list = Items.potionitem.getEffects(itemstack)) != null) {
                        for (PotionEffect potioneffect : list) {
                            this.addPotionEffect(new PotionEffect(potioneffect));
                        }
                    }
                    this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).removeModifier(field_110185_bq);
                }
            } else {
                int short1 = -1;
                if (this.rand.nextFloat() < 0.15f && this.isBurning() && !this.isPotionActive(Potion.fireResistance)) {
                    short1 = 16307;
                } else if (this.rand.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                    short1 = 16341;
                } else if (this.rand.nextFloat() < 0.25f && this.getAttackTarget() != null && !this.isPotionActive(Potion.moveSpeed) && this.getAttackTarget().getDistanceSqToEntity((Entity)this) > 121.0) {
                    short1 = 16274;
                } else if (this.rand.nextFloat() < 0.25f && this.getAttackTarget() != null && !this.isPotionActive(Potion.moveSpeed) && this.getAttackTarget().getDistanceSqToEntity((Entity)this) > 121.0) {
                    short1 = 16274;
                }
                if (short1 > -1) {
                    this.setCurrentItemOrArmor(0, new ItemStack((Item)Items.potionitem, 1, short1));
                    this.witchAttackTimer = this.getHeldItem().getMaxItemUseDuration();
                    this.setAggressive(true);
                    IAttributeInstance attributeinstance = this.getEntityAttribute(SharedMonsterAttributes.movementSpeed);
                    attributeinstance.removeModifier(field_110185_bq);
                    attributeinstance.applyModifier(field_110185_bq);
                }
            }
            if (this.rand.nextFloat() < 7.5E-4f) {
                this.worldObj.setEntityState((Entity)this, (byte)15);
            }
        }
        super.onLivingUpdate();
    }

    protected float applyPotionDamageCalculations(DamageSource par1DamageSource, float par2) {
        par2 = super.applyPotionDamageCalculations(par1DamageSource, par2);
        if (par1DamageSource.getEntity() == this) {
            par2 = 0.0f;
        }
        if (par1DamageSource.isMagicDamage()) {
            par2 = (float)((double)par2 * 0.15);
        }
        return par2;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 15) {
            for (int i = 0; i < this.rand.nextInt(35) + 10; ++i) {
                this.worldObj.spawnParticle("witchMagic", this.posX + this.rand.nextGaussian() * (double)0.13f, this.boundingBox.maxY + 0.5 + this.rand.nextGaussian() * (double)0.13f, this.posZ + this.rand.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public boolean interact(EntityPlayer player) {
        if (!this.worldObj.isRemote && player != null) {
            if (!this.isTamed() && !this.getAggressive() && player.dimension != Config.instance().dimensionDreamID) {
                if (this.questAccepted) {
                    if (this.questOfferedTo.equalsIgnoreCase(player.getCommandSenderName())) {
                        if (this.isCovenFull(player)) {
                            this.questAccepted = false;
                            this.questType = 0;
                            this.questOfferedTo = "";
                            EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.4f);
                            ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), Witchery.resource("witchery.witch.say.covenfull")));
                        } else if (EntityCovenWitch.isQuestItemForEntity(player.getHeldItem(), this)) {
                            --player.inventory.mainInventory[player.inventory.currentItem].stackSize;
                            if (player.inventory.mainInventory[player.inventory.currentItem].stackSize == 0) {
                                player.inventory.mainInventory[player.inventory.currentItem] = null;
                            }
                            if (--this.questItemsNeeded == 0) {
                                if (this.addToPlayerCoven(player)) {
                                    ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), Witchery.resource("witchery.witch.say.joinedcoven")));
                                } else {
                                    ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), Witchery.resource("witchery.witch.say.tricked")));
                                    this.setRevengeTarget((EntityLivingBase)player);
                                    this.setAttackTarget((EntityLivingBase)player);
                                    this.setTarget((Entity)player);
                                    this.setAggressive(true);
                                    this.questAccepted = false;
                                    this.questType = 0;
                                    this.questOfferedTo = "";
                                }
                            } else {
                                ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), String.format(Witchery.resource("witchery.witch.say.questitemsremaining"), Integer.valueOf(this.questItemsNeeded).toString())));
                            }
                            EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.8f);
                        } else {
                            ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), Witchery.resource("witchery.witch.say.questnotfinished")));
                            EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.4f);
                        }
                    } else {
                        ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), Witchery.resource("witchery.witch.say.begone")));
                        EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.4f);
                    }
                } else if (!this.questOfferedTo.equalsIgnoreCase(player.getCommandSenderName())) {
                    this.func_110163_bv();
                    if (!this.hasCustomNameTag()) {
                        this.setInnerCustomNameTag(EntityCovenWitch.generateWitchName());
                    }
                    if (this.isCovenFull(player)) {
                        EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.4f);
                        ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), Witchery.resource("witchery.witch.say.covenfull")));
                    } else if (!Familiar.hasActiveFamiliar(player)) {
                        String s;
                        switch (this.worldObj.rand.nextInt(3)) {
                            default: {
                                s = Witchery.resource("witchery.witch.say.notinterested1");
                                break;
                            }
                            case 1: {
                                s = Witchery.resource("witchery.witch.say.notinterested2");
                                break;
                            }
                            case 2: {
                                s = Witchery.resource("witchery.witch.say.notinterested3");
                            }
                        }
                        EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.4f);
                        ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), s));
                    } else {
                        this.questOfferedTo = player.getCommandSenderName();
                        this.questType = this.worldObj.rand.nextInt(QUESTS.length);
                        this.questItemsNeeded = QUESTS[this.questType].getItemsNeeded();
                        ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), QUESTS[this.questType].getDescriptionText()));
                        EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.4f);
                    }
                } else if (this.isCovenFull(player)) {
                    this.questOfferedTo = "";
                    EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 0.4f);
                    ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), Witchery.resource("witchery.witch.say.covenfull")));
                } else {
                    this.questAccepted = true;
                    QUESTS[this.questType].activate(this.worldObj, this, player);
                    if (!QUESTS[this.questType].getStartText().isEmpty()) {
                        ChatUtil.sendPlain(EnumChatFormatting.BLUE, (ICommandSender)player, String.format("<%s> %s", this.getCustomNameTag(), QUESTS[this.questType].getStartText()));
                    }
                    EntityCovenWitch.playWitchTalk(this.worldObj, (Entity)this, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isCovenFull(EntityPlayer player) {
        return EntityCovenWitch.getCovenSize(player) >= 6;
    }

    public static int getCovenSize(EntityPlayer player) {
        if (player == null) {
            return 0;
        }
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        if (!nbtPlayer.hasKey(COVEN_KEY)) {
            return 0;
        }
        NBTTagList nbtCovenList = nbtPlayer.getTagList(COVEN_KEY, 10);
        return nbtCovenList.tagCount();
    }

    protected boolean canDespawn() {
        if (this.isTamed()) {
            EntityLivingBase player = this.getOwner();
            if (player == null) {
                return true;
            }
            if (player.getDistanceSqToEntity((Entity)this) > 4096.0) {
                return true;
            }
            return super.canDespawn();
        }
        return super.canDespawn();
    }

    private boolean addToPlayerCoven(EntityPlayer player) {
        NBTTagList nbtCovenList;
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        if (!nbtPlayer.hasKey(COVEN_KEY)) {
            nbtPlayer.setTag(COVEN_KEY, (NBTBase)new NBTTagList());
        }
        if (this.isWitchInList(nbtCovenList = nbtPlayer.getTagList(COVEN_KEY, 10))) {
            return false;
        }
        this.setTamed(true);
        TameableUtil.setOwner(this, player);
        NBTTagCompound nbtWitch = new NBTTagCompound();
        this.writeToPlayerNBT(nbtWitch);
        nbtCovenList.appendTag((NBTBase)nbtWitch);
        ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 2.0, 16);
        this.setDead();
        return true;
    }

    private boolean isWitchInList(NBTTagList nbtCovenList) {
        for (int i = 0; i < nbtCovenList.tagCount(); ++i) {
            String name;
            NBTTagCompound nbtWitch = nbtCovenList.getCompoundTagAt(i);
            if (nbtWitch == null || (name = nbtWitch.getString("WitchName")) == null || !name.equalsIgnoreCase(this.getCustomNameTag())) continue;
            return true;
        }
        return false;
    }

    private void writeToPlayerNBT(NBTTagCompound nbtWitch) {
        nbtWitch.setString("WitchName", this.getCustomNameTag());
        nbtWitch.setInteger("Skin", this.getTameSkin());
        nbtWitch.setInteger("Quest", this.questType);
    }

    private void readFromPlayerNBT(NBTTagCompound nbtWitch) {
        this.setTameSkin(nbtWitch.getInteger("Skin"));
        this.questType = nbtWitch.getInteger("Quest");
        this.setInnerCustomNameTag(nbtWitch.getString("WitchName"));
    }

    public static void summonCoven(ArrayList<RitualStep> ritualSteps, World world, EntityPlayer player, int[][] pos) {
        double RADIUS_XZ = 64.0;
        double RADIUS_Y = 16.0;
        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 64.0), (double)(player.posY - 16.0), (double)(player.posZ - 64.0), (double)(player.posX + 64.0), (double)(player.posY + 16.0), (double)(player.posZ + 64.0));
        List entities = world.getEntitiesWithinAABB(EntityCovenWitch.class, bounds);
        for (int index = 0; index < entities.size(); ++index) {
            EntityCovenWitch witch = (EntityCovenWitch)((Object)entities.get(index));
            if (!witch.isTamed() || witch.getOwner() != player) continue;
            ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)witch, 1.0, 2.0, 16);
            witch.setDead();
        }
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        if (nbtPlayer.hasKey(COVEN_KEY)) {
            NBTTagList nbtCovenList = nbtPlayer.getTagList(COVEN_KEY, 10);
            for (int index = 0; index < nbtCovenList.tagCount() && index < pos.length; ++index) {
                ritualSteps.add(new StepSummonCovenMemeber(player, index, pos[index]));
            }
        }
    }

    public static void summonCoven(World world, EntityPlayer player, Coord target, int ticks) {
        NBTTagCompound nbtPlayer;
        if (ticks % 20 == 0 && ticks / 20 > 0 && (nbtPlayer = Infusion.getNBT((Entity)player)).hasKey(COVEN_KEY)) {
            double RADIUS_XZ = 64.0;
            double RADIUS_Y = 16.0;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 64.0), (double)(player.posY - 16.0), (double)(player.posZ - 64.0), (double)(player.posX + 64.0), (double)(player.posY + 16.0), (double)(player.posZ + 64.0));
            List entities = world.getEntitiesWithinAABB(EntityCovenWitch.class, bounds);
            int witchIndex = ticks / 20 - 1;
            NBTTagList nbtCovenList = nbtPlayer.getTagList(COVEN_KEY, 10);
            if (witchIndex > nbtCovenList.tagCount()) {
                return;
            }
            NBTTagCompound nbtWitch = nbtCovenList.getCompoundTagAt(witchIndex);
            EntityCovenWitch witch = null;
            for (int index = 0; index < entities.size(); ++index) {
                EntityCovenWitch witchAround = (EntityCovenWitch)((Object)entities.get(index));
                if (!witchAround.isTamed() || witchAround.getOwner() != player || !witchAround.getCustomNameTag().equalsIgnoreCase(nbtWitch.getString("WitchName"))) continue;
                witch = witchAround;
                break;
            }
            boolean spawn = false;
            if (witch == null) {
                witch = new EntityCovenWitch(world);
                witch.readFromPlayerNBT(nbtWitch);
                witch.setTamed(true);
                TameableUtil.setOwner(witch, player);
                spawn = true;
            }
            TileEntity closest = null;
            double bestDistSq = 0.0;
            for (Object obj : world.loadedTileEntityList) {
                TileEntity tile = (TileEntity)obj;
                if (!(tile instanceof TileEntityCauldron)) continue;
                double dist = player.getDistanceSq((double)tile.xCoord, (double)tile.yCoord, (double)tile.zCoord);
                if (closest != null && !(dist < bestDistSq)) continue;
                closest = tile;
                bestDistSq = dist;
            }
            double cauldronRange = 9.0;
            double cauldronRangeSq = 81.0;
            if (closest != null && bestDistSq <= 81.0) {
                witch.setHomeArea(closest.xCoord, closest.yCoord, closest.zCoord, 3);
                int maxRange = 3;
                int minRange = 1;
                int activeRadius = maxRange - minRange;
                int ax = world.rand.nextInt(activeRadius * 2 + 1);
                if (ax > activeRadius) {
                    ax += minRange * 2;
                }
                int nx = closest.xCoord - maxRange + ax;
                int az = world.rand.nextInt(activeRadius * 2 + 1);
                if (az > activeRadius) {
                    az += minRange * 2;
                }
                int nz = closest.zCoord - maxRange + az;
                witch.setPositionAndRotation(nx, 0.01 + (double)closest.yCoord, nz, 0.0f, 0.0f);
            } else {
                witch.setPositionAndRotation(0.5 + (double)target.x + (double)world.rand.nextInt(3) - 1.5, 0.01 + (double)target.y, 0.5 + (double)target.z + (double)world.rand.nextInt(3) - 1.5, 0.0f, 0.0f);
            }
            witch.aiSit.resetTask();
            witch.setTimeToLive(1200);
            if (spawn) {
                world.spawnEntityInWorld((Entity)witch);
            }
            ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)witch, 1.0, 2.0, 16);
        }
    }

    public static void summonCovenMember(World world, EntityPlayer player, int ttlSecs) {
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        if (nbtPlayer.hasKey(COVEN_KEY)) {
            NBTTagList nbtCovenList = nbtPlayer.getTagList(COVEN_KEY, 10);
            if (nbtCovenList.tagCount() > 0) {
                int i1;
                int l;
                int k;
                int j;
                int i;
                EntityCovenWitch witch;
                double RADIUS_XZ = 64.0;
                double RADIUS_Y = 16.0;
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 64.0), (double)(player.posY - 16.0), (double)(player.posZ - 64.0), (double)(player.posX + 64.0), (double)(player.posY + 16.0), (double)(player.posZ + 64.0));
                List entities = world.getEntitiesWithinAABB(EntityCovenWitch.class, bounds);
                Collections.shuffle(entities);
                for (int index = 0; index < entities.size(); ++index) {
                    witch = (EntityCovenWitch)((Object)entities.get(index));
                    if (!witch.isTamed() || witch.getOwner() != player) continue;
                    i = MathHelper.floor_double((double)player.posX) - 2;
                    j = MathHelper.floor_double((double)player.posZ) - 2;
                    k = MathHelper.floor_double((double)player.boundingBox.minY);
                    for (l = 0; l <= 4; ++l) {
                        for (i1 = 0; i1 <= 4; ++i1) {
                            if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !world.getBlock(i + l, k - 1, j + i1).isSideSolid((IBlockAccess)world, i + l, k - 1, j + i1, ForgeDirection.UP) || world.getBlock(i + l, k, j + i1).isNormalCube() || world.getBlock(i + l, k + 1, j + i1).isNormalCube()) continue;
                            ItemGeneral cfr_ignored_0 = Witchery.Items.GENERIC;
                            ItemGeneral.teleportToLocation(world, (float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, player.dimension, (Entity)witch, true);
                            witch.getNavigator().clearPathEntity();
                            return;
                        }
                    }
                }
                NBTTagCompound nbtWitch = nbtCovenList.getCompoundTagAt(world.rand.nextInt(nbtCovenList.tagCount()));
                witch = new EntityCovenWitch(world);
                i = MathHelper.floor_double((double)player.posX) - 2;
                j = MathHelper.floor_double((double)player.posZ) - 2;
                k = MathHelper.floor_double((double)player.boundingBox.minY);
                block3: for (l = 0; l <= 4; ++l) {
                    for (i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !world.getBlock(i + l, k - 1, j + i1).isSideSolid((IBlockAccess)world, i + l, k - 1, j + i1, ForgeDirection.UP) || world.getBlock(i + l, k, j + i1).isNormalCube() || world.getBlock(i + l, k + 1, j + i1).isNormalCube()) continue;
                        witch.setLocationAndAngles((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, 0.0f, 0.0f);
                        continue block3;
                    }
                }
                witch.setTamed(true);
                TameableUtil.setOwner(witch, player);
                witch.readFromPlayerNBT(nbtWitch);
                witch.setTimeToLive(ttlSecs * 20);
                world.spawnEntityInWorld((Entity)witch);
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)witch, 1.0, 2.0, 16);
            } else {
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            }
        } else {
            SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
        }
    }

    private static void playWitchTalk(World world, Entity where, float volume) {
        Witchery.packetPipeline.sendToAllAround(new PacketSound(world.rand.nextBoolean() ? SoundEffect.WITCHERY_MOB_BABA_DEATH : SoundEffect.WITCHERY_MOB_BABA_LIVING, where, 1.0f, 1.0f), TargetPointUtil.from(where, 8.0));
    }

    private static boolean isQuestItemForEntity(ItemStack stack, EntityCovenWitch questGiver) {
        if (questGiver != null && stack != null) {
            NBTTagCompound nbtRoot;
            if (QUESTS[questGiver.questType].isQuestItem(stack)) {
                return true;
            }
            if (stack.hasTagCompound() && (nbtRoot = stack.getTagCompound()).hasKey("WITCQuestOwnerIDLeast") && nbtRoot.hasKey("WITCQuestOwnerIDMost")) {
                UUID questGiverID = new UUID(nbtRoot.getLong("WITCQuestOwnerIDMost"), nbtRoot.getLong("WITCQuestOwnerIDLeast"));
                return questGiverID.equals(questGiver.getPersistentID());
            }
        }
        return false;
    }

    protected void dropFewItems(boolean par1, int par2) {
        int j = this.rand.nextInt(3) + 1;
        for (int k = 0; k < j; ++k) {
            int l = this.rand.nextInt(3);
            Item i1 = witchDrops[this.rand.nextInt(witchDrops.length)];
            if (par2 > 0) {
                l += this.rand.nextInt(par2 + 1);
            }
            for (int j1 = 0; j1 < l; ++j1) {
                this.dropItem(i1, 1);
            }
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase par1EntityLivingBase, float par2) {
        if (!this.getAggressive()) {
            EntityPotion entitypotion = new EntityPotion(this.worldObj, (EntityLivingBase)this, 32732);
            entitypotion.rotationPitch -= -20.0f;
            double d0 = par1EntityLivingBase.posX + par1EntityLivingBase.motionX - this.posX;
            double d1 = par1EntityLivingBase.posY + (double)par1EntityLivingBase.getEyeHeight() - (double)1.1f - this.posY;
            double d2 = par1EntityLivingBase.posZ + par1EntityLivingBase.motionZ - this.posZ;
            float f1 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2));
            if (f1 >= 8.0f && !par1EntityLivingBase.isPotionActive(Potion.moveSlowdown)) {
                entitypotion.setPotionDamage(32698);
            } else if (par1EntityLivingBase.getHealth() >= 8.0f && !par1EntityLivingBase.isPotionActive(Potion.poison)) {
                entitypotion.setPotionDamage(32660);
            } else if (f1 <= 3.0f && !par1EntityLivingBase.isPotionActive(Potion.weakness) && this.rand.nextFloat() < 0.25f) {
                entitypotion.setPotionDamage(32696);
            }
            entitypotion.setThrowableHeading(d0, d1 + (double)(f1 * 0.2f), d2, 0.75f, 8.0f);
            this.worldObj.spawnEntityInWorld((Entity)entitypotion);
        }
    }

    public EntityAgeable createChild(EntityAgeable entityageable) {
        return null;
    }

    public static String generateWitchName() {
        Random ra = new Random();
        return String.format("%s %s", FIRST_NAMES[ra.nextInt(FIRST_NAMES.length)], SURNAMES[ra.nextInt(SURNAMES.length)]);
    }

    public void standStill() {
        this.aiSit.setSitting(true);
    }

    private static class FightZombiePetQuest
    extends Quest {
        public FightZombiePetQuest(String descriptionText, String startText) {
            super(descriptionText, startText, 1);
        }

        @Override
        public void activate(World world, EntityCovenWitch witch, EntityPlayer player) {
            EntityZombie spider = new EntityZombie(world);
            spider.setLocationAndAngles(witch.posX, witch.posY, witch.posZ, witch.rotationPitch, witch.rotationYaw);
            world.spawnEntityInWorld((Entity)spider);
            spider.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
            spider.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
            spider.setCurrentItemOrArmor(4, new ItemStack(Items.skull));
            spider.setHealth((float)spider.getEntityAttribute(SharedMonsterAttributes.maxHealth).getAttributeValue());
            spider.setAttackTarget((EntityLivingBase)player);
            spider.setTarget((Entity)player);
            spider.setRevengeTarget((EntityLivingBase)player);
            spider.setCustomNameTag(String.format(Witchery.resource("witchery.witch.pet"), witch.getCustomNameTag()));
            ItemStack stack = new ItemStack(Items.rotten_flesh);
            stack.setStackDisplayName(String.format(Witchery.resource("witchery.witch.petflesh"), witch.getCustomNameTag()));
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = stack.getTagCompound();
            nbtRoot.setLong("WITCQuestOwnerIDLeast", witch.getUniqueID().getLeastSignificantBits());
            nbtRoot.setLong("WITCQuestOwnerIDMost", witch.getUniqueID().getMostSignificantBits());
            NBTTagCompound nbtExtraDrop = new NBTTagCompound();
            stack.writeToNBT(nbtExtraDrop);
            NBTTagCompound nbtSpider = spider.getEntityData();
            if (!nbtSpider.hasKey("WITCExtraDrops")) {
                nbtSpider.setTag("WITCExtraDrops", (NBTBase)new NBTTagList());
            }
            NBTTagList nbtExtraDrops = nbtSpider.getTagList("WITCExtraDrops", 10);
            nbtExtraDrops.appendTag((NBTBase)nbtExtraDrop);
            ParticleEffect.MOB_SPELL.send(SoundEffect.NONE, (Entity)spider, 2.0, 2.0, 16);
        }
    }

    private static class FightPetQuest
    extends Quest {
        public FightPetQuest(String descriptionText, String startText) {
            super(descriptionText, startText, 1);
        }

        @Override
        public void activate(World world, EntityCovenWitch witch, EntityPlayer player) {
            EntitySpider spider = new EntitySpider(world);
            spider.setLocationAndAngles(witch.posX, witch.posY, witch.posZ, witch.rotationPitch, witch.rotationYaw);
            world.spawnEntityInWorld((Entity)spider);
            spider.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
            spider.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
            spider.setHealth((float)spider.getEntityAttribute(SharedMonsterAttributes.maxHealth).getAttributeValue());
            spider.setAttackTarget((EntityLivingBase)player);
            spider.setTarget((Entity)player);
            spider.setRevengeTarget((EntityLivingBase)player);
            spider.setCustomNameTag(String.format(Witchery.resource("witchery.witch.pet"), witch.getCustomNameTag()));
            ItemStack stack = new ItemStack(Items.spider_eye);
            stack.setStackDisplayName(String.format(Witchery.resource("witchery.witch.peteye"), witch.getCustomNameTag()));
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = stack.getTagCompound();
            nbtRoot.setLong("WITCQuestOwnerIDLeast", witch.getUniqueID().getLeastSignificantBits());
            nbtRoot.setLong("WITCQuestOwnerIDMost", witch.getUniqueID().getMostSignificantBits());
            NBTTagCompound nbtExtraDrop = new NBTTagCompound();
            stack.writeToNBT(nbtExtraDrop);
            NBTTagCompound nbtSpider = spider.getEntityData();
            if (!nbtSpider.hasKey("WITCExtraDrops")) {
                nbtSpider.setTag("WITCExtraDrops", (NBTBase)new NBTTagList());
            }
            NBTTagList nbtExtraDrops = nbtSpider.getTagList("WITCExtraDrops", 10);
            nbtExtraDrops.appendTag((NBTBase)nbtExtraDrop);
            ParticleEffect.MOB_SPELL.send(SoundEffect.NONE, (Entity)spider, 2.0, 2.0, 16);
        }
    }

    private static class FetchQuest
    extends Quest {
        final ItemStack stack;

        public FetchQuest(String descriptionText, String startText, ItemStack stack) {
            super(descriptionText, startText, stack.stackSize);
            this.stack = stack;
        }

        @Override
        public void activate(World world, EntityCovenWitch witch, EntityPlayer player) {
        }

        @Override
        public boolean isQuestItem(ItemStack stack) {
            return this.stack.isItemEqual(stack);
        }
    }

    private static abstract class Quest {
        private final String questDescriptionText;
        private final String questStartText;
        private final int itemsNeeded;

        public Quest(String descriptionText, String startText, int itemsNeeded) {
            this.questStartText = startText;
            this.questDescriptionText = descriptionText;
            this.itemsNeeded = itemsNeeded;
        }

        public int getItemsNeeded() {
            return this.itemsNeeded;
        }

        public String getDescriptionText() {
            return this.questDescriptionText;
        }

        public String getStartText() {
            return this.questStartText;
        }

        public abstract void activate(World var1, EntityCovenWitch var2, EntityPlayer var3);

        public boolean isQuestItem(ItemStack stack) {
            return false;
        }
    }

    private static class StepSummonCovenMemeber
    extends RitualStep {
        private final int index;
        private final int[] position;

        public StepSummonCovenMemeber(EntityPlayer player, int index, int[] position) {
            super(false);
            this.index = index;
            this.position = position;
        }

        @Override
        public RitualStep.Result process(World world, int xCoord, int yCoord, int zCoord, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            NBTTagCompound nbtPlayer;
            if (ticks % 20L != 0L) {
                return RitualStep.Result.STARTING;
            }
            EntityPlayer player = ritual.getInitiatingPlayer(world);
            if (player != null && (nbtPlayer = Infusion.getNBT((Entity)player)).hasKey(EntityCovenWitch.COVEN_KEY)) {
                double RADIUS_XZ = 64.0;
                double RADIUS_Y = 16.0;
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 64.0), (double)(player.posY - 16.0), (double)(player.posZ - 64.0), (double)(player.posX + 64.0), (double)(player.posY + 16.0), (double)(player.posZ + 64.0));
                List entities = world.getEntitiesWithinAABB(EntityCovenWitch.class, bounds);
                NBTTagList nbtCovenList = nbtPlayer.getTagList(EntityCovenWitch.COVEN_KEY, 10);
                NBTTagCompound nbtWitch = nbtCovenList.getCompoundTagAt(this.index);
                EntityCovenWitch witch = null;
                for (int index = 0; index < entities.size(); ++index) {
                    EntityCovenWitch witchAround = (EntityCovenWitch)((Object)entities.get(index));
                    if (!witchAround.isTamed() || witchAround.getOwner() != player || !witchAround.getCustomNameTag().equalsIgnoreCase(nbtWitch.getString("WitchName"))) continue;
                    witch = witchAround;
                    break;
                }
                boolean spawn = false;
                if (witch == null) {
                    witch = new EntityCovenWitch(world);
                    witch.readFromPlayerNBT(nbtWitch);
                    witch.setTamed(true);
                    TameableUtil.setOwner(witch, player);
                    spawn = true;
                }
                float[] FACING = new float[]{-45.0f, 45.0f, -135.0f, 135.0f, 180.0f, 0.0f};
                witch.setPositionAndRotation(0.5 + (double)this.position[0], 0.01 + (double)this.position[1], 0.5 + (double)this.position[2], FACING[this.index], 0.0f);
                witch.rotationYawHead = witch.rotationYaw;
                witch.renderYawOffset = witch.rotationYaw;
                witch.prevRotationYaw = witch.rotationYaw;
                witch.aiSit.setSitting(true);
                witch.setTimeToLive(300);
                if (spawn) {
                    world.spawnEntityInWorld((Entity)witch);
                }
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)witch, 1.0, 2.0, 16);
            }
            return RitualStep.Result.COMPLETED;
        }
    }
}

