/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.util.Dye;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class EntityEnt
extends EntityMob
implements IEntitySelector {
    private int attackTimer;
    EntityPlayer fakePlayer = null;

    public EntityEnt(World par1World) {
        super(par1World);
        this.setSize(1.2f, 3.0f);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, (IEntitySelector)this));
        this.experienceValue = 25;
    }

    public boolean isEntityApplicable(Entity entity) {
        return true;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(16, (Object)0);
    }

    public boolean isScreaming() {
        return this.dataWatcher.getWatchableObjectByte(16) > 0;
    }

    public void setScreaming(boolean par1) {
        this.dataWatcher.updateObject(16, (Object)((byte)(par1 ? 1 : 0)));
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.ent.name");
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        super.updateAITick();
        if (!this.worldObj.isRemote && this.isEntityAlive()) {
            if (this.getAttackTarget() != null) {
                this.setScreaming(true);
            } else {
                this.setScreaming(false);
            }
        }
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(200.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        Block l;
        int k;
        int j;
        int i;
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.worldObj.isRemote && this.worldObj.rand.nextInt(300) == 0) {
            try {
                i = MathHelper.floor_double((double)this.posX);
                j = MathHelper.floor_double((double)this.posY) - 1;
                k = MathHelper.floor_double((double)this.posZ);
                if ((this.fakePlayer == null || this.fakePlayer.worldObj != this.worldObj) && this.worldObj instanceof WorldServer) {
                    this.fakePlayer = new FakePlayer((WorldServer)this.worldObj, new GameProfile(UUID.randomUUID(), "[Minecraft]"));
                }
                if (this.fakePlayer != null) {
                    ItemDye.applyBonemeal((ItemStack)Dye.BONE_MEAL.createStack(), (World)this.worldObj, (int)i, (int)j, (int)k, (EntityPlayer)this.fakePlayer);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.motionX * this.motionX + this.motionZ * this.motionZ > 2.500000277905201E-7 && this.rand.nextInt(5) == 0 && (l = this.worldObj.getBlock(i = MathHelper.floor_double((double)this.posX), j = MathHelper.floor_double((double)(this.posY - (double)0.2f - (double)this.yOffset)), k = MathHelper.floor_double((double)this.posZ))) != Blocks.air) {
            this.worldObj.spawnParticle("tilecrack_" + l + "_" + this.worldObj.getBlockMetadata(i, j, k), this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.boundingBox.minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0);
        }
    }

    public boolean canAttackClass(Class par1Class) {
        return super.canAttackClass(par1Class);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        if (this.getOwnerName() == null) {
            par1NBTTagCompound.setString("Owner", "");
        } else {
            par1NBTTagCompound.setString("Owner", this.getOwnerName());
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        String s = par1NBTTagCompound.getString("Owner");
        if (s.length() > 0) {
            this.setOwner(s);
        }
    }

    public String getOwnerName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwner(String par1Str) {
        this.func_110163_bv();
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public EntityPlayer getOwnerEntity() {
        return this.worldObj.getPlayerEntityByName(this.getOwnerName());
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = super.attackEntityAsMob(par1Entity);
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        Entity entity = par1DamageSource.getEntity();
        par2 = Math.min(par2, 15.0f);
        if (entity != null && entity instanceof EntityLivingBase && (par1DamageSource.damageType == "mob" || par1DamageSource.damageType == "player") && ((EntityLivingBase)entity).getHeldItem() != null && ((EntityLivingBase)entity).getHeldItem().getItem() instanceof ItemAxe) {
            par2 *= 3.0f;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "mob.horse.zombie.hit";
    }

    protected String getDeathSound() {
        return "mob.horse.zombie.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.irongolem.walk", 1.0f, 1.0f);
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(Witchery.Items.GENERIC.itemBranchEnt.createStack(), 0.0f);
        this.entityDropItem(new ItemStack(Witchery.Blocks.SAPLING, 1, this.worldObj.rand.nextInt(3)), 0.0f);
    }

    public boolean isPlayerCreated() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setPlayerCreated(boolean par1) {
        this.func_110163_bv();
        byte b0 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
    }

    protected boolean canDespawn() {
        return true;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        return super.onSpawnWithEgg(par1EntityLivingData);
    }
}

