/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.util.Waypoint;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityFlyingTameable
extends EntityTameable {
    protected EntityAISit aiSit = new EntityAISit((EntityTameable)this);
    public ItemStack waypoint = null;
    public double homeX;
    public double homeY;
    public double homeZ;

    public Waypoint getWaypoint() {
        return new Waypoint(this.worldObj, this.waypoint, this.homeX, this.homeY, this.homeZ);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (this.waypoint != null) {
            NBTTagCompound nbtWaypoint = new NBTTagCompound();
            this.waypoint.writeToNBT(nbtWaypoint);
            nbtRoot.setTag("WITCWaypoint", (NBTBase)nbtWaypoint);
        }
        nbtRoot.setDouble("HomeX", this.homeX);
        nbtRoot.setDouble("HomeY", this.homeY);
        nbtRoot.setDouble("HomeZ", this.homeZ);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("WITCWaypoint")) {
            NBTTagCompound nbtWaypoint = nbtRoot.getCompoundTag("WITCWaypoint");
            this.waypoint = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbtWaypoint);
        } else {
            this.waypoint = null;
        }
        this.homeX = nbtRoot.getDouble("HomeX");
        this.homeY = nbtRoot.getDouble("HomeY");
        this.homeZ = nbtRoot.getDouble("HomeZ");
    }

    public EntityFlyingTameable(World par1World) {
        super(par1World);
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public void moveEntityWithHeading(float par1, float par2) {
        if (this.isInWater()) {
            this.moveFlying(par1, par2, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
        } else if (this.handleLavaMovement()) {
            this.moveFlying(par1, par2, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.54600006f;
                Block i = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.boundingBox.minY) - 1, MathHelper.floor_double((double)this.posZ));
                if (i != Blocks.air) {
                    f2 = i.slipperiness * 0.91f;
                }
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            this.moveFlying(par1, par2, this.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.54600006f;
                Block j = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.boundingBox.minY) - 1, MathHelper.floor_double((double)this.posZ));
                if (j != Blocks.air) {
                    f2 = j.slipperiness * 0.91f;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)f2;
            this.motionY *= (double)f2;
            this.motionZ *= (double)f2;
        }
        this.prevLimbSwingAmount = this.limbSwingAmount;
        double d0 = this.posX - this.prevPosX;
        double d1 = this.posZ - this.prevPosZ;
        float f4 = MathHelper.sqrt_double((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.limbSwingAmount += (f4 - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }

    public boolean isOnLadder() {
        return false;
    }
}

