/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityVillageGuard;
import com.emoniph.witchery.entity.ai.EntityAIAvoidEntityConditionally;
import com.emoniph.witchery.entity.ai.EntityAIDigBlocks;
import com.emoniph.witchery.entity.ai.EntityAIDropOffBlocks;
import com.emoniph.witchery.entity.ai.EntityAIGoblinMate;
import com.emoniph.witchery.entity.ai.EntityAILookAtTradePlayerGeneric;
import com.emoniph.witchery.entity.ai.EntityAIMoveIndoorsLeashAware;
import com.emoniph.witchery.entity.ai.EntityAIPickUpBlocks;
import com.emoniph.witchery.entity.ai.EntityAITradePlayerGeneric;
import com.emoniph.witchery.entity.ai.EntityAIWorship;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Tuple;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class EntityGoblin
extends EntityAgeable
implements IMerchant,
INpc,
IEntitySelector,
EntityAIAvoidEntityConditionally.IAvoidEntities {
    private int randomTickDivider;
    private boolean isMating;
    Village villageObj;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private String lastBuyingPlayer;
    private boolean isLookingForHome;
    private float field_82191_bN;
    public static final Map villagersSellingList = new HashMap();
    public static final Map blacksmithSellingList = new HashMap();
    private EntityAIWorship aiWorship;
    private boolean preventDespawn;
    private static final double KOBOLDITE_HARVEST_CHANCE = 0.02;
    private boolean testingLeashRange;

    public EntityGoblin(World par1World) {
        this(par1World, 0);
    }

    public EntityGoblin(World par1World, int par2) {
        super(par1World);
        this.setProfession(this.rand.nextInt(4));
        this.setSize(0.6f, 0.95f);
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.aiWorship = new EntityAIWorship(this, TimeUtil.secsToTicks(30) + this.rand.nextInt(10));
        this.tasks.addTask(1, (EntityAIBase)this.aiWorship);
        this.tasks.addTask(2, (EntityAIBase)new EntityAIPickUpBlocks(this, 24.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIDropOffBlocks(this, 24.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIDigBlocks(this, 16.0, 0.02));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 0.6, 0.6));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAvoidEntityConditionally((EntityCreature)this, EntityVillageGuard.class, 12.0f, 0.8, 0.8, this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITradePlayerGeneric(this, (EntityLiving)this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAILookAtTradePlayerGeneric((EntityLiving)this, this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveIndoorsLeashAware((EntityCreature)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIGoblinMate(this));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityGoblin.class, 5.0f, 0.02f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, true, (IEntitySelector)this));
    }

    public boolean isEntityApplicable(Entity entity) {
        double R = 8.0;
        if (entity instanceof EntityVillager) {
            return this.worldObj.getEntitiesWithinAABB(EntityGoblin.class, AxisAlignedBB.getBoundingBox((double)(this.posX - 8.0), (double)(this.posY - 8.0), (double)(this.posZ - 8.0), (double)(this.posX + 8.0), (double)(this.posY + 8.0), (double)(this.posZ + 8.0))).size() >= 3;
        }
        return true;
    }

    @Override
    public boolean shouldAvoid() {
        double R = 8.0;
        return this.worldObj.getEntitiesWithinAABB(EntityGoblin.class, AxisAlignedBB.getBoundingBox((double)(this.posX - 8.0), (double)(this.posY - 8.0), (double)(this.posZ - 8.0), (double)(this.posX + 8.0), (double)(this.posY + 8.0), (double)(this.posZ + 8.0))).size() >= 3;
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.goblin.name");
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.4);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
        }
        if (flag = targetEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                targetEntity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                targetEntity.setFire(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        if (--this.randomTickDivider <= 0) {
            this.worldObj.villageCollectionObj.addVillagerPosition(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ));
            this.randomTickDivider = 70 + this.rand.nextInt(50);
            this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ), 32);
            if (this.villageObj == null) {
                this.detachHome();
            } else {
                this.preventDespawn = true;
                ChunkCoordinates chunkcoordinates = this.villageObj.getCenter();
                this.setHomeArea(chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, (int)((float)this.villageObj.getVillageRadius() * 0.6f));
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.villageObj.setDefaultPlayerReputation(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    if (this.buyingList.size() > 1) {
                        for (MerchantRecipe merchantrecipe : this.buyingList) {
                            if (!merchantrecipe.isRecipeDisabled()) continue;
                            merchantrecipe.func_82783_a(this.rand.nextInt(6) + this.rand.nextInt(6) + 2);
                        }
                    }
                    this.addDefaultEquipmentAndRecipies(1);
                    this.needsInitilization = false;
                    if (this.villageObj != null && this.lastBuyingPlayer != null) {
                        this.worldObj.setEntityState((Entity)this, (byte)14);
                        this.villageObj.setReputationForPlayer(this.lastBuyingPlayer, 1);
                    }
                }
                this.addPotionEffect(new PotionEffect(Potion.regeneration.id, 200, 0));
            }
        }
        super.updateAITick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLeashedState() {
        try {
            this.testingLeashRange = true;
            if (this.getLeashed()) {
                this.preventDespawn = true;
            }
            super.updateLeashedState();
        }
        finally {
            this.testingLeashRange = false;
        }
    }

    public float getDistanceToEntity(Entity par1Entity) {
        float distance = super.getDistanceToEntity(par1Entity);
        if (this.testingLeashRange && distance < 9.0f) {
            distance *= 0.5f;
        }
        return distance;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            this.setBesideClimbableBlock(this.isCollidedHorizontally);
        }
    }

    public boolean isOnLadder() {
        return super.isOnLadder();
    }

    public boolean isWorking() {
        return this.dataWatcher.getWatchableObjectByte(18) == 1;
    }

    public void setWorking(boolean par1) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(18);
        if (par1 && b0 != 1 || !par1 && b0 == 1) {
            this.dataWatcher.updateObject(18, (Object)((byte)(par1 ? 1 : 0)));
        }
    }

    public boolean isWorshipping() {
        return this.dataWatcher.getWatchableObjectByte(18) == 2;
    }

    public void setWorshipping(boolean worshiping) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(18);
        if (worshiping && b0 != 2 || !worshiping && b0 == 2) {
            this.dataWatcher.updateObject(18, (Object)((byte)(worshiping ? 2 : 0)));
        }
    }

    public void beginWorship(TileEntity tile) {
        this.aiWorship.begin(tile);
    }

    public boolean isBesideClimbableBlock() {
        return (this.dataWatcher.getWatchableObjectByte(17) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean par1) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(17);
        b0 = par1 ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.dataWatcher.updateObject(17, (Object)b0);
    }

    public boolean interact(EntityPlayer player) {
        boolean heldSpawnEgg;
        ItemStack stack = player.inventory.getCurrentItem();
        boolean bl = heldSpawnEgg = stack != null && stack.getItem() == Items.spawn_egg;
        if (!(heldSpawnEgg || !this.isEntityAlive() || this.isTrading() || this.isChild() || player.isSneaking())) {
            if (this.getLeashed()) {
                if (this.getHeldItem() == null) {
                    if (stack != null && stack.getItem() instanceof ItemPickaxe) {
                        this.setCurrentItemOrArmor(0, stack);
                        player.setCurrentItemOrArmor(0, null);
                    }
                } else {
                    if (!this.worldObj.isRemote) {
                        ItemStack goblinItem = this.getHeldItem();
                        if (!player.inventory.addItemStackToInventory(goblinItem)) {
                            this.entityDropItem(goblinItem, 1.0f);
                        } else if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                    this.setCurrentItemOrArmor(0, null);
                }
            } else if (!(this.isWorking() || this.isWorshipping() || this.villageObj == null || this.worldObj.isRemote)) {
                this.setCustomer(player);
                player.displayGUIMerchant((IMerchant)this, this.getCommandSenderName());
            }
            return true;
        }
        return super.interact(player);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(18, (Object)0);
        this.dataWatcher.addObject(19, (Object)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("Profession", this.getProfession());
        nbtRoot.setInteger("Riches", this.wealth);
        nbtRoot.setBoolean("Worshipping", this.isWorshipping());
        if (this.buyingList != null) {
            nbtRoot.setTag("Offers", (NBTBase)this.buyingList.getRecipiesAsTags());
        }
        nbtRoot.setBoolean("PreventDespawn", this.preventDespawn);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setProfession(nbtRoot.getInteger("Profession"));
        this.wealth = nbtRoot.getInteger("Riches");
        if (nbtRoot.getBoolean("Worshipping") && !this.worldObj.isRemote) {
            this.setWorshipping(true);
        }
        if (nbtRoot.hasKey("Offers", 10)) {
            NBTTagCompound nbttagcompound1 = nbtRoot.getCompoundTag("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
        this.preventDespawn = nbtRoot.getBoolean("PreventDespawn");
    }

    protected float getSoundPitch() {
        return 1.2f;
    }

    protected boolean canDespawn() {
        return !Config.instance().goblinDespawnBlock && this.villageObj == null && !this.preventDespawn && !this.isWorshipping();
    }

    protected String getLivingSound() {
        return this.isTrading() ? "witchery:mob.goblin.haggle" : "witchery:mob.goblin.idle";
    }

    protected String getHurtSound() {
        return "witchery:mob.goblin.hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.goblin.death";
    }

    public void setProfession(int par1) {
        this.dataWatcher.updateObject(16, (Object)par1);
    }

    public int getProfession() {
        return this.dataWatcher.getWatchableObjectInt(16);
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean par1) {
        this.isMating = par1;
    }

    public void setRevengeTarget(EntityLivingBase par1EntityLivingBase) {
        super.setRevengeTarget(par1EntityLivingBase);
        if (this.villageObj != null && par1EntityLivingBase != null) {
            this.villageObj.addOrRenewAgressor(par1EntityLivingBase);
            if (par1EntityLivingBase instanceof EntityPlayer) {
                if (this.isChild()) {
                    this.villageObj.setReputationForPlayer(par1EntityLivingBase.getCommandSenderName(), -3);
                }
                if (this.isEntityAlive()) {
                    this.worldObj.setEntityState((Entity)this, (byte)13);
                }
            }
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        if (this.villageObj != null) {
            EntityPlayer entityplayer;
            Entity entity = par1DamageSource.getEntity();
            if (entity != null) {
                if (!(entity instanceof EntityPlayer) && entity instanceof IMob) {
                    this.villageObj.endMatingSeason();
                }
            } else if (entity == null && (entityplayer = this.worldObj.getClosestPlayerToEntity((Entity)this, 16.0)) != null) {
                this.villageObj.endMatingSeason();
            }
        }
        super.onDeath(par1DamageSource);
    }

    public boolean getCanSpawnHere() {
        int k;
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        return this.worldObj.getBlock(i, (j = MathHelper.floor_double((double)this.boundingBox.minY)) - 1, k = MathHelper.floor_double((double)this.posZ)) == Blocks.grass && this.worldObj.getFullBlockLightValue(i, j, k) > 8 && super.getCanSpawnHere();
    }

    public void setCustomer(EntityPlayer par1EntityPlayer) {
        this.buyingPlayer = par1EntityPlayer;
    }

    public EntityPlayer getCustomer() {
        return this.buyingPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void useRecipe(MerchantRecipe par1MerchantRecipe) {
        par1MerchantRecipe.incrementToolUses();
        this.livingSoundTime = -this.getTalkInterval();
        this.playSound("witchery:mob.goblin.yes", this.getSoundVolume(), this.getSoundPitch());
        if (par1MerchantRecipe.hasSameIDsAs((MerchantRecipe)this.buyingList.get(this.buyingList.size() - 1))) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.getCommandSenderName() : null;
        }
        if (par1MerchantRecipe.getItemToBuy().getItem() == Items.emerald) {
            this.wealth += par1MerchantRecipe.getItemToBuy().stackSize;
        }
    }

    public void func_110297_a_(ItemStack par1ItemStack) {
        if (!this.worldObj.isRemote && this.livingSoundTime > -this.getTalkInterval() + 20) {
            this.livingSoundTime = -this.getTalkInterval();
            if (par1ItemStack != null) {
                this.playSound("witchery:mob.goblin.yes", this.getSoundVolume(), this.getSoundPitch());
            } else {
                this.playSound("witchery:mob.goblin.no", this.getSoundVolume(), this.getSoundPitch());
            }
        }
    }

    public MerchantRecipeList getRecipes(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies(1);
        }
        return this.buyingList;
    }

    private float adjustProbability(float par1) {
        float f1 = par1 + this.field_82191_bN;
        return f1 > 0.9f ? 0.9f - (f1 - 0.9f) : f1;
    }

    private void addDefaultEquipmentAndRecipies(int par1) {
        this.field_82191_bN = this.buyingList != null ? MathHelper.sqrt_float((float)this.buyingList.size()) * 0.2f : 0.0f;
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        boolean shuffle = true;
        switch (this.getProfession()) {
            case 0: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.wheat, this.rand, this.adjustProbability(0.9f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Item.getItemFromBlock((Block)Blocks.wool), this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.chicken, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.cooked_fished, this.rand, this.adjustProbability(0.4f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.bread, this.rand, this.adjustProbability(0.9f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.melon, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.apple, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.cookie, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.shears, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.flint_and_steel, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.cooked_chicken, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.arrow, this.rand, this.adjustProbability(0.5f));
                if (!(this.rand.nextFloat() < this.adjustProbability(0.5f))) break;
                merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(Blocks.gravel, 10), new ItemStack(Items.emerald), new ItemStack(Items.flint, 4 + this.rand.nextInt(2), 0)));
                break;
            }
            case 1: 
            case 2: {
                shuffle = false;
                if (this.buyingList == null) {
                    merchantrecipelist.add((Object)new MerchantRecipe(Witchery.Items.GENERIC.itemKobolditeDust.createStack(9), new ItemStack(Items.gold_nugget, 5), Witchery.Items.GENERIC.itemKobolditeNugget.createStack()));
                    break;
                }
                if (this.buyingList.size() == 1) {
                    merchantrecipelist.add((Object)new MerchantRecipe(Witchery.Items.GENERIC.itemKobolditeDust.createStack(16), new ItemStack(Items.gold_ingot), Witchery.Items.GENERIC.itemKobolditeNugget.createStack(2)));
                    break;
                }
                if (this.buyingList.size() != 2) break;
                merchantrecipelist.add((Object)new MerchantRecipe(Witchery.Items.GENERIC.itemKobolditeNugget.createStack(9), new ItemStack(Items.emerald), Witchery.Items.GENERIC.itemKobolditeIngot.createStack()));
                break;
            }
            case 3: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.coal, this.rand, this.adjustProbability(0.7f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.iron_ingot, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.gold_ingot, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.diamond, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.iron_sword, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.diamond_sword, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.iron_axe, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.diamond_axe, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.iron_pickaxe, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.diamond_pickaxe, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.iron_shovel, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.diamond_shovel, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.iron_hoe, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.diamond_hoe, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.iron_boots, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.diamond_boots, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.iron_helmet, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.diamond_helmet, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.iron_chestplate, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.diamond_chestplate, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.iron_leggings, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.diamond_leggings, this.rand, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.chainmail_boots, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.chainmail_helmet, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.chainmail_chestplate, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.chainmail_leggings, this.rand, this.adjustProbability(0.1f));
                break;
            }
            case 4: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.coal, this.rand, this.adjustProbability(0.7f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.porkchop, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.beef, this.rand, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.saddle, this.rand, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.leather_chestplate, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.leather_boots, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.leather_helmet, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.leather_leggings, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.cooked_porkchop, this.rand, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.cooked_beef, this.rand, this.adjustProbability(0.3f));
            }
        }
        if (merchantrecipelist.isEmpty()) {
            merchantrecipelist.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(Items.gold_ingot, this.rand), Items.emerald));
        }
        if (shuffle) {
            Collections.shuffle(merchantrecipelist);
        }
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int l = 0; l < par1 && l < merchantrecipelist.size(); ++l) {
            this.buyingList.addToListWithCheck((MerchantRecipe)merchantrecipelist.get(l));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setRecipes(MerchantRecipeList par1MerchantRecipeList) {
    }

    public static void addItemToSwapForAnEmerald(MerchantRecipeList buyList, Item item, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            if (rand.nextInt(3) == 0) {
                buyList.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(item, rand), Witchery.Items.GENERIC.itemKobolditeDust.createStack()));
            } else {
                buyList.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(item, rand), Items.emerald));
            }
        }
    }

    private static ItemStack getItemStackToSwapForAnEmerald(Item item, Random rand) {
        return new ItemStack(item, EntityGoblin.getQuantityToSwapForAnEmerald(item, rand), 0);
    }

    private static int getQuantityToSwapForAnEmerald(Item item, Random rand) {
        Tuple tuple = (Tuple)villagersSellingList.get(item);
        return tuple == null ? 1 : ((Integer)tuple.getFirst() >= (Integer)tuple.getSecond() ? (Integer)tuple.getFirst() : (Integer)tuple.getFirst() + rand.nextInt((Integer)tuple.getSecond() - (Integer)tuple.getFirst()));
    }

    public static void addItemToBuyOrSell(MerchantRecipeList list, Item item, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = EntityGoblin.quantityToBuyOrSell(item, rand);
            if (i < 0) {
                itemstack = Witchery.Items.GENERIC.itemKobolditeNugget.createStack(1);
                itemstack1 = new ItemStack(item, -i, 0);
            } else {
                itemstack = Witchery.Items.GENERIC.itemKobolditeNugget.createStack(i);
                itemstack1 = new ItemStack(item, 1, 0);
            }
            list.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    private static int quantityToBuyOrSell(Item item, Random rand) {
        Tuple tuple = (Tuple)blacksmithSellingList.get(item);
        return tuple == null ? 1 : ((Integer)tuple.getFirst() >= (Integer)tuple.getSecond() ? (Integer)tuple.getFirst() : (Integer)tuple.getFirst() + rand.nextInt((Integer)tuple.getSecond() - (Integer)tuple.getFirst()));
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 12) {
            this.generateRandomParticles("heart");
        } else if (par1 == 13) {
            this.generateRandomParticles("angryVillager");
        } else if (par1 == 14) {
            this.generateRandomParticles("happyVillager");
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.onSpawnWithEgg(par1EntityLivingData);
        int trade = this.rand.nextInt(5);
        this.setProfession(trade);
        return par1EntityLivingData;
    }

    @SideOnly(value=Side.CLIENT)
    private void generateRandomParticles(String par1Str) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle(par1Str, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 1.0 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d0, d1, d2);
        }
    }

    public void setLookingForHome() {
        this.isLookingForHome = true;
    }

    public EntityGoblin createChild(EntityAgeable par1EntityAgeable) {
        EntityGoblin entityvillager = new EntityGoblin(this.worldObj);
        entityvillager.onSpawnWithEgg(null);
        return entityvillager;
    }

    static {
        villagersSellingList.put(Items.coal, new Tuple((Object)16, (Object)24));
        villagersSellingList.put(Items.iron_ingot, new Tuple((Object)8, (Object)10));
        villagersSellingList.put(Items.gold_ingot, new Tuple((Object)8, (Object)10));
        villagersSellingList.put(Items.diamond, new Tuple((Object)4, (Object)6));
        villagersSellingList.put(Items.paper, new Tuple((Object)24, (Object)36));
        villagersSellingList.put(Items.book, new Tuple((Object)11, (Object)13));
        villagersSellingList.put(Items.written_book, new Tuple((Object)1, (Object)1));
        villagersSellingList.put(Items.ender_pearl, new Tuple((Object)3, (Object)4));
        villagersSellingList.put(Items.ender_eye, new Tuple((Object)2, (Object)3));
        villagersSellingList.put(Items.porkchop, new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.beef, new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.chicken, new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.cooked_fished, new Tuple((Object)9, (Object)13));
        villagersSellingList.put(Items.wheat_seeds, new Tuple((Object)34, (Object)48));
        villagersSellingList.put(Items.melon_seeds, new Tuple((Object)30, (Object)38));
        villagersSellingList.put(Items.pumpkin_seeds, new Tuple((Object)30, (Object)38));
        villagersSellingList.put(Items.wheat, new Tuple((Object)18, (Object)22));
        villagersSellingList.put(Item.getItemFromBlock((Block)Blocks.wool), new Tuple((Object)14, (Object)22));
        villagersSellingList.put(Items.rotten_flesh, new Tuple((Object)36, (Object)64));
        blacksmithSellingList.put(Items.flint_and_steel, new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put(Items.shears, new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put(Items.iron_sword, new Tuple((Object)7, (Object)11));
        blacksmithSellingList.put(Items.diamond_sword, new Tuple((Object)12, (Object)14));
        blacksmithSellingList.put(Items.iron_axe, new Tuple((Object)6, (Object)8));
        blacksmithSellingList.put(Items.diamond_axe, new Tuple((Object)9, (Object)12));
        blacksmithSellingList.put(Items.iron_pickaxe, new Tuple((Object)7, (Object)9));
        blacksmithSellingList.put(Items.diamond_pickaxe, new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Items.iron_shovel, new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.diamond_shovel, new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put(Items.iron_hoe, new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.diamond_hoe, new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put(Items.iron_boots, new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.diamond_boots, new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put(Items.iron_helmet, new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.diamond_helmet, new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put(Items.iron_chestplate, new Tuple((Object)10, (Object)14));
        blacksmithSellingList.put(Items.diamond_chestplate, new Tuple((Object)16, (Object)19));
        blacksmithSellingList.put(Items.iron_leggings, new Tuple((Object)8, (Object)10));
        blacksmithSellingList.put(Items.diamond_leggings, new Tuple((Object)11, (Object)14));
        blacksmithSellingList.put(Items.chainmail_boots, new Tuple((Object)5, (Object)7));
        blacksmithSellingList.put(Items.chainmail_helmet, new Tuple((Object)5, (Object)7));
        blacksmithSellingList.put(Items.chainmail_chestplate, new Tuple((Object)11, (Object)15));
        blacksmithSellingList.put(Items.chainmail_leggings, new Tuple((Object)9, (Object)11));
        blacksmithSellingList.put(Items.bread, new Tuple((Object)-4, (Object)-2));
        blacksmithSellingList.put(Items.melon, new Tuple((Object)-8, (Object)-4));
        blacksmithSellingList.put(Items.apple, new Tuple((Object)-8, (Object)-4));
        blacksmithSellingList.put(Items.cookie, new Tuple((Object)-10, (Object)-7));
        blacksmithSellingList.put(Item.getItemFromBlock((Block)Blocks.glass), new Tuple((Object)-5, (Object)-3));
        blacksmithSellingList.put(Item.getItemFromBlock((Block)Blocks.bookshelf), new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put(Items.leather_chestplate, new Tuple((Object)4, (Object)5));
        blacksmithSellingList.put(Items.leather_boots, new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put(Items.leather_helmet, new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put(Items.leather_leggings, new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put(Items.saddle, new Tuple((Object)6, (Object)8));
        blacksmithSellingList.put(Items.experience_bottle, new Tuple((Object)-4, (Object)-1));
        blacksmithSellingList.put(Items.redstone, new Tuple((Object)-4, (Object)-1));
        blacksmithSellingList.put(Items.compass, new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Items.clock, new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Item.getItemFromBlock((Block)Blocks.glowstone), new Tuple((Object)-3, (Object)-1));
        blacksmithSellingList.put(Items.cooked_porkchop, new Tuple((Object)-7, (Object)-5));
        blacksmithSellingList.put(Items.cooked_beef, new Tuple((Object)-7, (Object)-5));
        blacksmithSellingList.put(Items.cooked_chicken, new Tuple((Object)-8, (Object)-6));
        blacksmithSellingList.put(Items.ender_eye, new Tuple((Object)7, (Object)11));
        blacksmithSellingList.put(Items.arrow, new Tuple((Object)-12, (Object)-8));
    }
}

