/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityGoblin;
import com.emoniph.witchery.entity.EntityGoblinMog;
import com.emoniph.witchery.entity.ai.EntityAIMoveTowardsEntityClass;
import com.emoniph.witchery.util.IHandleDT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityGoblinGulg
extends EntityMob
implements IBossDisplayData,
IHandleDT {
    private int attackTimer;
    long ticksSinceTeleport = 0L;
    private static final double INVULNRABLE = 9.0;
    private static final double PERCENT_20 = 36.0;
    private static final double PERCENT_50 = 81.0;
    private static final double PERCENT_80 = 256.0;

    public EntityGoblinGulg(World world) {
        super(world);
        this.setSize(0.8f, 1.8f);
        this.isImmuneToFire = true;
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMoveTowardsEntityClass((EntityCreature)this, EntityGoblinMog.class, 1.0, 6.0f, 64.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.experienceValue = 35;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(20, (Object)new Integer(0));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(400.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    public int getTotalArmorValue() {
        return 8;
    }

    public void setInWeb() {
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.goblingulg.name");
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void setRevengeTarget(EntityLivingBase entity) {
        if (!(entity instanceof EntityGoblinMog || entity instanceof EntityGoblin || entity instanceof EntityGoblinGulg)) {
            super.setRevengeTarget(entity);
        }
    }

    protected void updateAITick() {
        super.updateAITick();
    }

    public int func_82212_n() {
        return this.dataWatcher.getWatchableObjectInt(20);
    }

    public void func_82215_s(int par1) {
        this.dataWatcher.updateObject(20, (Object)par1);
    }

    public void func_82206_m() {
        this.func_82215_s(150);
        this.setHealth(this.getMaxHealth() / 4.0f);
    }

    protected void updateAITasks() {
        if (this.func_82212_n() > 0) {
            int i = this.func_82212_n() - 1;
            if (i <= 0) {
                this.worldObj.playBroadcastSound(1013, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            }
            this.func_82215_s(i);
            if (this.ticksExisted % 10 == 0) {
                this.heal(20.0f);
            }
        } else {
            super.updateAITasks();
            if (this.ticksExisted % 20 == 0) {
                this.heal(2.0f);
            }
            if (!this.worldObj.isRemote && this.getNavigator().noPath() && this.getAttackTarget() != null && (long)this.ticksExisted - this.ticksSinceTeleport > 200L) {
                this.ticksSinceTeleport = this.ticksExisted;
                this.teleportToEntity((Entity)this.getAttackTarget());
            }
        }
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX - par1Entity.posX), (double)(this.boundingBox.minY + (double)(this.height / 2.0f) - par1Entity.posY + (double)par1Entity.getEyeHeight()), (double)(this.posZ - par1Entity.posZ));
        vec3 = vec3.normalize();
        double d0 = 16.0;
        double d1 = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.xCoord * d0;
        double d2 = this.posY + (double)(this.rand.nextInt(16) - 8) - vec3.yCoord * d0;
        double d3 = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.zCoord * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.posX;
        double d4 = this.posY;
        double d5 = this.posZ;
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        boolean flag = false;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.blockExists(i, j = MathHelper.floor_double((double)this.posY), k = MathHelper.floor_double((double)this.posZ))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.worldObj.getBlock(i, j - 1, k);
                if (block.getMaterial().blocksMovement()) {
                    flag1 = true;
                    continue;
                }
                this.posY -= 1.0;
                --j;
            }
            if (flag1) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.setPosition(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.posX - d3) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d8 = d4 + (this.posY - d4) * d6 + this.rand.nextDouble() * (double)this.height;
            double d9 = d5 + (this.posZ - d5) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.worldObj.spawnParticle("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.worldObj.playSoundEffect(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.playSound("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        double distance = this.getDistanceSqToPartner();
        double scale = 1.0;
        if (distance <= 9.0) {
            return false;
        }
        if (distance <= 36.0) {
            scale = 0.2;
        } else if (distance <= 81.0) {
            scale = 0.5;
        } else if (distance <= 256.0) {
            scale = 0.8;
        }
        return super.attackEntityFrom(source, (float)Math.min((double)damage * scale, 15.0));
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return 15.0f;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        double distance = this.getDistanceSqToPartner();
        double height = 0.0;
        int force = 4;
        if (distance <= 9.0) {
            height = 1.0;
            force = 20;
        } else if (distance <= 36.0) {
            height = 0.8;
            force = 15;
        } else if (distance <= 81.0) {
            height = 0.5;
            force = 10;
        } else if (distance <= 256.0) {
            height = 0.2;
            force = 6;
        }
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(6 + this.rand.nextInt(force)));
        if (flag) {
            par1Entity.motionY += 0.5 + height;
        }
        this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    private double getDistanceSqToPartner() {
        double R = 16.0;
        AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.posX - 16.0), (double)(this.posY - 16.0), (double)(this.posZ - 16.0), (double)(this.posX + 16.0), (double)(this.posY + 16.0), (double)(this.posZ + 16.0));
        List mogs = this.worldObj.getEntitiesWithinAABB(EntityGoblinMog.class, bb);
        double minDistance = Double.MAX_VALUE;
        for (Object obj : mogs) {
            EntityGoblinMog mog = (EntityGoblinMog)obj;
            double distance = this.getDistanceSqToEntity((Entity)mog);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    public boolean canAttackClass(Class par1Class) {
        return super.canAttackClass(par1Class);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("Invul", this.func_82212_n());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.func_82215_s(par1NBTTagCompound.getInteger("Invul"));
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    protected String getLivingSound() {
        return "witchery:mob.goblin.gulg_idle";
    }

    protected String getHurtSound() {
        return "mob.horse.zombie.hit";
    }

    protected String getDeathSound() {
        return "mob.wither.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.irongolem.walk", 1.0f, 1.0f);
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(Witchery.Items.GENERIC.itemKobolditeNugget.createStack(this.rand.nextInt(3) + 1), 0.0f);
        ItemStack armor = null;
        switch (this.rand.nextInt(4)) {
            case 0: {
                armor = new ItemStack((Item)Items.chainmail_boots);
                break;
            }
            case 1: {
                armor = new ItemStack((Item)Items.chainmail_leggings);
                break;
            }
            case 2: {
                armor = new ItemStack((Item)Items.chainmail_chestplate);
                break;
            }
            case 3: {
                armor = new ItemStack((Item)Items.chainmail_helmet);
            }
        }
        if (armor != null) {
            EnchantmentHelper.addRandomEnchantment((Random)this.worldObj.rand, (ItemStack)armor, (int)30);
            this.entityDropItem(armor, 0.0f);
        }
        if (this.worldObj.rand.nextInt(2) == 0) {
            this.entityDropItem(new ItemStack(Witchery.Items.GULGS_GURDLE), 0.0f);
        }
    }

    protected Item getDropItem() {
        return null;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        this.func_110163_bv();
        return super.onSpawnWithEgg(par1EntityLivingData);
    }

    protected boolean canDespawn() {
        return false;
    }
}

