/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityFollower;
import com.emoniph.witchery.util.ParticleEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityHellhound
extends EntityMob
implements IEntitySelector {
    private float field_70926_e;
    private float field_70924_f;
    private boolean isShaking;
    private boolean field_70928_h;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int conversionTime;

    public EntityHellhound(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.setSize(0.9f, 0.9f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySheep.class, 0, true, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, (IEntitySelector)this));
        this.targetTasks.addTask(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFollower.class, 0, true, true, (IEntitySelector)this));
    }

    public boolean isEntityApplicable(Entity entity) {
        double AGGRO_RANGE = 5.0;
        return entity != null && entity.getDistanceSqToEntity((Entity)this) < 25.0;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.3f);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    public int getTotalArmorValue() {
        int i = super.getTotalArmorValue() + 2;
        if (i > 20) {
            i = 20;
        }
        return i;
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        this.dataWatcher.updateObject(18, (Object)Float.valueOf(this.getHealth()));
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)new Float(this.getHealth()));
        this.dataWatcher.addObject(19, (Object)new Byte(0));
        this.getDataWatcher().addObject(14, (Object)0);
    }

    protected void convertToWolf() {
        EntityWolf entityvillager = new EntityWolf(this.worldObj);
        entityvillager.copyLocationAndAnglesFrom((Entity)this);
        entityvillager.onSpawnWithEgg((IEntityLivingData)null);
        this.worldObj.removeEntity((Entity)this);
        this.worldObj.spawnEntityInWorld((Entity)entityvillager);
        entityvillager.addPotionEffect(new PotionEffect(Potion.confusion.id, 200, 0));
        this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1017, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
    }

    public boolean interact(EntityPlayer p_70085_1_) {
        ItemStack itemstack = p_70085_1_.getCurrentEquippedItem();
        if (itemstack != null && itemstack.getItem() == Items.golden_apple && itemstack.getItemDamage() == 0 && this.isPotionActive(Potion.weakness)) {
            if (!p_70085_1_.capabilities.isCreativeMode) {
                --itemstack.stackSize;
            }
            if (itemstack.stackSize <= 0) {
                p_70085_1_.inventory.setInventorySlotContents(p_70085_1_.inventory.currentItem, (ItemStack)null);
            }
            if (!this.worldObj.isRemote) {
                this.startConversion(this.rand.nextInt(1000) + 3600);
            }
            return true;
        }
        return false;
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.playSound("mob.wolf.step", 0.15f, 1.0f);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("ConversionTime", 99) && nbtRoot.getInteger("ConversionTime") > -1) {
            this.startConversion(nbtRoot.getInteger("ConversionTime"));
        }
    }

    protected void startConversion(int p_82228_1_) {
        this.conversionTime = p_82228_1_;
        this.getDataWatcher().updateObject(14, (Object)1);
        this.removePotionEffect(Potion.weakness.id);
        this.addPotionEffect(new PotionEffect(Potion.damageBoost.id, p_82228_1_, Math.min(this.worldObj.difficultySetting.getDifficultyId() - 1, 0)));
        this.worldObj.setEntityState((Entity)this, (byte)16);
    }

    protected int getConversionTimeBoost() {
        int i = 1;
        if (this.rand.nextFloat() < 0.01f) {
            int j = 0;
            for (int k = (int)this.posX - 4; k < (int)this.posX + 4 && j < 14; ++k) {
                for (int l = (int)this.posY - 4; l < (int)this.posY + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.posZ - 4; i1 < (int)this.posZ + 4 && j < 14; ++i1) {
                        Block block = this.worldObj.getBlock(k, l, i1);
                        if (block != Blocks.iron_bars && block != Blocks.bed) continue;
                        if (this.rand.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    protected String getLivingSound() {
        return "mob.wolf.growl";
    }

    protected String getHurtSound() {
        return "mob.wolf.hurt";
    }

    protected String getDeathSound() {
        return "mob.wolf.death";
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected Item getDropItem() {
        return Item.getItemById((int)-1);
    }

    protected void dropFewItems(boolean recentlyHitByPlayer, int looting) {
        this.entityDropItem(Witchery.Items.GENERIC.itemDogTongue.createStack(), 0.0f);
        if (this.worldObj.rand.nextInt(12) <= Math.min(looting, 3)) {
            this.entityDropItem(new ItemStack(Witchery.Blocks.WOLFHEAD, 1, 1), 0.0f);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.worldObj.isRemote && !this.isDead && this.isShaking && !this.field_70928_h && !this.hasPath() && this.onGround) {
            this.field_70928_h = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.worldObj.setEntityState((Entity)this, (byte)8);
        }
    }

    public void onUpdate() {
        if (!this.worldObj.isRemote && this.isConverting()) {
            int i = this.getConversionTimeBoost();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                this.convertToWolf();
            }
        }
        super.onUpdate();
        if (!this.isDead) {
            this.field_70924_f = this.field_70926_e;
            this.field_70926_e = this.func_70922_bv() ? (this.field_70926_e += (1.0f - this.field_70926_e) * 0.4f) : (this.field_70926_e += (0.0f - this.field_70926_e) * 0.4f);
            if (this.func_70922_bv()) {
                this.numTicksToChaseTarget = 10;
            }
            if (this.isWet()) {
                this.isShaking = true;
                this.field_70928_h = false;
                this.timeWolfIsShaking = 0.0f;
                this.prevTimeWolfIsShaking = 0.0f;
            } else if ((this.isShaking || this.field_70928_h) && this.field_70928_h) {
                if (this.timeWolfIsShaking == 0.0f) {
                    this.playSound("mob.wolf.shake", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                }
                this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
                this.timeWolfIsShaking += 0.05f;
                if (this.prevTimeWolfIsShaking >= 2.0f) {
                    this.isShaking = false;
                    this.field_70928_h = false;
                    this.prevTimeWolfIsShaking = 0.0f;
                    this.timeWolfIsShaking = 0.0f;
                }
                if (this.timeWolfIsShaking > 0.4f) {
                    float f = (float)this.boundingBox.minY;
                    int i = (int)(MathHelper.sin((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                        float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                        this.worldObj.spawnParticle("splash", this.posX + (double)f1, (double)(f + 0.8f), this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                    }
                }
            }
            if (this.worldObj.isRemote && this.ticksExisted % 2 == 0) {
                this.worldObj.spawnParticle(ParticleEffect.FLAME.toString(), this.posX - (double)this.width * 0.35 + this.worldObj.rand.nextDouble() * (double)this.width * 0.7, 0.5 + this.posY + this.worldObj.rand.nextDouble() * ((double)this.height - 0.1), this.posZ - (double)this.width * 0.35 + this.worldObj.rand.nextDouble() * (double)this.width * 0.7, 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getWolfShaking() {
        return this.isShaking;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileShaking(float p_70915_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70915_1_) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f2 = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.sin((float)(f2 * (float)Math.PI)) * MathHelper.sin((float)(f2 * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return (this.field_70924_f + (this.field_70926_e - this.field_70924_f) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        Entity entity = p_70097_1_.getEntity();
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            p_70097_2_ = (p_70097_2_ + 1.0f) / 2.0f;
        }
        return super.attackEntityFrom(p_70097_1_, p_70097_2_);
    }

    public boolean attackEntityAsMob(Entity p_70652_1_) {
        boolean flag = super.attackEntityAsMob(p_70652_1_);
        if (flag) {
            int i = this.worldObj.difficultySetting.getDifficultyId();
            if (this.rand.nextFloat() < (float)i * 0.1f) {
                p_70652_1_.setFire(2 * i);
            }
        }
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte p_70103_1_) {
        if (p_70103_1_ == 8) {
            this.field_70928_h = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.handleHealthUpdate(p_70103_1_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return 1.5393804f;
    }

    public int getMaxSpawnedInChunk() {
        return super.getMaxSpawnedInChunk();
    }

    public void func_70918_i(boolean p_70918_1_) {
        if (p_70918_1_) {
            this.dataWatcher.updateObject(19, (Object)1);
        } else {
            this.dataWatcher.updateObject(19, (Object)0);
        }
    }

    public boolean func_70922_bv() {
        return this.dataWatcher.getWatchableObjectByte(19) == 1;
    }

    protected boolean canDespawn() {
        return !this.isConverting();
    }

    public boolean isConverting() {
        return this.getDataWatcher().getWatchableObjectByte(14) == 1;
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox);
    }
}

