/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.network.PacketSound;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class EntityIllusion
extends EntityMob {
    private EntityPlayer victimPlayer = null;

    public EntityIllusion(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.illusion.name");
    }

    protected SoundEffect getFakeLivingSound() {
        return SoundEffect.NONE;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(0.0);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    public EntityLivingBase getAttackTarget() {
        return this.worldObj.getPlayerEntityByName(this.getVictimName());
    }

    public int getMaxSafePointTries() {
        return this.getAttackTarget() == null ? 3 : 3 + (int)(this.getHealth() - 1.0f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(18, (Object)0);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        if (this.getVictimName() == null) {
            par1NBTTagCompound.setString("Victim", "");
        } else {
            par1NBTTagCompound.setString("Victim", this.getVictimName());
        }
        par1NBTTagCompound.setInteger("IllusionType", this.getIllusionType());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        String s = par1NBTTagCompound.getString("Victim");
        if (s.length() > 0) {
            this.setVictim(s);
        }
        this.setIllusionType(par1NBTTagCompound.getInteger("IllusionType"));
    }

    public String getVictimName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setVictim(String par1Str) {
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public int getIllusionType() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void setIllusionType(int par1) {
        this.dataWatcher.updateObject(18, (Object)((byte)par1));
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            if (this.worldObj.rand.nextInt(15) == 0) {
                float newHealth = this.getHealth() - 1.0f;
                if ((double)newHealth <= 0.5) {
                    this.setDead();
                } else {
                    this.setHealth(newHealth);
                }
            }
            if (this.worldObj.rand.nextInt(40) == 0) {
                SoundEffect sound = this.getFakeLivingSound();
                if (this.victimPlayer == null) {
                    this.victimPlayer = this.worldObj.getPlayerEntityByName(this.getVictimName());
                }
                if (this.victimPlayer != null && sound != null && sound != SoundEffect.NONE && this.victimPlayer.getDistanceSqToEntity((Entity)this) < 64.0) {
                    Witchery.packetPipeline.sendTo((IMessage)new PacketSound(sound, (Entity)this, 1.0f, 1.0f), this.victimPlayer);
                }
            }
        }
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return null;
    }

    protected String getDeathSound() {
        return null;
    }

    public boolean attackEntityAsMob(Entity entity) {
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        return false;
    }

    protected void dropFewItems(boolean par1, int par2) {
    }
}

