/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.ai.EntityAIWanderWithRestriction;
import com.emoniph.witchery.item.ItemGeneralContract;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TameableUtil;
import com.emoniph.witchery.util.TimeUtil;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityImp
extends EntityTameable
implements IMob,
IEntitySelector,
EntityAIWanderWithRestriction.IHomeLocationProvider {
    private float field_70926_e;
    private float field_70924_f;
    private boolean field_70928_h;
    private static final int MAX_WANDER_RANGE = 16;
    private int secretsShared;
    private int homeX;
    private int homeY;
    private int homeZ;
    private long lastGiftTime;
    private long powerUpExpiry;
    private static final HashMap<Item, Integer> shinies = new HashMap();
    private static final int REWARD_AFFECTION_LEVEL = 20;
    private static final long GIFT_DELAY_TICKS;
    private static final ItemStack[] EXTRA_DROPS;
    private static final String[] DEMON_NAMES;

    public EntityImp(World par1World) {
        super(par1World);
        this.isImmuneToFire = true;
        this.setSize(0.4f, 1.3f);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWanderWithRestriction((EntityCreature)this, 1.0, this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, (IEntitySelector)this));
        this.setTamed(false);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.3f);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(50.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)0);
        this.dataWatcher.addObject(19, (Object)0);
    }

    private void setAffection(int affection) {
        this.dataWatcher.updateObject(18, (Object)affection);
    }

    private int getAffection() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    private void setPowered(boolean powered) {
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(19, (Object)(powered ? 1 : 0));
        }
    }

    public boolean isPowered() {
        return this.dataWatcher.getWatchableObjectInt(19) == 1;
    }

    public boolean isEntityApplicable(Entity target) {
        if (!this.isTamed()) {
            return target instanceof EntityPlayer;
        }
        return target == this.getAttackTarget();
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.imp.name");
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("Affection", this.getAffection());
        par1NBTTagCompound.setInteger("SecretsShared", this.secretsShared);
        par1NBTTagCompound.setLong("LastGiftTime", this.lastGiftTime);
        par1NBTTagCompound.setLong("PowerUpUntil2", this.powerUpExpiry);
        par1NBTTagCompound.setInteger("HomeLocX", this.homeX);
        par1NBTTagCompound.setInteger("HomeLocY", this.homeY);
        par1NBTTagCompound.setInteger("HomeLocZ", this.homeZ);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setAffection(par1NBTTagCompound.getInteger("Affection"));
        this.secretsShared = par1NBTTagCompound.getInteger("SecretsShared");
        this.lastGiftTime = par1NBTTagCompound.getLong("LastGiftTime");
        long time = TimeUtil.getServerTimeInTicks();
        if (par1NBTTagCompound.hasKey("PowerUpUntil2")) {
            this.powerUpExpiry = par1NBTTagCompound.getLong("PowerUpUntil2");
        } else if (par1NBTTagCompound.hasKey("PowerUpUntil")) {
            this.powerUpExpiry = par1NBTTagCompound.getLong("PowerUpUntil");
            if (this.powerUpExpiry > 0L) {
                this.powerUpExpiry = time + (long)TimeUtil.minsToTicks(60);
            }
        }
        if (time < this.powerUpExpiry) {
            this.setPowered(true);
        }
        this.homeX = par1NBTTagCompound.getInteger("HomeLocX");
        this.homeY = par1NBTTagCompound.getInteger("HomeLocY");
        this.homeZ = par1NBTTagCompound.getInteger("HomeLocZ");
    }

    protected String getLivingSound() {
        return "witchery:mob.imp.laugh";
    }

    protected float getSoundPitch() {
        return this.isPowered() ? (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.7f : (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.1f;
    }

    protected String getHurtSound() {
        return "witchery:mob.imp.hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.imp.death";
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public int getTalkInterval() {
        return TimeUtil.secsToTicks(40);
    }

    public void onLivingUpdate() {
        EntityLivingBase owner;
        super.onLivingUpdate();
        if (!this.worldObj.isRemote && TimeUtil.secondsElapsed(300, this.ticksExisted) && TameableUtil.hasOwner(this) && (owner = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)owner;
            this.setAffection(Math.max(0, this.getAffection() - 1));
            if (this.getAffection() == 0 && this.ticksExisted > TimeUtil.minsToTicks(60) && this.worldObj.rand.nextDouble() < 0.01) {
                ParticleEffect.FLAME.send(SoundEffect.WITCHERY_MOB_IMP_LAUGH, (Entity)this, 1.0, 1.0, 16);
                ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.goodbye", this.getCommandSenderName());
                this.setDead();
            }
        }
        if (!this.worldObj.isRemote && this.powerUpExpiry > 0L && this.isPowerupExpired()) {
            this.setPowered(false);
            this.powerUpExpiry = 0L;
        }
        if (this.ticksExisted % 20 == 0) {
            if (this.isPowered()) {
                if ((double)this.width != 0.6) {
                    this.setSize(0.6f, 1.3f);
                }
                if (!this.worldObj.isRemote) {
                    this.heal(1.0f);
                }
            } else if ((double)this.width != 0.4) {
                this.setSize(0.4f, 1.3f);
            }
        }
        if (this.ticksExisted % 400 == 0) {
            this.heal(1.0f);
        }
    }

    private boolean isPowerupExpired() {
        return TimeUtil.getServerTimeInTicks() >= this.powerUpExpiry;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote && this.isPowered()) {
            this.worldObj.spawnParticle(ParticleEffect.FLAME.toString(), this.posX - (double)this.width * 0.5 + this.worldObj.rand.nextDouble() * (double)this.width, 0.1 + this.posY + this.worldObj.rand.nextDouble() * 2.0, this.posZ - (double)this.width * 0.5 + this.worldObj.rand.nextDouble() * (double)this.width, 0.0, 0.0, 0.0);
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        return super.attackEntityFrom(source, Math.min(damage, this.isPowered() ? 5.0f : 15.0f));
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), this.isPowered() ? 8.0f : 4.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean interact(EntityPlayer player) {
        ItemStack stack = player.inventory.getCurrentItem();
        if (stack == null) {
            return true;
        }
        if (this.worldObj.isRemote) {
            return false;
        }
        if (this.isTamed()) {
            if (Witchery.Items.GENERIC.itemDemonHeart.isMatch(stack)) {
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                    if (stack.stackSize <= 0) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                    }
                }
                if (this.worldObj.isRemote) return super.interact(player);
                this.powerUpExpiry = TimeUtil.getServerTimeInTicks() + (long)TimeUtil.minsToTicks(60);
                this.setPowered(true);
                SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
                ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.gift.power", this.getCommandSenderName());
                return super.interact(player);
            }
            if (Witchery.Items.GENERIC.itemIcyNeedle.isMatch(stack)) {
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                    if (stack.stackSize <= 0) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                    }
                }
                if (this.worldObj.isRemote) return super.interact(player);
                this.powerUpExpiry = 0L;
                this.setPowered(false);
                SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
                ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.gift.powerloss", this.getCommandSenderName());
                return super.interact(player);
            }
            if (ItemGeneralContract.isBoundContract(stack)) {
                if (this.worldObj.isRemote) return super.interact(player);
                SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
                if (this.isPowered()) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.spell.toomuchpower", this.getCommandSenderName());
                    return super.interact(player);
                }
                if (this.getAffection() < 20) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.spell.notliked", this.getCommandSenderName());
                    return super.interact(player);
                }
                long timeNow = TimeUtil.getServerTimeInTicks();
                if (timeNow <= this.lastGiftTime + GIFT_DELAY_TICKS && !player.capabilities.isCreativeMode) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.spell.toooften", this.getCommandSenderName());
                    return super.interact(player);
                }
                ItemGeneralContract contract = ItemGeneralContract.getContract(stack);
                EntityLivingBase targetEntity = Witchery.Items.TAGLOCK_KIT.getBoundEntity(this.worldObj, (Entity)player, stack, 1);
                if (targetEntity == null) {
                    String name = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(stack, 1);
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.spell.cannotfind", this.getCommandSenderName(), name);
                    return super.interact(player);
                }
                if (contract.activate(stack, targetEntity)) {
                    this.lastGiftTime = timeNow;
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.spell.feelthefire", this.getCommandSenderName(), targetEntity.getCommandSenderName());
                    if (player.capabilities.isCreativeMode) return super.interact(player);
                    --stack.stackSize;
                    if (stack.stackSize > 0) return super.interact(player);
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                    return super.interact(player);
                }
                ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.spell.failed", this.getCommandSenderName(), targetEntity.getCommandSenderName());
                return super.interact(player);
            }
            if (this.worldObj.isRemote) return true;
            Integer affectionBoost = shinies.get(stack.getItem());
            if (affectionBoost != null && stack.getItemDamage() == 0) {
                long timeNow = TimeUtil.getServerTimeInTicks();
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                    if (stack.stackSize <= 0) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                    }
                }
                int affection = this.getAffection() + affectionBoost;
                SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
                if (affection >= 20 && (timeNow > this.lastGiftTime + GIFT_DELAY_TICKS || player.capabilities.isCreativeMode) && this.rand.nextInt(Math.max(1, 10 - Math.max(affection - 20, 0))) == 0) {
                    this.lastGiftTime = timeNow;
                    affection = 0;
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.gift.reciprocate", this.getCommandSenderName());
                    ItemStack stackForPlayer = null;
                    switch (this.secretsShared) {
                        case 0: {
                            stackForPlayer = Witchery.Items.GENERIC.itemBrewSoulHunger.createStack();
                            ++this.secretsShared;
                            break;
                        }
                        case 1: {
                            stackForPlayer = Witchery.Items.GENERIC.itemBrewSoulFear.createStack();
                            ++this.secretsShared;
                            break;
                        }
                        case 2: {
                            stackForPlayer = Witchery.Items.GENERIC.itemBrewSoulAnguish.createStack();
                            ++this.secretsShared;
                            break;
                        }
                        case 3: {
                            stackForPlayer = Witchery.Items.GENERIC.itemContractTorment.createStack();
                            ++this.secretsShared;
                            break;
                        }
                        default: {
                            stackForPlayer = EXTRA_DROPS[this.rand.nextInt(EXTRA_DROPS.length)].copy();
                        }
                    }
                    if (stackForPlayer != null) {
                        ParticleEffect.INSTANT_SPELL.send(SoundEffect.NOTE_HARP, (Entity)this, 1.0, 1.0, 16);
                        this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, stackForPlayer));
                    }
                } else if (timeNow < this.lastGiftTime + GIFT_DELAY_TICKS) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.gift.toomany", this.getCommandSenderName());
                } else {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.gift.like", this.getCommandSenderName());
                }
                this.setAffection(affection);
                return true;
            }
            SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
            ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.gift.hate", this.getCommandSenderName());
            return true;
        }
        if (!Witchery.Items.GENERIC.itemContractOwnership.isMatch(stack)) return super.interact(player);
        if (this.worldObj.isRemote) return true;
        EntityLivingBase boundEntity = ItemGeneralContract.getBoundEntity(this.worldObj, player, stack);
        if (boundEntity == player) {
            int EXPERIENCE_NEEDED = 25;
            if (player.experienceLevel < 25 && !player.capabilities.isCreativeMode) {
                SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
                ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.contract.noxp", this.getCommandSenderName());
                return true;
            }
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
                if (stack.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
            }
            player.addExperienceLevel(-25);
            this.setTamed(true);
            TameableUtil.setOwner(this, player);
            this.setAttackTarget(null);
            this.setPathToEntity(null);
            this.homeX = (int)this.posX;
            this.homeY = (int)this.posY;
            this.homeZ = (int)this.posZ;
            this.func_110163_bv();
            SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
            ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.contract.deal", this.getCommandSenderName());
            this.setCustomNameTag(EntityImp.getDemonName(this.rand));
            return true;
        }
        if (boundEntity != null) {
            SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
            ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.contract.notowners", this.getCommandSenderName());
            return true;
        }
        SoundEffect.WITCHERY_MOB_IMP_LAUGH.playAtPlayer(this.worldObj, player, 0.5f, this.getSoundPitch());
        ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "entity.witchery.imp.contract.unsigned", this.getCommandSenderName());
        return true;
    }

    public EntityImp createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        return false;
    }

    protected boolean canDespawn() {
        return true;
    }

    private static String getDemonName(Random rand) {
        if (rand.nextInt(5) == 0) {
            return DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)];
        }
        return DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)] + " " + DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)];
    }

    @Override
    public double getHomeX() {
        return this.homeX;
    }

    @Override
    public double getHomeY() {
        return this.homeY;
    }

    @Override
    public double getHomeZ() {
        return this.homeZ;
    }

    @Override
    public double getHomeRange() {
        return 16.0;
    }

    static {
        shinies.put(new ItemStack(Items.diamond).getItem(), 8);
        shinies.put(new ItemStack(Items.diamond_axe).getItem(), 24);
        shinies.put(new ItemStack(Items.diamond_hoe).getItem(), 16);
        shinies.put(new ItemStack(Items.diamond_sword).getItem(), 16);
        shinies.put(new ItemStack(Items.diamond_shovel).getItem(), 8);
        shinies.put(new ItemStack(Items.diamond_pickaxe).getItem(), 24);
        shinies.put(new ItemStack(Items.emerald).getItem(), 3);
        shinies.put(new ItemStack(Items.gold_ingot).getItem(), 1);
        shinies.put(new ItemStack(Items.nether_star).getItem(), 16);
        shinies.put(new ItemStack(Items.blaze_rod).getItem(), 1);
        shinies.put(new ItemStack(Items.ghast_tear).getItem(), 4);
        shinies.put(new ItemStack(Items.golden_axe).getItem(), 3);
        shinies.put(new ItemStack(Items.golden_sword).getItem(), 2);
        shinies.put(new ItemStack(Items.golden_hoe).getItem(), 2);
        shinies.put(new ItemStack(Items.golden_shovel).getItem(), 1);
        shinies.put(new ItemStack(Items.golden_pickaxe).getItem(), 3);
        shinies.put(new ItemStack(Blocks.gold_block).getItem(), 9);
        shinies.put(new ItemStack(Blocks.emerald_block).getItem(), 27);
        shinies.put(new ItemStack(Blocks.diamond_block).getItem(), 72);
        shinies.put(new ItemStack(Blocks.lapis_block).getItem(), 7);
        shinies.put(new ItemStack(Blocks.redstone_block).getItem(), 5);
        GIFT_DELAY_TICKS = TimeUtil.minsToTicks(3);
        EXTRA_DROPS = new ItemStack[]{Witchery.Items.GENERIC.itemBatWool.createStack(5), Witchery.Items.GENERIC.itemDogTongue.createStack(5), Witchery.Items.GENERIC.itemToeOfFrog.createStack(2), Witchery.Items.GENERIC.itemOwletsWing.createStack(2), Witchery.Items.GENERIC.itemBranchEnt.createStack(1), Witchery.Items.GENERIC.itemInfernalBlood.createStack(2), Witchery.Items.GENERIC.itemCreeperHeart.createStack(2)};
        DEMON_NAMES = new String[]{"Ppaironael", "Aethon", "Tyrnak", "Beelzebuth", "Botis", "Moloch", "Taet", "Epnanaet", "Unonom", "Hexpemsazon", "Thayax", "Ethahoat", "Pruslas", "Ahtuxies", "Laripael", "Elxar", "Tarihimal", "Sapanolr", "Sahaminapiel", "Honed", "Oghmus", "Zedeson", "Halmaneop", "Nopoz", "Ekarnahox", "Sacuhatakael", "Ticos", "Arametheus", "Azmodaeus", "Larhepeis", "Topriraiz", "Rarahaimzah", "Tedrahamael", "Osaselael", "Phlegon", "Nelokhiel", "Haristum", "Zul", "Larhepeis", "Aamon", "Tramater", "Ehhbes", "Kra`an", "Quarax", "Hotesiatrem", "Surgat", "Nu`uhn", "Litedabh", "Unonom", "Bolenoz", "Hilopael", "Haristum", "Uhn", "Hiepacth", "Pemcapso", "Ankou", "Pundohien", "Koit", "Montobulus", "Amsaset", "Aropet", "Isnal", "Solael", "Exroh", "Sidragrosam", "Pnecamob", "Malashim", "Beelzebuth", "Ehohit", "Izatap", "Olon", "Assoaz", "Agalierept", "Krakus", "Umlaboor", "Aknrar", "Damaz", "Rhysus", "Pundohien", "Ba`al", "Rasuniolpas", "Anhoor", "Nyarlathotep", "Krakus", "Larhepeis", "Itakup", "Erdok", "Umlaboor", "Ezon", "Krakus", "Glassyalabolas", "Kra`an", "Ehnnat", "Terxor", "Asramel", "Tadal", "Arpzih", "Azmodaeus", "Henbolaron", "Rhysus"};
    }
}

