/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityLostSoul;
import com.emoniph.witchery.entity.EntitySpellEffect;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.symbols.EffectRegistry;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffect;
import com.emoniph.witchery.util.BlockActionSphere;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.RandomCollection;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityLeonard
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob,
IHandleDT {
    private int attackTimer;
    private boolean isImmune;
    private int spawnDelay;
    private static final RandomCollection<SymbolEffect> SPELLS = EntityLeonard.createSpells();

    public EntityLeonard(World world) {
        super(world);
        this.setSize(0.6f, 1.8f);
        this.isImmuneToFire = true;
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 30.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.experienceValue = 100;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(20, (Object)new Integer(0));
        this.dataWatcher.addObject(21, (Object)new Integer(0));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(600.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    public int getTotalArmorValue() {
        return 0;
    }

    public void setInWeb() {
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.leonard.name");
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        super.updateAITick();
    }

    public int getInvulnerableStartTicks() {
        return this.dataWatcher.getWatchableObjectInt(20);
    }

    public void setInvulnerableStartTicks(int par1) {
        this.dataWatcher.updateObject(20, (Object)par1);
    }

    public int getLifetime() {
        return this.dataWatcher.getWatchableObjectInt(21);
    }

    public void setLifetime(int par1) {
        this.dataWatcher.updateObject(21, (Object)par1);
    }

    public void setInvulnerableStart() {
        this.setInvulnerableStartTicks(150);
        this.setHealth(this.getMaxHealth() / 4.0f);
    }

    protected void updateAITasks() {
        if (this.getInvulnerableStartTicks() > 0) {
            int i = this.getInvulnerableStartTicks() - 1;
            if (i <= 0) {
                this.worldObj.playBroadcastSound(1013, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            }
            this.setInvulnerableStartTicks(i);
            if (this.ticksExisted % 10 == 0) {
                this.heal(this.getMaxHealth() * 0.75f / 15.0f);
            }
        } else {
            super.updateAITasks();
            this.setLifetime(this.getLifetime() + 1);
            if (this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            if (!(this.ticksExisted % 20 != 0 || this.worldObj.rand.nextInt(5) != 0 || this.getAttackTarget() == null && this.getLastAttacker() == null || this.worldObj.isRemote)) {
                EntityPlayer player;
                int R = 40;
                double RY = 40.0;
                double RSQ = 1600.0;
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - 40.0), (double)(this.posY - 40.0), (double)(this.posZ - 40.0), (double)(this.posX + 40.0), (double)(this.posY + 40.0), (double)(this.posZ + 40.0));
                List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                boolean hexed = false;
                for (EntityPlayer player2 : players) {
                    if (!(this.getDistanceSq(player2.posX, this.posY, player2.posZ) <= 1600.0) || player2.isDead || !(player2.getHealth() > 0.0f) || player2.isPotionActive(Witchery.Potions.MORTAL_COIL)) continue;
                    hexed = true;
                    ParticleEffect.MOB_SPELL.send(SoundEffect.RANDOM_FIZZ, (Entity)player2, 1.0, 2.0, 40);
                    player2.addPotionEffect(new PotionEffect(Witchery.Potions.MORTAL_COIL.id, TimeUtil.secsToTicks(90)));
                }
                if (hexed) {
                    ParticleEffect.SPELL_COLORED.send(SoundEffect.NOTE_HARP, (Entity)this, 1.0, 1.0, 40, 39168);
                } else if (this.worldObj.rand.nextInt(5) == 1 && players.size() > 0 && (player = (EntityPlayer)players.get(this.worldObj.rand.nextInt(players.size()))) != null && this.getDistanceSq(player.posX, this.posY, player.posZ) <= 1600.0 && !player.isDead && player.getHealth() > 0.0f) {
                    ParticleEffect.MOB_SPELL.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.0, 2.0, 40);
                    switch (this.worldObj.rand.nextInt(10)) {
                        case 0: 
                        case 1: 
                        case 2: {
                            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
                            Collection effects = player.getActivePotionEffects();
                            for (PotionEffect effect : effects) {
                                Potion potion = Potion.potionTypes[effect.getPotionID()];
                                if (PotionBase.isDebuff(potion) || !PotionBase.isCurable(potion)) continue;
                                effectsToRemove.add(potion);
                            }
                            for (Potion potion : effectsToRemove) {
                                player.removePotionEffect(potion.id);
                            }
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            player.addPotionEffect(new PotionEffect(Witchery.Potions.SINKING.id, TimeUtil.secsToTicks(60), 3));
                            ParticleEffect.SPELL_COLORED.send(SoundEffect.NOTE_HARP, (Entity)this, 1.0, 1.0, 40, 0x990000);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            player.addPotionEffect(new PotionEffect(Witchery.Potions.INSANITY.id, TimeUtil.secsToTicks(60), 3));
                            ParticleEffect.SPELL_COLORED.send(SoundEffect.NOTE_HARP, (Entity)this, 1.0, 1.0, 40, 153);
                            break;
                        }
                        case 9: {
                            player.addPotionEffect(new PotionEffect(Witchery.Potions.OVERHEATING.id, TimeUtil.secsToTicks(60), 3));
                            ParticleEffect.SPELL_COLORED.send(SoundEffect.NOTE_HARP, (Entity)this, 1.0, 1.0, 40, 39321);
                        }
                    }
                }
            }
            if (this.ticksExisted % 20 == 2) {
                if (this.worldObj.rand.nextInt(5) == 0) {
                    new BlockActionSphere(){

                        @Override
                        protected void onBlock(World world, int x, int y, int z) {
                            Block block = world.getBlock(x, y, z);
                            if (block == Witchery.Blocks.BREW_GAS || block == Witchery.Blocks.BREW_LIQUID) {
                                world.setBlock(x, y, z, (Block)Blocks.fire);
                            }
                        }
                    }.drawFilledSphere(this.worldObj, MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY) + 2, MathHelper.floor_double((double)this.posZ), 4);
                }
                if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
                    if (this.getAttackTarget() != null || this.getLastAttacker() != null) {
                        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.25 && this.worldObj.rand.nextInt(3) == 1 && !this.isPotionActive(Witchery.Potions.RESIZING)) {
                            this.addPotionEffect(new PotionEffect(Witchery.Potions.RESIZING.id, TimeUtil.secsToTicks(60), 3));
                        }
                        int SPAWN_DELAY = 10;
                        int R = 15;
                        double RY = 5.0;
                        double RSQ = 225.0;
                        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - 15.0), (double)(this.posY - 5.0), (double)(this.posZ - 15.0), (double)(this.posX + 15.0), (double)(this.posY + 5.0), (double)(this.posZ + 15.0));
                        List souls = this.worldObj.getEntitiesWithinAABB(EntityLostSoul.class, bounds);
                        if (souls.size() == 0) {
                            this.isImmune = false;
                            if (--this.spawnDelay <= 0) {
                                EntityLostSoul soul;
                                int i;
                                this.removeCoilEffects(15, 5.0);
                                this.spawnDelay = 10;
                                int spawned = 0;
                                for (i = 0; i < 4 + this.worldObj.rand.nextInt(2); ++i) {
                                    soul = (EntityLostSoul)Infusion.spawnCreature(this.worldObj, EntityLostSoul.class, (int)this.posX, (int)this.posY + 1, (int)this.posZ, null, 1, 4, ParticleEffect.SMOKE, SoundEffect.RANDOM_POP);
                                    if (soul == null) continue;
                                    soul.setTimeToLive(TimeUtil.secsToTicks(60 + this.worldObj.rand.nextInt(30)));
                                    ++spawned;
                                }
                                for (i = spawned; i < 3; ++i) {
                                    soul = (EntityLostSoul)Infusion.spawnCreature(this.worldObj, EntityLostSoul.class, (int)this.posX, (int)this.posY + 1, (int)this.posZ, null, 0, 0, ParticleEffect.SMOKE, SoundEffect.RANDOM_POP);
                                    if (soul == null) continue;
                                    soul.setTimeToLive(TimeUtil.secsToTicks(60 + this.worldObj.rand.nextInt(30)));
                                }
                            }
                        } else {
                            this.isImmune = true;
                        }
                    }
                } else {
                    this.isImmune = false;
                }
            }
        }
    }

    public void onDeath(DamageSource source) {
        super.onDeath(source);
        this.removeCoilEffects(40, 40.0);
    }

    private void removeCoilEffects(int R, double RY) {
        AxisAlignedBB bounds2 = AxisAlignedBB.getBoundingBox((double)(this.posX - (double)R), (double)(this.posY - RY), (double)(this.posZ - (double)R), (double)(this.posX + (double)R), (double)(this.posY + RY), (double)(this.posZ + (double)R));
        List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bounds2);
        for (EntityPlayer player : players) {
            if (player.isDead || !(player.getHealth() > 0.0f) || !player.isPotionActive(Witchery.Potions.MORTAL_COIL)) continue;
            player.removePotionEffect(Witchery.Potions.MORTAL_COIL.id);
            ExtendedPlayer playerEx = ExtendedPlayer.get(player);
            if (playerEx == null) continue;
            playerEx.clearCachedIncurablePotionEffect(Witchery.Potions.MORTAL_COIL);
        }
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        boolean immune = this.isImmune;
        if (immune) {
            return false;
        }
        if (source.getDamageType().equals("player")) {
            if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.25) {
                boolean isLarge = this.isPotionActive(Witchery.Potions.RESIZING) && this.getActivePotionEffect(Witchery.Potions.RESIZING).getAmplifier() >= 2;
                return super.attackEntityFrom(source, Math.min(damage, isLarge ? 1.0f : 4.0f));
            }
            return super.attackEntityFrom(source, Math.min(damage, 12.0f));
        }
        return false;
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return this.isImmune || !source.getDamageType().equals("player") ? 0.0f : 2.0f;
    }

    public void attackEntityFromWeakness(int damage) {
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.4) {
            boolean isLarge = this.isPotionActive(Witchery.Potions.RESIZING) && this.getActivePotionEffect(Witchery.Potions.RESIZING).getAmplifier() >= 2;
            super.attackEntityFrom(DamageSource.magic, Math.min((float)damage, isLarge ? 8.0f : 15.0f));
        }
    }

    public boolean canAttackClass(Class par1Class) {
        return super.canAttackClass(par1Class);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("PlayerCreated", this.isPlayerCreated());
        par1NBTTagCompound.setInteger("Invul", this.getInvulnerableStartTicks());
        par1NBTTagCompound.setLong("Lifetime", (long)this.getLifetime());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setPlayerCreated(par1NBTTagCompound.getBoolean("PlayerCreated"));
        this.setInvulnerableStartTicks(par1NBTTagCompound.getInteger("Invul"));
        this.setLifetime(par1NBTTagCompound.getInteger("Lifetime"));
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    protected String getLivingSound() {
        return "witchery:mob.leonard.say";
    }

    protected String getHurtSound() {
        return "witchery:mob.leonard.hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.leonard.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        super.func_145780_a(par1, par2, par3, par4);
    }

    protected void dropFewItems(boolean par1, int par2) {
        Enchantment enchantment = Enchantment.enchantmentsBookList[this.rand.nextInt(Enchantment.enchantmentsBookList.length)];
        int k = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 2, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack = Items.enchanted_book.getEnchantedItemStack(new EnchantmentData(enchantment, k));
        this.entityDropItem(itemstack, 0.0f);
        this.entityDropItem(Witchery.Items.GENERIC.itemDemonHeart.createStack(), 0.0f);
        this.entityDropItem(new ItemStack(Witchery.Items.LEONARDS_URN), 0.0f);
    }

    protected Item getDropItem() {
        return null;
    }

    public boolean isPlayerCreated() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setPlayerCreated(boolean par1) {
        this.func_110163_bv();
        byte b0 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    protected boolean canDespawn() {
        return false;
    }

    private static RandomCollection<SymbolEffect> createSpells() {
        RandomCollection<SymbolEffect> spells = new RandomCollection<SymbolEffect>();
        EffectRegistry.instance();
        spells.add(14.0, EffectRegistry.Ignianima);
        EffectRegistry.instance();
        spells.add(2.0, EffectRegistry.Expelliarmus);
        EffectRegistry.instance();
        spells.add(2.0, EffectRegistry.Flipendo);
        EffectRegistry.instance();
        spells.add(2.0, EffectRegistry.Impedimenta);
        EffectRegistry.instance();
        spells.add(1.0, EffectRegistry.Confundus);
        return spells;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        if (this.worldObj.rand.nextBoolean()) {
            this.attackTimer = 10;
            this.worldObj.setEntityState((Entity)this, (byte)4);
            double d0 = targetEntity.posX - this.posX;
            double d1 = targetEntity.boundingBox.minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d2 = targetEntity.posZ - this.posZ;
            float f1 = MathHelper.sqrt_float((float)par2) * 0.5f;
            if (!this.worldObj.isRemote) {
                this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                int count = this.rand.nextInt(10) == 0 ? 9 : 3;
                EntitySpellEffect effect = new EntitySpellEffect(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1, SPELLS.next(), 1);
                double d8 = 1.0;
                effect.posX = this.posX;
                effect.posY = this.posY + (double)(this.height / 2.0f);
                effect.posZ = this.posZ;
                this.worldObj.spawnEntityInWorld((Entity)effect);
                effect.setShooter((EntityLivingBase)this);
            }
        }
    }
}

