/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntitySpellEffect;
import com.emoniph.witchery.infusion.infusions.symbols.EffectRegistry;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffect;
import com.emoniph.witchery.item.ItemGlassGoblet;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.RandomCollection;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityLilith
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob,
IHandleDT {
    private int attackTimer;
    boolean isFriendly = false;
    int weaknessTimer;
    private static final RandomCollection<SymbolEffect> SPELLS = EntityLilith.createSpells();

    public EntityLilith(World world) {
        super(world);
        this.setSize(0.8f, 2.5f);
        this.isImmuneToFire = true;
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 30.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.experienceValue = 60;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(20, (Object)new Integer(0));
        this.dataWatcher.addObject(21, (Object)new Integer(0));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(200.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    public int getTotalArmorValue() {
        return 8;
    }

    public void setInWeb() {
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.lilith.name");
    }

    public boolean isAIEnabled() {
        return !this.isFriendly;
    }

    protected Entity findPlayerToAttack() {
        return this.isFriendly ? null : super.findPlayerToAttack();
    }

    protected void updateAITick() {
        super.updateAITick();
    }

    public int getInvulnerableStartTicks() {
        return this.dataWatcher.getWatchableObjectInt(20);
    }

    public void setInvulnerableStartTicks(int par1) {
        this.dataWatcher.updateObject(20, (Object)par1);
    }

    public int getLifetime() {
        return this.dataWatcher.getWatchableObjectInt(21);
    }

    public void setLifetime(int par1) {
        this.dataWatcher.updateObject(21, (Object)par1);
    }

    public void setInvulnerableStart() {
        this.setInvulnerableStartTicks(150);
        this.setHealth(this.getMaxHealth() / 4.0f);
    }

    protected void updateAITasks() {
        if (this.getInvulnerableStartTicks() > 0) {
            int i = this.getInvulnerableStartTicks() - 1;
            if (i <= 0) {
                this.worldObj.playBroadcastSound(1013, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            }
            this.setInvulnerableStartTicks(i);
            if (this.ticksExisted % 10 == 0) {
                this.heal(this.getMaxHealth() * 0.75f / 15.0f);
            }
        } else {
            super.updateAITasks();
            if (!this.worldObj.isRemote && !this.isPotionActive(Witchery.Potions.RESIZING)) {
                this.addPotionEffect(new PotionEffect(Witchery.Potions.RESIZING.id, 10000, 3, true));
            }
            this.setLifetime(this.getLifetime() + 1);
            if (this.ticksExisted % 20 == 0) {
                if (this.weaknessTimer > 0) {
                    --this.weaknessTimer;
                }
                if (!this.isPotionActive(Witchery.Potions.CHILLED) && !this.isPotionActive(Potion.weakness) && this.weaknessTimer == 0) {
                    this.heal(5.0f);
                } else if (this.weaknessTimer == 0) {
                    this.heal(1.0f);
                }
            }
            if (!(this.ticksExisted % 20 != 0 || this.worldObj.rand.nextInt(5) != 0 || this.getAttackTarget() == null && this.getLastAttacker() == null || this.worldObj.isRemote)) {
                int R = 32;
                double RY = 16.0;
                double RSQ = 1024.0;
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - 32.0), (double)(this.posY - 16.0), (double)(this.posZ - 32.0), (double)(this.posX + 32.0), (double)(this.posY + 16.0), (double)(this.posZ + 32.0));
                List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                for (EntityPlayer player : players) {
                    if (player.isPotionActive(Potion.fireResistance)) {
                        player.removePotionEffect(Potion.fireResistance.id);
                    }
                    if (this.worldObj.rand.nextInt(2) != 0) continue;
                    SoundEffect.MOB_ENDERDRAGON_GROWL.playAtPlayer(this.worldObj, player);
                    for (int i = 0; i < 3 + this.rand.nextInt(4); ++i) {
                        EntitySmallFireball fireball = new EntitySmallFireball(this.worldObj, player.posX + this.rand.nextDouble() * 4.0 - 2.0, player.posY + (double)this.rand.nextInt(2) + 14.0, player.posZ + this.rand.nextDouble() * 4.0 - 2.0, 0.0, -0.2, 0.0);
                        this.worldObj.spawnEntityInWorld((Entity)fireball);
                    }
                }
            }
        }
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        boolean immune = false;
        if (immune) {
            return false;
        }
        if (source.getEntity() != null && source.getSourceOfDamage() instanceof EntityLargeFireball && source.getEntity() instanceof EntityPlayer) {
            this.weaknessTimer = 10;
        }
        return super.attackEntityFrom(source, Math.min(damage, 12.0f));
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return 12.0f;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("Invul", this.getInvulnerableStartTicks());
        nbtRoot.setLong("Lifetime", (long)this.getLifetime());
        nbtRoot.setBoolean("Friendly", this.isFriendly);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setInvulnerableStartTicks(nbtRoot.getInteger("Invul"));
        this.setLifetime(nbtRoot.getInteger("Lifetime"));
        this.isFriendly = nbtRoot.getBoolean("Friendly");
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    protected String getLivingSound() {
        return this.isFriendly ? null : "witchery:mob.lilith.say";
    }

    protected String getHurtSound() {
        return "witchery:mob.lilith.hit";
    }

    protected String getDeathSound() {
        return this.isFriendly ? "witchery:mob.lilith.hit" : "witchery:mob.lilith.death";
    }

    protected void dropFewItems(boolean par1, int par2) {
    }

    public void onDeath(DamageSource source) {
        if (!this.worldObj.isRemote) {
            this.isDead = false;
            ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 2.0, 16);
            this.setHealth(this.getMaxHealth());
            this.isFriendly = true;
            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
            Collection effects = this.getActivePotionEffects();
            for (PotionEffect effect : effects) {
                Potion potion = Potion.potionTypes[effect.getPotionID()];
                if (!PotionBase.isCurable(potion)) continue;
                effectsToRemove.add(potion);
            }
            for (Potion potion : effectsToRemove) {
                this.removePotionEffect(potion.id);
            }
            EntityPlayer player = null;
            if (source != null && source.getEntity() != null && source.getEntity() instanceof EntityPlayer) {
                player = (EntityPlayer)source.getEntity();
                if (player.dimension != this.dimension || player.isDead || player.getDistanceSqToEntity((Entity)this) > 4096.0) {
                    player = null;
                }
            }
            if (player == null) {
                int R = 32;
                double RY = 16.0;
                double RSQ = 1024.0;
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - 32.0), (double)(this.posY - 16.0), (double)(this.posZ - 32.0), (double)(this.posX + 32.0), (double)(this.posY + 16.0), (double)(this.posZ + 32.0));
                List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                double distSq = 0.0;
                for (EntityPlayer player2 : players) {
                    if (player == null) {
                        distSq = this.getDistanceSqToEntity((Entity)player2);
                        player = player2;
                        continue;
                    }
                    double newDist = this.getDistanceSqToEntity((Entity)player2);
                    if (!(newDist < distSq)) continue;
                    distSq = newDist;
                    player = player2;
                }
            }
            if (player != null) {
                this.setPositionAndUpdate(player.posX - 1.0 + this.rand.nextDouble() * 2.0, player.posY + 0.05, player.posZ - 1.0 + this.rand.nextDouble() * 2.0);
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 2.0, 16);
                ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcomplete", new Object[0]);
                SoundEffect.WITCHERY_MOB_LILITH_TALK.playAt((EntityLiving)this);
            } else {
                this.setDead();
            }
        }
    }

    protected Item getDropItem() {
        return null;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected boolean interact(EntityPlayer player) {
        if (!this.worldObj.isRemote && this.isFriendly) {
            ItemStack stack = player.getHeldItem();
            SoundEffect.WITCHERY_MOB_LILITH_TALK.playAt((EntityLiving)this, 1.0f);
            boolean vanish = false;
            if (stack == null) {
                ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcomplete2", new Object[0]);
            } else if (stack.getItem() == Witchery.Items.BLOOD_GOBLET) {
                if (!ExtendedPlayer.get(player).isVampire()) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcompletelife", new Object[0]);
                    player.setCurrentItemOrArmor(0, null);
                    ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, player.worldObj, player.posX, player.posY + (double)player.height * 0.85, player.posZ, 0.8, 0.8, 16);
                    Witchery.Items.BLOOD_GOBLET.setBloodOwner(stack, ItemGlassGoblet.BloodSource.LILITH);
                    this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, player.posX, player.posY, player.posZ, stack));
                    ExtendedPlayer.get(player).setHumanBlood(0);
                    vanish = true;
                } else {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcompletelifefail", new Object[0]);
                }
            } else if (stack.getItem() == Witchery.Items.SEEDS_GARLIC) {
                if (ExtendedPlayer.get(player).isVampire()) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcompletecure", new Object[0]);
                    player.setCurrentItemOrArmor(0, null);
                    ExtendedPlayer.get(player).setVampireLevel(0);
                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.0, 1.5, 16);
                    vanish = true;
                } else {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcompletecurefail", new Object[0]);
                }
            } else if (stack.getItem() == Item.getItemFromBlock((Block)Blocks.red_flower) && stack.getItemDamage() == 0) {
                ExtendedPlayer playerEx = ExtendedPlayer.get(player);
                if (playerEx.getVampireLevel() == 6 && playerEx.canIncreaseVampireLevel()) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcompletebatflight", new Object[0]);
                    player.setCurrentItemOrArmor(0, null);
                    playerEx.increaseVampireLevel();
                    ParticleEffect.REDDUST.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.0, 1.5, 16);
                    vanish = true;
                } else {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcompletebatflightfail", new Object[0]);
                }
            } else {
                List enchants = EnchantmentHelper.buildEnchantmentList((Random)this.worldObj.rand, (ItemStack)stack, (int)40);
                if (enchants != null && enchants.size() > 0) {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcompletemagic", new Object[0]);
                    player.setCurrentItemOrArmor(0, null);
                    EntityLilith.addEnchantmentsFromList(stack, enchants);
                    if (stack.isItemStackDamageable()) {
                        stack.setItemDamage(0);
                    }
                    this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, player.posX, player.posY, player.posZ, stack));
                    vanish = true;
                } else {
                    ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)player, "item.witchery:glassgoblet.lilithquestcomplete2", new Object[0]);
                }
            }
            if (vanish) {
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 2.0, 16);
                this.setDead();
            }
            return true;
        }
        return false;
    }

    private static void addEnchantmentsFromList(ItemStack stack, List list) {
        boolean flag;
        boolean bl = flag = stack.getItem() == Items.book;
        if (flag) {
            stack.func_150996_a((Item)Items.enchanted_book);
        }
        Map enchants = EnchantmentHelper.getEnchantments((ItemStack)stack);
        if (list != null) {
            for (EnchantmentData enchantmentdata : list) {
                if (flag) {
                    Items.enchanted_book.addEnchantment(stack, enchantmentdata);
                    continue;
                }
                if (stack.getTagCompound() == null) {
                    stack.setTagCompound(new NBTTagCompound());
                }
                if (!stack.getTagCompound().hasKey("ench", 9)) {
                    stack.getTagCompound().setTag("ench", (NBTBase)new NBTTagList());
                }
                NBTTagList nbttaglist = stack.getTagCompound().getTagList("ench", 10);
                boolean addEnchant = true;
                for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                    if (nbttagcompound.getShort("id") != enchantmentdata.enchantmentobj.effectId) continue;
                    if (nbttagcompound.getShort("lvl") < enchantmentdata.enchantmentLevel) {
                        nbttagcompound.setShort("lvl", (short)enchantmentdata.enchantmentLevel);
                    }
                    addEnchant = false;
                    break;
                }
                if (addEnchant) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    nbttagcompound.setShort("id", (short)enchantmentdata.enchantmentobj.effectId);
                    nbttagcompound.setShort("lvl", (short)((byte)enchantmentdata.enchantmentLevel));
                    nbttaglist.appendTag((NBTBase)nbttagcompound);
                }
                stack.getTagCompound().setTag("ench", (NBTBase)nbttaglist);
            }
        }
    }

    private static RandomCollection<SymbolEffect> createSpells() {
        RandomCollection<SymbolEffect> spells = new RandomCollection<SymbolEffect>();
        EffectRegistry.instance();
        spells.add(1.0, EffectRegistry.Ignianima);
        EffectRegistry.instance();
        spells.add(5.0, EffectRegistry.Flipendo);
        EffectRegistry.instance();
        spells.add(1.0, EffectRegistry.Impedimenta);
        EffectRegistry.instance();
        spells.add(1.0, EffectRegistry.Confundus);
        EffectRegistry.instance();
        spells.add(5.0, EffectRegistry.Attraho);
        return spells;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        if (this.worldObj.rand.nextBoolean()) {
            this.attackTimer = 10;
            this.worldObj.setEntityState((Entity)this, (byte)4);
            double d0 = targetEntity.posX - this.posX;
            double d1 = targetEntity.boundingBox.minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d2 = targetEntity.posZ - this.posZ;
            float f1 = MathHelper.sqrt_float((float)par2) * 0.5f;
            if (!this.worldObj.isRemote) {
                if (this.worldObj.rand.nextInt(3) == 0) {
                    EntityLargeFireball fireballEntity = new EntityLargeFireball(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1);
                    double d8 = 1.0;
                    Vec3 vec3 = this.getLook(1.0f);
                    fireballEntity.posX = this.posX + vec3.xCoord * d8;
                    fireballEntity.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
                    fireballEntity.posZ = this.posZ + vec3.zCoord * d8;
                    if (!this.worldObj.isRemote) {
                        this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                        this.worldObj.spawnEntityInWorld((Entity)fireballEntity);
                    }
                } else {
                    this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                    int count = this.rand.nextInt(10) == 0 ? 9 : 3;
                    EntitySpellEffect effect = new EntitySpellEffect(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1, SPELLS.next(), 1);
                    double d8 = 1.0;
                    effect.posX = this.posX;
                    effect.posY = this.posY + (double)(this.height / 2.0f);
                    effect.posZ = this.posZ;
                    this.worldObj.spawnEntityInWorld((Entity)effect);
                    effect.setShooter((EntityLivingBase)this);
                }
            }
        }
    }
}

