/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.dimension.WorldProviderTorment;
import com.emoniph.witchery.entity.EntityFlyingMob;
import com.emoniph.witchery.entity.EntitySoulfire;
import com.emoniph.witchery.entity.EntitySpellEffect;
import com.emoniph.witchery.entity.ai.EntityAIFlyerArrowAttack;
import com.emoniph.witchery.entity.ai.EntityAIFlyerLand;
import com.emoniph.witchery.entity.ai.EntityAIFlyerWander;
import com.emoniph.witchery.infusion.infusions.symbols.EffectRegistry;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.DemonicDamageSource;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityLordOfTorment
extends EntityFlyingMob
implements IRangedAttackMob,
IBossDisplayData,
IHandleDT {
    private int attackTimer;
    private final HashSet<String> attackers = new HashSet();

    public EntityLordOfTorment(World world) {
        super(world);
        this.setSize(0.6f, 1.9f);
        this.isImmuneToFire = true;
        this.experienceValue = 50;
        this.getNavigator().setCanSwim(true);
        this.getNavigator().setAvoidsWater(true);
        this.experienceValue = 80;
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIFlyerArrowAttack(this, 1.0, 20, 60, 12.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, 0.8, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 0.2, 10.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(500.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.2);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(8.0);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(50.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote) {
            this.worldObj.spawnParticle(ParticleEffect.FLAME.toString(), this.posX - (double)this.width * 0.5 + this.worldObj.rand.nextDouble() * (double)this.width, 0.1 + this.posY + this.worldObj.rand.nextDouble() * 2.0, this.posZ - (double)this.width * 0.5 + this.worldObj.rand.nextDouble() * (double)this.width, 0.0, 0.0, 0.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_110182_bF() {
        return this.dataWatcher.getWatchableObjectByte(16) != 0;
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected boolean canDespawn() {
        return false;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.worldObj.rand.nextDouble() < 0.05 && this.getAttackTarget() != null && this.getAttackTarget() instanceof EntityPlayer && ((EntityPlayer)this.getAttackTarget()).capabilities.isFlying && !this.getAttackTarget().isPotionActive(Potion.moveSlowdown)) {
            this.getAttackTarget().addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 200, 5));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte state) {
        if (state == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.handleHealthUpdate(state);
        }
    }

    public boolean attackEntityAsMob(Entity target) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = target.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            target.motionY += (double)0.4f;
        }
        this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.lordoftorment.name");
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        if (nbtRoot.hasKey("WITCAttackers")) {
            NBTTagList nbtAttackers = nbtRoot.getTagList("WITCAttackers", 8);
            for (int i = 0; i < nbtAttackers.tagCount(); ++i) {
                String attacker = nbtAttackers.getStringTagAt(i);
                if (this.attackers.contains(attacker)) continue;
                this.attackers.add(attacker);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        NBTTagList nbtAttackers = new NBTTagList();
        boolean i = false;
        for (String attacker : this.attackers) {
            nbtAttackers.appendTag((NBTBase)new NBTTagString(attacker));
        }
        nbtRoot.setTag("WITCAttackers", (NBTBase)nbtAttackers);
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        EntityPlayer attacker;
        if (source.isExplosion()) {
            return false;
        }
        if (source.getSourceOfDamage() != null && source.getSourceOfDamage() instanceof EntityPlayer && !this.attackers.contains((attacker = (EntityPlayer)source.getSourceOfDamage()).getCommandSenderName())) {
            this.attackers.add(attacker.getCommandSenderName());
        }
        float damageCap = source instanceof DemonicDamageSource ? 8.0f : 5.0f;
        boolean damaged = super.attackEntityFrom(source, Math.min(damage, damageCap));
        if (!this.worldObj.isRemote && this.dimension != Config.instance().dimensionTormentID && this.getHealth() <= this.getMaxHealth() * 0.5f) {
            EntityPlayer otherPlayer;
            int tormentlevel = WorldProviderTorment.getRandomTormentLevel(this.worldObj);
            double R = 16.0;
            double Ry = 32.0;
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.posX - 16.0), (double)(this.posY - 32.0), (double)(this.posZ - 16.0), (double)(this.posX + 16.0), (double)(this.posY + 32.0), (double)(this.posZ + 16.0));
            List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bb);
            for (Object obj : players) {
                otherPlayer = (EntityPlayer)obj;
                WorldProviderTorment.setPlayerMustTorment(otherPlayer, 2, tormentlevel);
            }
            for (String playerName : this.attackers) {
                otherPlayer = this.worldObj.getPlayerEntityByName(playerName);
                if (otherPlayer == null || otherPlayer.dimension != this.dimension) continue;
                WorldProviderTorment.setPlayerMustTorment(otherPlayer, 2, tormentlevel);
            }
            ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 2.0, 16);
            this.setDead();
        }
        return damaged;
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return 5.0f;
    }

    protected String getLivingSound() {
        return "witchery:mob.torment.laugh";
    }

    protected String getHurtSound() {
        return "witchery:mob.torment.hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.torment.death";
    }

    public int getTalkInterval() {
        return TimeUtil.secsToTicks(10);
    }

    protected Item getDropItem() {
        return null;
    }

    protected void dropFewItems(boolean par1, int par2) {
        Enchantment enchantment = Enchantment.enchantmentsBookList[this.rand.nextInt(Enchantment.enchantmentsBookList.length)];
        int k = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 3, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack = Items.enchanted_book.getEnchantedItemStack(new EnchantmentData(enchantment, k));
        this.entityDropItem(itemstack, 0.0f);
        Enchantment enchantment2 = Enchantment.enchantmentsBookList[this.rand.nextInt(Enchantment.enchantmentsBookList.length)];
        int k2 = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)Math.min(enchantment2.getMinLevel() + 1, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack2 = Items.enchanted_book.getEnchantedItemStack(new EnchantmentData(enchantment, k2));
        this.entityDropItem(itemstack, 0.0f);
        this.entityDropItem(Witchery.Items.GENERIC.itemDemonHeart.createStack(), 0.0f);
        this.entityDropItem(Witchery.Items.GENERIC.itemBrewSoulTorment.createStack(), 0.0f);
    }

    protected float getSoundVolume() {
        return 2.0f;
    }

    public boolean getCanSpawnHere() {
        return true;
    }

    public int getMaxSpawnedInChunk() {
        return 1;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        double d0 = targetEntity.posX - this.posX;
        double d1 = targetEntity.boundingBox.minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double d2 = targetEntity.posZ - this.posZ;
        float f1 = MathHelper.sqrt_float((float)par2) * 0.5f;
        if (!this.worldObj.isRemote) {
            this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            int count = this.rand.nextInt(10) == 0 ? 9 : 3;
            EntitySpellEffect effect = new EntitySpellEffect(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1, EffectRegistry.instance().getEffect(39), 1);
            double d8 = 1.0;
            effect.posX = this.posX;
            effect.posY = this.posY + (double)(this.height / 2.0f);
            effect.posZ = this.posZ;
            this.worldObj.spawnEntityInWorld((Entity)effect);
            effect.setShooter((EntityLivingBase)this);
            for (int i = 0; i < count; ++i) {
                EntitySoulfire fireballEntity = new EntitySoulfire(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1);
                d8 = 1.0;
                fireballEntity.posX = this.posX;
                fireballEntity.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
                fireballEntity.posZ = this.posZ;
                this.worldObj.spawnEntityInWorld((Entity)fireballEntity);
            }
        }
    }
}

