/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.dimension.WorldProviderDreamWorld;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityNightmare
extends EntityMob
implements IEntitySelector {
    private int attackTimer;
    private int defenseTimer;

    public EntityNightmare(World par1World) {
        super(par1World);
        this.isImmuneToFire = true;
        this.setSize(0.6f, 1.8f);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, (IEntitySelector)this));
        this.experienceValue = 25;
    }

    public boolean isEntityApplicable(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            String victim = this.getVictimName();
            return victim == null || victim.isEmpty() || player.getCommandSenderName().equalsIgnoreCase(victim);
        }
        return false;
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(21, (Object)0);
    }

    public void setInWeb() {
    }

    protected void fall(float par1) {
    }

    public boolean isScreaming() {
        return this.dataWatcher.getWatchableObjectByte(16) > 0;
    }

    public void setScreaming(boolean par1) {
        this.dataWatcher.updateObject(16, (Object)((byte)(par1 ? 1 : 0)));
    }

    public boolean isDefended() {
        return this.dataWatcher.getWatchableObjectByte(21) > 0;
    }

    public void setDefended(boolean par1) {
        this.dataWatcher.updateObject(21, (Object)((byte)(par1 ? 1 : 0)));
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.nightmare.name");
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        super.updateAITick();
        if (!this.worldObj.isRemote && this.isEntityAlive()) {
            if (this.getAttackTarget() != null) {
                this.setScreaming(true);
            } else {
                this.setScreaming(false);
            }
        }
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    protected void updateEntityActionState() {
        super.updateEntityActionState();
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        if (this.getVictimName() == null) {
            par1NBTTagCompound.setString("Victim", "");
        } else {
            par1NBTTagCompound.setString("Victim", this.getVictimName());
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        String s = par1NBTTagCompound.getString("Victim");
        if (s.length() > 0) {
            this.setVictim(s);
        }
    }

    public String getVictimName() {
        String s = this.dataWatcher.getWatchableObjectString(17);
        return s != null ? s : "";
    }

    public void setVictim(String par1Str) {
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.worldObj.isRemote) {
            if (this.defenseTimer > 0 && --this.defenseTimer == 0) {
                this.setDefended(false);
            }
            if (!this.isDead && !this.getVictimName().isEmpty() && (this.getAttackTarget() == null || this.getAttackTarget().isDead || this.getDistanceSqToEntity((Entity)this.getAttackTarget()) > 256.0) || this.worldObj.rand.nextInt(5) == 0 && this.getAttackTarget() instanceof EntityPlayer && WorldProviderDreamWorld.getPlayerHasNightmare((EntityPlayer)this.getAttackTarget()) == 0 && !this.isWakingNightmare((EntityPlayer)this.getAttackTarget())) {
                ParticleEffect.EXPLODE.send(SoundEffect.NONE, (Entity)this, 1.0, 2.0, 16);
                this.setDead();
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    private boolean isWakingNightmare(EntityPlayer player) {
        NBTTagCompound nbtTag = Infusion.getNBT((Entity)player);
        if (nbtTag != null && nbtTag.hasKey("witcheryWakingNightmare")) {
            return nbtTag.getInteger("witcheryWakingNightmare") > 0;
        }
        return player.isPotionActive(Witchery.Potions.WAKING_NIGHTMARE);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 15;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        this.attackTimer = 15;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        if (entity != null && entity instanceof EntityPlayer) {
            int index;
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.findInInventory(player.inventory, Witchery.Items.GENERIC.itemCharmOfDisruptedDreams) && player.inventory.armorInventory[index = player.worldObj.rand.nextInt(player.inventory.armorInventory.length)] != null) {
                Infusion.dropEntityItemWithRandomChoice((EntityLivingBase)player, player.inventory.armorInventory[index], true);
                player.inventory.armorInventory[index] = null;
            }
        }
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        if (this.dimension != Config.instance().dimensionDreamID) {
            f = 0.5f;
        }
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                entity.setFire(j * 4);
            }
        }
        return flag;
    }

    private boolean findInInventory(InventoryPlayer inventory, ItemGeneral.SubItem item) {
        for (int i = 0; i < inventory.mainInventory.length; ++i) {
            ItemStack stack = inventory.mainInventory[i];
            if (stack == null || !item.isMatch(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        EntityLivingBase living;
        if (this.isDefended()) {
            return false;
        }
        boolean weakeningWeapon = false;
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).getEntity() != null && ((EntityDamageSource)source).getEntity() instanceof EntityLivingBase && (living = (EntityLivingBase)((EntityDamageSource)source).getEntity()).getHeldItem() != null && living.getHeldItem().getItem() == Witchery.Items.HUNTSMANS_SPEAR) {
            weakeningWeapon = true;
        }
        if (!this.worldObj.isRemote && this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)) != Witchery.Blocks.FLOWING_SPIRIT) {
            this.defenseTimer = this.dimension == Config.instance().dimensionDreamID ? (weakeningWeapon ? 40 : 80) : (weakeningWeapon ? 30 : 40);
            this.setDefended(true);
        }
        return super.attackEntityFrom(source, Math.min(damage, 15.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected String getLivingSound() {
        return "witchery:mob.nightmare.nightmare_live";
    }

    protected String getHurtSound() {
        return "witchery:mob.nightmare.nightmare_dead";
    }

    protected String getDeathSound() {
        return "witchery:mob.nightmare.nightmare_hit";
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (this.dimension == Config.instance().dimensionDreamID) {
            int chance = this.rand.nextInt(Math.max(10 - par2, 5));
            int quantity = par2 > 0 && chance == 0 ? 2 : 1;
            this.entityDropItem(Witchery.Items.GENERIC.itemMellifluousHunger.createStack(quantity), 0.0f);
        }
    }

    public void onDeath(DamageSource source) {
        if (!this.worldObj.isRemote && source != null && source.getEntity() != null && source.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.getEntity();
            String victim = this.getVictimName();
            if (victim != null && !victim.isEmpty() && player.getCommandSenderName().equalsIgnoreCase(victim) && this.dimension == Config.instance().dimensionDreamID) {
                WorldProviderDreamWorld.setPlayerLastNightmareKillNow(player);
            }
        }
        super.onDeath(source);
    }

    protected boolean canDespawn() {
        return true;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        return super.onSpawnWithEgg(par1EntityLivingData);
    }
}

