/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.client.renderer.RenderReflection;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityBolt;
import com.emoniph.witchery.entity.EntitySpellEffect;
import com.emoniph.witchery.infusion.infusions.symbols.EffectRegistry;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffect;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.RandomCollection;
import com.emoniph.witchery.util.TransformCreature;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class EntityReflection
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob,
IHandleDT {
    private int attackTimer;
    private boolean freeSpawn;
    private boolean isVampire;
    private int livingTicks = -1;
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f);
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.2, false);
    private String owner = "";
    private Task task = Task.NONE;
    private static final RandomCollection<SymbolEffect> SPELLS = EntityReflection.createSpells();
    @SideOnly(value=Side.CLIENT)
    private ThreadDownloadImageData downloadImageSkin;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation locationSkin;
    private String lastSkinOwner;

    public EntityReflection(World world) {
        super(world);
        this.setSize(0.6f, 1.8f);
        this.isImmuneToFire = true;
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.experienceValue = 50;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(18, (Object)0);
    }

    public String getOwnerSkin() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public String getOwnerName() {
        return this.owner;
    }

    public void setOwnerSkin(String skinName) {
        this.dataWatcher.updateObject(17, (Object)skinName);
    }

    public void setOwner(String par1Str) {
        this.func_110163_bv();
        this.owner = par1Str;
    }

    public EntityPlayer getOwnerEntity() {
        return this.worldObj.getPlayerEntityByName(this.getOwnerName());
    }

    public void setModel(int model) {
        this.dataWatcher.updateObject(18, (Object)((byte)model));
    }

    public int getModel() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void setLifetime(int ticks) {
        this.livingTicks = ticks;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
    }

    public void setInWeb() {
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        String owner = this.getOwnerName();
        return owner == null || owner.isEmpty() ? StatCollector.translateToLocal((String)"entity.witchery.reflection.name") : owner;
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        super.updateAITick();
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.worldObj.isRemote && this.ticksExisted % 30 == 1) {
            if (!this.freeSpawn && this.dimension != Config.instance().dimensionMirrorID) {
                this.setDead();
                return;
            }
            if (this.livingTicks > -1 && --this.livingTicks == 0) {
                this.setDead();
                return;
            }
            double R = 10.0;
            double RY = 8.0;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - R), (double)(this.posY - RY), (double)(this.posZ - R), (double)(this.posX + R), (double)(this.posY + RY), (double)(this.posZ + R));
            List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bounds);
            EntityPlayer ownerEntity = this.getOwnerEntity();
            boolean ownerFound = false;
            EntityPlayer closest = null;
            double distance = Double.MAX_VALUE;
            for (EntityPlayer player : players) {
                double newDistance = player.getDistanceSqToEntity((Entity)this);
                if (closest == null || newDistance < distance) {
                    closest = player;
                    distance = newDistance;
                }
                if (ownerEntity != player) continue;
                ownerFound = true;
            }
            if (ownerEntity == null || !ownerFound) {
                if (closest != null) {
                    this.setOwner(closest.getCommandSenderName());
                } else {
                    this.setOwner("");
                }
            }
            boolean resetGear = true;
            String skinName = this.getOwnerName();
            if (!this.getOwnerName().isEmpty()) {
                EntityPlayer owner;
                EntityPlayer entityPlayer = owner = ownerEntity == null || !ownerFound ? this.getOwnerEntity() : ownerEntity;
                if (owner != null) {
                    ItemStack stack;
                    for (int slot = 1; slot <= 4; ++slot) {
                        ItemStack stack2 = owner.getEquipmentInSlot(slot);
                        if (stack2 != null) {
                            stack2 = stack2.copy();
                        }
                        this.setCurrentItemOrArmor(slot, stack2);
                    }
                    ItemStack bestWeapon = null;
                    double bestDamage = 0.0;
                    for (int hot = 0; hot < 9; ++hot) {
                        stack = owner.inventory.getStackInSlot(hot);
                        if (stack == null) continue;
                        Multimap modifierMap = stack.getAttributeModifiers();
                        Iterator itr = modifierMap.get((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName()).iterator();
                        double damage = 0.0;
                        while (itr.hasNext()) {
                            AttributeModifier modifier = (AttributeModifier)itr.next();
                            if (modifier.getOperation() != 0) continue;
                            damage += modifier.getAmount();
                        }
                        if (!(damage > bestDamage)) continue;
                        bestWeapon = stack;
                        bestDamage = damage;
                    }
                    ExtendedPlayer playerEx = ExtendedPlayer.get(owner);
                    if (playerEx != null) {
                        this.setModel(playerEx.getCreatureType() == TransformCreature.WOLFMAN ? 1 : 0);
                        this.isVampire = playerEx.isVampire();
                        if (playerEx.getCreatureType() == TransformCreature.PLAYER) {
                            skinName = playerEx.getOtherPlayerSkin();
                        }
                    }
                    ItemStack itemStack = stack = bestWeapon != null ? bestWeapon : owner.getEquipmentInSlot(0);
                    if (stack != null) {
                        stack = stack.copy();
                        Witchery.modHooks.makeItemModProof(stack);
                    }
                    if (this.getModel() == 1) {
                        stack = null;
                        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(6.0);
                    } else {
                        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
                    }
                    this.setCurrentItemOrArmor(0, stack);
                    resetGear = false;
                    if (this.ticksExisted % 60 == 1) {
                        this.clearActivePotions();
                        for (PotionEffect effect : owner.getActivePotionEffects()) {
                            this.addPotionEffect(new PotionEffect(effect));
                        }
                    }
                }
            }
            if (resetGear) {
                for (int slot = 0; slot <= 4; ++slot) {
                    this.setCurrentItemOrArmor(slot, null);
                }
            }
            this.setOwnerSkin(skinName);
            ItemStack held = this.getHeldItem();
            if (held != null) {
                if (held.getItem() == Witchery.Items.MYSTIC_BRANCH) {
                    if (this.task == Task.MELEE) {
                        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
                    }
                    this.tasks.addTask(2, (EntityAIBase)this.aiArrowAttack);
                    this.task = Task.RANGED;
                } else if (held.getItem() == Witchery.Items.CROSSBOW_PISTOL || held.getItem() instanceof ItemBow) {
                    if (this.task == Task.MELEE) {
                        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
                    }
                    this.tasks.addTask(2, (EntityAIBase)this.aiArrowAttack);
                    this.task = Task.RANGED;
                } else {
                    if (this.task == Task.RANGED) {
                        this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
                    }
                    this.tasks.addTask(2, (EntityAIBase)this.aiAttackOnCollide);
                    this.task = Task.MELEE;
                }
            } else {
                if (this.task == Task.RANGED) {
                    this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
                }
                this.tasks.addTask(2, (EntityAIBase)this.aiAttackOnCollide);
                this.task = Task.MELEE;
            }
            if (this.isEntityAlive() && this.getAttackTarget() != null && this.getNavigator().noPath() && this.getEntitySenses().canSee((Entity)this.getAttackTarget())) {
                EntityLivingBase entityLivingBase = this.getAttackTarget();
                EffectRegistry.instance();
                this.castSpell(entityLivingBase, 1.0f, EffectRegistry.Attraho);
            }
        }
        if (!this.worldObj.isRemote && this.worldObj.rand.nextDouble() < 0.05 && this.getAttackTarget() != null && (this.getAttackTarget().isAirBorne || this.getAttackTarget() instanceof EntityPlayer && ((EntityPlayer)this.getAttackTarget()).capabilities.isFlying) && !this.getAttackTarget().isPotionActive(Potion.moveSlowdown)) {
            this.getAttackTarget().addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 200, 5));
        }
    }

    public void onDeath(DamageSource p_70645_1_) {
        super.onDeath(p_70645_1_);
        Witchery.Blocks.MIRROR.demonSlain(this.worldObj, this.posX, this.posY, this.posZ);
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        return super.attackEntityFrom(source, Math.min(damage, 6.0f));
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return 2.0f;
    }

    public boolean canAttackClass(Class par1Class) {
        return super.canAttackClass(par1Class);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setString("Owner", this.getOwnerName());
        nbtRoot.setString("OwnerSkin", this.getOwnerSkin());
        nbtRoot.setInteger("Model", this.getModel());
        nbtRoot.setBoolean("FreeSpawn", this.freeSpawn);
        nbtRoot.setBoolean("Vampire", this.isVampire);
        nbtRoot.setInteger("LivingTicks", this.livingTicks);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setOwner(nbtRoot.getString("Owner"));
        this.setOwnerSkin(nbtRoot.getString("OwnerSkin"));
        this.freeSpawn = nbtRoot.getBoolean("FreeSpawn");
        this.livingTicks = nbtRoot.getInteger("LivingTicks");
        this.isVampire = nbtRoot.getBoolean("Vampire");
        this.setModel(nbtRoot.getInteger("Model"));
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        boolean flag = super.attackEntityAsMob(par1Entity);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    protected String getLivingSound() {
        return "witchery:mob.reflection.say";
    }

    protected String getHurtSound() {
        return "witchery:mob.reflection.hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.reflection.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        super.func_145780_a(par1, par2, par3, par4);
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(Witchery.Items.GENERIC.itemDemonHeart.createStack(), 0.0f);
    }

    protected void dropEquipment(boolean p_82160_1_, int p_82160_2_) {
    }

    protected Item getDropItem() {
        return null;
    }

    protected boolean canDespawn() {
        return false;
    }

    private static RandomCollection<SymbolEffect> createSpells() {
        RandomCollection<SymbolEffect> spells = new RandomCollection<SymbolEffect>();
        EffectRegistry.instance();
        spells.add(14.0, EffectRegistry.Ignianima);
        EffectRegistry.instance();
        spells.add(2.0, EffectRegistry.Expelliarmus);
        EffectRegistry.instance();
        spells.add(2.0, EffectRegistry.Flipendo);
        EffectRegistry.instance();
        spells.add(2.0, EffectRegistry.Impedimenta);
        EffectRegistry.instance();
        spells.add(1.0, EffectRegistry.Confundus);
        return spells;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        ItemStack held = this.getHeldItem();
        if (held == null) {
            return;
        }
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        if (held.getItem() == Witchery.Items.MYSTIC_BRANCH) {
            if (this.worldObj.rand.nextBoolean()) {
                this.castSpell(targetEntity, par2, SPELLS.next());
            }
        } else if (held.getItem() == Witchery.Items.CROSSBOW_PISTOL) {
            EntityBolt entityarrow = new EntityBolt(this.worldObj, (EntityLivingBase)this, targetEntity, 1.6f, 14 - this.worldObj.difficultySetting.getDifficultyId() * 4);
            int i = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)this.getHeldItem());
            int j = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)this.getHeldItem());
            entityarrow.setDamage((double)(par2 * 2.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)this.worldObj.difficultySetting.getDifficultyId() * 0.11f));
            if (i > 0) {
                entityarrow.setDamage(entityarrow.getDamage() + (double)i * 0.5 + 0.5);
            }
            if (j > 0) {
                entityarrow.setKnockbackStrength(j);
            }
            if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)this.getHeldItem()) > 0 || CreatureUtil.isVampire((Entity)this.getAttackTarget()) && this.worldObj.rand.nextInt(3) == 0) {
                entityarrow.setFire(100);
            }
            if (this.getAttackTarget() != null) {
                if (CreatureUtil.isWerewolf((Entity)this.getAttackTarget())) {
                    entityarrow.setBoltType(4);
                } else if (CreatureUtil.isUndead((Entity)this.getAttackTarget())) {
                    entityarrow.setBoltType(3);
                } else if (this.worldObj.rand.nextInt(4) == 0) {
                    entityarrow.setBoltType(2);
                }
            }
            this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
            this.worldObj.spawnEntityInWorld((Entity)entityarrow);
        } else {
            EntityArrow entityarrow = new EntityArrow(this.worldObj, (EntityLivingBase)this, targetEntity, 1.6f, (float)(14 - this.worldObj.difficultySetting.getDifficultyId() * 3));
            int i = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)this.getHeldItem());
            int j = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)this.getHeldItem());
            entityarrow.setDamage((double)(par2 * 2.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)this.worldObj.difficultySetting.getDifficultyId() * 0.11f));
            if (i > 0) {
                entityarrow.setDamage(entityarrow.getDamage() + (double)i * 0.5 + 0.5);
            }
            if (j > 0) {
                entityarrow.setKnockbackStrength(j);
            }
            if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)this.getHeldItem()) > 0) {
                entityarrow.setFire(100);
            }
            this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
            this.worldObj.spawnEntityInWorld((Entity)entityarrow);
        }
    }

    private void castSpell(EntityLivingBase targetEntity, float par2, SymbolEffect spell) {
        double d0 = targetEntity.posX - this.posX;
        double d1 = targetEntity.boundingBox.minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double d2 = targetEntity.posZ - this.posZ;
        float f1 = MathHelper.sqrt_float((float)par2) * 0.5f;
        if (!this.worldObj.isRemote) {
            this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            int count = this.rand.nextInt(10) == 0 ? 9 : 3;
            EntitySpellEffect effect = new EntitySpellEffect(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1, spell, 1);
            double d8 = 1.0;
            effect.posX = this.posX;
            effect.posY = this.posY + (double)(this.height / 2.0f);
            effect.posZ = this.posZ;
            this.worldObj.spawnEntityInWorld((Entity)effect);
            effect.setShooter((EntityLivingBase)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLocationSkin() {
        if (this.locationSkin == null || !this.lastSkinOwner.equals(this.getOwnerName())) {
            this.setupCustomSkin();
        }
        if (this.locationSkin != null) {
            return this.locationSkin;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setupCustomSkin() {
        String ownerName = this.getOwnerSkin();
        if (ownerName != null && !ownerName.isEmpty()) {
            this.locationSkin = AbstractClientPlayer.getLocationSkin((String)ownerName);
            this.downloadImageSkin = EntityReflection.getDownloadImageSkin(this.locationSkin, ownerName);
            this.lastSkinOwner = ownerName;
        } else {
            this.locationSkin = null;
            this.downloadImageSkin = null;
            this.lastSkinOwner = "";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ThreadDownloadImageData getDownloadImageSkin(ResourceLocation location, String name) {
        TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
        ITextureObject object = texturemanager.getTexture(location);
        if (object == null) {
            object = new ThreadDownloadImageData((File)null, String.format("http://skins.minecraft.net/MinecraftSkins/%s.png", StringUtils.stripControlCodes((String)name)), RenderReflection.SKIN, (IImageBuffer)new ImageBufferDownload());
            texturemanager.loadTexture(location, object);
        }
        return (ThreadDownloadImageData)object;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        this.freeSpawn = true;
        return super.onSpawnWithEgg(data);
    }

    public boolean isVampire() {
        return this.isVampire;
    }

    private static enum Task {
        NONE,
        MELEE,
        RANGED;

    }
}

