/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityFlyingTameable;
import com.emoniph.witchery.entity.ai.EntityAIFlyerFlyToWaypoint;
import com.emoniph.witchery.entity.ai.EntityAIFlyerFollowOwner;
import com.emoniph.witchery.entity.ai.EntityAIFlyerLand;
import com.emoniph.witchery.entity.ai.EntityAIFlyerWander;
import com.emoniph.witchery.entity.ai.EntityAIFlyingTempt;
import com.emoniph.witchery.entity.ai.EntityAISitAndStay;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;

public class EntitySpirit
extends EntityFlyingTameable {
    public EntityAIFlyingTempt aiTempt;
    private int timeToLive = -1;
    private int spiritType = 0;
    private static final ItemStack[] TEMPTATIONS = new ItemStack[]{Witchery.Items.GENERIC.itemFocusedWill.createStack()};
    private static Field fieldStructureGenerators;
    private static Field fieldVillageGenerator;

    public EntitySpirit(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay(this));
        this.aiTempt = new EntityAIFlyingTempt((EntityCreature)this, 0.6, TEMPTATIONS, true);
        this.tasks.addTask(3, (EntityAIBase)this.aiTempt);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIFlyerFollowOwner(this, 1.0, 14.0f, 5.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIFlyerFlyToWaypoint(this, EntityAIFlyerFlyToWaypoint.CarryRequirement.NONE));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, 0.8, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 0.8, 10.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
    }

    protected boolean canDespawn() {
        return true;
    }

    public void setTarget(String target, int type) {
        this.timeToLive = TimeUtil.secsToTicks(10);
        this.spiritType = type;
        try {
            if (target.equals("Village")) {
                IChunkProvider cp = this.worldObj.getChunkProvider();
                while (cp != null && cp instanceof ChunkProviderServer) {
                    cp = ((ChunkProviderServer)cp).currentChunkProvider;
                }
                if (cp != null) {
                    if (cp instanceof ChunkProviderFlat) {
                        if (fieldStructureGenerators == null) {
                            fieldStructureGenerators = ReflectionHelper.findField(ChunkProviderFlat.class, (String[])new String[]{"structureGenerators", "field_82696_f", "f"});
                        }
                        Iterator iterator = ((List)fieldStructureGenerators.get((ChunkProviderFlat)cp)).iterator();
                        while (iterator.hasNext()) {
                            if (!this.setWaypointTo(iterator.next(), MapGenVillage.class)) continue;
                            return;
                        }
                    } else if (cp instanceof ChunkProviderGenerate) {
                        if (fieldVillageGenerator == null) {
                            fieldVillageGenerator = ReflectionHelper.findField(ChunkProviderGenerate.class, (String[])new String[]{"villageGenerator", "field_73224_v", "v"});
                        }
                        if (fieldVillageGenerator != null) {
                            this.setWaypointTo(fieldVillageGenerator.get((ChunkProviderGenerate)cp), MapGenVillage.class);
                        }
                    } else if (cp instanceof ChunkProviderHell) {
                        this.setWaypointTo((MapGenStructure)((ChunkProviderHell)cp).genNetherBridge);
                    }
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private boolean setWaypointTo(Object objStructure, Class<? extends MapGenStructure> clazz) {
        if (objStructure != null && clazz.isAssignableFrom(objStructure.getClass())) {
            this.setWaypointTo((MapGenStructure)objStructure);
            return true;
        }
        return false;
    }

    private void setWaypointTo(MapGenStructure mapStructure) {
        ChunkPosition pos;
        if (mapStructure != null && (pos = mapStructure.func_151545_a(this.worldObj, (int)this.posX, (int)this.posY, (int)this.posZ)) != null) {
            this.homeX = pos.chunkPosX;
            this.homeY = pos.chunkPosY;
            this.homeZ = pos.chunkPosZ;
            this.waypoint = Witchery.Items.GENERIC.itemWaystone.createStack();
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("SuicideIn", this.timeToLive);
        nbtRoot.setInteger("SpiritType", this.spiritType);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.timeToLive = nbtRoot.hasKey("SuicideIn") ? nbtRoot.getInteger("SuicideIn") : -1;
        this.spiritType = nbtRoot.hasKey("SpiritType") ? nbtRoot.getInteger("SpiritType") : 0;
    }

    protected void updateAITick() {
        this.getNavigator().clearPathEntity();
        super.updateAITick();
        if (this.worldObj != null && !this.isDead && !this.worldObj.isRemote && this.timeToLive != -1 && --this.timeToLive == 0) {
            ParticleEffect.EXPLODE.send(SoundEffect.NONE, (Entity)this, 1.0, 1.0, 16);
            this.setDead();
            if (!this.worldObj.isRemote) {
                this.dropFewItems(false, 0);
            }
        }
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(21, (Object)0);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.4);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (this.spiritType == 2) {
            return;
        }
        ItemStack stack = this.spiritType == 1 ? Witchery.Items.GENERIC.itemSubduedSpiritVillage.createStack() : Witchery.Items.GENERIC.itemSubduedSpirit.createStack();
        this.entityDropItem(stack, 0.0f);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote) {
            int color = this.getFeatherColor();
            float red = 1.0f;
            float green = 0.8f;
            float blue = 0.0f;
            if (color > 0) {
                red = (float)(color >> 16 & 0xFF) / 255.0f;
                green = (float)(color >> 8 & 0xFF) / 255.0f;
                blue = (float)(color & 0xFF) / 255.0f;
            }
            Witchery.proxy.generateParticle(this.worldObj, this.posX - (double)this.width * 0.5 + this.worldObj.rand.nextDouble() * (double)this.width, 0.1 + this.posY + this.worldObj.rand.nextDouble() * 0.2, this.posZ - (double)this.width * 0.5 + this.worldObj.rand.nextDouble() * (double)this.width, red, green, blue, 10, -0.1f);
        }
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return null;
    }

    protected String getDeathSound() {
        return null;
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        return false;
    }

    public EntitySpirit spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public boolean isBreedingItem(ItemStack itemstack) {
        return itemstack != null && itemstack.getItem() == Items.bone;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        return false;
    }

    public int getFeatherColor() {
        return this.dataWatcher.getWatchableObjectInt(21);
    }

    public void setFeatherColor(int par1) {
        this.dataWatcher.updateObject(21, (Object)par1);
    }

    public boolean getCanSpawnHere() {
        if (this.worldObj.provider.dimensionId == Config.instance().dimensionDreamID) {
            boolean superGetCanSpawnHere = this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox);
            int i = MathHelper.floor_double((double)this.posX);
            int j = MathHelper.floor_double((double)this.boundingBox.minY);
            int k = MathHelper.floor_double((double)this.posZ);
            superGetCanSpawnHere = superGetCanSpawnHere && this.getBlockPathWeight(i, j, k) >= 0.0f && j >= 60;
            Block blockID = this.worldObj.getBlock(i, j - 1, k);
            return superGetCanSpawnHere && this.worldObj.rand.nextInt(10) == 0 && (blockID == Blocks.grass || blockID == Blocks.sand) && this.worldObj.getFullBlockLightValue(i, j, k) > 8;
        }
        return false;
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.spirit.name");
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.onSpawnWithEgg(par1EntityLivingData);
        return par1EntityLivingData;
    }

    public EntityAgeable createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }
}

