/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.ai.EntityAIDimensionalFollowOwner;
import com.emoniph.witchery.entity.ai.EntityAISitAndStay;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.familiar.IFamiliar;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TameableUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityToad
extends EntityTameable
implements IFamiliar {
    private int timeToLive = -1;
    private boolean poisoned = false;

    public EntityToad(World par1World) {
        super(par1World);
        this.setSize(0.8f, 0.8f);
        this.getNavigator().setCanSwim(true);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAISitAndStay(this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIDimensionalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.rotten_flesh, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.setTamed(false);
    }

    public void setTimeToLive(int i, boolean poisoned) {
        this.timeToLive = i;
        this.poisoned = poisoned;
    }

    public boolean isTemp() {
        return this.timeToLive != -1;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.20000001192092895);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(10.0);
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + (this.isFamiliar() ? 5 : 0);
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    @Override
    public void setMaxHealth(float maxHealth) {
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxHealth);
        this.setHealth(maxHealth);
        this.setFamiliar(true);
    }

    public EntityLivingBase getOwner() {
        if (this.isFamiliar() && !this.worldObj.isRemote) {
            return TameableUtil.getOwnerAccrossDimensions(this);
        }
        return super.getOwner();
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void fall(float par1) {
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        super.updateAITick();
        this.dataWatcher.updateObject(18, (Object)Float.valueOf(this.getHealth()));
        if (this.worldObj != null && !this.isDead && !this.worldObj.isRemote && this.timeToLive != -1 && --this.timeToLive == 0) {
            this.setDead();
            if (this.poisoned) {
                AxisAlignedBB axisalignedbb = this.boundingBox.expand(3.0, 2.0, 3.0);
                List list1 = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
                if (list1 != null && !list1.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list1) {
                        double d0 = this.getDistanceSqToEntity((Entity)entitylivingbase);
                        if (!(d0 < 9.0)) continue;
                        double d1 = 1.0 - Math.sqrt(d0) / 3.0;
                        entitylivingbase.addPotionEffect(new PotionEffect(Potion.poison.id, 60, 0));
                    }
                }
                ParticleEffect.SLIME.send(SoundEffect.MOB_SLIME_BIG, (Entity)this, 1.0, 1.0, 16);
            }
            ParticleEffect.MOB_SPELL.send(SoundEffect.NONE, (Entity)this, 0.5, 0.5, 16);
        }
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)new Float(this.getHealth()));
        this.dataWatcher.addObject(19, (Object)new Byte(0));
        this.dataWatcher.addObject(20, (Object)new Byte((byte)BlockColored.func_150032_b((int)(this.worldObj != null ? this.worldObj.rand.nextInt(16) : new Random().nextInt(16)))));
        this.dataWatcher.addObject(26, (Object)0);
    }

    @Override
    public boolean isFamiliar() {
        return this.dataWatcher.getWatchableObjectByte(26) > 0;
    }

    public void setFamiliar(boolean familiar) {
        this.dataWatcher.updateObject(26, (Object)((byte)(familiar ? 1 : 0)));
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.slime.small", 0.15f, 1.0f);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setByte("SkinColor", (byte)this.getSkinColor());
        par1NBTTagCompound.setByte("Familiar", (byte)(this.isFamiliar() ? 1 : 0));
        par1NBTTagCompound.setInteger("SuicideIn", this.timeToLive);
        par1NBTTagCompound.setBoolean("Poisonous", this.poisoned);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasKey("SkinColor")) {
            this.setSkinColor(par1NBTTagCompound.getByte("SkinColor"));
        }
        if (par1NBTTagCompound.hasKey("Familiar")) {
            this.setFamiliar(par1NBTTagCompound.getByte("Familiar") > 0);
        }
        this.timeToLive = par1NBTTagCompound.hasKey("SuicideIn") ? par1NBTTagCompound.getInteger("SuicideIn") : -1;
        this.poisoned = par1NBTTagCompound.hasKey("Poisonous") ? par1NBTTagCompound.getBoolean("Poisonous") : false;
    }

    protected String getLivingSound() {
        return "witchery:mob.toad.toad_croak";
    }

    protected String getHurtSound() {
        return "witchery:mob.toad.toad_hurt";
    }

    protected String getDeathSound() {
        return "witchery:mob.toad.toad_hurt";
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected Item getDropItem() {
        if (!this.isTemp()) {
            return Items.slime_ball;
        }
        return super.getDropItem();
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public void onUpdate() {
        this.isImmuneToFire = this.isFamiliar();
        super.onUpdate();
        if (!(this.isSitting() || this.worldObj.isRemote || this.motionX == 0.0 && this.motionZ == 0.0 || this.isInWater())) {
            this.getJumpHelper().setJumping();
        }
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    public int getVerticalFaceSpeed() {
        return this.isSitting() ? 20 : super.getVerticalFaceSpeed();
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        Entity entity = par1DamageSource.getEntity();
        if (!this.isFamiliar()) {
            this.setSitting(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public void setTamed(boolean par1) {
        super.setTamed(par1);
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        if (this.isTemp()) {
            return true;
        }
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        if (this.isTamed()) {
            if (TameableUtil.isOwner(this, par1EntityPlayer) && this.isFamiliar() && par1EntityPlayer.isSneaking() && this.isSitting()) {
                if (!this.worldObj.isRemote) {
                    Familiar.dismissFamiliar(par1EntityPlayer, this);
                }
                return true;
            }
            if (itemstack != null) {
                if (itemstack.getItem() == Items.rotten_flesh && this.getHealth() < this.getMaxHealth()) {
                    if (!par1EntityPlayer.capabilities.isCreativeMode) {
                        --itemstack.stackSize;
                    }
                    this.heal(10.0f);
                    if (itemstack.stackSize <= 0) {
                        par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, (ItemStack)null);
                    }
                    return true;
                }
                if (itemstack.getItem() == Items.dye) {
                    int i = BlockColored.func_150032_b((int)itemstack.getItemDamage());
                    if (i != this.getSkinColor()) {
                        this.setSkinColor(i);
                        if (!par1EntityPlayer.capabilities.isCreativeMode && --itemstack.stackSize <= 0) {
                            par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, (ItemStack)null);
                        }
                        return true;
                    }
                } else if (itemstack.getItem() == Items.name_tag || itemstack.getItem() == Witchery.Items.POLYNESIA_CHARM || itemstack.getItem() == Witchery.Items.DEVILS_TONGUE_CHARM) {
                    return false;
                }
            }
            if (TameableUtil.isOwner(this, par1EntityPlayer) && !this.isBreedingItem(itemstack)) {
                if (!this.worldObj.isRemote) {
                    this.setSitting(!this.isSitting());
                    this.getJumpHelper().doJump();
                    this.isJumping = false;
                    this.setPathToEntity(null);
                    this.setTarget(null);
                    this.setAttackTarget(null);
                }
                return true;
            }
        } else if (itemstack != null && itemstack.getItem() == Items.rotten_flesh) {
            if (!par1EntityPlayer.capabilities.isCreativeMode) {
                --itemstack.stackSize;
            }
            if (itemstack.stackSize <= 0) {
                par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, (ItemStack)null);
            }
            if (!this.worldObj.isRemote) {
                if (this.rand.nextInt(3) == 0) {
                    this.setTamed(true);
                    this.func_110163_bv();
                    this.setPathToEntity(null);
                    this.setAttackTarget(null);
                    this.setSitting(true);
                    TameableUtil.setOwner(this, par1EntityPlayer);
                    this.playTameEffect(true);
                    this.worldObj.setEntityState((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.worldObj.setEntityState((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.interact(par1EntityPlayer);
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.toad.name");
    }

    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return par1ItemStack != null && par1ItemStack.getItem() == Items.rotten_flesh;
    }

    public int getSkinColor() {
        return this.dataWatcher.getWatchableObjectByte(20) & 0xF;
    }

    public void setSkinColor(int par1) {
        this.dataWatcher.updateObject(20, (Object)((byte)(par1 & 0xF)));
    }

    public EntityToad spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        EntityToad entity = new EntityToad(this.worldObj);
        if (TameableUtil.hasOwner(this)) {
            entity.func_110163_bv();
            entity.setSkinColor(this.getSkinColor());
        }
        return entity;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityToad)) {
            return false;
        }
        EntityToad entity = (EntityToad)par1EntityAnimal;
        return !entity.isTamed() ? false : (entity.isSitting() ? false : this.isInLove() && entity.isInLove());
    }

    public boolean func_70922_bv() {
        return this.dataWatcher.getWatchableObjectByte(19) == 1;
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean func_142018_a(EntityLivingBase par1EntityLivingBase, EntityLivingBase par2EntityLivingBase) {
        if (!(par1EntityLivingBase instanceof EntityCreeper) && !(par1EntityLivingBase instanceof EntityGhast)) {
            EntityToad entity;
            if (par1EntityLivingBase instanceof EntityToad && (entity = (EntityToad)par1EntityLivingBase).isTamed() && entity.getOwner() == par2EntityLivingBase) {
                return false;
            }
            return par1EntityLivingBase instanceof EntityPlayer && par2EntityLivingBase instanceof EntityPlayer && !((EntityPlayer)par2EntityLivingBase).canAttackPlayer((EntityPlayer)par1EntityLivingBase) ? false : !(par1EntityLivingBase instanceof EntityHorse) || !((EntityHorse)par1EntityLivingBase).isTame();
        }
        return false;
    }

    public EntityAgeable createChild(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal(par1EntityAgeable);
    }

    @Override
    public void clearFamiliar() {
        this.setFamiliar(false);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(10.0);
        this.setHealth(10.0f);
    }
}

