/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityGoblin;
import com.emoniph.witchery.entity.EntityWitchHunter;
import com.emoniph.witchery.entity.ai.EntityAIDefendVillageGeneric;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class EntityVillageGuard
extends EntityCreature
implements IRangedAttackMob,
EntityAIDefendVillageGeneric.IVillageGuard,
IEntitySelector {
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f);
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false);
    private int homeCheckTimer;
    Village villageObj;

    public EntityVillageGuard(World world) {
        super(world);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setBreakDoors(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIDefendVillageGeneric(this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, (IEntitySelector)this));
        if (world != null && !world.isRemote) {
            this.setCombatTask();
        }
        this.experienceValue = 5;
    }

    public boolean canAttackClass(Class p_70686_1_) {
        return EntityCreeper.class != p_70686_1_ && this.getClass() != p_70686_1_;
    }

    public boolean isEntityApplicable(Entity entity) {
        EntityPlayer player;
        EntityLivingBase target;
        if (entity instanceof IMob && !(entity instanceof EntityWitchHunter) || entity instanceof EntityGoblin) {
            return true;
        }
        return this.villageObj != null && entity instanceof EntityPlayer && (target = (player = (EntityPlayer)entity).getAITarget()) instanceof EntityPlayer && this.villageObj.getReputationForPlayer(target.getCommandSenderName()) == 10;
    }

    public int getBlood() {
        return this.dataWatcher.getWatchableObjectInt(14);
    }

    public void setBlood(int blood) {
        this.dataWatcher.updateObject(14, (Object)MathHelper.clamp_int((int)blood, (int)0, (int)500));
    }

    public int takeBlood(int quantity, EntityLivingBase player) {
        PotionEffect effect = this.getActivePotionEffect(Witchery.Potions.PARALYSED);
        boolean transfixed = effect != null && effect.getAmplifier() >= 4;
        int blood = this.getBlood();
        quantity = (int)Math.ceil(0.66f * (float)quantity);
        int remainder = Math.max(blood - quantity, 0);
        int taken = blood - remainder;
        this.setBlood(remainder);
        if (blood < (int)Math.ceil(250.0)) {
            this.attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)player), 2.0f);
        } else if (!transfixed) {
            this.attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)player), 0.5f);
        }
        return taken;
    }

    public void giveBlood(int quantity) {
        int blood = this.getBlood();
        if (blood < 500) {
            this.setBlood(blood + quantity);
        }
    }

    @Override
    public Village getVillage() {
        return this.villageObj;
    }

    @Override
    public EntityCreature getCreature() {
        return this;
    }

    protected void updateAITick() {
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.rand.nextInt(50);
            this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ), 32);
            if (this.villageObj == null) {
                this.detachHome();
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.getCenter();
                this.setHomeArea(chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, (int)((float)this.villageObj.getVillageRadius() * 1.5f));
                if (this.getAttackTarget() == null) {
                    this.heal(1.0f);
                    if (this.worldObj.rand.nextInt(4) == 0) {
                        this.giveBlood(1);
                    }
                }
            }
        }
        super.updateAITick();
    }

    protected String getSwimSound() {
        return "game.hostile.swim";
    }

    protected String getSplashSound() {
        return "game.hostile.swim.splash";
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(13, (Object)new Byte(0));
        this.dataWatcher.addObject(14, (Object)new Integer(500));
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected String getLivingSound() {
        return "mob.villager.idle";
    }

    protected String getHurtSound() {
        return "mob.villager.hit";
    }

    protected String getDeathSound() {
        return "mob.villager.death";
    }

    protected float getSoundPitch() {
        return 0.8f;
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        float f = this.getBrightness(1.0f);
        if (f > 0.5f) {
            this.entityAge += 2;
        }
        super.onLivingUpdate();
    }

    public boolean attackEntityFrom(DamageSource damageSource, float damage) {
        if (damageSource.getEntity() != null && (damageSource.getEntity() instanceof EntityVillageGuard || damageSource.getEntity() instanceof EntityWitchHunter)) {
            return false;
        }
        return super.attackEntityFrom(damageSource, damage);
    }

    public boolean attackEntityAsMob(Entity p_70652_1_) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (p_70652_1_ instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)p_70652_1_));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)p_70652_1_));
        }
        if (flag = p_70652_1_.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                p_70652_1_.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                p_70652_1_.setFire(j * 4);
            }
            if (p_70652_1_ instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)p_70652_1_), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)p_70652_1_);
        }
        return flag;
    }

    protected void attackEntity(Entity p_70785_1_, float p_70785_2_) {
        if (this.attackTime <= 0 && p_70785_2_ < 2.0f && p_70785_1_.boundingBox.maxY > this.boundingBox.minY && p_70785_1_.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            this.attackEntityAsMob(p_70785_1_);
        }
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    public void updateRidden() {
        super.updateRidden();
        if (this.ridingEntity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.ridingEntity;
            this.renderYawOffset = entitycreature.renderYawOffset;
        }
    }

    protected String func_146067_o(int p_146067_1_) {
        return p_146067_1_ > 4 ? "game.hostile.hurt.fall.big" : "game.hostile.hurt.fall.small";
    }

    public void onDeath(DamageSource p_70645_1_) {
        if (this.attackingPlayer != null && this.villageObj != null) {
            this.villageObj.setReputationForPlayer(this.attackingPlayer.getCommandSenderName(), -5);
        }
        super.onDeath(p_70645_1_);
    }

    protected Item getDropItem() {
        return Items.arrow;
    }

    protected void dropRareDrop(int p_70600_1_) {
        this.entityDropItem(new ItemStack((Item)Items.leather_chestplate, 1), 0.0f);
    }

    protected void addRandomArmor() {
        this.setCurrentItemOrArmor(0, new ItemStack((Item)Items.bow));
        this.setCurrentItemOrArmor(1, new ItemStack((Item)Items.leather_boots));
        this.setCurrentItemOrArmor(2, new ItemStack((Item)Items.leather_leggings));
        this.setCurrentItemOrArmor(3, new ItemStack((Item)(this.worldObj.rand.nextInt(5) == 0 ? Items.iron_chestplate : Items.leather_chestplate)));
        this.setCurrentItemOrArmor(4, new ItemStack((Item)(this.worldObj.rand.nextInt(5) == 0 ? Items.iron_helmet : Items.leather_helmet)));
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.villageguard.name");
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.onSpawnWithEgg(p_110161_1_);
        this.addRandomArmor();
        return p_110161_1_;
    }

    public void setCombatTask() {
        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
        this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.getHeldItem();
        if (itemstack != null && itemstack.getItem() == Items.bow) {
            this.tasks.addTask(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.tasks.addTask(4, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float p_82196_2_) {
        PotionEffect effect = this.getActivePotionEffect(Witchery.Potions.PARALYSED);
        if (effect != null && effect.getAmplifier() >= 4) {
            return;
        }
        EntityArrow entityarrow = new EntityArrow(this.worldObj, (EntityLivingBase)this, target, 1.6f, (float)(16 - this.worldObj.difficultySetting.getDifficultyId() * 4));
        int i = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)this.getHeldItem());
        int j = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)this.getHeldItem());
        entityarrow.setDamage((double)(p_82196_2_ * 2.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)this.worldObj.difficultySetting.getDifficultyId() * 0.11f));
        if (i > 0) {
            entityarrow.setDamage(entityarrow.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.setKnockbackStrength(j);
        }
        if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)this.getHeldItem()) > 0 || this.getGuardType() == 1) {
            entityarrow.setFire(100);
        }
        this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.worldObj.spawnEntityInWorld((Entity)entityarrow);
    }

    public int getGuardType() {
        return this.dataWatcher.getWatchableObjectByte(13);
    }

    public void setGuardType(int p_82201_1_) {
        this.dataWatcher.updateObject(13, (Object)((byte)p_82201_1_));
        boolean bl = this.isImmuneToFire = p_82201_1_ == 1;
        if (p_82201_1_ == 1) {
            this.setSize(0.72f, 2.34f);
        } else {
            this.setSize(0.6f, 1.8f);
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("GuardType", 99)) {
            byte b0 = nbtRoot.getByte("GuardType");
            this.setGuardType(b0);
        }
        this.setCombatTask();
        if (nbtRoot.hasKey("BloodLevel")) {
            this.setBlood(nbtRoot.getInteger("BloodLevel"));
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setByte("GuardType", (byte)this.getGuardType());
        nbtRoot.setInteger("BloodLevel", this.getBlood());
    }

    public void setCurrentItemOrArmor(int p_70062_1_, ItemStack p_70062_2_) {
        super.setCurrentItemOrArmor(p_70062_1_, p_70062_2_);
        if (!this.worldObj.isRemote && p_70062_1_ == 0) {
            this.setCombatTask();
        }
    }

    public double getYOffset() {
        return super.getYOffset() - 0.5;
    }

    public static void createFrom(EntityVillager villager) {
        World world = villager.worldObj;
        EntityVillageGuard entity = new EntityVillageGuard(world);
        entity.func_110163_bv();
        entity.copyLocationAndAnglesFrom((Entity)villager);
        entity.onSpawnWithEgg(null);
        world.removeEntity((Entity)villager);
        world.spawnEntityInWorld((Entity)entity);
        ParticleEffect.INSTANT_SPELL.send(SoundEffect.NONE, (Entity)entity, entity.width, entity.height, 16);
    }
}

