/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.blocks.BlockCircleGlyph;
import com.emoniph.witchery.brewing.potions.PotionEnslaved;
import com.emoniph.witchery.entity.EntityDemon;
import com.emoniph.witchery.entity.EntityEnt;
import com.emoniph.witchery.entity.EntityHornedHuntsman;
import com.emoniph.witchery.entity.EntityOwl;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.network.PacketPushTarget;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.EarthItems;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityWitchProjectile
extends EntityThrowable {
    private int damageValue;
    private boolean skipFX = false;
    private static final String DAMAGE_VALUE_KEY = "damageValue";

    public EntityWitchProjectile(World world) {
        super(world);
    }

    public EntityWitchProjectile(World world, EntityLivingBase entityLiving, ItemGeneral.SubItem generalSubItem) {
        super(world, entityLiving);
        this.setDamageValue(generalSubItem.damageValue);
    }

    public EntityWitchProjectile(World world, double posX, double posY, double posZ, ItemGeneral.SubItem generalSubItem) {
        super(world, posX, posY, posZ);
        this.setDamageValue(generalSubItem.damageValue);
    }

    protected void entityInit() {
        this.dataWatcher.addObject(6, (Object)0);
        super.entityInit();
    }

    public void setDamageValue(int damageValue) {
        this.damageValue = damageValue;
        this.getDataWatcher().updateObject(6, (Object)damageValue);
    }

    public int getDamageValue() {
        return this.getDataWatcher().getWatchableObjectInt(6);
    }

    public boolean isPotion() {
        return Witchery.Items.GENERIC.subItems.get(this.damageValue) instanceof ItemGeneral.Brew || Witchery.Items.GENERIC.itemQuicklime.damageValue == this.damageValue;
    }

    protected float getGravityVelocity() {
        if (this.isPotion()) {
            return 0.05f;
        }
        return super.getGravityVelocity();
    }

    protected float func_70182_d() {
        if (this.isPotion()) {
            return 0.5f;
        }
        return super.func_70182_d();
    }

    protected float func_70183_g() {
        if (this.isPotion()) {
            return -20.0f;
        }
        return super.func_70183_g();
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote && mop != null) {
            boolean enhanced = false;
            EntityLivingBase thrower = this.getThrower();
            if (thrower != null && thrower instanceof EntityPlayer) {
                enhanced = Familiar.hasActiveBrewMasteryFamiliar((EntityPlayer)thrower);
            }
            this.skipFX = false;
            if (Witchery.Items.GENERIC.itemBrewOfVines.damageValue == this.damageValue) {
                this.impactVines(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfThorns.damageValue == this.damageValue) {
                this.impactThorns(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfWebs.damageValue == this.damageValue) {
                this.impactWebBig(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfInk.damageValue == this.damageValue) {
                this.impactInk(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfWasting.damageValue == this.damageValue) {
                this.impactWasting(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfSprouting.damageValue == this.damageValue) {
                this.impactSprout(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfErosion.damageValue == this.damageValue) {
                this.impactErosion(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfLove.damageValue == this.damageValue) {
                this.impactLove(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemWeb.damageValue == this.damageValue) {
                this.impactWebSmall(mop);
                this.skipFX = true;
            } else if (Witchery.Items.GENERIC.itemRock.damageValue == this.damageValue) {
                this.impactRock(mop);
                this.skipFX = true;
            } else if (Witchery.Items.GENERIC.itemBrewOfRaising.damageValue == this.damageValue) {
                this.impactRaising(mop);
            } else if (Witchery.Items.GENERIC.itemQuicklime.damageValue == this.damageValue) {
                this.impactQuicklime(mop);
            } else if (Witchery.Items.GENERIC.itemBrewOfIce.damageValue == this.damageValue) {
                this.impactIce(mop);
            } else if (Witchery.Items.GENERIC.itemBrewOfFrogsTongue.damageValue == this.damageValue) {
                this.impactFrogsTongue(mop, false);
            } else if (Witchery.Items.GENERIC.itemBrewOfCursedLeaping.damageValue == this.damageValue) {
                this.impactLeaping(mop, false);
            } else if (Witchery.Items.GENERIC.itemBrewOfHitchcock.damageValue == this.damageValue) {
                this.impactHitchcock(mop);
            } else if (Witchery.Items.GENERIC.itemBrewOfInfection.damageValue == this.damageValue) {
                this.impactInfection(mop, enhanced);
            } else if (Witchery.Items.GENERIC.itemBrewOfBats.damageValue == this.damageValue) {
                this.impactBats(mop, enhanced);
            } else {
                ItemGeneral.SubItem item = Witchery.Items.GENERIC.subItems.get(this.damageValue);
                if (item instanceof ItemGeneral.Brew) {
                    ItemGeneral.Brew brew = (ItemGeneral.Brew)item;
                    ItemGeneral.Brew.BrewResult result = brew.onImpact(this.worldObj, thrower, mop, enhanced, this.posX, this.posY, this.posZ, this.boundingBox);
                    if (result == ItemGeneral.Brew.BrewResult.DROP_ITEM) {
                        EntityItem itemEntity = null;
                        if (mop != null) {
                            ItemStack newBrewStack = brew.createStack();
                            switch (mop.typeOfHit) {
                                case BLOCK: {
                                    itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                                    break;
                                }
                                case ENTITY: {
                                    itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                                    break;
                                }
                            }
                        }
                        this.skipFX = true;
                        if (itemEntity != null) {
                            this.worldObj.spawnEntityInWorld(itemEntity);
                        }
                    } else {
                        boolean bl = this.skipFX = result == ItemGeneral.Brew.BrewResult.HIDE_EFFECT;
                    }
                }
            }
            if (!this.skipFX) {
                this.worldObj.playAuxSFX(2002, (int)Math.round(this.posX), (int)Math.round(this.posY), (int)Math.round(this.posZ), 2);
            }
        }
        this.setDead();
    }

    private void impactBats(MovingObjectPosition mop, boolean enhanced) {
        switch (mop.typeOfHit) {
            case BLOCK: {
                this.explodeBats(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, mop.sideHit, enhanced);
                break;
            }
            case ENTITY: {
                int x = MathHelper.floor_double((double)mop.entityHit.posX);
                int y = MathHelper.floor_double((double)mop.entityHit.posY);
                int z = MathHelper.floor_double((double)mop.entityHit.posZ);
                this.explodeBats(this.worldObj, x, y, z, -1, enhanced);
                break;
            }
        }
        double RADIUS = enhanced ? 4.0 : 3.0;
        AxisAlignedBB axisalignedbb = this.boundingBox.expand(RADIUS, 2.0, RADIUS);
        List list1 = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        if (list1 != null && !list1.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list1) {
                double d0 = entitylivingbase.getDistanceSq(this.posX, this.posY, this.posZ);
                if (!(d0 < RADIUS * RADIUS)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / RADIUS;
                if (entitylivingbase == mop.entityHit) {
                    d1 = 1.0;
                }
                int j = (int)(d1 * 100.0 + 0.5);
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, j, 5));
                if (!(entitylivingbase instanceof EntityLiving)) continue;
                EntityUtil.dropAttackTarget((EntityLiving)entitylivingbase);
            }
        }
    }

    private void explodeBats(World world, int posX, int posY, int posZ, int side, boolean enhanced) {
        int x = posX + (side == 4 ? -1 : (side == 5 ? 1 : 0));
        int z = posZ + (side == 2 ? -1 : (side == 3 ? 1 : 0));
        int y = posY + (side == 0 ? -1 : (side == 1 ? 1 : 0));
        if (side == 1 && !world.getBlock(x, posY, z).getMaterial().isSolid()) {
            --y;
        }
        int NUM_BATS = enhanced ? 14 : 10;
        for (int i = 0; i < NUM_BATS; ++i) {
            EntityBat bat = new EntityBat(world);
            NBTTagCompound nbtBat = bat.getEntityData();
            nbtBat.setBoolean("WITCNoDrops", true);
            bat.setLocationAndAngles((double)x, (double)y, (double)z, 0.0f, 0.0f);
            this.worldObj.spawnEntityInWorld((Entity)bat);
        }
        ParticleEffect.LARGE_EXPLODE.send(SoundEffect.MOB_ENDERMEN_PORTAL, world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 3.0, 3.0, 16);
    }

    private void impactInfection(MovingObjectPosition mop, boolean enhanced) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block blockID = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            int blockMeta = this.worldObj.getBlockMetadata(mop.blockX, mop.blockY, mop.blockZ);
            if ((blockID == Blocks.stone || blockID == Blocks.cobblestone || blockID == Blocks.stonebrick && blockMeta == 0) && BlockProtect.canBreak(mop.blockX, mop.blockZ, mop.blockY, this.worldObj)) {
                if (blockID == Blocks.stone) {
                    this.worldObj.setBlock(mop.blockX, mop.blockY, mop.blockZ, Blocks.monster_egg, 0, 3);
                } else if (blockID == Blocks.cobblestone) {
                    this.worldObj.setBlock(mop.blockX, mop.blockY, mop.blockZ, Blocks.monster_egg, 1, 3);
                } else if (blockID == Blocks.stonebrick) {
                    this.worldObj.setBlock(mop.blockX, mop.blockY, mop.blockZ, Blocks.monster_egg, 2, 3);
                }
                return;
            }
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)mop.entityHit;
            if (entity instanceof EntityVillager) {
                EntityZombie entityzombie = new EntityZombie(this.worldObj);
                entityzombie.copyLocationAndAnglesFrom((Entity)entity);
                this.worldObj.removeEntity((Entity)entity);
                entityzombie.onSpawnWithEgg((IEntityLivingData)null);
                entityzombie.setVillager(true);
                if (entity.isChild()) {
                    entityzombie.setChild(true);
                }
                this.worldObj.spawnEntityInWorld((Entity)entityzombie);
                this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1016, (int)entityzombie.posX, (int)entityzombie.posY, (int)entityzombie.posZ, 0);
            } else {
                float WORM_DAMAGE = enhanced ? 4.0f : 1.0f;
                entity.attackEntityFrom(DamageSource.causeThrownDamage((Entity)entity, (Entity)this.getThrower()), WORM_DAMAGE);
                entity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 100, 8));
            }
            return;
        }
        EntityItem itemEntity = null;
        if (mop != null) {
            ItemStack newBrewStack = Witchery.Items.GENERIC.itemBrewOfInfection.createStack();
            switch (mop.typeOfHit) {
                case BLOCK: {
                    itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                    break;
                }
                case ENTITY: {
                    itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                    break;
                }
            }
        }
        this.skipFX = true;
        if (itemEntity != null) {
            this.worldObj.spawnEntityInWorld(itemEntity);
        }
    }

    private void impactHitchcock(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit instanceof EntityLivingBase) {
            EntityLivingBase victim = (EntityLivingBase)mop.entityHit;
            int BIRDS = this.worldObj.rand.nextInt(2) + 3;
            for (int i = 0; i < BIRDS; ++i) {
                EntityOwl owl = new EntityOwl(this.worldObj);
                owl.setLocationAndAngles(victim.posX - 2.0 + (double)this.worldObj.rand.nextInt(5), victim.posY + (double)victim.height + 1.0 + (double)this.worldObj.rand.nextInt(2), victim.posZ - 2.0 + (double)this.worldObj.rand.nextInt(5), 0.0f, 0.0f);
                owl.setAttackTarget(victim);
                owl.setTimeToLive(400);
                this.worldObj.spawnEntityInWorld((Entity)owl);
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)owl, 1.0, 1.0, 16);
            }
        } else {
            EntityItem itemEntity = null;
            if (mop != null) {
                ItemStack newBrewStack = Witchery.Items.GENERIC.itemBrewOfHitchcock.createStack();
                switch (mop.typeOfHit) {
                    case BLOCK: {
                        itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                        break;
                    }
                    case ENTITY: {
                        itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                        break;
                    }
                }
            }
            this.skipFX = true;
            if (itemEntity != null) {
                this.worldObj.spawnEntityInWorld(itemEntity);
            }
        }
    }

    private void impactLeaping(MovingObjectPosition mop, boolean enhanced) {
        Entity livingEntity = mop.entityHit;
        double RADIUS = enhanced ? 6.0 : 5.0;
        AxisAlignedBB axisalignedbb = this.boundingBox.expand(RADIUS, 2.0, RADIUS);
        List list1 = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        if (list1 != null && !list1.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list1) {
                double d0 = entitylivingbase.getDistanceSq(this.posX, this.posY, this.posZ);
                if (!(d0 < RADIUS * RADIUS)) continue;
                double d1 = 1.0 - 0.5 * (Math.sqrt(d0) / RADIUS / 2.0);
                if (entitylivingbase == livingEntity) {
                    d1 = 1.0;
                }
                int j = (int)(d1 * 400.0 + 0.5);
                double LEAP = d1 * 1.6;
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.jump.id, 200, 3));
                if (entitylivingbase instanceof EntityPlayer) {
                    Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(entitylivingbase.motionX, entitylivingbase.motionY + LEAP, entitylivingbase.motionZ), (EntityPlayer)entitylivingbase);
                    continue;
                }
                entitylivingbase.motionY += LEAP;
            }
        }
    }

    private void impactFrogsTongue(MovingObjectPosition mop, boolean enhanced) {
        if (!this.worldObj.isRemote && this.getThrower() != null) {
            double RADIUS = enhanced ? 5.0 : 4.0;
            double RADIUS_SQ = RADIUS * RADIUS;
            EntityLivingBase thrower = this.getThrower();
            boolean pulled = false;
            AxisAlignedBB axisalignedbb = this.boundingBox.expand(RADIUS, 2.0, RADIUS);
            List entityLivingList = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
            if (entityLivingList != null && !entityLivingList.isEmpty()) {
                for (EntityLivingBase livingEntity : entityLivingList) {
                    double distanceSq = livingEntity.getDistanceSq(this.posX, this.posY, this.posZ);
                    if (!(distanceSq < RADIUS_SQ) || livingEntity == this.getThrower()) continue;
                    this.pull(this.worldObj, (Entity)livingEntity, thrower.posX, thrower.posY, thrower.posZ, 0.05, 0.0);
                }
            }
        }
    }

    private void pull(World world, Entity entity, double posX, double posY, double posZ, double dy, double yy) {
        if (entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman) {
            return;
        }
        double d = posX - entity.posX;
        double d1 = posY - entity.posY;
        double d2 = posZ - entity.posZ;
        float distance = MathHelper.sqrt_double((double)(d * d + d1 * d1 + d2 * d2));
        float f2 = 0.1f + (float)dy;
        double mx = d / (double)distance * (double)f2 * (double)distance;
        double my = yy == 0.0 ? 0.4 : d1 / (double)distance * (double)distance * 0.2 + 0.2 + yy;
        double mz = d2 / (double)distance * (double)f2 * (double)distance;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Potion.jump.id, 20, 1));
        }
        if (entity instanceof EntityPlayer) {
            Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(mx, my, mz), (EntityPlayer)entity);
        } else {
            entity.motionX = mx;
            entity.motionY = my;
            entity.motionZ = mz;
        }
    }

    private void impactIce(MovingObjectPosition mop) {
        switch (mop.typeOfHit) {
            case BLOCK: {
                int FREEZE_RANGE = 3;
                if (this.worldObj.getBlock(mop.blockX + 1, mop.blockY, mop.blockZ).getMaterial() == Material.water || this.worldObj.getBlock(mop.blockX - 1, mop.blockY, mop.blockZ).getMaterial() == Material.water || this.worldObj.getBlock(mop.blockX, mop.blockY + 1, mop.blockZ).getMaterial() == Material.water || this.worldObj.getBlock(mop.blockX, mop.blockY - 1, mop.blockZ).getMaterial() == Material.water || this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ + 1).getMaterial() == Material.water || this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ - 1).getMaterial() == Material.water) {
                    this.freezeSurroundingWater(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, mop.blockX, mop.blockY, mop.blockZ, 3);
                    return;
                }
                int SHIELD_HEIGHT = 3;
                if (mop.sideHit == 1) {
                    EntityWitchProjectile.explodeIceShield(this.worldObj, this.getThrower(), mop.blockX, mop.blockY, mop.blockZ, 3);
                    return;
                }
                if (mop.sideHit != 0) {
                    int dy;
                    int dx;
                    int b0 = 0;
                    switch (mop.sideHit) {
                        case 0: 
                        case 1: {
                            b0 = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            b0 = 8;
                            break;
                        }
                        case 4: 
                        case 5: {
                            b0 = 4;
                        }
                    }
                    int n = mop.sideHit == 5 ? 1 : (dx = mop.sideHit == 4 ? -1 : 0);
                    int n2 = mop.sideHit == 0 ? -1 : (dy = mop.sideHit == 1 ? 1 : 0);
                    int dz = mop.sideHit == 3 ? 1 : (mop.sideHit == 2 ? -1 : 0);
                    EntityWitchProjectile.explodeIceShield(this.worldObj, this.getThrower(), mop.blockX + dx, mop.blockY + dy, mop.blockZ + dz, 3);
                    return;
                }
                EntityItem itemEntity = null;
                if (mop != null) {
                    ItemStack newBrewStack = Witchery.Items.GENERIC.itemBrewOfIce.createStack();
                    switch (mop.typeOfHit) {
                        case BLOCK: {
                            itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                            break;
                        }
                        case ENTITY: {
                            itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                            break;
                        }
                    }
                }
                this.skipFX = true;
                if (itemEntity == null) break;
                this.worldObj.spawnEntityInWorld(itemEntity);
                break;
            }
            case ENTITY: {
                int x = (int)Math.round(mop.entityHit.posX);
                int y = MathHelper.floor_double((double)mop.entityHit.posY);
                int z = (int)Math.round(mop.entityHit.posZ);
                EntityWitchProjectile.explodeIceBlock(this.worldObj, x, y, z, -1, mop.entityHit);
                break;
            }
        }
    }

    private void freezeSurroundingWater(World world, int x, int y, int z, int x0, int y0, int z0, int range) {
        if (Math.abs(x0 - x) >= range || Math.abs(y0 - y) >= range || Math.abs(z0 - z) >= range) {
            return;
        }
        if (this.freezeWater(world, x + 1, y, z)) {
            this.freezeSurroundingWater(world, x + 1, y, z, x0, y0, z0, range);
        }
        if (this.freezeWater(world, x - 1, y, z)) {
            this.freezeSurroundingWater(world, x - 1, y, z, x0, y0, z0, range);
        }
        if (this.freezeWater(world, x, y, z + 1)) {
            this.freezeSurroundingWater(world, x, y, z + 1, x0, y0, z0, range);
        }
        if (this.freezeWater(world, x, y, z - 1)) {
            this.freezeSurroundingWater(world, x, y, z - 1, x0, y0, z0, range);
        }
        if (this.freezeWater(world, x, y + 1, z)) {
            this.freezeSurroundingWater(world, x, y + 1, z, x0, y0, z0, range);
        }
        if (this.freezeWater(world, x, y - 1, z)) {
            this.freezeSurroundingWater(world, x, y - 1, z, x0, y0, z0, range);
        }
    }

    private boolean freezeWater(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z).getMaterial() == Material.water) {
            world.setBlock(x, y, z, Blocks.ice);
            return true;
        }
        return false;
    }

    public static void explodeIceBlock(World world, int posX, int posY, int posZ, int side, Entity entity) {
        boolean resistent;
        int x = posX + (side == 4 ? -1 : (side == 5 ? 1 : 0));
        int z = posZ + (side == 2 ? -1 : (side == 3 ? 1 : 0));
        int y = posY + (side == 0 ? -1 : (side == 1 ? 1 : 0)) - 1;
        if (side == 1 && !world.getBlock(x, posY, z).getMaterial().isSolid()) {
            --y;
        }
        Block block = Blocks.ice;
        boolean bl = resistent = entity instanceof EntityDemon || entity instanceof EntityBlaze || entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman || entity instanceof EntityEnt || entity instanceof EntityWither || entity instanceof EntityIronGolem;
        if (resistent) {
            EntityWitchProjectile.setBlockIfNotSolid(world, x, y + 1, z, (Block)Blocks.flowing_water);
        } else {
            int HEIGHT = resistent ? 2 : 4;
            for (int i = 0; i < HEIGHT; ++i) {
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 2, y + i, z - 1, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 2, y + i, z, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 1, y + i, z + 1, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x, y + i, z + 1, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x + 1, y + i, z, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x + 1, y + i, z - 1, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x, y + i, z - 2, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 1, y + i, z - 2, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 2, y + i, z - 2, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 2, y + i, z + 1, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x + 1, y + i, z + 1, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x + 1, y + i, z - 2, block);
            }
            EntityWitchProjectile.setBlockIfNotSolid(world, x, y, z, block);
            if (!resistent) {
                EntityWitchProjectile.setBlockIfNotSolid(world, x, y + HEIGHT - 1, z, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 1, y + HEIGHT - 1, z - 1, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x - 1, y + HEIGHT - 1, z, block);
                EntityWitchProjectile.setBlockIfNotSolid(world, x, y + HEIGHT - 1, z - 1, block);
            }
            if (entity instanceof EntityCreeper) {
                EntityCreeper creeper = (EntityCreeper)entity;
                boolean flag = world.getGameRules().getGameRuleBooleanValue("mobGriefing");
                if (creeper.getPowered()) {
                    world.createExplosion((Entity)creeper, creeper.posX, creeper.posY, creeper.posZ, 6.0f, flag);
                } else {
                    world.createExplosion((Entity)creeper, creeper.posX, creeper.posY, creeper.posZ, 3.0f, flag);
                }
                creeper.setDead();
            }
        }
    }

    public static void explodeIceShield(World world, EntityLivingBase player, int posX, int posY, int posZ, int height) {
        double f1 = player != null ? (double)MathHelper.cos((float)(-player.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI)) : 0.0;
        double f2 = player != null ? (double)MathHelper.sin((float)(-player.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI)) : 0.0;
        Vec3 loc = Vec3.createVectorHelper((double)f2, (double)0.0, (double)f1);
        if (!world.getBlock(posX, posY, posZ).getMaterial().isSolid()) {
            --posY;
        }
        EntityWitchProjectile.explodeIceColumn(world, posX, posY + 1, posZ, height);
        loc.rotateAroundY((float)Math.toRadians(90.0));
        int newX = MathHelper.floor_double((double)((double)posX + 0.5 + loc.xCoord * 1.0));
        int newZ = MathHelper.floor_double((double)((double)posZ + 0.5 + loc.zCoord * 1.0));
        EntityWitchProjectile.explodeIceColumn(world, newX, posY + 1, newZ, height);
        loc.rotateAroundY((float)Math.toRadians(180.0));
        newX = MathHelper.floor_double((double)((double)posX + 0.5 + loc.xCoord * 1.0));
        newZ = MathHelper.floor_double((double)((double)posZ + 0.5 + loc.zCoord * 1.0));
        EntityWitchProjectile.explodeIceColumn(world, newX, posY + 1, newZ, height);
    }

    public static void explodeIceColumn(World world, int posX, int posY, int posZ, int height) {
        for (int offsetPosY = posY; offsetPosY < posY + height; ++offsetPosY) {
            EntityWitchProjectile.setBlockIfNotSolid(world, posX, offsetPosY, posZ, Blocks.ice);
        }
    }

    private void impactLove(MovingObjectPosition mop, boolean enhanced) {
        double RADIUS = enhanced ? 5.0 : 4.0;
        AxisAlignedBB axisalignedbb = this.boundingBox.expand(RADIUS, 2.0, RADIUS);
        List list1 = this.worldObj.getEntitiesWithinAABB(EntityLiving.class, axisalignedbb);
        if (list1 != null && !list1.isEmpty() && !this.worldObj.isRemote) {
            EntityVillager mate;
            EntityLivingBase entityThrower = this.getThrower();
            EntityPlayer thrower = entityThrower != null && entityThrower instanceof EntityPlayer ? (EntityPlayer)entityThrower : null;
            Iterator iterator = list1.iterator();
            ArrayList<EntityVillager> villagers = new ArrayList<EntityVillager>();
            ArrayList<EntityZombie> zombies = new ArrayList<EntityZombie>();
            while (iterator.hasNext()) {
                EntityZombie zombie;
                EntityLiving entitylivingbase = (EntityLiving)iterator.next();
                double d0 = entitylivingbase.getDistanceSq(this.posX, this.posY, this.posZ);
                if (!(d0 < RADIUS * RADIUS)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / RADIUS;
                if (entitylivingbase == mop.entityHit) {
                    d1 = 1.0;
                }
                int j = (int)(d1 * 400.0 + 0.5);
                if (entitylivingbase instanceof EntityAnimal) {
                    EntityAnimal animal = (EntityAnimal)entitylivingbase;
                    if (animal.getGrowingAge() < 0) continue;
                    animal.setGrowingAge(0);
                    animal.func_146082_f(null);
                    continue;
                }
                if (entitylivingbase instanceof EntityVillager) {
                    EntityVillager villager = (EntityVillager)entitylivingbase;
                    if (villager.getGrowingAge() < 0) continue;
                    villagers.add(villager);
                    continue;
                }
                if (!(entitylivingbase instanceof EntityZombie) || (zombie = (EntityZombie)entitylivingbase).isChild() || thrower == null) continue;
                NBTTagCompound nbt = zombie.getEntityData();
                if (!PotionEnslaved.isMobEnslavedBy((EntityLiving)zombie, thrower)) continue;
                zombies.add(zombie);
            }
            int limit = 10;
            while (villagers.size() > 1 && limit-- > 0) {
                EntityVillager villager = (EntityVillager)villagers.get(0);
                mate = (EntityVillager)villagers.get(1);
                villager.setPosition(mate.posX, mate.posY, mate.posZ);
                ParticleEffect.HEART.send(SoundEffect.NONE, (Entity)mate, 1.0, 2.0, 8);
                this.giveBirth(villager, mate);
                villagers.remove(0);
                villagers.remove(0);
            }
            limit = 10;
            while (zombies.size() > 1 && limit-- > 0) {
                EntityZombie zombie = (EntityZombie)zombies.get(0);
                mate = (EntityZombie)zombies.get(1);
                zombie.setPosition(mate.posX, mate.posY, mate.posZ);
                ParticleEffect.HEART.send(SoundEffect.NONE, (Entity)mate, 1.0, 2.0, 8);
                zombie.setVillager(true);
                mate.setVillager(true);
                EntityZombie baby = new EntityZombie(this.worldObj);
                baby.setLocationAndAngles(mate.posX, mate.posY, mate.posZ, 0.0f, 0.0f);
                baby.setChild(true);
                this.worldObj.spawnEntityInWorld((Entity)baby);
                zombies.remove(0);
                zombies.remove(0);
            }
        }
    }

    private void giveBirth(EntityVillager villagerObj, EntityVillager mate) {
        EntityVillager entityvillager = villagerObj.createChild((EntityAgeable)mate);
        mate.setGrowingAge(6000);
        villagerObj.setGrowingAge(6000);
        entityvillager.setGrowingAge(-24000);
        entityvillager.setLocationAndAngles(villagerObj.posX, villagerObj.posY, villagerObj.posZ, 0.0f, 0.0f);
        this.worldObj.spawnEntityInWorld((Entity)entityvillager);
        this.worldObj.setEntityState((Entity)entityvillager, (byte)12);
    }

    private void impactQuicklime(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (mop.entityHit instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)mop.entityHit;
                if (!livingEntity.isPotionActive(Potion.blindness)) {
                    livingEntity.addPotionEffect(new PotionEffect(Potion.blindness.id, 60, 0));
                }
                float DAMAGE = mop.entityHit instanceof EntitySlime ? 4.0f : (livingEntity.getHealth() == livingEntity.getMaxHealth() ? 0.5f : 0.1f);
                livingEntity.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this.getThrower()), DAMAGE);
            }
            this.skipFX = true;
            return;
        }
        EntityItem itemEntity = null;
        if (mop != null) {
            ItemStack newBrewStack = Witchery.Items.GENERIC.itemQuicklime.createStack();
            switch (mop.typeOfHit) {
                case BLOCK: {
                    itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                    break;
                }
                case ENTITY: {
                    itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                    break;
                }
            }
        }
        this.skipFX = true;
        if (itemEntity != null) {
            this.worldObj.spawnEntityInWorld(itemEntity);
        }
    }

    private void impactRaising(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && mop.sideHit == 1) {
            int posX = mop.blockX;
            int posY = mop.blockY;
            int posZ = mop.blockZ;
            World world = this.worldObj;
            EntityWitchProjectile.raiseDead(posX, posY, posZ, world, this.getThrower());
            return;
        }
        EntityItem itemEntity = null;
        if (mop != null) {
            ItemStack newBrewStack = Witchery.Items.GENERIC.itemBrewOfRaising.createStack();
            switch (mop.typeOfHit) {
                case BLOCK: {
                    itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                    break;
                }
                case ENTITY: {
                    itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                    break;
                }
            }
        }
        this.skipFX = true;
        if (itemEntity != null) {
            this.worldObj.spawnEntityInWorld(itemEntity);
        }
    }

    public static void raiseDead(int posX, int posY, int posZ, World world, EntityLivingBase raiser) {
        int y0 = world.getBlock(posX, posY, posZ).getMaterial().isSolid() ? posY : posY - 1;
        int MAX_SPAWNS = 3;
        int MAX_DISTANCE = 3;
        int MAX_DROP = 6;
        EntityPlayer playerThrower = (EntityPlayer)(raiser instanceof EntityPlayer ? raiser : null);
        EntityWitchProjectile.raiseUndead(world, posX, y0, posZ, playerThrower);
        int extraCount = 0;
        double chance = world.rand.nextDouble();
        if (chance < 0.1) {
            extraCount = 2;
        } else if (chance < 0.4) {
            extraCount = 1;
        }
        for (int i = 0; i < extraCount; ++i) {
            int x = posX - 3 + world.rand.nextInt(6) + 1;
            int z = posZ - 3 + world.rand.nextInt(6) + 1;
            int y = -1;
            for (int dy = -6; dy < 6; ++dy) {
                if (!world.getBlock(x, y0 - dy, z).getMaterial().isSolid()) continue;
                y = y0 - dy;
                break;
            }
            if (y == -1) continue;
            EntityWitchProjectile.raiseUndead(world, x, y, z, playerThrower);
        }
    }

    private static void raiseUndead(World world, int posX, int posY, int posZ, EntityPlayer thrower) {
        if (!world.isRemote) {
            Block blockID = world.getBlock(posX, posY, posZ);
            if (blockID != Blocks.dirt && blockID != Blocks.stone && blockID != Blocks.grass && blockID != Blocks.netherrack && blockID != Blocks.mycelium && blockID != Blocks.soul_sand && blockID != Blocks.cobblestone && blockID != Blocks.gravel && blockID != Blocks.sand) {
                ++posY;
            }
            EntityWitchProjectile.spawnParticles(world, ParticleEffect.SMOKE, 0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ);
            world.setBlockToAir(posX, posY, posZ);
            world.setBlockToAir(posX, posY + 1, posZ);
            EntityLiving undeadEntity = EntityWitchProjectile.createUndeadCreature(world);
            undeadEntity.setLocationAndAngles(0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ, 1.0f, 0.0f);
            IEntityLivingData entitylivingData = null;
            entitylivingData = undeadEntity.onSpawnWithEgg(entitylivingData);
            undeadEntity.func_110163_bv();
            if (thrower != null) {
                try {
                    PotionEnslaved.setEnslaverForMob(undeadEntity, thrower);
                }
                catch (Exception e) {
                    Log.instance().warning(e, "Unhandled exception occurred setting enslaver from raiseUnded potion.");
                }
            }
            world.spawnEntityInWorld((Entity)undeadEntity);
        }
    }

    private static EntityLiving createUndeadCreature(World world) {
        double value = world.rand.nextDouble();
        if (value < 0.6) {
            return new EntityZombie(world);
        }
        if (value < 0.97) {
            return new EntitySkeleton(world);
        }
        return new EntityPigZombie(world);
    }

    private void impactErosion(MovingObjectPosition mop, boolean enhanced) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (BlockProtect.checkModsForBreakOK(this.worldObj, mop.blockX, mop.blockZ, mop.blockY, this.getThrower())) {
                int RADIUS = 2;
                int obsidianMetled = 0;
                obsidianMetled += this.drawFilledCircle(this.worldObj, mop.blockX, mop.blockZ, mop.blockY, 2);
                for (int i = 0; i < 2; ++i) {
                    int dy = i + 1;
                    obsidianMetled += this.drawFilledCircle(this.worldObj, mop.blockX, mop.blockZ, mop.blockY + dy, 2 - dy);
                    obsidianMetled += this.drawFilledCircle(this.worldObj, mop.blockX, mop.blockZ, mop.blockY - dy, 2 - dy);
                }
                if (obsidianMetled > 0) {
                    this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, 0.5 + (double)mop.blockX, 0.5 + (double)mop.blockY, 0.5 + (double)mop.blockZ, new ItemStack(Blocks.obsidian, obsidianMetled, 0)));
                }
            }
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (mop.entityHit instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)mop.entityHit;
                float ACID_DAMAGE = enhanced ? 10.0f : 8.0f;
                entity.attackEntityFrom(DamageSource.causeThrownDamage((Entity)entity, (Entity)this.getThrower()), ACID_DAMAGE);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (this.causeAcidDamage(entity.getHeldItem())) {
                        player.destroyCurrentEquippedItem();
                    }
                    for (int slot = 0; slot < player.inventory.armorInventory.length; ++slot) {
                        if (!this.causeAcidDamage(player.inventory.armorInventory[slot])) continue;
                        player.inventory.armorInventory[slot] = null;
                    }
                } else {
                    for (int slot = 0; slot < 5; ++slot) {
                        if (!this.causeAcidDamage(entity.getEquipmentInSlot(slot))) continue;
                        entity.setCurrentItemOrArmor(slot, null);
                    }
                }
            } else {
                this.skipFX = true;
                this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, Witchery.Items.GENERIC.itemBrewOfErosion.createStack()));
            }
        }
    }

    private boolean causeAcidDamage(ItemStack itemstack) {
        int ITEM_ACID_DAMAGE = 100;
        if (itemstack != null && itemstack.isItemStackDamageable() && EarthItems.instance().isMatch(itemstack)) {
            itemstack.damageItem(100, this.getThrower());
            return itemstack.getItemDamage() <= 0;
        }
        return false;
    }

    protected int drawFilledCircle(World world, int x0, int z0, int y, int radius) {
        int x = radius;
        int radiusError = 1 - x;
        int obsidianMelted = 0;
        for (int z = 0; x >= z; ++z) {
            obsidianMelted += this.drawLine(world, -x + x0, x + x0, z + z0, y);
            obsidianMelted += this.drawLine(world, -z + x0, z + x0, x + z0, y);
            obsidianMelted += this.drawLine(world, -x + x0, x + x0, -z + z0, y);
            obsidianMelted += this.drawLine(world, -z + x0, z + x0, -x + z0, y);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
        return obsidianMelted;
    }

    protected int drawLine(World world, int x1, int x2, int z, int y) {
        int obsidianMelted = 0;
        for (int x = x1; x <= x2; ++x) {
            Block blockID = world.getBlock(x, y, z);
            if (blockID == Blocks.obsidian) {
                ++obsidianMelted;
            }
            if (blockID == Blocks.air || blockID == Blocks.lava || blockID == Blocks.flowing_lava || blockID == Blocks.fire || blockID == Blocks.flowing_water || blockID == Blocks.water || !BlockProtect.canBreak(blockID, world)) continue;
            world.setBlockToAir(x, y, z);
            EntityWitchProjectile.spawnParticles(this.worldObj, ParticleEffect.SPLASH, this.posX, this.posY, this.posZ);
        }
        return obsidianMelted;
    }

    private void impactSprout(MovingObjectPosition mop, boolean enhanced) {
        if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int posX = mop.blockX;
            int posY = mop.blockY;
            int posZ = mop.blockZ;
            World world = this.worldObj;
            int sideHit = mop.sideHit;
            EntityWitchProjectile.growBranch(posX, posY, posZ, world, sideHit, enhanced ? 20 : 15, this.boundingBox);
        } else {
            EntityItem itemEntity = null;
            if (mop != null) {
                ItemStack newBrewStack = Witchery.Items.GENERIC.itemBrewOfSprouting.createStack();
                switch (mop.typeOfHit) {
                    case BLOCK: {
                        itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                        break;
                    }
                    case ENTITY: {
                        itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                        break;
                    }
                }
            }
            this.skipFX = true;
            if (itemEntity != null) {
                this.worldObj.spawnEntityInWorld(itemEntity);
            }
        }
    }

    public static void growBranch(int posX, int posY, int posZ, World world, int sideHit, int extent, AxisAlignedBB boundingBox) {
        AxisAlignedBB axisalignedbb;
        List list1;
        int i;
        int dy;
        int dx;
        Block logBlock;
        Block blockID = world.getBlock(posX, posY, posZ);
        int j1 = world.getBlockMetadata(posX, posY, posZ);
        if (blockID == Blocks.log || blockID == Blocks.planks || blockID == Blocks.sapling || blockID == Blocks.leaves) {
            logBlock = Blocks.log;
        } else if (blockID == Witchery.Blocks.LOG || blockID == Witchery.Blocks.PLANKS || blockID == Witchery.Blocks.SAPLING || blockID == Witchery.Blocks.LEAVES) {
            logBlock = Witchery.Blocks.LOG;
        } else {
            logBlock = world.rand.nextInt(2) == 0 ? Blocks.log : Witchery.Blocks.LOG;
            j1 = world.rand.nextInt(Blocks.log == logBlock ? 4 : 3);
        }
        BlockLeaves leavesBlock = Blocks.log == logBlock ? Blocks.leaves : Witchery.Blocks.LEAVES;
        int b0 = 0;
        j1 &= 3;
        switch (sideHit) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        int meta = j1 | b0;
        ParticleEffect particleEffect = ParticleEffect.EXPLODE;
        int n = sideHit == 5 ? 1 : (dx = sideHit == 4 ? -1 : 0);
        int n2 = sideHit == 0 ? -1 : (dy = sideHit == 1 ? 1 : 0);
        int dz = sideHit == 3 ? 1 : (sideHit == 2 ? -1 : 0);
        int sproutExtent = extent;
        boolean isInitialBlockSolid = world.getBlock(posX, posY, posZ).getMaterial().isSolid();
        int n3 = i = sideHit == 1 && !isInitialBlockSolid ? 0 : 1;
        while (i < sproutExtent) {
            int lz;
            int x = posX + i * dx;
            int y = posY + i * dy;
            int z = posZ + i * dz;
            if (y >= 255 || !EntityWitchProjectile.setBlockIfNotSolid(world, x, y, z, logBlock, meta)) break;
            int lx = dx == 0 && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            int ly = dy == 0 && lx == 0 && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            int n4 = lz = dz == 0 && lx == 0 && ly == 0 && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            if (lx != 0 || ly != 0 || lz != 0) {
                EntityWitchProjectile.setBlockIfNotSolid(world, x + lx, y + ly, z + lz, (Block)leavesBlock, meta);
            }
            ++i;
        }
        if (sideHit == 1 && (list1 = world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb = boundingBox.expand(0.0, 2.0, 0.0))) != null && !list1.isEmpty()) {
            Iterator iterator = list1.iterator();
            int x = posX + i * dx;
            int y = Math.min(posY + i * dy, 255);
            int z = posZ + i * dz;
            while (iterator.hasNext()) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)iterator.next();
                if (world.getBlock(x, y + 1, z).getMaterial().isSolid() || world.getBlock(x, y + 2, z).getMaterial().isSolid()) continue;
                entitylivingbase.setPosition(0.5 + (double)x, (double)(y + 1), 0.5 + (double)z);
            }
        }
    }

    private void impactWasting(MovingObjectPosition mop, boolean enhanced) {
        double z;
        double y;
        double x;
        Entity livingEntity = mop.entityHit;
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            x = livingEntity.posX;
            y = livingEntity.posY;
            z = livingEntity.posZ;
        } else {
            x = mop.blockX;
            y = mop.blockY;
            z = mop.blockZ;
        }
        EntityWitchProjectile.explodeWasting(this.worldObj, x, y, z, livingEntity, this.boundingBox, enhanced);
    }

    public static void explodeWasting(World world, double posX, double posY, double posZ, Entity livingEntity, AxisAlignedBB boundingBox, boolean enhanced) {
        double RADIUS = enhanced ? 5.0 : 4.0;
        AxisAlignedBB axisalignedbb = boundingBox.expand(RADIUS, 2.0, RADIUS);
        List list1 = world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        if (list1 != null && !list1.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list1) {
                double d0 = entitylivingbase.getDistanceSq(posX, posY, posZ);
                if (!(d0 < RADIUS * RADIUS)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / RADIUS;
                if (entitylivingbase == livingEntity) {
                    d1 = 1.0;
                }
                int j = (int)(d1 * 400.0 + 0.5);
                if (entitylivingbase instanceof EntityPlayer) {
                    int minLevel;
                    EntityPlayer victim = (EntityPlayer)entitylivingbase;
                    int n = minLevel = enhanced ? 6 : 10;
                    if (victim.getFoodStats().getFoodLevel() > minLevel) {
                        victim.getFoodStats().addStats(-minLevel, 0.0f);
                    }
                    victim.addPotionEffect(new PotionEffect(Potion.hunger.id, j * 2, enhanced ? 2 : 1));
                    victim.addPotionEffect(new PotionEffect(Potion.poison.id, Math.max(j / 3, 40), 0));
                    continue;
                }
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.wither.id, j * 2, enhanced ? 1 : 0));
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.poison.id, Math.max(j / 3, 40), 0));
            }
        }
        int BLOCK_RADIUS = (int)RADIUS - 1;
        int BLOCK_RADIUS_SQ = BLOCK_RADIUS * BLOCK_RADIUS;
        int blockX = MathHelper.floor_double((double)posX);
        int blockY = MathHelper.floor_double((double)posY);
        int blockZ = MathHelper.floor_double((double)posZ);
        for (int y = blockY - BLOCK_RADIUS; y <= blockY + BLOCK_RADIUS; ++y) {
            for (int x = blockX - BLOCK_RADIUS; x <= blockX + BLOCK_RADIUS; ++x) {
                for (int z = blockZ - BLOCK_RADIUS; z <= blockZ + BLOCK_RADIUS; ++z) {
                    Block blockID;
                    Material material;
                    if (!(Coord.distanceSq(x, y, z, blockX, blockY, blockZ) <= (double)BLOCK_RADIUS_SQ) || (material = world.getBlock(x, y, z).getMaterial()) == null || material != Material.leaves && (material != Material.plants && material != Material.vine || !material.isReplaceable()) || (blockID = world.getBlock(x, y, z)) instanceof BlockCircle || blockID instanceof BlockCircleGlyph) continue;
                    blockID.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
                    world.setBlockToAir(x, y, z);
                }
            }
        }
    }

    private void impactInk(MovingObjectPosition mop, boolean enhanced) {
        Entity livingEntity = mop.entityHit;
        EntityWitchProjectile.explodeInk(this.worldObj, this.posX, this.posY, this.posZ, livingEntity, this.boundingBox, enhanced);
    }

    public static void explodeInk(World world, double posX, double posY, double posZ, Entity livingEntity, AxisAlignedBB boundingBox, boolean enhanced) {
        double RADIUS = enhanced ? 5.0 : 4.0;
        AxisAlignedBB axisalignedbb = boundingBox.expand(RADIUS, 2.0, RADIUS);
        List list1 = world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        if (list1 != null && !list1.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list1) {
                double d0 = entitylivingbase.getDistanceSq(posX, posY, posZ);
                if (!(d0 < RADIUS * RADIUS)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / RADIUS;
                if (entitylivingbase == livingEntity) {
                    d1 = 1.0;
                }
                int j = (int)(d1 * 400.0 + 0.5);
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.blindness.id, j, 0));
                if (!(entitylivingbase instanceof EntityLiving)) continue;
                EntityUtil.dropAttackTarget((EntityLiving)entitylivingbase);
            }
        }
    }

    private void impactRock(MovingObjectPosition mop) {
        if (mop.entityHit != null) {
            float DAMAGE = 6.0f;
            mop.entityHit.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this.getThrower()), 6.0f);
        }
        EntityWitchProjectile.spawnParticles(this.worldObj, ParticleEffect.EXPLODE, this.posX, this.posY, this.posZ);
    }

    private static void spawnParticles(World world, ParticleEffect effect, double posX, double posY, double posZ) {
        effect.send(SoundEffect.NONE, world, posX, posY, posZ, 1.0, 1.0, 8);
    }

    private void impactWebSmall(MovingObjectPosition mop) {
        switch (mop.typeOfHit) {
            case ENTITY: {
                this.worldObj.setBlock((int)mop.entityHit.posX, (int)mop.entityHit.posY, (int)mop.entityHit.posZ, Blocks.web);
                break;
            }
            case BLOCK: {
                if (this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ) == Blocks.snow) {
                    --mop.blockY;
                    mop.sideHit = 1;
                }
                switch (mop.sideHit) {
                    case 0: {
                        EntityWitchProjectile.setBlockIfNotSolid(this.worldObj, mop.blockX, mop.blockY - 1, mop.blockZ, Blocks.web);
                        break;
                    }
                    case 1: {
                        EntityWitchProjectile.setBlockIfNotSolid(this.worldObj, mop.blockX, mop.blockY + 1, mop.blockZ, Blocks.web);
                        break;
                    }
                    case 2: {
                        EntityWitchProjectile.setBlockIfNotSolid(this.worldObj, mop.blockX - 1, mop.blockY, mop.blockZ, Blocks.web);
                        break;
                    }
                    case 3: {
                        EntityWitchProjectile.setBlockIfNotSolid(this.worldObj, mop.blockX + 1, mop.blockY, mop.blockZ, Blocks.web);
                        break;
                    }
                    case 4: {
                        EntityWitchProjectile.setBlockIfNotSolid(this.worldObj, mop.blockX, mop.blockY, mop.blockZ - 1, Blocks.web);
                        break;
                    }
                    case 5: {
                        EntityWitchProjectile.setBlockIfNotSolid(this.worldObj, mop.blockX, mop.blockY, mop.blockZ + 1, Blocks.web);
                    }
                }
                break;
            }
        }
    }

    private void impactWebBig(MovingObjectPosition mop, boolean enhanced) {
        switch (mop.typeOfHit) {
            case BLOCK: {
                EntityWitchProjectile.explodeWeb(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, mop.sideHit, enhanced);
                break;
            }
            case ENTITY: {
                int x = MathHelper.floor_double((double)mop.entityHit.posX);
                int y = MathHelper.floor_double((double)mop.entityHit.posY);
                int z = MathHelper.floor_double((double)mop.entityHit.posZ);
                EntityWitchProjectile.explodeWeb(this.worldObj, x, y, z, -1, enhanced);
                break;
            }
        }
    }

    public static void explodeWeb(World world, int posX, int posY, int posZ, int side, boolean enhanced) {
        int x = posX + (side == 4 ? -1 : (side == 5 ? 1 : 0));
        int z = posZ + (side == 2 ? -1 : (side == 3 ? 1 : 0));
        int y = posY + (side == 0 ? -1 : (side == 1 ? 1 : 0));
        if (side == 1 && !world.getBlock(x, posY, z).getMaterial().isSolid()) {
            --y;
        }
        EntityWitchProjectile.setBlockIfNotSolid(world, x, y, z, Blocks.web);
        EntityWitchProjectile.setBlockIfNotSolid(world, x + 1, y, z, Blocks.web);
        EntityWitchProjectile.setBlockIfNotSolid(world, x - 1, y, z, Blocks.web);
        EntityWitchProjectile.setBlockIfNotSolid(world, x, y, z + 1, Blocks.web);
        EntityWitchProjectile.setBlockIfNotSolid(world, x, y, z - 1, Blocks.web);
        if (enhanced) {
            EntityWitchProjectile.setBlockIfNotSolid(world, x + 1, y, z + 1, Blocks.web);
            EntityWitchProjectile.setBlockIfNotSolid(world, x - 1, y, z - 1, Blocks.web);
            EntityWitchProjectile.setBlockIfNotSolid(world, x - 1, y, z + 1, Blocks.web);
            EntityWitchProjectile.setBlockIfNotSolid(world, x + 1, y, z - 1, Blocks.web);
        }
        EntityWitchProjectile.setBlockIfNotSolid(world, x, y + 1, z, Blocks.web);
        EntityWitchProjectile.setBlockIfNotSolid(world, x, y - 1, z, Blocks.web);
    }

    private void impactThorns(MovingObjectPosition mop, boolean enhanced) {
        switch (mop.typeOfHit) {
            case BLOCK: {
                int z;
                int x;
                int y;
                if (mop.sideHit == 1 || this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ) == Blocks.cactus) {
                    int CACTUS_HEIGHT;
                    y = mop.blockY;
                    x = mop.blockX;
                    z = mop.blockZ;
                    int n = CACTUS_HEIGHT = enhanced ? 4 : 3;
                    if (EntityWitchProjectile.plantCactus(this.worldObj, x, y, z, CACTUS_HEIGHT)) break;
                }
                ItemStack newBrewStack = Witchery.Items.GENERIC.itemBrewOfThorns.createStack();
                x = mop.blockX + (mop.sideHit == 4 ? -1 : (mop.sideHit == 5 ? 1 : 0));
                z = mop.blockZ + (mop.sideHit == 2 ? -1 : (mop.sideHit == 3 ? 1 : 0));
                y = mop.blockY + (mop.sideHit == 0 ? -1 : (mop.sideHit == 1 ? 1 : 0));
                this.skipFX = true;
                this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, newBrewStack));
                break;
            }
            case ENTITY: {
                int CACTUS_HEIGHT = enhanced ? 2 : 1;
                int x = MathHelper.floor_double((double)mop.entityHit.posX);
                int y = MathHelper.floor_double((double)mop.entityHit.posY);
                int z = MathHelper.floor_double((double)mop.entityHit.posZ);
                boolean success = EntityWitchProjectile.plantCactus(this.worldObj, x + 1, y, z, CACTUS_HEIGHT);
                success = success && EntityWitchProjectile.plantCactus(this.worldObj, x - 1, y, z, CACTUS_HEIGHT);
                success = success && EntityWitchProjectile.plantCactus(this.worldObj, x, y, z + 1, CACTUS_HEIGHT);
                boolean bl = success = success && EntityWitchProjectile.plantCactus(this.worldObj, x, y, z - 1, CACTUS_HEIGHT);
                if (success) break;
                this.skipFX = true;
                this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, Witchery.Items.GENERIC.itemBrewOfThorns.createStack()));
                break;
            }
        }
    }

    public static boolean plantCactus(World world, int x, int y, int z, int CACTUS_HEIGHT) {
        Material material;
        if (!world.getBlock(x, y, z).getMaterial().isSolid()) {
            --y;
        }
        if ((material = world.getBlock(x, y, z).getMaterial()) != Material.clay && material != Material.craftedSnow && material != Material.grass && material != Material.ground && material != Material.rock && material != Material.sand && material != Material.snow && material != Material.sponge && material != Material.cactus) {
            return false;
        }
        Block blockID = world.getBlock(x, y, z);
        if (!BlockProtect.canBreak(blockID, world)) {
            return false;
        }
        if (material != Material.cactus) {
            world.setBlock(x, y, z, (Block)Blocks.sand);
        } else {
            while (world.getBlock(x, y, z) == Blocks.cactus) {
                ++y;
            }
            --y;
        }
        for (int i = 1; i <= CACTUS_HEIGHT && y + i < 256 && EntityWitchProjectile.setBlockIfNotSolid(world, x, y + i, z, Blocks.cactus); ++i) {
        }
        return true;
    }

    private void impactVines(MovingObjectPosition mop, boolean enhanced) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && mop.sideHit != 0 && mop.sideHit != 1) {
            int dx;
            int n = mop.sideHit == 4 ? -1 : (dx = mop.sideHit == 5 ? 1 : 0);
            int dz = mop.sideHit == 2 ? -1 : (mop.sideHit == 3 ? 1 : 0);
            int y0 = mop.blockY;
            int meta = 0;
            switch (mop.sideHit) {
                case 2: {
                    meta = 1;
                    break;
                }
                case 3: {
                    meta = 4;
                    break;
                }
                case 4: {
                    meta = 8;
                    break;
                }
                case 5: {
                    meta = 2;
                }
            }
            ParticleEffect EFFECT = ParticleEffect.EXPLODE;
            int y = y0;
            int x = mop.blockX;
            int z = mop.blockZ;
            if (!this.isNotSolidOrLeaves(this.worldObj.getBlock(x + dx, y, z + dz).getMaterial()) || !this.worldObj.getBlock(x, y, z).getMaterial().isSolid()) {
                x += dx;
                z += dz;
            }
            while (this.isNotSolidOrLeaves(this.worldObj.getBlock(x + dx, y, z + dz).getMaterial()) && this.worldObj.getBlock(x, y, z).getMaterial().isSolid() && y > 0) {
                this.worldObj.setBlock(x + dx, y, z + dz, Blocks.vine, meta, 3);
                EntityWitchProjectile.spawnParticles(this.worldObj, EFFECT, 0.5 + (double)x + (double)dx, 0.5 + (double)y, 0.5 + (double)z + (double)dz);
                if (this.isNotSolidOrLeaves(this.worldObj.getBlock(x + dx, --y, z + dz).getMaterial()) && this.worldObj.getBlock(x, y, z).getMaterial().isSolid() || !enhanced || this.isNotSolidOrLeaves(this.worldObj.getBlock((x += dx) + dx, y, (z += dz) + dz).getMaterial()) && this.worldObj.getBlock(x, y, z).getMaterial().isSolid()) continue;
                x += dx;
                z += dz;
            }
            x = mop.blockX;
            y = y0 + 1;
            z = mop.blockZ;
            if (!this.worldObj.getBlock(x, y, z).getMaterial().isSolid() && enhanced && !this.worldObj.getBlock(x -= dx, y, z -= dz).getMaterial().isSolid()) {
                x -= dx;
                z -= dz;
            }
            while (this.isNotSolidOrLeaves(this.worldObj.getBlock(x + dx, y, z + dz).getMaterial()) && this.worldObj.getBlock(x, y, z).getMaterial().isSolid() && y < 256) {
                this.worldObj.setBlock(x + dx, y, z + dz, Blocks.vine, meta, 3);
                EntityWitchProjectile.spawnParticles(this.worldObj, EFFECT, 0.5 + (double)x + (double)dx, 0.5 + (double)y, 0.5 + (double)z + (double)dz);
                if (this.worldObj.getBlock(x, ++y, z).getMaterial().isSolid() || !enhanced || this.worldObj.getBlock(x -= dx, y, z -= dz).getMaterial().isSolid()) continue;
                x -= dx;
                z -= dz;
            }
        } else {
            EntityItem itemEntity = null;
            ItemStack newBrewStack = Witchery.Items.GENERIC.itemBrewOfVines.createStack();
            switch (mop.typeOfHit) {
                case BLOCK: {
                    itemEntity = new EntityItem(this.worldObj, (double)mop.blockX + 0.5, (double)(mop.blockY + (mop.sideHit == 0 ? -1 : 1)) + 0.5, (double)mop.blockZ + 0.5, newBrewStack);
                    break;
                }
                case ENTITY: {
                    itemEntity = new EntityItem(this.worldObj, mop.entityHit.posX, mop.entityHit.posY, mop.entityHit.posZ, newBrewStack);
                    break;
                }
            }
            this.skipFX = true;
            this.worldObj.spawnEntityInWorld(itemEntity);
        }
    }

    private boolean isNotSolidOrLeaves(Material material) {
        return material == null || !material.isSolid() || material == Material.leaves;
    }

    private static boolean setBlockIfNotSolid(World world, int x, int y, int z, Block block) {
        return EntityWitchProjectile.setBlockIfNotSolid(world, x, y, z, block, 0);
    }

    private static boolean setBlockIfNotSolid(World world, int x, int y, int z, Block block, int metadata) {
        if (!world.getBlock(x, y, z).getMaterial().isSolid() || block == Blocks.web && world.getBlock(x, y, z) == Blocks.snow) {
            world.setBlock(x, y, z, block, metadata, 3);
            EntityWitchProjectile.spawnParticles(world, ParticleEffect.EXPLODE, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z);
            return true;
        }
        return false;
    }

    public void readEntityFromNBT(NBTTagCompound nbtTag) {
        super.readEntityFromNBT(nbtTag);
        if (nbtTag.hasKey(DAMAGE_VALUE_KEY)) {
            this.damageValue = nbtTag.getInteger(DAMAGE_VALUE_KEY);
            this.setDamageValue(this.damageValue);
        } else {
            this.setDead();
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbtTag) {
        super.writeEntityToNBT(nbtTag);
        nbtTag.setInteger(DAMAGE_VALUE_KEY, this.damageValue);
    }
}

