/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityGoblin;
import com.emoniph.witchery.util.BlockUtil;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EntityAIDigBlocks
extends EntityAIBase {
    protected final EntityGoblin entity;
    protected final double range;
    protected final double kobolditeChance;
    public static final GameProfile NORMAL_MINER_PROFILE = new GameProfile(UUID.fromString("AB06ACB0-0CDB-11E4-9191-0800200C9A66"), "[Minecraft]");
    public static final GameProfile KOBOLDITE_MINER_PROFILE = new GameProfile(UUID.fromString("24818AE0-0CDE-11E4-9191-0800200C9A66"), "[Minecraft]");
    MovingObjectPosition mop = null;
    int failedChecks = 0;
    private int waitTimer = 60;

    public EntityAIDigBlocks(EntityGoblin entity, double range, double kobolditeChance) {
        this.entity = entity;
        this.range = range;
        this.kobolditeChance = kobolditeChance;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        if (this.entity != null && !this.entity.isWorshipping() && this.entity.getHeldItem() != null && this.entity.getHeldItem().getItem() instanceof ItemPickaxe && this.entity.getLeashed() && this.entity.worldObj.rand.nextInt(2) == 0) {
            MovingObjectPosition mop = EntityAIDigBlocks.raytraceBlocks(this.entity.worldObj, (EntityLiving)this.entity, true, this.failedChecks == 15 ? 1.0 : 4.0, this.failedChecks == 15);
            if (mop == null || mop.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
                ++this.failedChecks;
                mop = null;
                return false;
            }
            Block block = BlockUtil.getBlock(this.entity.worldObj, mop);
            if (this.isMineable(block, this.entity.worldObj, mop.blockX, mop.blockY, mop.blockZ)) {
                this.failedChecks = 0;
                this.mop = mop;
                return true;
            }
            this.mop = null;
            ++this.failedChecks;
            return false;
        }
        return false;
    }

    private boolean isMineable(Block block, World world, int x, int y, int z) {
        if (block.getMaterial() != Material.rock && block.getMaterial() != Material.sand && block.getMaterial() != Material.grass && block.getMaterial() != Material.snow && block.getMaterial() != Material.ground) {
            return false;
        }
        return !(block.getBlockHardness(world, x, y, z) < 0.0f);
    }

    private static MovingObjectPosition raytraceBlocks(World world, EntityLiving player, boolean collisionFlag, double reachDistance, boolean down) {
        float rotationYaw;
        Vec3 playerPosition = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        player.rotationYaw = rotationYaw = (float)world.rand.nextInt(360);
        float rotationPitch = down ? 90.0f : 0.0f;
        float f1 = MathHelper.cos((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.sin((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.cos((float)(-rotationPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.sin((float)(-rotationPitch * ((float)Math.PI / 180)));
        Vec3 playerLook = Vec3.createVectorHelper((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        Vec3 playerViewOffset = Vec3.createVectorHelper((double)(playerPosition.xCoord + playerLook.xCoord * reachDistance), (double)(playerPosition.yCoord + playerLook.yCoord * reachDistance), (double)(playerPosition.zCoord + playerLook.zCoord * reachDistance));
        return world.func_147447_a(playerPosition, playerViewOffset, collisionFlag, !collisionFlag, false);
    }

    public void startExecuting() {
        double SPEED = 0.6;
        this.entity.getNavigator().tryMoveToXYZ((double)this.mop.blockX, (double)this.mop.blockY, (double)this.mop.blockZ, 0.6);
    }

    public boolean continueExecuting() {
        return this.entity != null && !this.entity.isWorshipping() && this.entity.getHeldItem() != null && this.entity.getHeldItem().getItem() instanceof ItemPickaxe && this.entity.getLeashed() && this.mop != null;
    }

    public void resetTask() {
        if (this.entity.isWorking()) {
            this.entity.setWorking(false);
        }
    }

    public void updateTask() {
        Block block;
        MovingObjectPosition mop;
        double DROP_RANGE = 2.5;
        double DROP_RANGE_SQ = 6.25;
        double dist = this.entity.getDistanceSq((double)this.mop.blockX + 0.5, (double)this.mop.blockY + 0.5, (double)this.mop.blockZ + 0.5);
        boolean retry = true;
        if (dist <= 6.25) {
            if (!this.entity.isWorking()) {
                this.entity.setWorking(true);
            }
            if (--this.waitTimer == 0) {
                if (!EntityAIDigBlocks.tryHarvestBlock(this.entity.worldObj, this.mop.blockX, this.mop.blockY, this.mop.blockZ, (EntityLivingBase)this.entity)) {
                    retry = false;
                }
                this.mop = null;
                this.waitTimer = this.getNextHarvestDelay();
            }
        } else if (this.entity.getNavigator().noPath()) {
            this.mop = null;
            this.waitTimer = this.getNextHarvestDelay();
            if (this.entity.isWorking()) {
                this.entity.setWorking(false);
            }
        } else if (!this.entity.isWorking()) {
            this.entity.setWorking(true);
        }
        if (this.mop == null && retry && this.entity.worldObj.rand.nextInt(20) != 0 && (mop = EntityAIDigBlocks.raytraceBlocks(this.entity.worldObj, (EntityLiving)this.entity, true, 4.0, false)) != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && this.isMineable(block = BlockUtil.getBlock(this.entity.worldObj, mop), this.entity.worldObj, mop.blockX, mop.blockY, mop.blockZ)) {
            this.mop = mop;
            this.waitTimer = this.getNextHarvestDelay();
        }
    }

    private int getNextHarvestDelay() {
        return EntityAIDigBlocks.isHoldingKobolditePick((EntityLivingBase)this.entity) ? 4 : 60;
    }

    private static boolean isHoldingKobolditePick(EntityLivingBase entity) {
        return entity.getHeldItem() != null && entity.getHeldItem().getItem() == Witchery.Items.KOBOLDITE_PICKAXE;
    }

    public static boolean tryHarvestBlock(World world, int par1, int par2, int par3, EntityLivingBase harvester) {
        boolean kobolditePick = EntityAIDigBlocks.isHoldingKobolditePick(harvester);
        FakePlayer minerPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)(kobolditePick ? KOBOLDITE_MINER_PROFILE : NORMAL_MINER_PROFILE));
        return EntityAIDigBlocks.tryHarvestBlock(world, par1, par2, par3, harvester, (EntityPlayer)minerPlayer);
    }

    public static boolean tryHarvestBlock(World world, int par1, int par2, int par3, EntityLivingBase harvester, EntityPlayer minerPlayer) {
        Block block = world.getBlock(par1, par2, par3);
        int blockMeta = world.getBlockMetadata(par1, par2, par3);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(par1, par2, par3, world, block, blockMeta, minerPlayer);
        event.setCanceled(false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        ItemStack stack = harvester.getHeldItem();
        if (stack != null && stack.getItem().onBlockStartBreak(stack, par1, par2, par3, minerPlayer)) {
            return false;
        }
        world.playAuxSFX(2001, par1, par2, par3, Block.getIdFromBlock((Block)block) + (blockMeta << 12));
        boolean canHarvest = false;
        if (block.getBlockHardness(world, par1, par2, par3) >= 0.0f) {
            int toolLevel;
            if (block.getMaterial().isToolNotRequired()) {
                canHarvest = true;
            }
            String tool = block.getHarvestTool(blockMeta);
            int n = toolLevel = stack != null ? stack.getItem().getHarvestLevel(stack, tool) : 0;
            if (toolLevel < 0) {
                canHarvest = true;
            }
            if (toolLevel >= block.getHarvestLevel(blockMeta)) {
                canHarvest = true;
            }
        }
        if (canHarvest && (canHarvest = EntityAIDigBlocks.removeBlock(world, par1, par2, par3, minerPlayer))) {
            block.harvestBlock(world, minerPlayer, par1, par2, par3, blockMeta);
        }
        return canHarvest;
    }

    private static boolean removeBlock(World world, int x, int y, int z, EntityPlayer player) {
        Block block = world.getBlock(x, y, z);
        int metadata = world.getBlockMetadata(x, y, z);
        block.onBlockHarvested(world, x, y, z, metadata, player);
        boolean flag = block.removedByPlayer(world, player, x, y, z, true);
        if (flag) {
            block.onBlockDestroyedByPlayer(world, x, y, z, metadata);
        }
        return flag;
    }

    public static void onHarvestDrops(EntityPlayer harvester, BlockEvent.HarvestDropsEvent event) {
        if (harvester != null && !harvester.worldObj.isRemote && !event.isCanceled() && (EntityAIDigBlocks.isEqual(harvester.getGameProfile(), KOBOLDITE_MINER_PROFILE) || EntityAIDigBlocks.isEqual(harvester.getGameProfile(), NORMAL_MINER_PROFILE))) {
            boolean hasKobolditePick = EntityAIDigBlocks.isEqual(harvester.getGameProfile(), KOBOLDITE_MINER_PROFILE);
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            double kobolditeChance = hasKobolditePick ? 0.02 : 0.01;
            for (ItemStack drop : event.drops) {
                String oreName;
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)drop);
                boolean addOriginal = true;
                if (oreIDs.length > 0 && (oreName = OreDictionary.getOreName((int)oreIDs[0])) != null && oreName.startsWith("ore")) {
                    ItemStack smeltedDrop = FurnaceRecipes.smelting().getSmeltingResult(drop);
                    if (smeltedDrop != null && hasKobolditePick && harvester.worldObj.rand.nextDouble() < 0.5) {
                        addOriginal = false;
                        newDrops.add(smeltedDrop.copy());
                        newDrops.add(smeltedDrop.copy());
                        if (harvester.worldObj.rand.nextDouble() < 0.25) {
                            newDrops.add(smeltedDrop.copy());
                        }
                    }
                    double d = kobolditeChance = hasKobolditePick ? 0.08 : 0.05;
                }
                if (!addOriginal) continue;
                newDrops.add(drop);
            }
            event.drops.clear();
            for (ItemStack newDrop : newDrops) {
                event.drops.add(newDrop);
            }
            if (kobolditeChance > 0.0 && harvester.worldObj.rand.nextDouble() < kobolditeChance) {
                event.drops.add(Witchery.Items.GENERIC.itemKobolditeDust.createStack());
            }
        }
    }

    private static boolean isEqual(GameProfile a, GameProfile b) {
        if (a == null || b == null || a.getId() == null || b.getId() == null) {
            return false;
        }
        return a.getId().equals(b.getId());
    }
}

