/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import com.emoniph.witchery.entity.EntityGoblin;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class EntityAIGoblinMate
extends EntityAIBase {
    private EntityGoblin goblinObj;
    private EntityGoblin mate;
    private World worldObj;
    private int matingTimeout;
    Village villageObj;

    public EntityAIGoblinMate(EntityGoblin goblin) {
        this.goblinObj = goblin;
        this.worldObj = goblin.worldObj;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.goblinObj.getGrowingAge() != 0) {
            return false;
        }
        if (this.goblinObj.getRNG().nextInt(500) != 0) {
            return false;
        }
        this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)this.goblinObj.posX), MathHelper.floor_double((double)this.goblinObj.posY), MathHelper.floor_double((double)this.goblinObj.posZ), 0);
        if (this.villageObj == null) {
            return false;
        }
        if (!this.checkSufficientDoorsPresentForNewVillager()) {
            return false;
        }
        Entity entity = this.worldObj.findNearestEntityWithinAABB(EntityGoblin.class, this.goblinObj.boundingBox.expand(8.0, 3.0, 8.0), (Entity)this.goblinObj);
        if (entity == null) {
            return false;
        }
        this.mate = (EntityGoblin)entity;
        return this.mate.getGrowingAge() == 0;
    }

    public void startExecuting() {
        this.matingTimeout = 300;
        this.goblinObj.setMating(true);
    }

    public void resetTask() {
        this.villageObj = null;
        this.mate = null;
        this.goblinObj.setMating(false);
    }

    public boolean continueExecuting() {
        return this.matingTimeout >= 0 && this.checkSufficientDoorsPresentForNewVillager() && this.goblinObj.getGrowingAge() == 0;
    }

    public void updateTask() {
        --this.matingTimeout;
        this.goblinObj.getLookHelper().setLookPositionWithEntity((Entity)this.mate, 10.0f, 30.0f);
        if (this.goblinObj.getDistanceSqToEntity((Entity)this.mate) > 2.25) {
            this.goblinObj.getNavigator().tryMoveToEntityLiving((Entity)this.mate, 0.25);
        } else if (this.matingTimeout == 0 && this.mate.isMating()) {
            this.giveBirth();
        }
        if (this.goblinObj.getRNG().nextInt(35) == 0) {
            this.worldObj.setEntityState((Entity)this.goblinObj, (byte)12);
        }
    }

    private boolean checkSufficientDoorsPresentForNewVillager() {
        if (!this.villageObj.isMatingSeason()) {
            return false;
        }
        int i = (int)((double)this.villageObj.getNumVillageDoors() * 0.35);
        return this.getNumVillagers() < i;
    }

    private int getNumVillagers() {
        if (this.worldObj == null || this.goblinObj == null) {
            return 0;
        }
        List list = this.worldObj.getEntitiesWithinAABB(EntityGoblin.class, this.goblinObj.boundingBox.expand(32.0, 3.0, 32.0));
        return list != null ? list.size() : 0;
    }

    private void giveBirth() {
        EntityGoblin entityvillager = this.goblinObj.createChild(this.mate);
        this.mate.setGrowingAge(6000);
        this.goblinObj.setGrowingAge(6000);
        entityvillager.setGrowingAge(-24000);
        entityvillager.setLocationAndAngles(this.goblinObj.posX, this.goblinObj.posY, this.goblinObj.posZ, 0.0f, 0.0f);
        this.worldObj.spawnEntityInWorld((Entity)entityvillager);
        this.worldObj.setEntityState((Entity)entityvillager, (byte)12);
    }
}

