/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import com.emoniph.witchery.common.ExtendedPlayer;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;

public class EntityAIMoveTowardsVampire
extends EntityAIBase {
    private EntityCreature theEntity;
    private EntityLivingBase targetEntity;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private double speed;
    private float maxTargetDistance;
    private float minTargetDistance;

    public EntityAIMoveTowardsVampire(EntityCreature par1EntityCreature, double par2, float min, float max) {
        this.theEntity = par1EntityCreature;
        this.speed = par2;
        this.minTargetDistance = min;
        this.maxTargetDistance = max;
        this.setMutexBits(1);
    }

    private EntityLivingBase getDistanceSqToPartner() {
        double R = this.maxTargetDistance;
        AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.theEntity.posX - R), (double)(this.theEntity.posY - R), (double)(this.theEntity.posZ - R), (double)(this.theEntity.posX + R), (double)(this.theEntity.posY + R), (double)(this.theEntity.posZ + R));
        List mogs = this.theEntity.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bb);
        double minDistance = Double.MAX_VALUE;
        EntityPlayer target = null;
        for (EntityPlayer player : mogs) {
            double distance;
            if (ExtendedPlayer.get(player).getVampireLevel() < 8 || !((distance = this.theEntity.getDistanceSqToEntity((Entity)player)) < minDistance)) continue;
            minDistance = distance;
            target = player;
        }
        return target;
    }

    public boolean shouldExecute() {
        this.targetEntity = this.getDistanceSqToPartner();
        if (this.targetEntity == null) {
            return false;
        }
        double dist = this.targetEntity.getDistanceSqToEntity((Entity)this.theEntity);
        if (dist > (double)(this.maxTargetDistance * this.maxTargetDistance)) {
            return false;
        }
        return !(dist < (double)(this.minTargetDistance * this.minTargetDistance));
    }

    public boolean continueExecuting() {
        if (this.theEntity.ticksExisted % 20 == 0) {
            this.theEntity.getNavigator().tryMoveToXYZ(this.targetEntity.posX, this.targetEntity.posY, this.targetEntity.posZ, this.speed);
        }
        return true;
    }

    public void resetTask() {
        this.targetEntity = null;
    }

    public void startExecuting() {
        this.theEntity.getNavigator().tryMoveToXYZ(this.targetEntity.posX, this.targetEntity.posY, this.targetEntity.posZ, this.speed);
    }
}

