/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.familiar;

import com.emoniph.witchery.entity.EntityOwl;
import com.emoniph.witchery.entity.EntityToad;
import com.emoniph.witchery.entity.EntityWitchCat;
import com.emoniph.witchery.familiar.IFamiliar;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TameableUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public abstract class Familiar {
    private static final String[] NAMES_TOAD = new String[]{"Casper", "Wart", "Langston", "Croaker", "Prince Charming", "Frog-n-stien", "Randolph", "Evileye", "Churchill", "Santa", "Dillinger", "Spuds"};
    private static final String[] NAMES_CAT = new String[]{"Pyewackett", "Salem", "Gobbolino", "Sabbath", "Norris", "Crookshanks", "Binx", "Voodoo", "Raven", "Simpkin", "Fishbone", "Kismet"};
    private static final String[] NAMES_OWL = new String[]{"Archimedes", "Dumbledornithologist", "Al Travis", "Baltimore", "Cornelius", "Hadwig", "Hoot", "Merlin", "Owl Capone", "Pigwidgeon", "Athena", "Albertine"};
    private static final String FAMILIAR_TAG_KEY = "WITCFamiliar";
    private static final String FAMILIAR_UUID_MOST = "UUIDMost";
    private static final String FAMILIAR_UUID_LEAST = "UUIDLeast";
    private static final String FAMILIAR_NAME = "FamiliarName";
    private static final String FAMILIAR_TYPE = "FamiliarType";
    private static final String FAMILIAR_COLOR = "FamiliarColor";
    private static final String FAMILIAR_SUMMONED = "FamiliarSummoned";
    public static final int FAMILIAR_NONE = 0;
    public static final int FAMILIAR_CAT = 1;
    public static final int FAMILIAR_TOAD = 2;
    public static final int FAMILIAR_OWL = 3;
    private static final float REDIRECTED_DAMAGE_PCT_FAR = 0.01f;
    private static final float REDIRECTED_DAMAGE_PCT_NEAR = 0.1f;
    private static final float MAX_HEALTH = 50.0f;
    private static final float FAMILIAR_NEAR_DISTANCE_SQ = 576.0f;

    public static void bindToPlayer(EntityPlayer player, EntityTameable familiarEntity) {
        NBTTagCompound nbtTag;
        if (Familiar.canBecomeFamiliar(familiarEntity) && TameableUtil.isOwner(familiarEntity, player) && (nbtTag = Infusion.getNBT((Entity)player)) != null) {
            EntityTameable currentFamiliar = Familiar.getFamiliarEntity(player);
            if (currentFamiliar != null) {
                ((IFamiliar)currentFamiliar).clearFamiliar();
            }
            if (familiarEntity instanceof EntityOcelot) {
                EntityOcelot oldCat = (EntityOcelot)familiarEntity;
                EntityWitchCat newCat = new EntityWitchCat(oldCat.worldObj);
                newCat.cloneOcelot(oldCat);
                newCat.setTameSkin(1);
                oldCat.setDead();
                newCat.worldObj.spawnEntityInWorld((Entity)newCat);
                newCat.worldObj.setEntityState((Entity)newCat, (byte)7);
                familiarEntity = newCat;
            }
            IFamiliar familiar = (IFamiliar)familiarEntity;
            NBTTagCompound nbtFamiliar = new NBTTagCompound();
            nbtFamiliar.setLong(FAMILIAR_UUID_MOST, familiarEntity.getUniqueID().getMostSignificantBits());
            nbtFamiliar.setLong(FAMILIAR_UUID_LEAST, familiarEntity.getUniqueID().getLeastSignificantBits());
            String name = "Familiar";
            if (familiarEntity instanceof EntityOwl) {
                name = NAMES_OWL[player.worldObj.rand.nextInt(NAMES_OWL.length)];
                nbtFamiliar.setInteger(FAMILIAR_TYPE, 3);
                nbtFamiliar.setByte(FAMILIAR_COLOR, Byte.valueOf((byte)((EntityOwl)familiar).getFeatherColor()).byteValue());
            } else if (familiarEntity instanceof EntityToad) {
                name = NAMES_TOAD[player.worldObj.rand.nextInt(NAMES_OWL.length)];
                nbtFamiliar.setInteger(FAMILIAR_TYPE, 2);
                nbtFamiliar.setByte(FAMILIAR_COLOR, Byte.valueOf((byte)((EntityToad)familiar).getSkinColor()).byteValue());
            } else if (familiarEntity instanceof EntityOcelot) {
                name = NAMES_CAT[player.worldObj.rand.nextInt(NAMES_OWL.length)];
                nbtFamiliar.setInteger(FAMILIAR_TYPE, 1);
                nbtFamiliar.setByte(FAMILIAR_COLOR, Byte.valueOf((byte)0).byteValue());
            }
            if (!familiarEntity.hasCustomNameTag() && name != null && !name.isEmpty()) {
                familiarEntity.setCustomNameTag(name);
            }
            nbtFamiliar.setString(FAMILIAR_NAME, familiarEntity.getCustomNameTag());
            nbtFamiliar.setByte(FAMILIAR_SUMMONED, Byte.valueOf((byte)1).byteValue());
            nbtTag.setTag(FAMILIAR_TAG_KEY, (NBTBase)nbtFamiliar);
            familiar.setMaxHealth(50.0f);
        }
    }

    public static boolean canBecomeFamiliar(EntityTameable familiarEntity) {
        return familiarEntity != null && familiarEntity.isTamed() && (familiarEntity instanceof EntityWitchCat || familiarEntity instanceof EntityOcelot || familiarEntity instanceof EntityToad || familiarEntity instanceof EntityOwl);
    }

    public static EntityTameable getFamiliarEntityByID(EntityPlayer player, UUID uuidFamiliar) {
        if (uuidFamiliar != null) {
            List list = player.worldObj.loadedEntityList;
            for (int i = 0; i < list.size(); ++i) {
                EntityTameable tameableEntity;
                Object obj = list.get(i);
                if (!(obj instanceof EntityTameable) || !(tameableEntity = (EntityTameable)obj).getUniqueID().equals(uuidFamiliar)) continue;
                return tameableEntity;
            }
            if (!player.worldObj.isRemote) {
                MinecraftServer server = MinecraftServer.getServer();
                for (WorldServer worldServer : server.worldServers) {
                    List list2 = worldServer.loadedEntityList;
                    for (int i = 0; i < list2.size(); ++i) {
                        EntityTameable tameableEntity;
                        Object obj = list2.get(i);
                        if (!(obj instanceof EntityTameable) || !(tameableEntity = (EntityTameable)obj).getUniqueID().equals(uuidFamiliar)) continue;
                        return tameableEntity;
                    }
                }
            }
        }
        return null;
    }

    public static EntityTameable getFamiliarEntity(EntityPlayer player) {
        UUID uuidFamiliar = Familiar.getFamiliarEntityID(player);
        EntityTameable familiar = Familiar.getFamiliarEntityByID(player, uuidFamiliar);
        return familiar;
    }

    public static UUID getFamiliarEntityID(EntityPlayer player) {
        NBTTagCompound nbtFamiliar;
        NBTTagCompound nbtTag;
        if (player != null && (nbtTag = Infusion.getNBT((Entity)player)) != null && nbtTag.hasKey(FAMILIAR_TAG_KEY) && (nbtFamiliar = nbtTag.getCompoundTag(FAMILIAR_TAG_KEY)) != null && nbtFamiliar.hasKey(FAMILIAR_UUID_MOST) && nbtFamiliar.hasKey(FAMILIAR_UUID_LEAST)) {
            UUID uuidFamiliar = new UUID(nbtFamiliar.getLong(FAMILIAR_UUID_MOST), nbtFamiliar.getLong(FAMILIAR_UUID_LEAST));
            return uuidFamiliar;
        }
        return null;
    }

    public static boolean isPlayerBoundToFamiliar(EntityPlayer player, EntityTameable familiar) {
        NBTTagCompound nbtFamiliar;
        NBTTagCompound nbtTag;
        if (player != null && familiar != null && (nbtTag = Infusion.getNBT((Entity)player)) != null && nbtTag.hasKey(FAMILIAR_TAG_KEY) && (nbtFamiliar = nbtTag.getCompoundTag(FAMILIAR_TAG_KEY)) != null && nbtFamiliar.hasKey(FAMILIAR_UUID_MOST) && nbtFamiliar.hasKey(FAMILIAR_UUID_LEAST)) {
            UUID uuidFamiliar = new UUID(nbtFamiliar.getLong(FAMILIAR_UUID_MOST), nbtFamiliar.getLong(FAMILIAR_UUID_LEAST));
            return uuidFamiliar.equals(familiar.getUniqueID());
        }
        return false;
    }

    public static FamiliarOwner getOwnerForFamiliar(EntityTameable familiar) {
        EntityLivingBase owner;
        if (familiar != null && !familiar.worldObj.isRemote && familiar.isTamed() && (owner = familiar.getOwner()) != null && owner instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)owner;
            UUID uuidFamiliar = Familiar.getFamiliarEntityID(player);
            if (uuidFamiliar != null && uuidFamiliar.equals(familiar.getUniqueID())) {
                return new FamiliarOwner(player, true);
            }
            return new FamiliarOwner(player, false);
        }
        return new FamiliarOwner(null, false);
    }

    public static boolean hasActiveCurseMasteryFamiliar(EntityPlayer player) {
        int familiarType = Familiar.getActiveFamiliarType(player);
        return familiarType == 1;
    }

    public static boolean hasActiveBrewMasteryFamiliar(EntityPlayer player) {
        int familiarType = Familiar.getActiveFamiliarType(player);
        return familiarType == 2;
    }

    public static boolean hasActiveBroomMasteryFamiliar(EntityPlayer player) {
        int familiarType = Familiar.getActiveFamiliarType(player);
        return familiarType == 3;
    }

    public static boolean hasActiveFamiliar(EntityPlayer player) {
        int familiarType = Familiar.getActiveFamiliarType(player);
        return familiarType > 0;
    }

    public static int getActiveFamiliarType(EntityPlayer player) {
        byte summoned;
        NBTTagCompound nbtFamiliar;
        NBTTagCompound nbtTag;
        if (player != null && !player.worldObj.isRemote && (nbtTag = Infusion.getNBT((Entity)player)) != null && nbtTag.hasKey(FAMILIAR_TAG_KEY) && (nbtFamiliar = nbtTag.getCompoundTag(FAMILIAR_TAG_KEY)).hasKey(FAMILIAR_SUMMONED) && nbtFamiliar.hasKey(FAMILIAR_TYPE) && nbtFamiliar.hasKey(FAMILIAR_NAME) && (summoned = nbtFamiliar.getByte(FAMILIAR_SUMMONED)) == 1) {
            int type = nbtFamiliar.getInteger(FAMILIAR_TYPE);
            return type;
        }
        return 0;
    }

    public static void handlePlayerHurt(LivingHurtEvent event, EntityPlayer player) {
        UUID familiarID;
        World world = event.entityLiving.worldObj;
        if (!world.isRemote && !event.isCanceled() && (familiarID = Familiar.getFamiliarEntityID(player)) != null) {
            float totalDamage = event.ammount;
            float redirectedDamage = totalDamage * 0.01f;
            EntityTameable familiar = Familiar.getFamiliarEntityByID(player, familiarID);
            if (familiar != null) {
                if (familiar.getDistanceSqToEntity((Entity)player) <= 576.0) {
                    redirectedDamage = totalDamage * 0.1f;
                }
                if (redirectedDamage >= 1.0f) {
                    familiar.attackEntityFrom(event.source, redirectedDamage);
                }
            }
            event.ammount -= redirectedDamage;
        }
    }

    public static void handleLivingDeath(LivingDeathEvent event) {
        World world = event.entityLiving.worldObj;
        if (!world.isRemote && !event.isCanceled()) {
            EntityPlayer player;
            EntityTameable familiar;
            if (event.entityLiving instanceof EntityTameable) {
                EntityTameable tameableEntity = (EntityTameable)event.entityLiving;
                if (Familiar.couldBeFamiliar(tameableEntity)) {
                    FamiliarOwner owner = Familiar.getOwnerForFamiliar(tameableEntity);
                    if (owner.player != null && owner.isOwner()) {
                        NBTTagCompound nbtTag = Infusion.getNBT((Entity)owner.player);
                        owner.player.attackEntityFrom(DamageSource.magic, owner.player.getMaxHealth() * 2.0f);
                        Familiar.dismissFamiliar(owner.player, tameableEntity);
                        event.setCanceled(true);
                    } else if (owner.player == null) {
                        tameableEntity.setHealth(1.0f);
                        event.setCanceled(true);
                    }
                }
            } else if (event.entityLiving instanceof EntityPlayer && (familiar = Familiar.getFamiliarEntity(player = (EntityPlayer)event.entityLiving)) != null && !familiar.isDead) {
                Familiar.dismissFamiliar(player, familiar);
            }
        }
    }

    public static void dismissFamiliar(EntityPlayer player, EntityTameable familiar) {
        NBTTagCompound nbtTag;
        if (player != null && familiar != null && !player.worldObj.isRemote && Familiar.isPlayerBoundToFamiliar(player, familiar) && (nbtTag = Infusion.getNBT((Entity)player)) != null && nbtTag.hasKey(FAMILIAR_TAG_KEY)) {
            NBTTagCompound nbtFamiliar = nbtTag.getCompoundTag(FAMILIAR_TAG_KEY);
            nbtFamiliar.setString(FAMILIAR_NAME, familiar.getCustomNameTag());
            nbtFamiliar.setByte(FAMILIAR_SUMMONED, Byte.valueOf((byte)0).byteValue());
            if (familiar instanceof EntityOwl) {
                nbtFamiliar.setByte(FAMILIAR_COLOR, Byte.valueOf((byte)((EntityOwl)familiar).getFeatherColor()).byteValue());
            } else if (familiar instanceof EntityToad) {
                nbtFamiliar.setByte(FAMILIAR_COLOR, Byte.valueOf((byte)((EntityToad)familiar).getSkinColor()).byteValue());
            }
            ParticleEffect.INSTANT_SPELL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)familiar, 1.0, 1.0, 16);
            familiar.setDead();
        }
    }

    public static String getFamiliarName(EntityPlayer player) {
        NBTTagCompound nbtFamiliar;
        NBTTagCompound nbtTag = Infusion.getNBT((Entity)player);
        if (nbtTag != null && nbtTag.hasKey(FAMILIAR_TAG_KEY) && (nbtFamiliar = nbtTag.getCompoundTag(FAMILIAR_TAG_KEY)).hasKey(FAMILIAR_SUMMONED) && nbtFamiliar.hasKey(FAMILIAR_TYPE) && nbtFamiliar.hasKey(FAMILIAR_NAME)) {
            byte summoned = nbtFamiliar.getByte(FAMILIAR_SUMMONED);
            String name = nbtFamiliar.getString(FAMILIAR_NAME);
            return name;
        }
        return null;
    }

    public static EntityTameable summonFamiliar(EntityPlayer player, double x, double y, double z) {
        byte summoned;
        NBTTagCompound nbtFamiliar;
        NBTTagCompound nbtTag;
        if (player != null && !player.worldObj.isRemote && (nbtTag = Infusion.getNBT((Entity)player)) != null && nbtTag.hasKey(FAMILIAR_TAG_KEY) && (nbtFamiliar = nbtTag.getCompoundTag(FAMILIAR_TAG_KEY)).hasKey(FAMILIAR_SUMMONED) && nbtFamiliar.hasKey(FAMILIAR_TYPE) && nbtFamiliar.hasKey(FAMILIAR_NAME) && (summoned = nbtFamiliar.getByte(FAMILIAR_SUMMONED)) == 0) {
            String name = nbtFamiliar.getString(FAMILIAR_NAME);
            int type = nbtFamiliar.getInteger(FAMILIAR_TYPE);
            byte color = nbtFamiliar.getByte(FAMILIAR_COLOR);
            IFamiliar familiar = null;
            switch (type) {
                case 1: {
                    familiar = new EntityWitchCat(player.worldObj);
                    break;
                }
                case 2: {
                    familiar = new EntityToad(player.worldObj);
                    ((EntityToad)familiar).setSkinColor(color);
                    break;
                }
                case 3: {
                    familiar = new EntityOwl(player.worldObj);
                    ((EntityOwl)familiar).setFeatherColor(color);
                    break;
                }
                default: {
                    return null;
                }
            }
            familiar.setTamed(true);
            TameableUtil.setOwner((EntityTameable)familiar, player);
            familiar.setCustomNameTag(name);
            ((IFamiliar)familiar).setMaxHealth(50.0f);
            familiar.setLocationAndAngles(x, y, z, 0.0f, 0.0f);
            player.worldObj.spawnEntityInWorld((Entity)familiar);
            nbtFamiliar.setLong(FAMILIAR_UUID_MOST, familiar.getUniqueID().getMostSignificantBits());
            nbtFamiliar.setLong(FAMILIAR_UUID_LEAST, familiar.getUniqueID().getLeastSignificantBits());
            ParticleEffect.INSTANT_SPELL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)familiar, 1.0, 1.0, 16);
            nbtFamiliar.setByte(FAMILIAR_SUMMONED, Byte.valueOf((byte)1).byteValue());
            return familiar;
        }
        return null;
    }

    public static boolean couldBeFamiliar(EntityTameable entity) {
        if (entity instanceof IFamiliar) {
            IFamiliar familiar = (IFamiliar)entity;
            return familiar.isFamiliar();
        }
        return false;
    }

    public static class FamiliarOwner {
        private final EntityPlayer player;
        private final boolean owner;

        public FamiliarOwner(EntityPlayer player, boolean owner) {
            this.player = player;
            this.owner = owner;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public boolean isOwner() {
            return this.owner;
        }

        public EntityPlayer getCurrentOwner() {
            return this.owner ? this.player : null;
        }
    }
}

