/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.dimension.WorldProviderDreamWorld;
import com.emoniph.witchery.dimension.WorldProviderTorment;
import com.emoniph.witchery.entity.EntityCovenWitch;
import com.emoniph.witchery.entity.EntityDemon;
import com.emoniph.witchery.entity.EntityIllusion;
import com.emoniph.witchery.entity.EntityIllusionCreeper;
import com.emoniph.witchery.entity.EntityIllusionSpider;
import com.emoniph.witchery.entity.EntityIllusionZombie;
import com.emoniph.witchery.entity.EntityNightmare;
import com.emoniph.witchery.entity.EntityVillageGuard;
import com.emoniph.witchery.entity.EntityWitchHunter;
import com.emoniph.witchery.entity.ai.EntityAIDigBlocks;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.infusion.InfusedBrewEffect;
import com.emoniph.witchery.infusion.PlayerEffects;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePower;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.item.ItemHunterClothes;
import com.emoniph.witchery.network.PacketPlayerStyle;
import com.emoniph.witchery.network.PacketPlayerSync;
import com.emoniph.witchery.predictions.PredictionManager;
import com.emoniph.witchery.ritual.rites.RiteProtectionCircleRepulsive;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Dye;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class Infusion {
    public static final Infusion DEFUSED = new Infusion(0);
    public static final String INFUSION_CHARGES_KEY = "witcheryInfusionCharges";
    public static final String INFUSION_ID_KEY = "witcheryInfusionID";
    public static final String INFUSION_MAX_CHARGES_KEY = "witcheryInfusionChargesMax";
    public static final String INFUSION_NEXTSYNC = "WITCResyncLook";
    public static final String INFUSION_GROTESQUE = "witcheryGrotesque";
    public static final String INFUSION_DEPTHS = "witcheryDepths";
    public static final String INFUSION_CURSED = "witcheryCursed";
    public static final String INFUSION_INSANITY = "witcheryInsanity";
    public static final String INFUSION_SINKING = "witcherySinking";
    public static final String INFUSION_OVERHEAT = "witcheryOverheating";
    public static final String INFUSION_NIGHTMARE = "witcheryWakingNightmare";
    public final int infusionID;
    protected static final int DEFAULT_CHARGE_COST = 1;

    public static EntityItem dropEntityItemWithRandomChoice(EntityLivingBase entity, ItemStack par1ItemStack, boolean par2) {
        if (par1ItemStack == null || entity == null) {
            return null;
        }
        if (par1ItemStack.stackSize == 0) {
            return null;
        }
        EntityItem entityitem = new EntityItem(entity.worldObj, entity.posX, entity.posY - (double)0.3f + (double)entity.getEyeHeight(), entity.posZ, par1ItemStack);
        entityitem.delayBeforeCanPickup = 40;
        float f = 0.1f;
        if (par2) {
            float f1 = entity.worldObj.rand.nextFloat() * 0.5f;
            float f2 = entity.worldObj.rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.motionX = -MathHelper.sin((float)f2) * f1;
            entityitem.motionZ = MathHelper.cos((float)f2) * f1;
            entityitem.motionY = 0.2f;
        } else {
            f = 0.3f;
            entityitem.motionX = -MathHelper.sin((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            entityitem.motionZ = MathHelper.cos((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            entityitem.motionY = -MathHelper.sin((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f;
            float f1 = entity.worldObj.rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.motionX += Math.cos(f1) * (double)(f *= entity.worldObj.rand.nextFloat());
            entityitem.motionY += (double)((entity.worldObj.rand.nextFloat() - entity.worldObj.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f1) * (double)f;
        }
        entity.worldObj.spawnEntityInWorld((Entity)entityitem);
        return entityitem;
    }

    public static EntityCreature spawnCreature(World world, Class<? extends EntityCreature> creatureType, EntityLivingBase victim, int minRange, int maxRange, ParticleEffect effect, SoundEffect effectSound) {
        int x = MathHelper.floor_double((double)victim.posX);
        int y = MathHelper.floor_double((double)victim.posY);
        int z = MathHelper.floor_double((double)victim.posZ);
        return Infusion.spawnCreature(world, creatureType, x, y, z, victim, minRange, maxRange, effect, effectSound);
    }

    public static EntityCreature spawnCreature(World world, Class<? extends EntityCreature> creatureType, int x, int y, int z, EntityPlayer victim, int minRange, int maxRange) {
        return Infusion.spawnCreature(world, creatureType, x, y, z, (EntityLivingBase)victim, minRange, maxRange, null, SoundEffect.NONE);
    }

    public static EntityCreature spawnCreature(World world, Class<? extends EntityCreature> creatureType, int x, int y, int z, EntityLivingBase victim, int minRange, int maxRange, ParticleEffect effect, SoundEffect effectSound) {
        if (!world.isRemote) {
            int hy;
            int ny;
            int activeRadius = maxRange - minRange;
            int ax = world.rand.nextInt(activeRadius * 2 + 1);
            if (ax > activeRadius) {
                ax += minRange * 2;
            }
            int nx = x - maxRange + ax;
            int az = world.rand.nextInt(activeRadius * 2 + 1);
            if (az > activeRadius) {
                az += minRange * 2;
            }
            int nz = z - maxRange + az;
            for (ny = y; !world.isAirBlock(nx, ny, nz) && ny < y + 8; ++ny) {
            }
            while (world.isAirBlock(nx, ny, nz) && ny > 0) {
                --ny;
            }
            for (hy = 0; world.isAirBlock(nx, ny + hy + 1, nz) && hy < 6; ++hy) {
            }
            Log.instance().debug("Creature: hy: " + hy + " (" + nx + "," + ny + "," + nz + ")");
            if (hy >= 2) {
                try {
                    Constructor<? extends EntityCreature> ctor = creatureType.getConstructor(World.class);
                    EntityCreature creature = ctor.newInstance(world);
                    if (victim instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)victim;
                        if (creature instanceof EntityIllusion) {
                            ((EntityIllusion)creature).setVictim(player.getCommandSenderName());
                        } else if (creature instanceof EntityNightmare) {
                            ((EntityNightmare)creature).setVictim(player.getCommandSenderName());
                            creature.setAttackTarget(victim);
                        }
                    }
                    creature.setLocationAndAngles(0.5 + (double)nx, 0.05 + (double)ny + 1.0, 0.5 + (double)nz, 0.0f, 0.0f);
                    world.spawnEntityInWorld((Entity)creature);
                    if (effect != null) {
                        effect.send(effectSound, world, 0.5 + (double)nx, 0.05 + (double)ny + 1.0, 0.5 + (double)nz, 1.0, creature.height, 16);
                    }
                    return creature;
                }
                catch (NoSuchMethodException ex) {
                }
                catch (InvocationTargetException ex) {
                }
                catch (InstantiationException ex) {
                }
                catch (IllegalAccessException ex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isOnCooldown(World world, ItemStack stack) {
        long currentTime;
        NBTTagCompound nbtTag;
        return !world.isRemote && (nbtTag = stack.getTagCompound()) != null && nbtTag.hasKey("WITCCooldown") && (currentTime = MinecraftServer.getSystemTimeMillis()) < nbtTag.getLong("WITCCooldown");
    }

    public static void setCooldown(World world, ItemStack stack, int milliseconds) {
        if (!world.isRemote) {
            NBTTagCompound nbtTag;
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            if ((nbtTag = stack.getTagCompound()) != null) {
                long currentTime = MinecraftServer.getSystemTimeMillis();
                nbtTag.setLong("WITCCooldown", currentTime + (long)milliseconds);
            }
        }
    }

    public Infusion(int infusionID) {
        this.infusionID = infusionID;
    }

    public void onHurt(World worldObj, EntityPlayer player, LivingHurtEvent event) {
    }

    public void onFalling(World world, EntityPlayer player, LivingFallEvent event) {
    }

    public IIcon getPowerBarIcon(EntityPlayer player, int index) {
        return Blocks.planks.getIcon(0, 0);
    }

    protected boolean consumeCharges(World world, EntityPlayer player, int cost, boolean playFailSound) {
        if (player.capabilities.isCreativeMode) {
            return true;
        }
        int charges = Infusion.getCurrentEnergy(player);
        if (charges - cost < 0) {
            world.playSoundAtEntity((Entity)player, "note.snare", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            this.clearInfusion(player);
            return false;
        }
        Infusion.setCurrentEnergy(player, charges - cost);
        return true;
    }

    public void onUpdate(ItemStack itemstack, World world, EntityPlayer player, int par4, boolean par5) {
    }

    public void onLeftClickEntity(ItemStack itemstack, World world, EntityPlayer player, Entity otherEntity) {
        if (!world.isRemote) {
            world.playSoundAtEntity((Entity)player, "note.snare", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 400;
    }

    public void onUsingItemTick(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
    }

    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (!world.isRemote) {
            world.playSoundAtEntity((Entity)player, "note.snare", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
    }

    public void playSound(World world, EntityPlayer player, String sound) {
        world.playSoundAtEntity((Entity)player, sound, 0.5f, 0.4f / ((float)world.rand.nextDouble() * 0.4f + 0.8f));
    }

    public void playFailSound(World world, EntityPlayer player) {
        this.playSound(world, player, "note.snare");
    }

    public static NBTTagCompound getNBT(Entity player) {
        NBTTagCompound entityData = player.getEntityData();
        if (player.worldObj.isRemote) {
            return entityData;
        }
        NBTTagCompound persistedData = entityData.getCompoundTag("PlayerPersisted");
        if (!entityData.hasKey("PlayerPersisted")) {
            entityData.setTag("PlayerPersisted", (NBTBase)persistedData);
        }
        return persistedData;
    }

    public void infuse(EntityPlayer player, int charges) {
        if (!player.worldObj.isRemote) {
            NBTTagCompound nbt = Infusion.getNBT((Entity)player);
            nbt.setInteger(INFUSION_ID_KEY, this.infusionID);
            nbt.setInteger(INFUSION_CHARGES_KEY, charges);
            nbt.setInteger(INFUSION_MAX_CHARGES_KEY, charges);
            CreaturePower.setCreaturePowerID(player, 0, 0);
            Infusion.syncPlayer(player.worldObj, player);
        }
    }

    private void clearInfusion(EntityPlayer player) {
        if (!player.worldObj.isRemote) {
            NBTTagCompound nbt = Infusion.getNBT((Entity)player);
            nbt.removeTag(INFUSION_CHARGES_KEY);
            Infusion.syncPlayer(player.worldObj, player);
        }
    }

    public static void setCurrentEnergy(EntityPlayer player, int currentEnergy) {
        if (!player.worldObj.isRemote) {
            NBTTagCompound nbt = Infusion.getNBT((Entity)player);
            nbt.setInteger(INFUSION_CHARGES_KEY, currentEnergy);
            Infusion.syncPlayer(player.worldObj, player);
        }
    }

    public static void syncPlayer(World world, EntityPlayer player) {
        if (!world.isRemote) {
            Witchery.packetPipeline.sendTo((IMessage)new PacketPlayerSync(player), player);
        }
    }

    public static int getInfusionID(EntityPlayer player) {
        NBTTagCompound nbt = Infusion.getNBT((Entity)player);
        return nbt.hasKey(INFUSION_ID_KEY) ? nbt.getInteger(INFUSION_ID_KEY) : 0;
    }

    public static int getCurrentEnergy(EntityPlayer player) {
        NBTTagCompound nbt = Infusion.getNBT((Entity)player);
        return nbt.hasKey(INFUSION_CHARGES_KEY) ? nbt.getInteger(INFUSION_CHARGES_KEY) : 0;
    }

    public static int getMaxEnergy(EntityPlayer player) {
        NBTTagCompound nbt = Infusion.getNBT((Entity)player);
        return nbt.hasKey(INFUSION_MAX_CHARGES_KEY) ? nbt.getInteger(INFUSION_MAX_CHARGES_KEY) : 0;
    }

    public static void setEnergy(EntityPlayer player, int infusionID, int currentEnergy, int maxEnergy) {
        if (player.worldObj.isRemote) {
            NBTTagCompound nbt = Infusion.getNBT((Entity)player);
            nbt.setInteger(INFUSION_ID_KEY, infusionID);
            nbt.setInteger(INFUSION_CHARGES_KEY, currentEnergy);
            nbt.setInteger(INFUSION_MAX_CHARGES_KEY, maxEnergy);
        }
    }

    public static void setSinkingCurseLevel(EntityPlayer playerEntity, int sinkingLevel) {
        if (playerEntity.worldObj.isRemote) {
            NBTTagCompound nbt = Infusion.getNBT((Entity)playerEntity);
            if (nbt.hasKey(INFUSION_SINKING) && sinkingLevel <= 0) {
                nbt.removeTag(INFUSION_SINKING);
            }
            nbt.setInteger(INFUSION_SINKING, sinkingLevel);
        }
    }

    public static int getSinkingCurseLevel(EntityPlayer player) {
        NBTTagCompound nbtTag = Infusion.getNBT((Entity)player);
        return nbtTag.hasKey(INFUSION_SINKING) ? nbtTag.getInteger(INFUSION_SINKING) : 0;
    }

    public static boolean aquireEnergy(World world, EntityPlayer player, int cost, boolean showMessages) {
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        if (nbtPlayer != null) {
            return Infusion.aquireEnergy(world, player, nbtPlayer, cost, showMessages);
        }
        return false;
    }

    public static boolean aquireEnergy(World world, EntityPlayer player, NBTTagCompound nbtPlayer, int cost, boolean showMessages) {
        if (nbtPlayer != null && nbtPlayer.hasKey(INFUSION_ID_KEY) && nbtPlayer.hasKey(INFUSION_CHARGES_KEY)) {
            if (player.capabilities.isCreativeMode || nbtPlayer.getInteger(INFUSION_CHARGES_KEY) >= cost) {
                if (!player.capabilities.isCreativeMode) {
                    Infusion.setCurrentEnergy(player, nbtPlayer.getInteger(INFUSION_CHARGES_KEY) - cost);
                }
                return true;
            }
            if (showMessages) {
                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.infuse.nocharges", new Object[0]);
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            }
            return false;
        }
        if (showMessages) {
            ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.infuse.infusionrequired", new Object[0]);
            SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
        }
        return false;
    }

    public static class Registry {
        private static final Registry INSTANCE = new Registry();
        private final ArrayList<Infusion> registry = new ArrayList();

        public static Registry instance() {
            return INSTANCE;
        }

        private Registry() {
        }

        public void add(Infusion infusion) {
            if (infusion.infusionID == this.registry.size() + 1) {
                this.registry.add(infusion);
            } else if (infusion.infusionID > this.registry.size() + 1) {
                for (int i = this.registry.size(); i < infusion.infusionID; ++i) {
                    this.registry.add(null);
                }
                this.registry.add(infusion);
            } else {
                Infusion existingInfusion = this.registry.get(infusion.infusionID);
                if (existingInfusion != null) {
                    Log.instance().warning(String.format("Creature power %s at id %d is being overwritten by another creature power %s.", existingInfusion, infusion.infusionID, infusion));
                }
                this.registry.set(infusion.infusionID, infusion);
            }
        }

        public Infusion get(EntityPlayer player) {
            int infusionID = Infusion.getInfusionID(player);
            return infusionID > 0 ? this.registry.get(infusionID - 1) : DEFUSED;
        }

        public Infusion get(int infusionID) {
            return infusionID > 0 ? this.registry.get(infusionID - 1) : DEFUSED;
        }
    }

    public static class EventHooks {
        private boolean isBannedSpiritObject(ItemStack stack) {
            if (stack != null) {
                Item item = stack.getItem();
                return item == Items.ender_pearl || item == Items.blaze_powder;
            }
            return false;
        }

        @SubscribeEvent(priority=EventPriority.NORMAL)
        public void onEnderTeleport(EnderTeleportEvent event) {
            if (!event.isCanceled() && event.entityLiving != null && !event.entityLiving.worldObj.isRemote && event.entityLiving instanceof EntityPlayer && ItemHunterClothes.isFullSetWorn(event.entityLiving, false)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.NORMAL)
        public void FillBucket(FillBucketEvent event) {
            ItemStack result = this.attemptFill(event.world, event.target);
            if (result != null) {
                event.result = result;
                event.setResult(Event.Result.ALLOW);
            }
        }

        private ItemStack attemptFill(World world, MovingObjectPosition p) {
            Block id = world.getBlock(p.blockX, p.blockY, p.blockZ);
            if (id == Witchery.Blocks.FLOWING_SPIRIT) {
                if (world.getBlockMetadata(p.blockX, p.blockY, p.blockZ) == 0) {
                    world.setBlock(p.blockX, p.blockY, p.blockZ, Blocks.air);
                    return new ItemStack(Witchery.Items.BUCKET_FLOWINGSPIRIT);
                }
            } else if (id == Witchery.Blocks.HOLLOW_TEARS && world.getBlockMetadata(p.blockX, p.blockY, p.blockZ) == 0) {
                world.setBlock(p.blockX, p.blockY, p.blockZ, Blocks.air);
                return new ItemStack(Witchery.Items.BUCKET_HOLLOWTEARS);
            }
            return null;
        }

        @SubscribeEvent
        public void onLivingDamage(LivingHurtEvent event) {
            if (event.entityLiving != null && event.entityLiving.worldObj != null && !event.entityLiving.worldObj.isRemote && event.entityLiving instanceof EntityPlayer && !event.isCanceled()) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                PredictionManager.instance().checkIfFulfilled(player, event);
            }
        }

        @SubscribeEvent
        public void onServerChat(ServerChatEvent event) {
            if (event.player != null && !event.isCanceled() && !event.player.worldObj.isRemote && event.message != null) {
                Witchery.Items.RUBY_SLIPPERS.trySayTheresNoPlaceLikeHome((EntityPlayer)event.player, event.message);
            }
        }

        @SubscribeEvent
        public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
            if (event.harvester != null && event.harvester.worldObj != null && !event.harvester.worldObj.isRemote) {
                PredictionManager.instance().checkIfFulfilled(event.harvester, event);
                PlayerEffects.onHarvestDrops(event.harvester, event);
                EntityAIDigBlocks.onHarvestDrops(event.harvester, event);
            }
            if (!event.world.isRemote && event.world.provider.dimensionId == Config.instance().dimensionDreamID && !event.isCanceled()) {
                Iterator iterator = event.drops.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = (ItemStack)iterator.next();
                    if (stack == null || !this.isBannedSpiritObject(stack)) continue;
                    iterator.remove();
                }
            }
        }

        @SubscribeEvent
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (event.entityLiving != null && event.entityLiving.worldObj != null && !event.entityLiving.worldObj.isRemote && event.entityLiving instanceof EntityPlayer && !event.isCanceled()) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                PredictionManager.instance().checkIfFulfilled(player, event);
                PlayerEffects.onInteract(player, event);
            }
        }

        @SubscribeEvent
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            Block blockID;
            ItemStack belt;
            long counter = event.entityLiving.worldObj.getTotalWorldTime();
            if (event.entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                if (!event.entityLiving.worldObj.isRemote) {
                    long time = TimeUtil.getServerTimeInTicks();
                    if (counter % 4L == 0L) {
                        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
                        this.handleBrewGrotesqueEffect(player, nbtPlayer);
                        WorldProviderDreamWorld.updatePlayerEffects(player.worldObj, player, nbtPlayer, time, counter);
                        WorldProviderTorment.updatePlayerEffects(player.worldObj, player, nbtPlayer, time, counter);
                        if (counter % 20L == 0L) {
                            this.handleSyncEffects(player, nbtPlayer);
                            this.handleBrewDepthsEffect(player, nbtPlayer);
                            this.handleCurseEffects((EntityLivingBase)player, nbtPlayer);
                            this.handleSeepingShoesEffect(player, nbtPlayer);
                            InfusedBrewEffect.checkActiveEffects(player.worldObj, player, nbtPlayer, counter % 1200L == 0L, time);
                        }
                        if (counter % 100L == 0L && !event.isCanceled()) {
                            NBTTagList nbtCovenList;
                            ChunkCoordinates coords;
                            PredictionManager.instance().checkIfFulfilled(player, event);
                            if (Config.instance().allowCovenWitchVisits && nbtPlayer.hasKey("WITCCoven") && player.worldObj.rand.nextInt(20) == 0 && (coords = player.getBedLocation(player.dimension)) != null && coords.getDistanceSquared((int)player.posX, (int)player.posY, (int)player.posZ) < 256.0f && (nbtCovenList = nbtPlayer.getTagList("WITCCoven", 10)).tagCount() > 0) {
                                EntityCovenWitch.summonCovenMember(player.worldObj, player, 90);
                            }
                        }
                    }
                    PlayerEffects.onUpdate(player, time);
                    if (counter % 100L == 1L) {
                        EntityWitchHunter.handleWitchHunterEffects(player, time);
                    }
                }
                this.handleIcySlippersEffect(player);
                this.handleFamiliarFollowerSync(player);
            } else if (!event.entityLiving.worldObj.isRemote && counter % 20L == 0L) {
                this.handleCurseEffects(event.entityLiving, event.entityLiving.getEntityData());
            }
            if (counter % 100L == 0L && (belt = event.entityLiving.getEquipmentInSlot(2)) != null && belt.getItem() == Witchery.Items.BARK_BELT && ((blockID = event.entityLiving.worldObj.getBlock(MathHelper.floor_double((double)event.entityLiving.posX), MathHelper.floor_double((double)event.entityLiving.posY) - 1, MathHelper.floor_double((double)event.entityLiving.posZ))) == Blocks.grass || blockID == Blocks.mycelium)) {
                int maxChargeLevel = Witchery.Items.BARK_BELT.getMaxChargeLevel(event.entityLiving);
                int currentChargeLevel = Witchery.Items.BARK_BELT.getChargeLevel(belt);
                if (currentChargeLevel < maxChargeLevel) {
                    Witchery.Items.BARK_BELT.setChargeLevel(belt, Math.min(currentChargeLevel + 1, maxChargeLevel));
                    event.entityLiving.worldObj.playSoundAtEntity((Entity)event.entityLiving, "witchery:random.wood_creak", 0.5f, (float)(0.8 + 2.0 * event.entityLiving.worldObj.rand.nextGaussian()));
                }
            }
        }

        private void handleSeepingShoesEffect(EntityPlayer player, NBTTagCompound nbtTag) {
            if (!player.onGround) {
                return;
            }
            if (!player.isPotionActive(Potion.poison) && !player.isPotionActive(Potion.wither)) {
                return;
            }
            ItemStack shoes = player.getEquipmentInSlot(1);
            if (shoes == null || shoes.getItem() != Witchery.Items.SEEPING_SHOES) {
                return;
            }
            boolean poisonRemoved = false;
            if (player.isPotionActive(Potion.poison)) {
                player.removePotionEffect(Potion.poison.id);
                poisonRemoved = true;
            }
            if (player.isPotionActive(Potion.wither)) {
                player.removePotionEffect(Potion.wither.id);
                poisonRemoved = true;
            }
            if (poisonRemoved) {
                int x = MathHelper.floor_double((double)player.posX);
                int z = MathHelper.floor_double((double)player.posZ);
                int y = MathHelper.floor_double((double)player.posY);
                int RADIUS = 3;
                int RADIUS_SQ = 9;
                for (int dx = x - 3; dx <= x + 3; ++dx) {
                    for (int dz = z - 3; dz <= z + 3; ++dz) {
                        for (int dy = y - 1; dy <= y + 1; ++dy) {
                            if (!(Coord.distanceSq(dx, 1.0, dy, x, 1.0, dy) <= 9.0) || !player.worldObj.isAirBlock(dx, dy + 1, dz) || player.worldObj.isAirBlock(dx, dy, dz)) continue;
                            ItemDye.applyBonemeal((ItemStack)Dye.BONE_MEAL.createStack(), (World)player.worldObj, (int)dx, (int)dy, (int)dz, (EntityPlayer)player);
                        }
                    }
                }
            }
        }

        private void handleSyncEffects(EntityPlayer player, NBTTagCompound nbtPlayer) {
            long nextSync;
            if (!player.worldObj.isRemote && nbtPlayer.hasKey(Infusion.INFUSION_NEXTSYNC) && (nextSync = nbtPlayer.getLong(Infusion.INFUSION_NEXTSYNC)) <= MinecraftServer.getSystemTimeMillis()) {
                nbtPlayer.removeTag(Infusion.INFUSION_NEXTSYNC);
                Witchery.packetPipeline.sendToDimension(new PacketPlayerStyle(player), player.dimension);
            }
        }

        private void handleFamiliarFollowerSync(EntityPlayer player) {
            if (!player.worldObj.isRemote) {
                NBTTagCompound compound = player.getEntityData();
                if (compound.hasKey("WITC_LASTPOS")) {
                    NBTTagCompound pos = compound.getCompoundTag("WITC_LASTPOS");
                    int lastDimension = pos.getInteger("D");
                    if (lastDimension != player.dimension || Math.abs(pos.getDouble("X") - player.posX) > 32.0 || Math.abs(pos.getDouble("Z") - player.posZ) > 32.0) {
                        EntityTameable familiar;
                        if (lastDimension != player.dimension && player.dimension == -1 || lastDimension == -1) {
                            NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
                            nbtPlayer.setBoolean("WITCVisitedNether", true);
                        }
                        if (Familiar.hasActiveFamiliar(player) && (familiar = Familiar.getFamiliarEntity(player)) != null && !familiar.isSitting()) {
                            int ipx = MathHelper.floor_double((double)player.posX) - 2;
                            int j = MathHelper.floor_double((double)player.posZ) - 2;
                            int k = MathHelper.floor_double((double)player.boundingBox.minY) - 2;
                            boolean done = false;
                            for (int l = 0; l <= 4 && !done; ++l) {
                                for (int i1 = 0; i1 <= 4 && !done; ++i1) {
                                    for (int dy = 0; dy <= 4 && !done; ++dy) {
                                        if (!player.worldObj.getBlock(ipx + l, k + dy - 1, j + i1).isSideSolid((IBlockAccess)player.worldObj, ipx + l, k + dy - 1, j + i1, ForgeDirection.UP) || player.worldObj.getBlock(ipx + l, k + dy, j + i1).isNormalCube() || player.worldObj.getBlock(ipx + l, k + dy + 1, j + i1).isNormalCube()) continue;
                                        ItemGeneral cfr_ignored_0 = Witchery.Items.GENERIC;
                                        ItemGeneral.teleportToLocation(player.worldObj, 0.5 + (double)ipx + (double)l, k + dy, 0.5 + (double)j + (double)i1, player.dimension, (Entity)familiar, true);
                                        done = true;
                                    }
                                }
                            }
                        }
                    }
                    pos.setDouble("X", player.posX);
                    pos.setDouble("Z", player.posZ);
                    pos.setInteger("D", player.dimension);
                } else {
                    NBTTagCompound pos = new NBTTagCompound();
                    pos.setDouble("X", player.posX);
                    pos.setDouble("Z", player.posZ);
                    pos.setInteger("D", player.dimension);
                    pos.setBoolean("visitedNether", player.dimension == -1);
                }
            }
        }

        private void handleIcySlippersEffect(EntityPlayer player) {
            ItemStack shoes = player.getCurrentArmor(0);
            if (shoes != null && shoes.getItem() == Witchery.Items.ICY_SLIPPERS) {
                int k = MathHelper.floor_double((double)(player.posY - 1.0));
                for (int i = 0; i < 4; ++i) {
                    int l;
                    int j = MathHelper.floor_double((double)(player.posX + (double)((float)(i % 2 * 2 - 1) * 0.5f)));
                    Block blockID = player.worldObj.getBlock(j, k, l = MathHelper.floor_double((double)(player.posZ + (double)((float)(i / 2 % 2 * 2 - 1) * 0.5f))));
                    if (blockID == Blocks.flowing_water || blockID == Blocks.water) {
                        player.worldObj.setBlock(j, k, l, Blocks.ice);
                        continue;
                    }
                    if (blockID != Blocks.flowing_lava && blockID != Blocks.lava) continue;
                    player.worldObj.setBlock(j, k, l, Blocks.obsidian);
                    if (player.worldObj.rand.nextInt(10) != 0) continue;
                    shoes.damageItem(1, (EntityLivingBase)player);
                }
            }
        }

        private void handleBrewDepthsEffect(EntityPlayer player, NBTTagCompound nbtTag) {
            if (nbtTag.hasKey(Infusion.INFUSION_DEPTHS)) {
                int timeLeft = nbtTag.getInteger(Infusion.INFUSION_DEPTHS);
                if (timeLeft > 0) {
                    if (!player.isPotionActive(Potion.waterBreathing)) {
                        player.addPotionEffect(new PotionEffect(Potion.waterBreathing.id, 6000));
                    }
                    if (!player.isInsideOfMaterial(Material.water)) {
                        if (!player.isPotionActive(Potion.wither)) {
                            player.addPotionEffect(new PotionEffect(Potion.wither.id, 100, 1));
                        }
                    } else if (player.isPotionActive(Potion.wither)) {
                        player.removePotionEffect(Potion.wither.id);
                    }
                }
                if (--timeLeft <= 0) {
                    nbtTag.removeTag(Infusion.INFUSION_DEPTHS);
                    if (player.isPotionActive(Potion.waterBreathing)) {
                        player.removePotionEffect(Potion.waterBreathing.id);
                    }
                    if (player.isPotionActive(Potion.poison)) {
                        player.removePotionEffect(Potion.poison.id);
                    }
                } else {
                    nbtTag.setInteger(Infusion.INFUSION_DEPTHS, timeLeft);
                }
            }
        }

        private void handleBrewGrotesqueEffect(EntityPlayer player, NBTTagCompound nbtTag) {
            if (nbtTag.hasKey(Infusion.INFUSION_GROTESQUE)) {
                int timeLeft = nbtTag.getInteger(Infusion.INFUSION_GROTESQUE);
                if (timeLeft > 0) {
                    float radius = 4.0f;
                    AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 4.0), (double)(player.posY - 4.0), (double)(player.posZ - 4.0), (double)(player.posX + 4.0), (double)(player.posY + 4.0), (double)(player.posZ + 4.0));
                    List list = player.worldObj.getEntitiesWithinAABB(EntityLiving.class, bounds);
                    for (EntityLiving entity : list) {
                        boolean victim = !(entity instanceof EntityDemon) && !(entity instanceof IBossDisplayData) && !(entity instanceof EntityGolem) && !(entity instanceof EntityWitch);
                        if (!victim || !(Coord.distance(entity.posX, entity.posY, entity.posZ, player.posX, player.posY, player.posZ) < 4.0)) continue;
                        RiteProtectionCircleRepulsive.push(player.worldObj, (Entity)entity, player.posX, player.posY, player.posZ);
                    }
                }
                if (--timeLeft <= 0) {
                    nbtTag.removeTag(Infusion.INFUSION_GROTESQUE);
                    Witchery.packetPipeline.sendToDimension(new PacketPlayerStyle(player), player.dimension);
                } else {
                    nbtTag.setInteger(Infusion.INFUSION_GROTESQUE, timeLeft);
                }
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private void handleCurseEffects(EntityLivingBase entity, NBTTagCompound nbtTag) {
            block39: {
                block40: {
                    block41: {
                        if (entity == null || nbtTag == null) break block39;
                        if (!(entity instanceof EntityPlayer) && nbtTag.hasKey("witcherySinking")) {
                            level = nbtTag.getInteger("witcherySinking");
                            if (level > 0) {
                                if (entity.isInWater() || entity instanceof EntityPlayer && !entity.onGround) {
                                    if (entity.motionY < 0.0) {
                                        entity.motionY *= 1.0 + Math.min(0.1 * (double)level, 0.4);
                                    } else if (entity.motionY > 0.0) {
                                        entity.motionY *= 1.0 - Math.min(0.1 * (double)level, 0.4);
                                    }
                                }
                            } else {
                                nbtTag.removeTag("witcherySinking");
                            }
                        }
                        if (!nbtTag.hasKey("witcheryCursed")) break block40;
                        level = nbtTag.getInteger("witcheryCursed");
                        if (level <= 0) break block41;
                        if (entity.isPotionActive(Potion.blindness.id) || entity.isPotionActive(Potion.weakness.id) || entity.isPotionActive(Potion.digSlowdown.id) || entity.isPotionActive(Potion.moveSlowdown.id) || entity.isPotionActive(Potion.poison.id) || entity.worldObj.rand.nextInt(20) != 0) break block40;
                        switch (entity.worldObj.rand.nextInt(level >= 5 ? 6 : (level >= 4 ? 5 : (level >= 3 ? 4 : (level >= 2 ? 3 : 2))))) {
                            case 0: {
                                entity.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, 600, Math.min(level - 1, 4)));
                                break;
                            }
                            case 1: {
                                entity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 600, Math.min(level - 1, 4)));
                                break;
                            }
                            case 2: {
                                entity.addPotionEffect(new PotionEffect(Potion.weakness.id, (13 + 2 * level) * 20, Math.min(level - 2, 4)));
                                break;
                            }
                            case 3: {
                                entity.addPotionEffect(new PotionEffect(Potion.blindness.id, 5 * level * 20));
                                if (level <= 5) break;
                                entity.addPotionEffect(new PotionEffect(Potion.nightVision.id, 5 * level * 20));
                                break;
                            }
                            case 5: {
                                if (!(entity instanceof EntityPlayer)) ** GOTO lbl42
                                player = (EntityPlayer)entity;
                                heldItemIndex = player.inventory.currentItem;
                                if (player.inventory.mainInventory[heldItemIndex] != null) {
                                    player.dropPlayerItemWithRandomChoice(player.inventory.mainInventory[heldItemIndex], true);
                                    player.inventory.mainInventory[heldItemIndex] = null;
                                    break;
                                }
                                break block40;
lbl42:
                                // 1 sources

                                heldItem = entity.getHeldItem();
                                if (heldItem == null) break;
                                Infusion.dropEntityItemWithRandomChoice(entity, heldItem, true);
                                entity.setCurrentItemOrArmor(0, null);
                            }
                        }
                        break block40;
                    }
                    nbtTag.removeTag("witcheryCursed");
                }
                if (nbtTag.hasKey("witcheryOverheating")) {
                    level = nbtTag.getInteger("witcheryOverheating");
                    if (level > 0) {
                        world = entity.worldObj;
                        if (!entity.isBurning() && world.rand.nextInt(level > 2 ? 20 : (level > 1 ? 25 : 30)) == 0) {
                            x = MathHelper.floor_double((double)entity.posX);
                            z = MathHelper.floor_double((double)entity.posZ);
                            biome = world.getBiomeGenForCoords(x, z);
                            if (!(!((double)biome.temperature >= 1.5) || biome.canSpawnLightningBolt() && world.isRaining() || entity.isInWater())) {
                                entity.setFire(Math.min(world.rand.nextInt(level < 4 ? 2 : level - 1) + 1, 4));
                            }
                        }
                    } else {
                        nbtTag.removeTag("witcheryOverheating");
                    }
                }
                if (nbtTag.hasKey("witcheryWakingNightmare") && entity instanceof EntityPlayer) {
                    player = (EntityPlayer)entity;
                    level = nbtTag.getInteger("witcheryWakingNightmare");
                    if (level > 0 && player.dimension != Config.instance().dimensionDreamID) {
                        world = player.worldObj;
                        if (world.rand.nextInt(level > 4 ? 30 : (level > 2 ? 60 : 180)) == 0) {
                            R = 16.0;
                            H = 8.0;
                            bounds = AxisAlignedBB.getBoundingBox((double)(entity.posX - 16.0), (double)(entity.posY - 8.0), (double)(entity.posZ - 16.0), (double)(entity.posX + 16.0), (double)(entity.posY + 8.0), (double)(entity.posZ + 16.0));
                            entities = world.getEntitiesWithinAABB(EntityNightmare.class, bounds);
                            doNothing = false;
                            for (E obj : entities) {
                                nightmare = (EntityNightmare)obj;
                                if (!nightmare.getVictimName().equalsIgnoreCase(player.getCommandSenderName())) continue;
                                doNothing = true;
                                break;
                            }
                            if (!doNothing) {
                                Infusion.spawnCreature(world, EntityNightmare.class, MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ), player, 2, 6);
                            }
                        }
                    } else {
                        nbtTag.removeTag("witcheryWakingNightmare");
                    }
                }
                if (entity instanceof EntityPlayer && nbtTag.hasKey("witcheryInsanity")) {
                    level = nbtTag.getInteger("witcheryInsanity");
                    if (level > 0) {
                        world = entity.worldObj;
                        x = MathHelper.floor_double((double)entity.posX);
                        y = MathHelper.floor_double((double)entity.posY);
                        z = MathHelper.floor_double((double)entity.posZ);
                        if (world.rand.nextInt(level > 2 ? 25 : (level > 1 ? 30 : 35)) == 0) {
                            creatureType /* !! */  = null;
                            switch (world.rand.nextInt(3)) {
                                default: {
                                    creatureType /* !! */  = EntityIllusionCreeper.class;
                                    break;
                                }
                                case 1: {
                                    creatureType /* !! */  = EntityIllusionSpider.class;
                                    break;
                                }
                                case 2: {
                                    creatureType /* !! */  = EntityIllusionZombie.class;
                                }
                            }
                            MAX_DISTANCE = 9;
                            MIN_DISTANCE = 4;
                            Infusion.spawnCreature(world, creatureType /* !! */ , x, y, z, (EntityPlayer)entity, 4, 9);
                        } else if (level >= 4 && world.rand.nextInt(20) == 0) {
                            sound = SoundEffect.NONE;
                            switch (world.rand.nextInt(3)) {
                                default: {
                                    sound = SoundEffect.RANDOM_EXPLODE;
                                    break;
                                }
                                case 1: {
                                    sound = SoundEffect.MOB_ENDERMAN_IDLE;
                                }
                            }
                            sound.playOnlyTo((EntityPlayer)entity, 1.0f, 1.0f);
                        }
                    } else {
                        nbtTag.removeTag("witcheryInsanity");
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onLivingDeath(LivingDeathEvent event) {
            if (!event.entityLiving.worldObj.isRemote && !event.isCanceled()) {
                if (event.entityLiving instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)event.entity;
                    World world = player.worldObj;
                    NBTTagCompound nbtTag = Infusion.getNBT((Entity)player);
                    if (nbtTag.hasKey(Infusion.INFUSION_DEPTHS)) {
                        nbtTag.removeTag(Infusion.INFUSION_DEPTHS);
                    }
                    PlayerEffects.onDeath(player);
                }
                Familiar.handleLivingDeath(event);
            }
        }

        @SubscribeEvent
        public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
            if (event.target != null && event.entityLiving instanceof EntityLiving) {
                EntityLiving aggressorEntity = (EntityLiving)event.entityLiving;
                if (event.target instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)event.target;
                    if (player.isInvisible()) {
                        if (aggressorEntity.worldObj.getClosestVulnerablePlayer(aggressorEntity.posX, aggressorEntity.posY, aggressorEntity.posZ, 16.0) != event.target) {
                            aggressorEntity.setAttackTarget(null);
                        }
                    } else if (aggressorEntity.isPotionActive(Potion.blindness)) {
                        aggressorEntity.setAttackTarget(null);
                    } else if (aggressorEntity instanceof EntityCreeper) {
                        ItemStack stack = player.inventory.armorItemInSlot(2);
                        if (stack != null && stack.getItem() == Witchery.Items.WITCH_ROBES) {
                            aggressorEntity.setAttackTarget(null);
                        }
                    } else if (aggressorEntity.isEntityUndead()) {
                        if (aggressorEntity instanceof EntityZombie && ExtendedPlayer.get(player).getVampireLevel() >= 10) {
                            aggressorEntity.setAttackTarget(null);
                        } else {
                            ItemStack stack = player.inventory.armorItemInSlot(2);
                            if (stack != null && stack.getItem() == Witchery.Items.NECROMANCERS_ROBES) {
                                aggressorEntity.setAttackTarget(null);
                            }
                        }
                    }
                }
                if (event.target instanceof EntityVillageGuard && event.entityLiving instanceof EntityGolem) {
                    aggressorEntity.setAttackTarget(null);
                } else if (Config.instance().isZombeIgnoreVillagerActive() && event.target instanceof EntityVillager && event.entityLiving instanceof EntityZombie) {
                    aggressorEntity.setAttackTarget(null);
                }
            }
        }

        @SubscribeEvent
        public void onLivingFall(LivingFallEvent event) {
            if (event.entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                Registry.instance().get(player).onFalling(player.worldObj, player, event);
            }
        }

        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent event) {
            if (event.entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                if (event.source.isFireDamage() && event.isCancelable() && !event.isCanceled() && player.getCurrentArmor(2) != null && player.getCurrentArmor(2).getItem() == Witchery.Items.DEATH_ROBE) {
                    if (!player.isPotionActive(Potion.fireResistance.id)) {
                        player.addPotionEffect(new PotionEffect(Potion.fireResistance.id, 100, 0));
                    }
                    event.setCanceled(true);
                }
                if (!event.isCanceled()) {
                    Registry.instance().get(player).onHurt(player.worldObj, player, event);
                }
            }
        }
    }
}

