/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions;

import com.emoniph.witchery.brewing.potions.PotionEnslaved;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.InfusionOtherwhere;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePower;
import com.emoniph.witchery.util.BlockSide;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class InfusionInfernal
extends Infusion {
    private static final int MAX_CHARGES = 20;

    public InfusionInfernal(int infusionID) {
        super(infusionID);
    }

    @Override
    public IIcon getPowerBarIcon(EntityPlayer player, int index) {
        return Blocks.netherrack.getIcon(0, 0);
    }

    @Override
    public void onLeftClickEntity(ItemStack itemstack, World world, EntityPlayer player, Entity otherEntity) {
        if (!world.isRemote && otherEntity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)otherEntity;
            if (player.isSneaking()) {
                if (PotionEnslaved.canCreatureBeEnslaved(entityLivingBase)) {
                    EntityLiving entityLiving = (EntityLiving)entityLivingBase;
                    if (PotionEnslaved.isMobEnslavedBy(entityLiving, player)) {
                        if (this.consumeCharges(world, player, 1, true)) {
                            this.trySacrificeCreature(world, player, entityLiving);
                        }
                    } else if (this.consumeCharges(world, player, 5, true)) {
                        PotionEnslaved.setEnslaverForMob(entityLiving, player);
                        EntityUtil.dropAttackTarget((EntityLiving)otherEntity);
                        ParticleEffect.SPELL.send(SoundEffect.MOB_ZOMBIE_INFECT, (Entity)entityLiving, 1.0, 2.0, 16);
                    }
                } else {
                    SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
                }
            } else {
                int r = 50;
                if (this.consumeCharges(world, player, 1, true)) {
                    int minionCount = 0;
                    AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 50.0), (double)(player.posY - 15.0), (double)(player.posZ - 50.0), (double)(player.posX + 50.0), (double)(player.posY + 15.0), (double)(player.posZ + 50.0));
                    for (Object obj : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                        EntityLiving nearbyLivingEntity = (EntityLiving)obj;
                        if (!PotionEnslaved.isMobEnslavedBy(nearbyLivingEntity, player)) continue;
                        ++minionCount;
                        nearbyLivingEntity.setAttackTarget(entityLivingBase);
                        if (nearbyLivingEntity instanceof EntityGhast) {
                            try {
                                EntityGhast ghastEntity = (EntityGhast)nearbyLivingEntity;
                                Field[] fields = EntityGhast.class.getDeclaredFields();
                                Field fieldTargetedEntity = fields[4];
                                fieldTargetedEntity.setAccessible(true);
                                fieldTargetedEntity.set(ghastEntity, entityLivingBase);
                                Field fieldAggroCooldown = fields[5];
                                fieldAggroCooldown.setAccessible(true);
                                fieldAggroCooldown.set(ghastEntity, 20000);
                            }
                            catch (IllegalAccessException e) {
                                Log.instance().warning(e, "Exception occurred setting ghast target.");
                            }
                            catch (Exception e) {
                                Log.instance().debug(String.format("Exception occurred setting ghast target. %s", e.toString()));
                            }
                        }
                        if (!(nearbyLivingEntity instanceof EntityCreature)) continue;
                        EntityCreature nearbyCreatureEntity = (EntityCreature)obj;
                        nearbyCreatureEntity.setTarget((Entity)entityLivingBase);
                        nearbyCreatureEntity.setRevengeTarget(entityLivingBase);
                        if (!(nearbyCreatureEntity instanceof EntityZombie) && !(nearbyCreatureEntity instanceof EntityCreeper)) continue;
                        nearbyCreatureEntity.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide(nearbyCreatureEntity, entityLivingBase.getClass(), 1.0, false));
                    }
                    if (minionCount > 0) {
                        ParticleEffect.CRIT.send(SoundEffect.RANDOM_BREATH, (Entity)entityLivingBase, 0.5, 2.0, 16);
                    }
                }
            }
        }
    }

    private void trySacrificeCreature(World world, EntityPlayer player, EntityLiving creature) {
        CreaturePower power = CreaturePower.Registry.instance().get(creature);
        if (power != null) {
            int currentCreaturePowerID = CreaturePower.getCreaturePowerID(player);
            if (currentCreaturePowerID == power.getCreaturePowerID()) {
                int currentCharges = CreaturePower.getCreaturePowerCharges(player);
                CreaturePower.setCreaturePowerCharges(player, MathHelper.floor_double((double)Math.min(currentCharges + power.getChargesPerSacrifice(), 20)));
            } else {
                CreaturePower.setCreaturePowerID(player, power.getCreaturePowerID(), power.getChargesPerSacrifice());
            }
            InfusionInfernal.syncPlayer(world, player);
            creature.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)player, null), creature.getHealth() + 1.0f);
        } else {
            this.playFailSound(world, player);
        }
    }

    @Override
    public void onHurt(World worldObj, EntityPlayer player, LivingHurtEvent event) {
        int creaturePowerID = CreaturePower.getCreaturePowerID(player);
        if (creaturePowerID > 0) {
            CreaturePower.Registry.instance().get(creaturePowerID).onDamage(player.worldObj, player, event);
        }
    }

    @Override
    public void onFalling(World world, EntityPlayer player, LivingFallEvent event) {
        int creaturePowerID = CreaturePower.getCreaturePowerID(player);
        if (creaturePowerID > 0) {
            CreaturePower.Registry.instance().get(creaturePowerID).onFalling(world, player, event);
        }
    }

    @Override
    public void onUsingItemTick(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        block12: {
            MovingObjectPosition mop;
            int elapsedTicks;
            block13: {
                block14: {
                    if (world.isRemote) break block12;
                    elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
                    double MAX_TARGET_RANGE = 15.0;
                    mop = InfusionOtherwhere.doCustomRayTrace(world, player, true, 15.0);
                    if (!player.isSneaking()) break block13;
                    if (mop == null) break block14;
                    switch (mop.typeOfHit) {
                        case ENTITY: {
                            this.playFailSound(world, player);
                            break;
                        }
                        case BLOCK: {
                            if (!BlockSide.TOP.isEqual(mop.sideHit)) break;
                            int minionCount = 0;
                            int r = 50;
                            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 50.0), (double)(player.posY - 15.0), (double)(player.posZ - 50.0), (double)(player.posX + 50.0), (double)(player.posY + 15.0), (double)(player.posZ + 50.0));
                            for (Object obj : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                                EntityCreature creature2;
                                EntityLiving creature = (EntityLiving)obj;
                                EntityCreature entityCreature = creature2 = creature instanceof EntityCreature ? (EntityCreature)creature : null;
                                if (!PotionEnslaved.isMobEnslavedBy(creature, player)) continue;
                                ++minionCount;
                                creature.setAttackTarget(null);
                                creature.setRevengeTarget(null);
                                if (creature2 != null) {
                                    creature2.setTarget(null);
                                }
                                if (!(creature instanceof EntitySpider) && creature.getNavigator().tryMoveToXYZ((double)mop.blockX, (double)(mop.blockY + 1), (double)mop.blockZ, 1.0) || creature2 == null) continue;
                                creature2.setPathToEntity(world.getEntityPathToXYZ((Entity)creature, mop.blockX, mop.blockY + 1, mop.blockZ, 10.0f, true, false, false, true));
                            }
                            if (minionCount > 0) {
                                ParticleEffect.INSTANT_SPELL.send(SoundEffect.RANDOM_POP, world, mop.blockX, mop.blockY + 1, mop.blockZ, 0.5, 2.0, 16);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block12;
                }
                this.playFailSound(world, player);
                break block12;
            }
            int beastPowerID = CreaturePower.getCreaturePowerID(player);
            if (beastPowerID > 0) {
                CreaturePower power = CreaturePower.Registry.instance().get(beastPowerID);
                int chargesRequired = power.activateCost(world, player, elapsedTicks, mop);
                int currentCharges = CreaturePower.getCreaturePowerCharges(player);
                if (currentCharges - chargesRequired >= 0 && this.consumeCharges(world, player, 1, true)) {
                    power.onActivate(world, player, elapsedTicks, mop);
                    if (!player.capabilities.isCreativeMode) {
                        CreaturePower.setCreaturePowerCharges(player, currentCharges - chargesRequired);
                        InfusionInfernal.syncPlayer(world, player);
                    }
                } else {
                    this.playFailSound(world, player);
                }
            } else {
                this.playFailSound(world, player);
            }
        }
    }
}

