/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions.spirit;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityBanshee;
import com.emoniph.witchery.entity.EntityPoltergeist;
import com.emoniph.witchery.entity.EntitySpectre;
import com.emoniph.witchery.entity.EntitySpirit;
import com.emoniph.witchery.infusion.infusions.spirit.IFetishTile;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritEnhancedPoppetEffect;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritGhostWalkerEffect;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritScreamerEffect;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritSentinalEffect;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritTwisterEffect;
import com.emoniph.witchery.util.Const;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class InfusedSpiritEffect {
    public static final ArrayList<InfusedSpiritEffect> effectList = new ArrayList();
    public static final InfusedSpiritEffect POPPET_ENHANCEMENT = new InfusedSpiritEnhancedPoppetEffect(1, 3, 1, 1, 1);
    public static final InfusedSpiritEffect SENTINAL = new InfusedSpiritSentinalEffect(2, 3, 3, 0, 0);
    public static final InfusedSpiritEffect SCREAMER = new InfusedSpiritScreamerEffect(3, 3, 0, 2, 0);
    public static final InfusedSpiritEffect TWISTER = new InfusedSpiritTwisterEffect(4, 3, 0, 0, 2);
    public static final InfusedSpiritEffect GHOST_WALKER = new InfusedSpiritGhostWalkerEffect(5, 3, 1, 1, 0);
    public static final InfusedSpiritEffect DEATH = new InfusedSpiritEffect(6, "death", 0, 5, 5, 5, false){

        @Override
        public boolean doUpdateEffect(TileEntity tile, boolean triggered, ArrayList<EntityLivingBase> foundEntities) {
            return true;
        }
    };
    public static final double RANGE = 16.0;
    public static final double RANGE_SQ = 256.0;
    public final int id;
    public final int spirits;
    public final int spectres;
    public final int banshees;
    public final int poltergeists;
    public final String unlocalizedName;
    private boolean inBook;
    private String localizedName = null;

    protected InfusedSpiritEffect(int id, String unlocalizedName, int spirits, int spectres, int banshees, int poltergeists) {
        this(id, unlocalizedName, spirits, spectres, banshees, poltergeists, true);
    }

    protected InfusedSpiritEffect(int id, String unlocalizedName, int spirits, int spectres, int banshees, int poltergeists, boolean inBook) {
        this.id = id;
        this.spirits = spirits;
        this.spectres = spectres;
        this.banshees = banshees;
        this.poltergeists = poltergeists;
        this.unlocalizedName = unlocalizedName;
        this.inBook = inBook;
        while (effectList.size() <= id) {
            effectList.add(null);
        }
        effectList.set(id, this);
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("\u00a7n");
        sb.append(this.getDisplayName());
        sb.append("\u00a7r");
        sb.append(Const.BOOK_NEWLINE);
        sb.append(Const.BOOK_NEWLINE);
        String description = Witchery.resource("witchery.fetish." + this.unlocalizedName + ".desc");
        if (!description.equals("witchery.fetish." + this.unlocalizedName + ".desc")) {
            sb.append(description);
            sb.append(Const.BOOK_NEWLINE);
            sb.append(Const.BOOK_NEWLINE);
        }
        sb.append(Witchery.resource("witchery.book.burning3"));
        sb.append(Const.BOOK_NEWLINE);
        sb.append(Const.BOOK_NEWLINE);
        if (this.spirits > 0) {
            sb.append(String.format("\u00a78>\u00a70  %s: %d", Witchery.resource("entity.witchery.spirit.name"), this.spirits));
            sb.append(Const.BOOK_NEWLINE);
        }
        if (this.spectres > 0) {
            sb.append(String.format("\u00a78>\u00a70  %s: %d", Witchery.resource("entity.witchery.spectre.name"), this.spectres));
            sb.append(Const.BOOK_NEWLINE);
        }
        if (this.banshees > 0) {
            sb.append(String.format("\u00a78>\u00a70  %s: %d", Witchery.resource("entity.witchery.banshee.name"), this.banshees));
            sb.append(Const.BOOK_NEWLINE);
        }
        if (this.poltergeists > 0) {
            sb.append(String.format("\u00a78>\u00a70  %s: %d", Witchery.resource("entity.witchery.poltergeist.name"), this.poltergeists));
            sb.append(Const.BOOK_NEWLINE);
        }
        return sb.toString();
    }

    private void setInBook(boolean inBook) {
        this.inBook = inBook;
    }

    public boolean isInBook() {
        return this.inBook;
    }

    private String getDisplayName() {
        if (this.localizedName == null) {
            this.localizedName = Witchery.resource("witchery.fetish." + this.unlocalizedName + ".name");
        }
        return this.localizedName;
    }

    public boolean isBound(IFetishTile tile) {
        return tile.getEffectType() == this.id;
    }

    public int getCooldownTicks() {
        return -1;
    }

    public static int tryBindFetish(World world, ItemStack stack, ArrayList<EntitySpirit> spiritList, ArrayList<EntitySpectre> spectreList, ArrayList<EntityBanshee> bansheeList, ArrayList<EntityPoltergeist> poltergeistList) {
        for (InfusedSpiritEffect effect : effectList) {
            if (effect == null || effect.spirits > spiritList.size() || effect.spectres > spectreList.size() || effect.banshees > bansheeList.size() || effect.poltergeists > poltergeistList.size()) continue;
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = stack.getTagCompound();
            nbtRoot.setInteger("WITCSpiritEffect", effect.id);
            InfusedSpiritEffect.consumeSpirits(world, effect.spirits, spiritList);
            InfusedSpiritEffect.consumeSpirits(world, effect.spectres, spectreList);
            InfusedSpiritEffect.consumeSpirits(world, effect.banshees, bansheeList);
            InfusedSpiritEffect.consumeSpirits(world, effect.poltergeists, poltergeistList);
            return effect == DEATH ? 2 : 1;
        }
        return 0;
    }

    private static <T extends EntityLiving> void consumeSpirits(World world, int count, ArrayList<T> list) {
        for (int i = 0; i < count; ++i) {
            EntityLiving entity = (EntityLiving)list.get(i);
            if (world.isRemote) continue;
            entity.setDead();
            ParticleEffect.PORTAL.send(SoundEffect.RANDOM_POP, (Entity)entity, 1.0, 2.0, 16);
        }
    }

    public static String getEffectDisplayName(ItemStack stack) {
        int effect;
        NBTTagCompound nbtRoot;
        if (stack.hasTagCompound() && (nbtRoot = stack.getTagCompound()).hasKey("WITCSpiritEffect") && (effect = nbtRoot.getInteger("WITCSpiritEffect")) > 0) {
            return effectList.get(effect).getDisplayName();
        }
        return null;
    }

    public static int getEffectID(ItemStack stack) {
        NBTTagCompound nbtRoot;
        if (stack.hasTagCompound() && (nbtRoot = stack.getTagCompound()).hasKey("WITCSpiritEffect")) {
            return nbtRoot.getInteger("WITCSpiritEffect");
        }
        return 0;
    }

    public static ItemStack setEffectID(ItemStack stack, int id) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = stack.getTagCompound();
        nbtRoot.setInteger("WITCSpiritEffect", id);
        return stack;
    }

    public static ItemStack setEffect(ItemStack stack, InfusedSpiritEffect effect) {
        return InfusedSpiritEffect.setEffectID(stack, effect.id);
    }

    public boolean isNearTo(EntityPlayer player) {
        for (Object obj : player.worldObj.loadedTileEntityList) {
            IFetishTile tile;
            if (!(obj instanceof IFetishTile) || !(player.getDistanceSq(0.5 + (double)(tile = (IFetishTile)obj).getX(), 0.5 + (double)tile.getY(), 0.5 + (double)tile.getZ()) <= 256.0) || !this.isBound(tile)) continue;
            return true;
        }
        return false;
    }

    public static InfusedSpiritEffect getEffect(IFetishTile tile) {
        return tile.getEffectType() > 0 ? effectList.get(tile.getEffectType()) : null;
    }

    public abstract boolean doUpdateEffect(TileEntity var1, boolean var2, ArrayList<EntityLivingBase> var3);

    public boolean isRedstoneSignaller() {
        return false;
    }

    public double getRadius() {
        return 0.0;
    }
}

