/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.WitcheryCreativeTab;
import com.emoniph.witchery.client.model.ModelClothesDeath;
import com.emoniph.witchery.infusion.infusions.InfusionOtherwhere;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.ItemUtil;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemDeathsClothes
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelClothesDeath modelClothesChest;
    private static final String BIBLIOCRAFT_ARMOR_STAND_ENTITY_NAME = "AbstractSteve";

    public ItemDeathsClothes(int armorSlot) {
        super(ItemArmor.ArmorMaterial.IRON, 1, armorSlot);
        this.setMaxDamage(ItemArmor.ArmorMaterial.DIAMOND.getDurability(armorSlot));
        this.setCreativeTab(WitcheryCreativeTab.INSTANCE);
    }

    public Item setUnlocalizedName(String itemName) {
        ItemUtil.registerItem((Item)this, itemName);
        return super.setUnlocalizedName(itemName);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack != null) {
            return "witchery:textures/entities/deathsclothes" + (type == null ? "" : "_overlay") + ".png";
        }
        return null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.isRemote && player.getCurrentArmor(3) == stack) {
            PotionEffect potion;
            int z;
            int y;
            int x;
            int offset = (int)(world.getTotalWorldTime() % 10L);
            if (Config.instance().allowDeathsHoodToFreezeVictims && offset == 1) {
                EntityLivingBase victim;
                MovingObjectPosition mop = InfusionOtherwhere.raytraceEntities(world, player, true, 16.0);
                if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit instanceof EntityLivingBase && (victim = (EntityLivingBase)mop.entityHit).canEntityBeSeen((Entity)player) && !victim.isPotionActive(Potion.moveSlowdown)) {
                    victim.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 60, 2));
                }
            } else if (offset == 2 && world.getBlockLightValue(x = MathHelper.floor_double((double)player.posX), y = MathHelper.floor_double((double)player.posY), z = MathHelper.floor_double((double)player.posZ)) < 8 && ((potion = player.getActivePotionEffect(Potion.nightVision)) == null || potion.getDuration() <= TimeUtil.secsToTicks(15))) {
                player.removePotionEffect(Potion.nightVision.id);
                player.addPotionEffect(new PotionEffect(Potion.nightVision.id, TimeUtil.secsToTicks(20), 0, true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelClothesDeath(0.4f);
        }
        ModelClothesDeath armorModel = null;
        if (stack != null && stack.getItem() instanceof ItemDeathsClothes) {
            int type = ((ItemArmor)stack.getItem()).armorType;
            armorModel = this.modelClothesChest;
            if (armorModel != null) {
                boolean isVisible = true;
                if (entityLiving != null && entityLiving.isInvisible()) {
                    String entityTypeName = entityLiving.getClass().getSimpleName();
                    isVisible = entityTypeName == null || entityTypeName.isEmpty() || entityTypeName.equals(BIBLIOCRAFT_ARMOR_STAND_ENTITY_NAME);
                }
                armorModel.bipedHead.showModel = isVisible && armorSlot == 0;
                armorModel.bipedHeadwear.showModel = isVisible && armorSlot == 0;
                armorModel.bipedBody.showModel = isVisible && armorSlot == 1;
                armorModel.bipedRightArm.showModel = isVisible && armorSlot == 1;
                armorModel.bipedLeftArm.showModel = isVisible && armorSlot == 1;
                armorModel.bipedRightLeg.showModel = isVisible && (armorSlot == 3 || armorSlot == 2);
                armorModel.bipedLeftLeg.showModel = isVisible && (armorSlot == 3 || armorSlot == 2);
                armorModel.isSneak = entityLiving.isSneaking();
                armorModel.isRiding = entityLiving.isRiding();
                armorModel.isChild = entityLiving.isChild();
                ItemStack heldStack = entityLiving.getEquipmentInSlot(0);
                armorModel.heldItemRight = heldStack != null ? 1 : 0;
                armorModel.aimedBow = false;
                if (entityLiving instanceof EntityPlayer && heldStack != null && ((EntityPlayer)entityLiving).getItemInUseDuration() > 0) {
                    EnumAction enumaction = heldStack.getItemUseAction();
                    if (enumaction == EnumAction.block) {
                        armorModel.heldItemRight = 3;
                    }
                    armorModel.aimedBow = enumaction == EnumAction.bow;
                }
                return armorModel;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.epic;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        String baseName = super.getItemStackDisplayName(stack);
        return baseName;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        String localText;
        if (stack != null && (stack.getItem() != Witchery.Items.DEATH_HOOD || Config.instance().allowDeathsHoodToFreezeVictims) && (localText = Witchery.resource(this.getUnlocalizedName() + ".tip")) != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
    }

    public static boolean isFullSetWorn(EntityLivingBase entity) {
        int count = 0;
        for (int i = 1; i <= 4; ++i) {
            ItemStack item = entity.getEquipmentInSlot(i);
            if (item == null || !(item.getItem() instanceof ItemDeathsClothes)) continue;
            ++count;
        }
        return count >= 3;
    }
}

