/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.WitcheryCreativeTab;
import com.emoniph.witchery.client.model.ModelEarmuffs;
import com.emoniph.witchery.util.ItemUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;

public class ItemEarmuffs
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelEarmuffs modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelEarmuffs modelClothesLegs;

    public ItemEarmuffs(int armorSlot) {
        super(ItemArmor.ArmorMaterial.CLOTH, 1, armorSlot);
        this.setMaxDamage(ItemArmor.ArmorMaterial.CLOTH.getDurability(armorSlot));
        this.setCreativeTab(WitcheryCreativeTab.INSTANCE);
    }

    public Item setUnlocalizedName(String itemName) {
        ItemUtil.registerItem((Item)this, itemName);
        return super.setUnlocalizedName(itemName);
    }

    public boolean hasColor(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int par2) {
        return super.getColorFromItemStack(stack, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return false;
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return 0xFFFFFF;
        }
        return super.getColor(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.common;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        String localText;
        if (stack != null && (localText = Witchery.resource(this.getUnlocalizedName() + ".tip")) != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack != null) {
            if (type == null) {
                return "witchery:textures/entities/earmuffs.png";
            }
            return "witchery:textures/entities/empty64x64_overlay.png";
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        int type;
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelEarmuffs();
        }
        ModelEarmuffs armorModel = null;
        if (stack != null && stack.getItem() instanceof ItemArmor && (armorModel = (type = ((ItemArmor)stack.getItem()).armorType) != 2 ? this.modelClothesChest : this.modelClothesChest) != null) {
            boolean isVisible = true;
            armorModel.bipedHead.showModel = isVisible && armorSlot == 0;
            armorModel.bipedHeadwear.showModel = isVisible && armorSlot == 0;
            armorModel.bipedBody.showModel = isVisible && (armorSlot == 1 || armorSlot == 2);
            armorModel.bipedRightArm.showModel = isVisible && armorSlot == 1;
            armorModel.bipedLeftArm.showModel = isVisible && armorSlot == 1;
            armorModel.bipedRightLeg.showModel = isVisible && (armorSlot == 3 || armorSlot == 2);
            armorModel.bipedLeftLeg.showModel = isVisible && (armorSlot == 3 || armorSlot == 2);
            armorModel.isSneak = entityLiving.isSneaking();
            armorModel.isRiding = entityLiving.isRiding();
            armorModel.isChild = entityLiving.isChild();
            ItemStack heldStack = entityLiving.getEquipmentInSlot(0);
            armorModel.heldItemRight = heldStack != null ? 1 : 0;
            armorModel.aimedBow = false;
            if (entityLiving instanceof EntityPlayer && heldStack != null && ((EntityPlayer)entityLiving).getItemInUseDuration() > 0) {
                EnumAction enumaction = heldStack.getItemUseAction();
                if (enumaction == EnumAction.block) {
                    armorModel.heldItemRight = 3;
                }
                armorModel.aimedBow = enumaction == EnumAction.bow;
            }
            return armorModel;
        }
        return null;
    }

    public static boolean isHelmWorn(EntityPlayer entity) {
        ItemStack currentArmor = entity.getCurrentArmor(3);
        return currentArmor != null && currentArmor.getItem() == Witchery.Items.EARMUFFS;
    }

    public static class ClientEventHooks {
        @SubscribeEvent
        public void onSound(PlaySoundEvent17 event) {
            Minecraft MC = Minecraft.getMinecraft();
            EntityClientPlayerMP player = MC.thePlayer;
            if (player != null && ItemEarmuffs.isHelmWorn((EntityPlayer)player)) {
                event.result = null;
            }
        }
    }
}

