/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.WitcheryCreativeTab;
import com.emoniph.witchery.client.model.ModelGoblinClothes;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.ServerTickEvents;
import com.emoniph.witchery.network.PacketPushTarget;
import com.emoniph.witchery.util.ItemUtil;
import com.emoniph.witchery.util.TransformCreature;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S08PacketPlayerPosLook;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemGoblinClothes
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelGoblinClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelGoblinClothes modelClothesLegs;

    public ItemGoblinClothes(int armorSlot) {
        super(armorSlot == 0 ? ItemArmor.ArmorMaterial.IRON : ItemArmor.ArmorMaterial.CLOTH, 1, armorSlot);
        this.setMaxDamage(armorSlot == 0 ? ItemArmor.ArmorMaterial.DIAMOND.getDurability(armorSlot) : ItemArmor.ArmorMaterial.IRON.getDurability(armorSlot));
        this.setCreativeTab(WitcheryCreativeTab.INSTANCE);
    }

    public Item setUnlocalizedName(String itemName) {
        ItemUtil.registerItem((Item)this, itemName);
        return super.setUnlocalizedName(itemName);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        EntityPlayer otherPlayer;
        if (!world.isRemote && world.getTotalWorldTime() % 100L == 0L) {
            double R = 8.0;
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(player.posX - 8.0), (double)(player.posY - 8.0), (double)(player.posZ - 8.0), (double)(player.posX + 8.0), (double)(player.posY + 8.0), (double)(player.posZ + 8.0));
            List players = world.getEntitiesWithinAABB(EntityPlayer.class, bb);
            for (Object obj : players) {
                otherPlayer = (EntityPlayer)obj;
                if (player == otherPlayer || (!ItemGoblinClothes.isQuiverWorn(player) || !ItemGoblinClothes.isBeltWorn(otherPlayer)) && (!ItemGoblinClothes.isQuiverWorn(otherPlayer) || !ItemGoblinClothes.isBeltWorn(player))) continue;
                if (player.isPotionActive(Potion.resistance)) {
                    player.removePotionEffect(Potion.resistance.id);
                }
                player.addPotionEffect(new PotionEffect(Potion.resistance.id, 200, 1));
                return;
            }
        }
        if (!world.isRemote && ItemGoblinClothes.isHelmWorn(player) && world.getTotalWorldTime() % 5L == 1L) {
            double R2 = 16.0;
            AxisAlignedBB bb2 = AxisAlignedBB.getBoundingBox((double)(player.posX - 16.0), (double)(player.posY - 16.0), (double)(player.posZ - 16.0), (double)(player.posX + 16.0), (double)(player.posY + 16.0), (double)(player.posZ + 16.0));
            List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, bb2);
            for (Object obj : entities) {
                otherPlayer = (EntityLivingBase)obj;
                if (player == otherPlayer || !this.shouldAffectTarget((EntityLivingBase)player, (EntityLivingBase)otherPlayer)) continue;
                if (otherPlayer instanceof EntityPlayer) {
                    double yawRadians = Math.atan2(otherPlayer.posZ - player.posZ, otherPlayer.posX - player.posZ);
                    double yaw = Math.toDegrees(yawRadians) + 180.0;
                    float rev = ((float)yaw + 90.0f) % 360.0f;
                    if (otherPlayer instanceof EntityPlayerMP) {
                        S08PacketPlayerPosLook packet = new S08PacketPlayerPosLook(otherPlayer.posX, otherPlayer.posY, otherPlayer.posZ, rev, otherPlayer.rotationPitch, false);
                        Witchery.packetPipeline.sendTo((Packet)packet, (EntityPlayer)((EntityPlayerMP)otherPlayer));
                    }
                    if (otherPlayer.isPotionActive(Potion.hunger)) continue;
                    otherPlayer.addPotionEffect(new PotionEffect(Potion.hunger.id, 100, 0));
                    continue;
                }
                if (otherPlayer.isPotionActive(Potion.weakness)) continue;
                otherPlayer.addPotionEffect(new PotionEffect(Potion.weakness.id, 100, 0));
            }
        }
    }

    private boolean shouldAffectTarget(EntityLivingBase player, EntityLivingBase target) {
        ItemStack itemstack = target.getEquipmentInSlot(1);
        if (itemstack != null && itemstack.getItem() == Item.getItemFromBlock((Block)Blocks.pumpkin)) {
            return false;
        }
        Vec3 vec3 = target.getLook(1.0f).normalize();
        Vec3 vec31 = Vec3.createVectorHelper((double)(player.posX - target.posX), (double)(player.boundingBox.minY + (double)(player.height / 2.0f) - (target.posY + (double)target.getEyeHeight())), (double)(player.posZ - target.posZ));
        double d0 = vec31.lengthVector();
        double d1 = vec3.dotProduct(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && target.canEntityBeSeen((Entity)player);
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        return super.hasEffect(stack, pass) || stack.getItem() != Witchery.Items.KOBOLDITE_HELM;
    }

    public boolean hasColor(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int par2) {
        return super.getColorFromItemStack(stack, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return false;
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return 0xFFFFFF;
        }
        return super.getColor(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return this.armorType != 0 ? EnumRarity.epic : EnumRarity.rare;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        String localText;
        if (stack != null && (localText = Witchery.resource(this.getUnlocalizedName() + ".tip")) != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack != null) {
            if (slot == 0) {
                return "witchery:textures/entities/goblinclothes_head" + (type == null ? "" : "_overlay") + ".png";
            }
            if (slot == 2) {
                return "witchery:textures/entities/goblinclothes_legs" + (type == null ? "" : "_overlay") + ".png";
            }
            return "witchery:textures/entities/goblinclothes" + (type == null ? "" : "_overlay") + ".png";
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        int type;
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelGoblinClothes(0.61f);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelGoblinClothes(0.0f);
        }
        ModelGoblinClothes armorModel = null;
        if (stack != null && stack.getItem() instanceof ItemArmor && (armorModel = (type = ((ItemArmor)stack.getItem()).armorType) != 2 ? this.modelClothesChest : this.modelClothesLegs) != null) {
            boolean isVisible = true;
            armorModel.bipedHead.showModel = isVisible && armorSlot == 0;
            armorModel.bipedHeadwear.showModel = isVisible && armorSlot == 0;
            armorModel.bipedBody.showModel = isVisible && (armorSlot == 1 || armorSlot == 2);
            armorModel.bipedRightArm.showModel = isVisible && armorSlot == 1;
            armorModel.bipedLeftArm.showModel = isVisible && armorSlot == 1;
            armorModel.bipedRightLeg.showModel = isVisible && (armorSlot == 3 || armorSlot == 2);
            armorModel.bipedLeftLeg.showModel = isVisible && (armorSlot == 3 || armorSlot == 2);
            armorModel.isSneak = entityLiving.isSneaking();
            armorModel.isRiding = entityLiving.isRiding();
            armorModel.isChild = entityLiving.isChild();
            ItemStack heldStack = entityLiving.getEquipmentInSlot(0);
            armorModel.heldItemRight = heldStack != null ? 1 : 0;
            armorModel.aimedBow = false;
            if (entityLiving instanceof EntityPlayer && heldStack != null && ((EntityPlayer)entityLiving).getItemInUseDuration() > 0) {
                EnumAction enumaction = heldStack.getItemUseAction();
                if (enumaction == EnumAction.block) {
                    armorModel.heldItemRight = 3;
                }
                armorModel.aimedBow = enumaction == EnumAction.bow;
            }
            return armorModel;
        }
        return null;
    }

    private static boolean isQuiverWorn(EntityPlayer player) {
        ItemStack currentArmor = player.getCurrentArmor(2);
        return currentArmor != null && currentArmor.getItem() == Witchery.Items.MOGS_QUIVER;
    }

    private static boolean isHelmWorn(EntityPlayer player) {
        ItemStack currentArmor = player.getCurrentArmor(3);
        return currentArmor != null && currentArmor.getItem() == Witchery.Items.KOBOLDITE_HELM;
    }

    private static boolean isBeltWorn(EntityPlayer player) {
        ItemStack currentArmor = player.getCurrentArmor(1);
        return currentArmor != null && currentArmor.getItem() == Witchery.Items.GULGS_GURDLE;
    }

    public static class EventHooks {
        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent event) {
            if (!event.entityLiving.worldObj.isRemote && !event.isCanceled()) {
                EntityPlayer player;
                Entity source;
                if (event.source.isProjectile()) {
                    boolean mogged;
                    if (event.source.getSourceOfDamage() != null && (mogged = event.source.getSourceOfDamage().getEntityData().getBoolean("WITCMogged"))) {
                        if (event.entityLiving.isAirBorne) {
                            event.ammount *= 3.0f;
                        }
                        if (event.entityLiving.isPotionActive(Potion.weakness)) {
                            event.entityLiving.removePotionEffect(Potion.weakness.id);
                        }
                        event.entityLiving.addPotionEffect(new PotionEffect(Potion.weakness.id, 200, 0));
                    }
                } else if (event.source.getDamageType().equals("player") && (source = event.source.getEntity()) != null && source instanceof EntityPlayer && ItemGoblinClothes.isBeltWorn(player = (EntityPlayer)source) && player.getHeldItem() == null) {
                    event.ammount = 5.0f;
                    final EntityLivingBase entity = event.entityLiving;
                    if (entity instanceof EntityPlayer) {
                        Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(entity.motionX, 1.0, entity.motionZ), (EntityPlayer)entity);
                    } else {
                        ServerTickEvents.TASKS.add(new ServerTickEvents.ServerTickTask(player.worldObj){

                            @Override
                            public boolean process() {
                                if (entity != null && !entity.isDead) {
                                    entity.motionY = 1.0;
                                }
                                return true;
                            }
                        });
                    }
                }
            }
        }

        @SubscribeEvent
        public void onArrowLoose(ArrowLooseEvent event) {
            if (!event.isCanceled() && ItemGoblinClothes.isQuiverWorn(event.entityPlayer)) {
                int l;
                int k;
                float f = (float)event.charge / 20.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                EntityArrow entityarrow = new EntityArrow(event.entityPlayer.worldObj, (EntityLivingBase)event.entityPlayer, f * 3.0f);
                entityarrow.getEntityData().setBoolean("WITCMogged", true);
                if (f == 1.0f) {
                    entityarrow.setIsCritical(true);
                }
                if ((k = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)event.bow)) > 0) {
                    entityarrow.setDamage(entityarrow.getDamage() + (double)k * 0.5 + 0.5);
                }
                if ((l = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)event.bow)) > 0) {
                    entityarrow.setKnockbackStrength(l);
                }
                if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)event.bow) > 0) {
                    entityarrow.setFire(100);
                }
                event.bow.damageItem(1, (EntityLivingBase)event.entityPlayer);
                event.entityPlayer.worldObj.playSoundAtEntity((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                entityarrow.canBePickedUp = 2;
                if (!event.entityPlayer.worldObj.isRemote) {
                    event.entityPlayer.worldObj.spawnEntityInWorld((Entity)entityarrow);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onArrowNock(ArrowNockEvent event) {
            ExtendedPlayer playerEx = ExtendedPlayer.get(event.entityPlayer);
            if (playerEx.getCreatureType() != TransformCreature.NONE) {
                event.setCanceled(true);
                return;
            }
            if (!event.isCanceled() && ItemGoblinClothes.isQuiverWorn(event.entityPlayer)) {
                event.entityPlayer.setItemInUse(event.result, event.result.getItem().getMaxItemUseDuration(event.result));
            }
        }
    }
}

