/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.Shapeshift;
import com.emoniph.witchery.item.ItemBase;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import com.emoniph.witchery.util.TransformCreature;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemMoonCharm
extends ItemBase {
    public ItemMoonCharm() {
        this.autoGenerateTooltip = true;
        this.setMaxStackSize(1);
        this.setMaxDamage(49);
    }

    public boolean getIsRepairable(ItemStack item, ItemStack otherMaterial) {
        return otherMaterial.isItemEqual(new ItemStack(Items.gold_ingot));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.bow;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return TimeUtil.secsToTicks(3);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int countdown) {
        ExtendedPlayer playerEx;
        int level;
        if (!player.worldObj.isRemote && countdown == Math.max(((level = (playerEx = ExtendedPlayer.get(player)).getWerewolfLevel()) - 1) * 4, 1)) {
            if (!ItemMoonCharm.isWolfsbaneActive(player, playerEx) && Shapeshift.INSTANCE.canControlTransform(playerEx)) {
                switch (playerEx.getCreatureType()) {
                    case NONE: {
                        if (player.isSneaking() && Shapeshift.INSTANCE.isWolfmanAllowed(playerEx)) {
                            Shapeshift.INSTANCE.shiftTo(player, TransformCreature.WOLFMAN);
                        } else {
                            Shapeshift.INSTANCE.shiftTo(player, TransformCreature.WOLF);
                        }
                        ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.5, 1.5, 16);
                        break;
                    }
                    case WOLF: {
                        if (player.isSneaking() && Shapeshift.INSTANCE.isWolfmanAllowed(playerEx)) {
                            Shapeshift.INSTANCE.shiftTo(player, TransformCreature.WOLFMAN);
                        } else {
                            Shapeshift.INSTANCE.shiftTo(player, TransformCreature.NONE);
                        }
                        ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.5, 1.5, 16);
                        break;
                    }
                    case WOLFMAN: {
                        if (player.isSneaking()) {
                            Shapeshift.INSTANCE.shiftTo(player, TransformCreature.NONE);
                        } else {
                            Shapeshift.INSTANCE.shiftTo(player, TransformCreature.WOLF);
                        }
                        ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.5, 1.5, 16);
                        break;
                    }
                    default: {
                        ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, (Entity)player, 0.5, 0.5, 8);
                        break;
                    }
                }
            } else {
                ParticleEffect.SMOKE.send(SoundEffect.NOTE_PLING, (Entity)player, 0.5, 0.5, 8);
            }
            stack.damageItem(1, (EntityLivingBase)player);
        }
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public static boolean isWolfsbaneActive(EntityPlayer player, ExtendedPlayer playerEx) {
        PotionEffect potion = player.getActivePotionEffect(Witchery.Potions.WOLFSBANE);
        if (potion == null) {
            return false;
        }
        int amplifier = 1 + Math.max(0, potion.getAmplifier() * 3 - 1);
        return amplifier >= playerEx.getWerewolfLevel();
    }
}

