/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockPoppetShelf;
import com.emoniph.witchery.entity.EntityWitchHunter;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritEffect;
import com.emoniph.witchery.item.ItemBase;
import com.emoniph.witchery.item.ItemHunterClothes;
import com.emoniph.witchery.network.PacketPushTarget;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ItemPoppet
extends ItemBase {
    private final ArrayList<PoppetType> poppetTypes = new ArrayList();
    public final PoppetType unboundPoppet = PoppetType.access$100(new PoppetType(0, "poppet", "Poppet", 0), this.poppetTypes);
    public final PoppetType earthPoppet = PoppetType.access$100(new PoppetType(1, "protectEarth", "Earth Protection Poppet").setDestroyOnUse(true), this.poppetTypes);
    public final PoppetType waterPoppet = PoppetType.access$100(new PoppetType(2, "protectWater", "Water Protection Poppet").setDestroyOnUse(true), this.poppetTypes);
    public final PoppetType firePoppet = PoppetType.access$100(new PoppetType(3, "protectFire", "Fire Protection Poppet").setDestroyOnUse(true), this.poppetTypes);
    public final PoppetType foodPoppet = PoppetType.access$100(new PoppetType(4, "protectStarvation", "Hunger Protection Poppet").setDestroyOnUse(true), this.poppetTypes);
    public final PoppetType toolPoppet = PoppetType.access$100(new PoppetType(5, "protectTool", "Tool Protection Poppet").setDestroyOnUse(true), this.poppetTypes);
    public final PoppetType deathPoppet = PoppetType.access$100(new PoppetType(6, "protectDeath", "Death Protection Poppet", 2).setDestroyOnUse(true), this.poppetTypes);
    public final PoppetType antiVoodooPoppet = PoppetType.access$100(new PoppetType(7, "protectVoodoo", "Voodoo Protection Poppet"), this.poppetTypes);
    public final PoppetType voodooPoppet = PoppetType.access$100(new PoppetType(8, "voodoo", "Voodoo Poppet"), this.poppetTypes);
    public final PoppetType vampiricPoppet = PoppetType.access$100(new PoppetType(9, "vampiric", "Vampiric Poppet", 2), this.poppetTypes);
    public final PoppetType poppetProtectionPoppet = PoppetType.access$100(new PoppetType(10, "protectPoppet", "Poppet Protection", 2), this.poppetTypes);
    public final PoppetType armorPoppet = PoppetType.access$100(new PoppetType(11, "protectArmor", "Armor Protection Poppet").setDestroyOnUse(true), this.poppetTypes);
    private static final String KEY_DAMAGE = "WITCDamage";
    private static final int MAX_DAMAGE = 1000;
    private static final float AUTO_REPAIR_THRESHOLD = 0.1f;

    public ItemPoppet() {
        this.setNoRepair();
        this.setMaxStackSize(1);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.values()[this.poppetTypes.get(itemstack.getItemDamage()).rarity];
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int damage = itemStack.getItemDamage();
        assert (damage >= 0 && damage < this.poppetTypes.size()) : "damage value is too large";
        if (damage >= 0 && damage < this.poppetTypes.size()) {
            return this.poppetTypes.get(damage).getUnlocalizedName();
        }
        return "";
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        if (this.vampiricPoppet.isMatch(itemstack)) {
            String sourceID = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(itemstack, 1);
            String targetID = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(itemstack, 2);
            String localizedName = super.getItemStackDisplayName(itemstack);
            if (!sourceID.isEmpty() && !targetID.isEmpty()) {
                return String.format("%s (%s -> %s)", localizedName, sourceID, targetID);
            }
            if (!sourceID.isEmpty()) {
                return String.format("%s (%s -> ??)", localizedName, sourceID);
            }
            if (!targetID.isEmpty()) {
                return String.format("%s (?? -> %s)", localizedName, targetID);
            }
            return localizedName;
        }
        String entityID = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(itemstack, 1);
        String localizedName = super.getItemStackDisplayName(itemstack);
        return !entityID.isEmpty() ? String.format("%s (%s)", localizedName, entityID) : localizedName;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advTooltips) {
        if (this.vampiricPoppet.isMatch(stack)) {
            String sourceID = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(stack, 1);
            String targetID = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(stack, 2);
            String localizedName = super.getItemStackDisplayName(stack);
            if (!sourceID.isEmpty() && !targetID.isEmpty()) {
                list.add(String.format(Witchery.resource("item.witcheryTaglockKit.boundto"), String.format("%s -> %s", sourceID, targetID)));
            } else if (!sourceID.isEmpty()) {
                list.add(String.format(Witchery.resource("item.witcheryTaglockKit.boundto"), String.format("%s -> ??", sourceID)));
            } else if (!targetID.isEmpty()) {
                list.add(String.format(Witchery.resource("item.witcheryTaglockKit.boundto"), String.format("?? -> %s", targetID)));
            } else {
                list.add(Witchery.resource("item.witcheryTaglockKit.unbound"));
            }
        } else {
            String entityID = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(stack, 1);
            String localizedName = super.getItemStackDisplayName(stack);
            if (entityID != null && !entityID.isEmpty()) {
                list.add(String.format(Witchery.resource("item.witcheryTaglockKit.boundto"), entityID));
            } else {
                list.add(Witchery.resource("item.witcheryTaglockKit.unbound"));
            }
        }
    }

    public void registerIcons(IIconRegister iconRegister) {
        for (PoppetType poppetType : this.poppetTypes) {
            poppetType.registerIcon(iconRegister, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        if (damage < 0 || damage >= this.poppetTypes.size()) {
            damage = 0;
        }
        return this.poppetTypes.get(damage).icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        for (PoppetType poppetType : this.poppetTypes) {
            itemList.add(new ItemStack(item, 1, poppetType.damageValue));
        }
    }

    public void onCreated(ItemStack stack, World world, EntityPlayer player) {
        this.ensureNBT(stack);
        super.onCreated(stack, world, player);
    }

    public boolean isDamageable() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        this.ensureNBT(stack);
        return this.getDamageNBT(stack) > 0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public int getDisplayDamage(ItemStack stack) {
        this.ensureNBT(stack);
        return this.getDamageNBT(stack);
    }

    public int getMaxDamage() {
        return 1000;
    }

    private int getDamageNBT(ItemStack stack) {
        this.ensureNBT(stack);
        return stack.getTagCompound().getInteger(KEY_DAMAGE);
    }

    private void setDamageNBT(IInventory inventory, ItemStack stack, int damage) {
        this.ensureNBT(stack);
        damage = Math.min(damage, 1000);
        stack.getTagCompound().setInteger(KEY_DAMAGE, damage);
        if (damage == 1000) {
            stack.stackSize = 0;
            if (inventory != null) {
                for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                    if (inventory.getStackInSlot(i) != stack) continue;
                    inventory.setInventorySlotContents(i, null);
                    break;
                }
            }
        }
    }

    private void ensureNBT(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (!stack.getTagCompound().hasKey(KEY_DAMAGE)) {
            stack.getTagCompound().setInteger(KEY_DAMAGE, 0);
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityLivingBase boundEntity;
        if (!world.isRemote && this.voodooPoppet.isMatch(stack) && entity.isInsideOfMaterial(Material.water) && entity.getAir() <= 0 && (boundEntity = Witchery.Items.TAGLOCK_KIT.getBoundEntity(world, entity, stack, 1)) != null && boundEntity.isEntityAlive() && !this.voodooProtectionActivated(entity instanceof EntityPlayer ? (EntityPlayer)entity : null, stack, boundEntity, true, false)) {
            boolean damageDisabled;
            if (entity instanceof EntityPlayer) {
                EntityWitchHunter.blackMagicPerformed((EntityPlayer)entity);
            }
            boolean bl = damageDisabled = boundEntity instanceof EntityPlayer && ((EntityPlayer)boundEntity).capabilities.disableDamage;
            if (!(ItemHunterClothes.isMagicalProtectionActive(boundEntity) || boundEntity.canBreatheUnderwater() || boundEntity.isPotionActive(Potion.waterBreathing.id) || damageDisabled)) {
                for (int i = 0; i < 8; ++i) {
                    float f = world.rand.nextFloat() - world.rand.nextFloat();
                    float f1 = world.rand.nextFloat() - world.rand.nextFloat();
                    float f2 = world.rand.nextFloat() - world.rand.nextFloat();
                    world.spawnParticle("bubble", boundEntity.posX + (double)f, boundEntity.posY + (double)f1, boundEntity.posZ + (double)f2, boundEntity.motionX, boundEntity.motionY, boundEntity.motionZ);
                }
                boundEntity.attackEntityFrom(DamageSource.drown, 1.0f);
            }
            boundEntity.extinguish();
        }
        super.onUpdate(stack, world, entity, par4, par5);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer player) {
        if (this.voodooPoppet.isMatch(itemstack)) {
            player.setItemInUse(itemstack, this.getMaxItemUseDuration(itemstack));
        }
        return super.onItemRightClick(itemstack, world, player);
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 80;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int ticks) {
        if (!world.isRemote) {
            EntityLivingBase entity;
            if (this.voodooPoppet.isMatch(itemstack) && (entity = Witchery.Items.TAGLOCK_KIT.getBoundEntity(world, (Entity)player, itemstack, 1)) != null) {
                EntityWitchHunter.blackMagicPerformed(player);
                MovingObjectPosition hitObject = this.getMovingObjectPositionFromPlayer(world, player, true);
                if (hitObject != null && hitObject.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                    Material hitMaterial = world.getBlock(hitObject.blockX, hitObject.blockY, hitObject.blockZ).getMaterial();
                    Block hitBlock = world.getBlock(hitObject.blockX, hitObject.blockY, hitObject.blockZ);
                    if (hitMaterial == Material.lava) {
                        if (!this.voodooProtectionActivated(player, itemstack, entity, true, false) && !ItemHunterClothes.isMagicalProtectionActive((EntityLivingBase)player)) {
                            entity.setFire(10);
                        }
                        this.setDamageNBT((IInventory)player.inventory, itemstack, 1000);
                        world.playSoundAtEntity((Entity)player, "random.fizz", 0.4f, 2.0f + world.rand.nextFloat() * 0.4f);
                        return;
                    }
                }
                if (player.isSneaking()) {
                    if (player.capabilities.isCreativeMode || Witchery.Items.GENERIC.itemBoneNeedle.isItemInInventory(player.inventory)) {
                        PoppetDamageSource damageSource = new PoppetDamageSource(DamageSource.magic, (Entity)player);
                        if (!this.voodooProtectionActivated(player, itemstack, entity, true, false)) {
                            entity.attackEntityFrom((DamageSource)damageSource, 0.5f);
                            if (!player.capabilities.isCreativeMode) {
                                Witchery.Items.GENERIC.itemBoneNeedle.consumeItemFromInventory(player.inventory);
                                this.setDamageNBT((IInventory)player.inventory, itemstack, this.getDamageNBT(itemstack) + 10);
                            }
                        }
                    }
                    return;
                }
                if (!this.voodooProtectionActivated(player, itemstack, entity, true, false) && !ItemHunterClothes.isMagicalProtectionActive((EntityLivingBase)player)) {
                    Vec3 look = player.getLookVec();
                    float scaling = (this.getMaxItemUseDuration(itemstack) - ticks) / 20;
                    double motionX = look.xCoord * 0.9 * (double)scaling;
                    double motionY = look.yCoord * 0.3 * (double)scaling;
                    double motionZ = look.zCoord * 0.9 * (double)scaling;
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer targetPlayer = (EntityPlayer)entity;
                        Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(motionX, motionY, motionZ), targetPlayer);
                    } else {
                        entity.motionX = motionX;
                        entity.motionY = motionY;
                        entity.motionZ = motionZ;
                    }
                    this.setDamageNBT((IInventory)player.inventory, itemstack, this.getDamageNBT(itemstack) + 10);
                }
                return;
            }
            super.onPlayerStoppedUsing(itemstack, world, player, ticks);
        }
    }

    public boolean voodooProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, int strength) {
        if (!(strength <= 1 || targetEntity instanceof EntityPlayer && InfusedSpiritEffect.POPPET_ENHANCEMENT.isNearTo((EntityPlayer)targetEntity))) {
            for (int i = 1; i <= strength; ++i) {
                boolean allowLightning;
                boolean bl = allowLightning = i == strength;
                if (this.voodooProtectionActivated(attackingEntity, voodooStack, targetEntity, allowLightning, false)) continue;
                return false;
            }
        } else {
            return this.voodooProtectionActivated(attackingEntity, voodooStack, targetEntity, true, false);
        }
        return true;
    }

    public boolean voodooProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, boolean allowLightning, boolean onlyBoosted) {
        EntityPlayer targetPlayer;
        ItemStack defenseStack;
        int ITEM_DAMAGE = 350;
        if (targetEntity instanceof EntityPlayer && (defenseStack = ItemPoppet.findBoundPoppetInWorld(this.antiVoodooPoppet, targetPlayer = (EntityPlayer)targetEntity, 350, false, onlyBoosted)) != null && !targetPlayer.worldObj.isRemote) {
            if (attackingEntity != null && voodooStack != null) {
                this.setDamageNBT((IInventory)attackingEntity.inventory, voodooStack, this.getDamageNBT(voodooStack) + 350);
            }
            if (attackingEntity != null && allowLightning) {
                EntityLightningBolt lightning = new EntityLightningBolt(attackingEntity.worldObj, attackingEntity.posX, attackingEntity.posY, attackingEntity.posZ);
                attackingEntity.worldObj.addWeatherEffect((Entity)lightning);
            }
            return true;
        }
        return false;
    }

    public boolean poppetProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, boolean allowLightning) {
        EntityPlayer targetPlayer;
        ItemStack defenseStack;
        int ITEM_DAMAGE = 350;
        if (targetEntity instanceof EntityPlayer && (defenseStack = ItemPoppet.findBoundPoppetInWorld(this.poppetProtectionPoppet, targetPlayer = (EntityPlayer)targetEntity, 350)) != null && !attackingEntity.worldObj.isRemote) {
            if (voodooStack != null) {
                this.setDamageNBT((IInventory)attackingEntity.inventory, voodooStack, this.getDamageNBT(voodooStack) + 350);
            }
            if (attackingEntity != null && allowLightning) {
                EntityLightningBolt lightning = new EntityLightningBolt(attackingEntity.worldObj, attackingEntity.posX, attackingEntity.posY, attackingEntity.posZ);
                attackingEntity.worldObj.addWeatherEffect((Entity)lightning);
            }
            return true;
        }
        return false;
    }

    public void destroyAntiVoodooPoppets(EntityPlayer attackingEntity, EntityLivingBase targetEntity, int poppetsToDestroy) {
        int ITEM_DAMAGE = 1000;
        int MAX = 1000;
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)targetEntity;
            for (int i = 0; i < poppetsToDestroy; ++i) {
                ItemStack defenseStack = ItemPoppet.findBoundPoppetInWorld(this.antiVoodooPoppet, targetPlayer, 1000);
                if (defenseStack != null) continue;
                return;
            }
        }
    }

    public static ItemStack findBoundPoppetInWorld(PoppetType poppetType, EntityPlayer player, int foundItemDamage) {
        return ItemPoppet.findBoundPoppetInWorld(poppetType, player, foundItemDamage, false, false);
    }

    public static ItemStack findBoundPoppetInWorld(PoppetType poppetType, EntityPlayer player, int foundItemDamage, boolean allIndices, boolean onlyBoosted) {
        if (ItemHunterClothes.isFullSetWorn((EntityLivingBase)player, false)) {
            return null;
        }
        int damageValue = poppetType.damageValue;
        ItemStack poppetStack = ItemPoppet.findBoundPoppetInInventory(Witchery.Items.POPPET, damageValue, player, (IInventory)player.inventory, foundItemDamage, allIndices, onlyBoosted);
        if (poppetStack != null) {
            return poppetStack;
        }
        if (!player.worldObj.isRemote && !onlyBoosted) {
            MinecraftServer server = MinecraftServer.getServer();
            for (WorldServer world : server.worldServers) {
                if (Config.instance().restrictPoppetShelvesToVanillaAndSpiritDimensions && world.provider.dimensionId != 0 && world.provider.dimensionId != -1 && world.provider.dimensionId != 1 && world.provider.dimensionId != Config.instance().dimensionDreamID) continue;
                for (Object obj : world.loadedTileEntityList) {
                    if (!(obj instanceof BlockPoppetShelf.TileEntityPoppetShelf) || (poppetStack = ItemPoppet.findBoundPoppetInInventory(Witchery.Items.POPPET, damageValue, player, (IInventory)obj, foundItemDamage, allIndices, false)) == null) continue;
                    return poppetStack;
                }
            }
        }
        return null;
    }

    private static ItemStack findBoundPoppetInInventory(Item item, int damage, EntityPlayer player, IInventory inventory, int foundItemDamage, boolean allIndices, boolean onlyBoosted) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack == null || itemstack.getItem() != item || itemstack.getItemDamage() != damage || !Witchery.Items.TAGLOCK_KIT.containsTaglockForEntity(itemstack, (Entity)player, 1) || allIndices && !Witchery.Items.TAGLOCK_KIT.isTaglockPresent(itemstack, 2)) continue;
            if (onlyBoosted) {
                if (InfusedSpiritEffect.POPPET_ENHANCEMENT.isNearTo(player)) {
                    Witchery.Items.POPPET.poppetTypes.get(damage).applyDamageOnUse(inventory, i, itemstack, foundItemDamage);
                    return itemstack;
                }
                return null;
            }
            Witchery.Items.POPPET.poppetTypes.get(damage).applyDamageOnUse(inventory, i, itemstack, foundItemDamage);
            return itemstack;
        }
        return null;
    }

    public void addDamageToPoppet(ItemStack sourcePoppet, ItemStack destPoppet) {
        this.setDamageNBT(null, destPoppet, this.getDamageNBT(sourcePoppet));
    }

    public void cancelEventIfPoppetFound(EntityPlayer player, PoppetType poppetType, LivingHurtEvent event, boolean heal) {
        this.cancelEventIfPoppetFound(player, poppetType, event, heal, false);
    }

    public void cancelEventIfPoppetFound(EntityPlayer player, PoppetType poppetType, LivingHurtEvent event, boolean heal, boolean onlyHandheld) {
        ItemStack stack = ItemPoppet.findBoundPoppetInWorld(poppetType, player, 1000, false, onlyHandheld);
        if (stack != null) {
            event.setCanceled(true);
            if (heal && player.getHealth() < 10.0f) {
                player.setHealth(10.0f);
            }
            SoundEffect.RANDOM_ORB.playAtPlayer(player.worldObj, player);
        }
    }

    public void checkForArmorProtection(EntityPlayer player) {
        for (int i = 0; i < player.inventory.armorInventory.length; ++i) {
            int maxDamage;
            int repairThreshold;
            int itemDamage;
            ItemStack armorPiece = player.inventory.armorInventory[i];
            if (armorPiece == null || !armorPiece.isItemStackDamageable() || (itemDamage = armorPiece.getItemDamage()) < (repairThreshold = (int)((float)(maxDamage = armorPiece.getMaxDamage()) * 0.9f))) continue;
            ItemPoppet cfr_ignored_0 = Witchery.Items.POPPET;
            ItemStack protectStack = ItemPoppet.findBoundPoppetInWorld(Witchery.Items.POPPET.armorPoppet, player, 1000);
            if (protectStack == null) continue;
            armorPiece.setItemDamage(0);
            player.worldObj.playSoundAtEntity((Entity)player, "random.orb", 0.5f, 0.4f / ((float)player.worldObj.rand.nextDouble() * 0.4f + 0.8f));
        }
    }

    public static class PoppetType {
        public final int damageValue;
        private final String unlocalizedName;
        private final String localizedName;
        private final int rarity;
        @SideOnly(value=Side.CLIENT)
        private IIcon icon;
        private boolean destroyOnUse;

        private static PoppetType register(PoppetType poppetType, ArrayList<PoppetType> poppetTypes) {
            poppetTypes.add(poppetType);
            return poppetType;
        }

        private PoppetType(int damageValue, String unlocalizedName, String localizedName) {
            this(damageValue, unlocalizedName, localizedName, 1);
        }

        private PoppetType(int damageValue, String unlocalizedName, String localizedName, int rarity) {
            this.damageValue = damageValue;
            this.unlocalizedName = unlocalizedName;
            this.localizedName = localizedName;
            this.rarity = rarity;
        }

        public ItemStack createStack() {
            return this.createStack(1);
        }

        public ItemStack createStack(int quantity) {
            return new ItemStack((Item)Witchery.Items.POPPET, quantity, this.damageValue);
        }

        public boolean isMatch(ItemStack itemstack) {
            return itemstack != null && itemstack.getItemDamage() == this.damageValue;
        }

        private String getUnlocalizedName() {
            if (this.damageValue > 0) {
                return String.format("%s.%s", Witchery.Items.POPPET.getUnlocalizedName(), this.unlocalizedName);
            }
            return Witchery.Items.POPPET.getUnlocalizedName();
        }

        @SideOnly(value=Side.CLIENT)
        private PoppetType registerIcon(IIconRegister iconRegister, ItemPoppet item) {
            this.icon = this.unlocalizedName.equals("poppet") ? iconRegister.registerIcon(item.getIconString()) : iconRegister.registerIcon(item.getIconString() + "." + this.unlocalizedName);
            return this;
        }

        public PoppetType setDestroyOnUse(boolean destroyOnUse) {
            this.destroyOnUse = destroyOnUse;
            return this;
        }

        private boolean applyDamageOnUse(IInventory inventory, int i, ItemStack itemstack, int itemDamage) {
            if (this.destroyOnUse) {
                inventory.setInventorySlotContents(i, null);
                itemstack.stackSize = 0;
            } else {
                Witchery.Items.POPPET.setDamageNBT(inventory, itemstack, Witchery.Items.POPPET.getDamageNBT(itemstack) + itemDamage);
            }
            return false;
        }

        static /* synthetic */ PoppetType access$100(PoppetType x0, ArrayList x1) {
            return PoppetType.register(x0, x1);
        }
    }

    public static class PoppetEventHooks {
        @SubscribeEvent
        public void onPlayerInteract(PlayerInteractEvent event) {
            ItemStack protectStack;
            int maxDamage;
            int repairThreshold;
            int itemDamage;
            EntityPlayer player;
            ItemStack heldItem;
            if (!event.entityPlayer.worldObj.isRemote && (heldItem = (player = event.entityPlayer).getHeldItem()) != null && heldItem.isItemStackDamageable() && (itemDamage = heldItem.getItemDamage()) >= (repairThreshold = (int)((float)(maxDamage = heldItem.getMaxDamage()) * 0.9f)) && (protectStack = ItemPoppet.findBoundPoppetInWorld(Witchery.Items.POPPET.toolPoppet, player, 1000)) != null) {
                heldItem.setItemDamage(0);
                player.worldObj.playSoundAtEntity((Entity)player, "random.orb", 0.5f, 0.4f / ((float)player.worldObj.rand.nextDouble() * 0.4f + 0.8f));
            }
        }
    }

    private static class PoppetDamageSource
    extends EntityDamageSource {
        private PoppetDamageSource(DamageSource damageType, Entity source) {
            super(damageType.getDamageType(), source);
            this.setDamageBypassesArmor();
            this.setMagicDamage();
        }
    }
}

