/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.predictions;

import com.emoniph.witchery.entity.EntityOwl;
import com.emoniph.witchery.predictions.PredictionAlwaysForced;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PredictionRescue
extends PredictionAlwaysForced {
    private final Class<? extends EntityLiving> entityClass;

    public PredictionRescue(int id, int itemWeight, double selfFulfillmentProbabilityPerSec, String translationKey, int regularFulfillmentDurationInTicks, double regularFulfillmentProbability, Class<? extends EntityLiving> entityClass) {
        super(id, itemWeight, selfFulfillmentProbabilityPerSec, translationKey, regularFulfillmentDurationInTicks, regularFulfillmentProbability);
        this.entityClass = entityClass;
    }

    @Override
    public boolean checkIfFulfilled(World world, EntityPlayer player, LivingHurtEvent event, boolean isPastDue, boolean veryOld) {
        Entity attackingEntity;
        if (!event.isCanceled() && (attackingEntity = event.source.getEntity()) != null && attackingEntity instanceof EntityLivingBase) {
            try {
                int x = MathHelper.floor_double((double)player.posX);
                int y = MathHelper.floor_double((double)player.posY);
                int z = MathHelper.floor_double((double)player.posZ);
                if (!world.isRemote) {
                    int hy;
                    int ny;
                    int MAX_DISTANCE = 4;
                    int MIN_DISTANCE = 2;
                    int activeRadius = 2;
                    int ax = world.rand.nextInt(activeRadius * 2 + 1);
                    if (ax > activeRadius) {
                        ax += 4;
                    }
                    int nx = x - 4 + ax;
                    int az = world.rand.nextInt(activeRadius * 2 + 1);
                    if (az > activeRadius) {
                        az += 4;
                    }
                    int nz = z - 4 + az;
                    for (ny = y; !world.isAirBlock(nx, ny, nz) && ny < y + 8; ++ny) {
                    }
                    while (world.isAirBlock(nx, ny, nz) && ny > 0) {
                        --ny;
                    }
                    for (hy = 0; world.isAirBlock(nx, ny + hy + 1, nz) && hy < 6; ++hy) {
                    }
                    Constructor<? extends EntityLiving> ctor = this.entityClass.getConstructor(World.class);
                    EntityLiving entity = ctor.newInstance(world);
                    if ((float)hy >= entity.height) {
                        entity.setLocationAndAngles(0.5 + (double)nx, 0.05 + (double)ny + 1.0, 0.5 + (double)nz, 0.0f, 0.0f);
                        world.spawnEntityInWorld((Entity)entity);
                        IEntityLivingData entitylivingData = null;
                        entitylivingData = entity.onSpawnWithEgg(entitylivingData);
                        if (entity instanceof EntityOwl) {
                            ((EntityOwl)entity).setTimeToLive(300);
                        }
                        entity.setAttackTarget((EntityLivingBase)attackingEntity);
                        if (entity instanceof EntityCreature) {
                            ((EntityCreature)entity).setTarget((Entity)((EntityLivingBase)attackingEntity));
                            ((EntityCreature)entity).setRevengeTarget((EntityLivingBase)attackingEntity);
                        }
                        ParticleEffect.SMOKE.send(SoundEffect.NONE, (Entity)entity, 0.5, 2.0, 16);
                        return true;
                    }
                    return false;
                }
            }
            catch (NoSuchMethodException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
            Log.instance().debug(String.format("Prediction for rescue by fulfilled as predicted", attackingEntity.toString()));
            return false;
        }
        return false;
    }
}

