/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.blocks.BlockGrassper;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.ritual.Sacrifice;
import com.emoniph.witchery.ritual.SacrificeItem;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Const;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SacrificeOptionalItem
extends SacrificeItem {
    public SacrificeOptionalItem(ItemStack optionalSacrifice) {
        super(optionalSacrifice);
    }

    @Override
    public void addDescription(StringBuffer sb) {
        for (ItemStack itemstack : this.itemstacks) {
            sb.append("\u00a78> ");
            if (itemstack.getItem() == Items.potionitem) {
                List list = Items.potionitem.getEffects(itemstack);
                if (list != null && !list.isEmpty()) {
                    PotionEffect effect = (PotionEffect)list.get(0);
                    String s = itemstack.getDisplayName();
                    if (effect.getAmplifier() > 0) {
                        s = s + " " + StatCollector.translateToLocal((String)("potion.potency." + effect.getAmplifier())).trim();
                    }
                    if (effect.getDuration() > 20) {
                        s = s + " (" + Potion.getDurationString((PotionEffect)effect) + ")";
                    }
                    sb.append(s);
                } else {
                    sb.append(itemstack.getDisplayName());
                }
            } else {
                sb.append(itemstack.getDisplayName());
            }
            sb.append(" ");
            sb.append(Witchery.resource("witchery.rite.optional"));
            sb.append("\u00a70");
            sb.append(Const.BOOK_NEWLINE);
        }
    }

    @Override
    public boolean isMatch(World world, int posX, int posY, int posZ, int maxDistance, ArrayList<Entity> entities, ArrayList<ItemStack> grassperStacks) {
        boolean found = super.isMatch(world, posX, posY, posZ, maxDistance, entities, grassperStacks);
        return true;
    }

    @Override
    public void addSteps(ArrayList<RitualStep> steps, AxisAlignedBB bounds, int maxDistance) {
        for (ItemStack itemstack : this.itemstacks) {
            steps.add(new StepSacrificeOptionalItem(itemstack, bounds, maxDistance));
        }
    }

    private static class StepSacrificeOptionalItem
    extends SacrificeItem.StepSacrificeItem {
        public StepSacrificeOptionalItem(ItemStack itemstack, AxisAlignedBB bounds, int maxDistance) {
            super(itemstack, bounds, maxDistance);
            this.showMessages = false;
        }

        @Override
        public RitualStep.Result process(World world, int posX, int posY, int posZ, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            if (ticks % 20L != 0L) {
                return RitualStep.Result.STARTING;
            }
            if (!world.isRemote) {
                ItemStack foundItemstack;
                EntityItem entity;
                List itemEntities = world.getEntitiesWithinAABB(EntityItem.class, this.bounds);
                if (Config.instance().traceRites()) {
                    for (Object obj : itemEntities) {
                        entity = (EntityItem)obj;
                        foundItemstack = entity.getEntityItem();
                        Log.instance().traceRite(String.format(" * found: %s, distance: %f", foundItemstack.toString(), Sacrifice.distance(entity.posX, entity.posY, entity.posZ, posX, posY, posZ)));
                    }
                }
                for (Object obj : itemEntities) {
                    entity = (EntityItem)obj;
                    foundItemstack = entity.getEntityItem();
                    if (!SacrificeItem.isItemEqual(this.itemstack, foundItemstack) || !(Sacrifice.distance(entity.posX, entity.posY, entity.posZ, posX, posY, posZ) <= (double)this.maxDistance)) continue;
                    boolean skip = false;
                    if (Witchery.Items.GENERIC.itemWaystoneBound.isMatch(foundItemstack) && !Witchery.Items.GENERIC.copyLocationBinding(world, foundItemstack, ritual)) {
                        skip = true;
                    }
                    if (!skip) {
                        ItemStack sacrificedItemstack = ItemStack.copyItemStack((ItemStack)foundItemstack);
                        sacrificedItemstack.stackSize = 1;
                        ritual.sacrificedItems.add(new RitualStep.SacrificedItem(sacrificedItemstack, new Coord((Entity)entity)));
                        if (foundItemstack.isStackable() && foundItemstack.stackSize > 1) {
                            --foundItemstack.stackSize;
                        } else {
                            world.removeEntity((Entity)entity);
                        }
                    }
                    if (!skip) {
                        ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_POP, (Entity)entity, 0.5, 1.0, 16);
                    } else {
                        ParticleEffect.SMOKE.send(SoundEffect.NOTE_PLING, (Entity)entity, 0.5, 1.0, 16);
                    }
                    return RitualStep.Result.COMPLETED;
                }
                int radius = 5;
                for (int x = posX - 5; x <= posX + 5; ++x) {
                    for (int z = posZ - 5; z <= posZ + 5; ++z) {
                        BlockGrassper.TileEntityGrassper grassper;
                        ItemStack stack;
                        TileEntity tile;
                        Block blockID = world.getBlock(x, posY, z);
                        if (blockID != Witchery.Blocks.GRASSPER || (tile = world.getTileEntity(x, posY, z)) == null || !(tile instanceof BlockGrassper.TileEntityGrassper) || (stack = (grassper = (BlockGrassper.TileEntityGrassper)tile).getStackInSlot(0)) == null || !SacrificeItem.isItemEqual(this.itemstack, stack)) continue;
                        boolean skip = false;
                        if (Witchery.Items.GENERIC.itemWaystoneBound.isMatch(stack) && !Witchery.Items.GENERIC.copyLocationBinding(world, stack, ritual)) {
                            skip = true;
                        }
                        if (!skip) {
                            ItemStack sacrificedItemstack = ItemStack.copyItemStack((ItemStack)stack);
                            sacrificedItemstack.stackSize = 1;
                            ritual.sacrificedItems.add(new RitualStep.SacrificedItem(sacrificedItemstack, new Coord(tile)));
                            if (stack.isStackable() && stack.stackSize > 1) {
                                --stack.stackSize;
                            } else {
                                grassper.setInventorySlotContents(0, null);
                            }
                        }
                        if (!skip) {
                            ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_POP, world, 0.5 + (double)x, 0.8 + (double)posY, 0.5 + (double)z, 0.5, 1.0, 16);
                        } else {
                            ParticleEffect.SMOKE.send(SoundEffect.NOTE_PLING, world, 0.5 + (double)x, 0.8 + (double)posY, 0.5 + (double)z, 0.5, 1.0, 16);
                        }
                        return RitualStep.Result.COMPLETED;
                    }
                }
            }
            return RitualStep.Result.COMPLETED;
        }

        @Override
        public String toString() {
            return String.format("StepSacrificeOptionalItem: %s, maxDistance: %d", this.itemstack.toString(), this.maxDistance);
        }
    }
}

