/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual.rites;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Dye;
import com.emoniph.witchery.util.MutableBlock;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class RiteForestation
extends Rite {
    private final int radius;
    private final int height;
    private final int duration;
    private final Block block;
    private final int metadata;

    public RiteForestation(int radius, int height, int duration, Block block, int protoMeta) {
        this.radius = radius;
        this.height = height;
        this.duration = duration;
        this.block = block;
        this.metadata = protoMeta;
    }

    @Override
    public void addSteps(ArrayList<RitualStep> steps, int intialStage) {
        steps.add(new StepForestation(this, intialStage));
    }

    private static class StepForestation
    extends RitualStep {
        private final RiteForestation rite;
        private int stage = 0;
        private EntityPlayer fakePlayer = null;

        public StepForestation(RiteForestation rite, int initialStage) {
            super(true);
            this.rite = rite;
            this.stage = initialStage;
        }

        @Override
        public int getCurrentStage() {
            return (byte)this.stage;
        }

        public boolean isAirOrReplaceableBlock(World world, int x, int y, int z) {
            Block blockID = world.getBlock(x, y, z);
            if (blockID == Blocks.air) {
                return true;
            }
            Material block = blockID.getMaterial();
            if (block == null) {
                return false;
            }
            if (block.isLiquid()) {
                return false;
            }
            return block.isReplaceable();
        }

        @Override
        public RitualStep.Result process(World world, int posX, int posY, int posZ, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            if (ticks % 20L != 0L) {
                return RitualStep.Result.STARTING;
            }
            if (!world.isRemote) {
                if (++this.stage < this.rite.duration + ritual.covenSize * 5) {
                    int modradius = this.rite.radius + ritual.covenSize * 2;
                    int modradiussq = (modradius + 1) * (modradius + 1);
                    --posY;
                    int x = posX - modradius + world.rand.nextInt(modradius * 2);
                    int z = posZ - modradius + world.rand.nextInt(modradius * 2);
                    int y = -1;
                    if (Coord.distanceSq(x, 1.0, z, posX, 1.0, posZ) > (double)modradiussq && Coord.distanceSq(x = posX - modradius + world.rand.nextInt(modradius * 2), 1.0, z = posZ - modradius + world.rand.nextInt(modradius * 2), posX, 1.0, posZ) > (double)modradiussq) {
                        return RitualStep.Result.UPKEEP;
                    }
                    world.playAuxSFX(2005, posX, posY + 2, posZ, 0);
                    Material material = world.getBlock(x, posY, z).getMaterial();
                    if (material == null || !material.isSolid() || !world.isAirBlock(x, posY + 1, z)) {
                        for (int h = 1; h < this.rite.height; ++h) {
                            material = world.getBlock(x, posY + h, z).getMaterial();
                            if (material != null && material.isSolid() && this.isAirOrReplaceableBlock(world, x, posY + h + 1, z)) {
                                y = posY + h;
                            } else {
                                material = world.getBlock(x, posY - h, z).getMaterial();
                                if (material == null || !material.isSolid() || !this.isAirOrReplaceableBlock(world, x, posY - h + 1, z)) continue;
                                y = posY - h;
                            }
                            break;
                        }
                    } else {
                        y = posY;
                    }
                    if (y != -1) {
                        world.playAuxSFX(2005, x, y + 1, z, 0);
                        this.drawPixel(world, x, z, y, false);
                    }
                    return RitualStep.Result.UPKEEP;
                }
                return RitualStep.Result.COMPLETED;
            }
            return RitualStep.Result.COMPLETED;
        }

        protected void drawPixel(World world, int x, int z, int y, boolean lower) {
            Block blockID = world.getBlock(x, y, z);
            boolean wasGrass = blockID == Blocks.grass;
            Material materialAbove = world.getBlock(x, y + 1, z).getMaterial();
            if (materialAbove != null && !materialAbove.isSolid()) {
                new MutableBlock(this.rite.block, this.rite.metadata).mutate(world, x, y + 1, z, false);
                int count = 0;
                if ((this.fakePlayer == null || this.fakePlayer.worldObj != world) && world instanceof WorldServer) {
                    this.fakePlayer = new FakePlayer((WorldServer)world, new GameProfile(UUID.randomUUID(), "[Minecraft]"));
                }
                ItemDye.applyBonemeal((ItemStack)Dye.BONE_MEAL.createStack(), (World)world, (int)x, (int)(y + 1), (int)z, (EntityPlayer)this.fakePlayer);
                Block saplingBlockID = world.getBlock(x, y + 1, z);
                while ((saplingBlockID == Blocks.sapling || saplingBlockID == Witchery.Blocks.SAPLING) && count++ < 10) {
                    ItemDye.applyBonemeal((ItemStack)Dye.BONE_MEAL.createStack(), (World)world, (int)x, (int)(y + 1), (int)z, (EntityPlayer)this.fakePlayer);
                    saplingBlockID = world.getBlock(x, y + 1, z);
                }
            }
        }
    }
}

