/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual.rites;

import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.entity.EntityToad;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.SoundEffect;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;

public class RiteRainOfToads
extends Rite {
    private final int minRadius;
    private final int maxRadius;
    private final int bolts;

    public RiteRainOfToads(int minRadius, int maxRadius, int bolts) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.bolts = bolts;
    }

    @Override
    public void addSteps(ArrayList<RitualStep> steps, int initialStage) {
        steps.add(new StepRainOfToads(this, initialStage));
    }

    private static class StepRainOfToads
    extends RitualStep {
        private final RiteRainOfToads rite;
        private int stage;

        public StepRainOfToads(RiteRainOfToads rite, int initialStage) {
            super(true);
            this.rite = rite;
            this.stage = initialStage;
        }

        @Override
        public int getCurrentStage() {
            return this.stage;
        }

        @Override
        public RitualStep.Result process(World world, int posX, int posY, int posZ, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            if (ticks % 30L != 0L) {
                return RitualStep.Result.STARTING;
            }
            if (ritual.covenSize < 1) {
                EntityPlayer player = ritual.getInitiatingPlayer(world);
                SoundEffect.NOTE_SNARE.playAt(world, posX, posY, posZ);
                if (player != null) {
                    ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.coventoosmall", new Object[0]);
                }
                return RitualStep.Result.ABORTED_REFUND;
            }
            ++this.stage;
            switch (this.stage) {
                case 1: {
                    this.spawnBolt(world, posX, posY, posZ);
                    return RitualStep.Result.STARTING;
                }
                case 2: {
                    this.spawnBolt(world, posX, posY, posZ);
                    return RitualStep.Result.STARTING;
                }
                case 3: {
                    this.spawnBolt(world, posX, posY, posZ);
                    return RitualStep.Result.STARTING;
                }
                case 4: {
                    if (world instanceof WorldServer && !world.isRaining()) {
                        WorldInfo worldinfo = ((WorldServer)world).getWorldInfo();
                        int i = (300 + world.rand.nextInt(600)) * 20;
                        worldinfo.setRainTime(i);
                        worldinfo.setRaining(true);
                    }
                    this.spawnBolt(world, posX, posY, posZ);
                    return RitualStep.Result.STARTING;
                }
            }
            int activeRadius = this.rite.maxRadius - this.rite.minRadius;
            for (int n = 0; n < world.rand.nextInt(this.rite.bolts) + 8; ++n) {
                int z;
                int y;
                int ax = world.rand.nextInt(activeRadius * 2 + 1);
                if (ax > activeRadius) {
                    ax += this.rite.minRadius * 2;
                }
                int x = posX - this.rite.maxRadius + ax;
                int az = world.rand.nextInt(activeRadius * 2 + 1);
                if (az > activeRadius) {
                    az += this.rite.minRadius * 2;
                }
                if (!world.isAirBlock(x, y = world.getTopSolidOrLiquidBlock(x, z = posZ - this.rite.maxRadius + az), z)) continue;
                EntityToad toad = new EntityToad(world);
                toad.setLocationAndAngles(x, y + 8 + world.rand.nextInt(7), z, 0.0f, 0.0f);
                toad.setTimeToLive(30, true);
                world.spawnEntityInWorld((Entity)toad);
            }
            return this.stage < 200 ? RitualStep.Result.UPKEEP : RitualStep.Result.COMPLETED;
        }

        private void spawnBolt(World world, int posX, int posY, int posZ) {
            int activeRadius = this.rite.maxRadius - this.rite.minRadius;
            int ax = world.rand.nextInt(activeRadius * 2 + 1);
            if (ax > activeRadius) {
                ax += this.rite.minRadius * 2;
            }
            int x = posX - this.rite.maxRadius + ax;
            int az = world.rand.nextInt(activeRadius * 2 + 1);
            if (az > activeRadius) {
                az += this.rite.minRadius * 2;
            }
            int z = posZ - this.rite.maxRadius + az;
            EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)posY, (double)z);
            world.addWeatherEffect((Entity)bolt);
        }
    }
}

