/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.util;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockFetish;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.Coord;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockUtil {
    public static Block registerBlock(Block block, String blockName) {
        int index = blockName.indexOf(58);
        if (index != -1) {
            blockName = blockName.substring(index + 1);
        }
        return GameRegistry.registerBlock((Block)block, (String)blockName);
    }

    public static Block registerBlock(Block block, Class<? extends ItemBlock> clazzItem, String blockName) {
        int index = blockName.indexOf(58);
        if (index != -1) {
            blockName = blockName.substring(index + 1);
        }
        return GameRegistry.registerBlock((Block)block, clazzItem, (String)blockName);
    }

    public static Block getBlock(World world, int posX, int posY, int posZ) {
        return world.getBlock(posX, posY, posZ);
    }

    public static Block getBlock(World world, double posX, double posY, double posZ) {
        int x = MathHelper.floor_double((double)posX);
        int y = MathHelper.floor_double((double)posY);
        int z = MathHelper.floor_double((double)posZ);
        return BlockUtil.getBlock(world, x, y, z);
    }

    public static Block getBlock(World world, MovingObjectPosition mop) {
        return BlockUtil.getBlock(world, mop, false);
    }

    public static boolean isReplaceableBlock(World world, int posX, int posY, int posZ) {
        return BlockUtil.isReplaceableBlock(world, posX, posY, posZ, null);
    }

    public static boolean isReplaceableBlock(World world, int posX, int posY, int posZ, EntityLivingBase player) {
        int meta;
        Block block = BlockUtil.getBlock(world, posX, posY, posZ);
        if (player != null && !BlockProtect.checkModsForBreakOK(world, posX, posY, posZ, block, meta = world.getBlockMetadata(posX, posY, posZ), player)) {
            return false;
        }
        if (block != null) {
            return block.getMaterial().isReplaceable();
        }
        return true;
    }

    public static Material getBlockMaterial(EntityPlayer player) {
        return BlockUtil.getBlockMaterial(player, 0);
    }

    public static Material getBlockMaterial(EntityPlayer player, int yOffset) {
        int posX = MathHelper.floor_double((double)player.posX);
        int posY = MathHelper.floor_double((double)player.boundingBox.minY) + yOffset;
        int posZ = MathHelper.floor_double((double)player.posZ);
        return BlockUtil.getBlockMaterial(player.worldObj, posX, posY, posZ);
    }

    public static Material getBlockMaterial(World world, int posX, int posY, int posZ) {
        Block block = BlockUtil.getBlock(world, posX, posY, posZ);
        if (block != null) {
            return block.getMaterial();
        }
        return Material.air;
    }

    public static Block getBlock(World world, MovingObjectPosition mop, boolean before) {
        if (mop == null) {
            return null;
        }
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (before) {
                int x = mop.blockX + (mop.sideHit == 4 ? -1 : (mop.sideHit == 5 ? 1 : 0));
                int z = mop.blockZ + (mop.sideHit == 2 ? -1 : (mop.sideHit == 3 ? 1 : 0));
                int y = mop.blockY + (mop.sideHit == 0 ? -1 : (mop.sideHit == 1 ? 1 : 0));
                if (mop.sideHit == 1 && !world.getBlock(x, mop.blockY, z).getMaterial().isSolid()) {
                    --y;
                }
                return BlockUtil.getBlock(world, x, y, z);
            }
            return BlockUtil.getBlock(world, mop.blockX, mop.blockY, mop.blockZ);
        }
        int posX = MathHelper.floor_double((double)mop.entityHit.posX);
        int posY = MathHelper.floor_double((double)mop.entityHit.posY) - 1;
        int posZ = MathHelper.floor_double((double)mop.entityHit.posZ);
        return BlockUtil.getBlock(world, posX, posY, posZ);
    }

    public static int[] getBlockCoords(World world, MovingObjectPosition mop, boolean before) {
        if (mop == null) {
            return null;
        }
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (before) {
                int x = mop.blockX + (mop.sideHit == 4 ? -1 : (mop.sideHit == 5 ? 1 : 0));
                int z = mop.blockZ + (mop.sideHit == 2 ? -1 : (mop.sideHit == 3 ? 1 : 0));
                int y = mop.blockY + (mop.sideHit == 0 ? -1 : (mop.sideHit == 1 ? 1 : 0));
                if (mop.sideHit != 1 || !world.getBlock(x, mop.blockY, z).getMaterial().isSolid()) {
                    // empty if block
                }
                return new int[]{x, --y, z};
            }
            return new int[]{mop.blockX, mop.blockY, mop.blockZ};
        }
        int posX = MathHelper.floor_double((double)mop.entityHit.posX);
        int posY = MathHelper.floor_double((double)mop.entityHit.posY) - 1;
        int posZ = MathHelper.floor_double((double)mop.entityHit.posZ);
        return new int[]{posX, posY, posZ};
    }

    public static int getBlockMetadata(World world, int posX, int posY, int posZ) {
        int blockMetadata = world.getBlockMetadata(posX, posY, posZ);
        return blockMetadata;
    }

    public static <T> T getTileEntity(IBlockAccess world, int posX, int posY, int posZ, Class<T> clazz) {
        TileEntity tile = world.getTileEntity(posX, posY, posZ);
        if (tile != null && clazz.isAssignableFrom(tile.getClass())) {
            return clazz.cast(tile);
        }
        return null;
    }

    public static void setBlock(World world, int posX, int posY, int posZ, Block newBlock, int newMetadata, int updateFlags) {
        world.setBlock(posX, posY, posZ, newBlock != null ? newBlock : Blocks.air, newMetadata, updateFlags);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, Block newBlock) {
        world.setBlock(posX, posY, posZ, newBlock != null ? newBlock : Blocks.air);
    }

    public static void setBlock(World world, double posX, double posY, double posZ, Block block) {
        int x = MathHelper.floor_double((double)posX);
        int y = MathHelper.floor_double((double)posY);
        int z = MathHelper.floor_double((double)posZ);
        BlockUtil.setBlock(world, x, y, z, block);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, ItemBlock item, int damage, int updateFlags) {
        world.setBlock(posX, posY, posZ, item.field_150939_a, damage, updateFlags);
    }

    public static void setMetadata(World world, int posX, int posY, int posZ, int newMetadata) {
        BlockUtil.setMetadata(world, posX, posY, posZ, newMetadata, 3);
    }

    public static void setMetadata(World world, int posX, int posY, int posZ, int newMetadata, int updateFlags) {
        world.setBlockMetadataWithNotify(posX, posY, posZ, newMetadata, updateFlags);
    }

    public static void setAirBlock(World world, int x, int y, int z) {
        world.setBlockToAir(x, y, z);
    }

    public static void setAirBlock(World world, int x, int y, int z, int updateFlags) {
        world.setBlock(x, y, z, Blocks.air, 0, updateFlags);
    }

    public static void notifyNeighborsOfBlockChange(World world, int xCoord, int yCoord, int zCoord, Block blockType) {
        world.notifyBlocksOfNeighborChange(xCoord, yCoord, zCoord, blockType);
    }

    public static boolean isImmovableBlock(Block block) {
        return block == Witchery.Blocks.ALTAR || block == Witchery.Blocks.VOID_BRAMBLE;
    }

    public static boolean isImmovableBlock(TileEntity tile) {
        if (tile instanceof BlockFetish.TileEntityFetish) {
            return ((BlockFetish.TileEntityFetish)tile).isSpectral();
        }
        return false;
    }

    public static void setBlockDefaultDirection(World world, int posX, int posY, int posZ) {
        if (!world.isRemote) {
            Block l = world.getBlock(posX, posY, posZ - 1);
            Block i1 = world.getBlock(posX, posY, posZ + 1);
            Block j1 = world.getBlock(posX - 1, posY, posZ);
            Block k1 = world.getBlock(posX + 1, posY, posZ);
            int b0 = 3;
            if (l.isOpaqueCube() && !i1.isOpaqueCube()) {
                b0 = 3;
            }
            if (i1.isOpaqueCube() && !l.isOpaqueCube()) {
                b0 = 2;
            }
            if (j1.isOpaqueCube() && !k1.isOpaqueCube()) {
                b0 = 5;
            }
            if (k1.isOpaqueCube() && !j1.isOpaqueCube()) {
                b0 = 4;
            }
            world.setBlockMetadataWithNotify(posX, posY, posZ, b0, 2);
        }
    }

    public static boolean isSolid(World world, int posX, int posY, int posZ) {
        Block block = BlockUtil.getBlock(world, posX, posY, posZ);
        if (block != null) {
            return !block.getMaterial().isReplaceable();
        }
        return false;
    }

    public static boolean isNormalCube(Block block) {
        return block.getMaterial().blocksMovement() && block.renderAsNormalBlock();
    }

    public static Coord getClosestPlantableBlock(World world, int x, int y, int z, ForgeDirection side, EntityLivingBase entity) {
        return BlockUtil.getClosestPlantableBlock(world, x, y, z, side, entity, false);
    }

    public static Coord getClosestPlantableBlock(World world, int x, int y, int z, ForgeDirection side, EntityLivingBase entity, boolean allowAir) {
        int replaceMeta;
        Block replaceBlock;
        boolean foundBase = false;
        if (!(!BlockUtil.isReplaceableBlock(world, x, y, z) || allowAir && world.isAirBlock(x, y, z))) {
            while (BlockUtil.isReplaceableBlock(world, x, --y, z)) {
            }
            foundBase = true;
        } else if (side == ForgeDirection.UP || side == ForgeDirection.UNKNOWN) {
            foundBase = true;
        } else if (side != ForgeDirection.DOWN && BlockUtil.isReplaceableBlock(world, x += side.offsetX, y, z += side.offsetZ)) {
            boolean bl = foundBase = !BlockUtil.isReplaceableBlock(world, x, --y, z);
        }
        if (foundBase && BlockProtect.checkModsForBreakOK(world, x, y + 1, z, replaceBlock = world.getBlock(x, y + 1, z), replaceMeta = world.getBlockMetadata(x, y + 1, z), entity)) {
            return new Coord(x, y + 1, z);
        }
        return null;
    }

    public static boolean setBlockIfReplaceable(World world, int x, int y, int z, Block block) {
        return BlockUtil.setBlockIfReplaceable(world, x, y, z, block, 0);
    }

    public static boolean setBlockIfReplaceable(World world, int x, int y, int z, Block block, int meta) {
        Block currentBlock = world.getBlock(x, y, z);
        if (currentBlock != null && currentBlock.isReplaceable((IBlockAccess)world, x, y, z)) {
            world.setBlock(x, y, z, block, meta, 3);
            return true;
        }
        return false;
    }
}

