/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.util;

import com.emoniph.witchery.util.BlockPosition;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;

public class EntityPosition {
    public final double x;
    public final double y;
    public final double z;

    public EntityPosition(int x, int y, int z) {
        this(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z);
    }

    public EntityPosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public EntityPosition(BlockPosition position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
    }

    public EntityPosition(Entity entity) {
        this(entity.posX, entity.posY, entity.posZ);
    }

    public EntityPosition(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            this.x = mop.entityHit.posX;
            this.y = mop.entityHit.posY;
            this.z = mop.entityHit.posZ;
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.x = (double)mop.blockX + 0.5;
            this.y = (double)mop.blockY + 0.5;
            this.z = (double)mop.blockZ + 0.5;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }
    }

    public double getDistanceSqToEntity(Entity entity) {
        double d0 = this.x - entity.posX;
        double d1 = this.y - entity.posY;
        double d2 = this.z - entity.posZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public AxisAlignedBB getBounds(double radius) {
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)(this.x - radius), (double)(this.y - radius), (double)(this.z - radius), (double)(this.x + radius), (double)(this.y + radius), (double)(this.z + radius));
        return aabb;
    }

    public boolean occupiedBy(Entity entity) {
        return entity != null && entity.posX == this.x && entity.posY == this.y && entity.posZ == this.z;
    }
}

