/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.util;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.network.PacketParticles;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TargetPointUtil;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum ParticleEffect {
    HUGE_EXPLOSION("hugeexplosion"),
    LARGE_EXPLODE("largeexplode"),
    WATER_BUBBLE("bubble"),
    SUSPENDED("suspended"),
    DEPTH_SUSPEND("depthsuspend"),
    TOWN_AURA("townaura"),
    CRIT("crit"),
    MAGIC_CRIT("magicCrit"),
    SMOKE("smoke"),
    MOB_SPELL("mobSpell"),
    SPELL("spell"),
    INSTANT_SPELL("instantSpell"),
    NOTE("note"),
    PORTAL("portal"),
    ENCHANTMENT_TABLE("enchantmenttable"),
    EXPLODE("explode"),
    FLAME("flame"),
    LAVA("lava"),
    FOOTSTEP("footstep"),
    SPLASH("splash"),
    LARGE_SMOKE("largesmoke"),
    CLOUD("cloud"),
    REDDUST("reddust"),
    SNOWBALL_POOF("snowballpoof"),
    DRIP_WATER("dripWater"),
    DRIP_LAVA("dripLava"),
    SNOW_SHOVEL("snowshovel"),
    SLIME("slime"),
    HEART("heart"),
    ICON_CRACK("iconcrack_"),
    TILE_CRACK("tilecrack_"),
    SPELL_COLORED("spell");

    final String particleID;

    private ParticleEffect(String particleID) {
        this.particleID = particleID;
    }

    public String toString() {
        return this.particleID;
    }

    public void send(SoundEffect sound, World world, double x, double y, double z, double width, double height, int range) {
        this.send(sound, world, x, y, z, width, height, range, 0xFFFFFF);
    }

    public void send(SoundEffect sound, World world, double x, double y, double z, double width, double height, int range, int color) {
        if (!world.isRemote) {
            Witchery.packetPipeline.sendToAllAround(new PacketParticles(this, sound, x, y, z, width, height, color), TargetPointUtil.from(world, x, y, z, range));
        }
    }

    public void send(SoundEffect sound, Entity entity, double width, double height, int range) {
        if (!entity.worldObj.isRemote) {
            Witchery.packetPipeline.sendToAllAround(new PacketParticles(this, sound, entity, width, height), TargetPointUtil.from(entity, range));
        }
    }

    public void send(SoundEffect sound, Entity entity, double width, double height, int range, int color) {
        if (!entity.worldObj.isRemote) {
            Witchery.packetPipeline.sendToAllAround(new PacketParticles(this, sound, entity, width, height, color), TargetPointUtil.from(entity, range));
        }
    }

    public void send(SoundEffect sound, TileEntity tile, double width, double height, int range, int color) {
        if (!tile.getWorldObj().isRemote) {
            Witchery.packetPipeline.sendToAllAround(new PacketParticles(this, sound, 0.5 + (double)tile.xCoord, 0.5 + (double)tile.yCoord, 0.5 + (double)tile.zCoord, width, height, color), TargetPointUtil.from(tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord, range));
        }
    }

    public void send(SoundEffect sound, World world, Coord center, double width, double height, int range) {
        this.send(sound, world, (double)center.x + 0.5, center.y, (double)center.z + 0.5, width, height, range);
    }
}

