/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.util;

import com.emoniph.witchery.Witchery;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class Waypoint {
    public final boolean valid;
    public final double X;
    public final double Y;
    public final double Z;
    public final double D;

    public Waypoint(World world, double homeX, double homeY, double homeZ) {
        this.X = homeX;
        this.Y = homeY;
        this.Z = homeZ;
        this.D = world.provider.dimensionId;
        this.valid = true;
    }

    public Waypoint(World world, ChunkPosition pos) {
        this.X = pos.chunkPosX;
        this.Y = pos.chunkPosY;
        this.Z = pos.chunkPosZ;
        this.D = world.provider.dimensionId;
        this.valid = true;
    }

    public Waypoint(World world, ItemStack stack, double homeX, double homeY, double homeZ) {
        if (Witchery.Items.GENERIC.itemWaystoneBound.isMatch(stack)) {
            NBTTagCompound nbtWaystone = stack.getTagCompound();
            int x = nbtWaystone.getInteger("PosX");
            int z = nbtWaystone.getInteger("PosZ");
            if (world.getChunkFromBlockCoords((int)x, (int)z).isChunkLoaded) {
                this.X = (double)x + 0.5;
                this.Y = (double)nbtWaystone.getInteger("PosY") + 1.5;
                this.Z = (double)z + 0.5;
                this.D = nbtWaystone.getInteger("PosD");
                this.valid = true;
            } else {
                this.X = homeX;
                this.Y = homeY;
                this.Z = homeZ;
                this.D = world.provider.dimensionId;
                this.valid = false;
            }
        } else if (Witchery.Items.GENERIC.itemWaystonePlayerBound.isMatch(stack)) {
            EntityLivingBase entity = Witchery.Items.TAGLOCK_KIT.getBoundEntity(world, null, stack, 1);
            if (entity != null) {
                this.X = entity.posX;
                this.Y = entity.posY + 1.0;
                this.Z = entity.posZ;
                this.D = entity.dimension;
                this.valid = true;
            } else {
                this.X = homeX;
                this.Y = homeY;
                this.Z = homeZ;
                this.D = world.provider.dimensionId;
                this.valid = false;
            }
        } else if (stack != null && stack.getItem() == Witchery.Items.TAGLOCK_KIT) {
            EntityLivingBase entity = Witchery.Items.TAGLOCK_KIT.getBoundEntity(world, null, stack, 1);
            if (entity != null) {
                this.X = entity.posX;
                this.Y = entity.posY + 1.0;
                this.Z = entity.posZ;
                this.D = entity.dimension;
                this.valid = true;
            } else {
                this.X = homeX;
                this.Y = homeY;
                this.Z = homeZ;
                this.D = world.provider.dimensionId;
                this.valid = false;
            }
        } else {
            this.X = homeX;
            this.Y = homeY;
            this.Z = homeZ;
            this.D = world.provider.dimensionId;
            this.valid = false;
        }
    }
}

