/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.worldgen;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.item.ItemDuplicationStaff;
import com.emoniph.witchery.worldgen.WitcheryComponent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public abstract class ComponentClonedStructure
extends WitcheryComponent {
    private ItemDuplicationStaff.Rotation rotation;
    private int witchesSpawned = 0;
    public static final WeightedRandomChestContent[] shackChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.glass_bottle, 0, 1, 1, 10), new WeightedRandomChestContent(Items.bread, 0, 1, 3, 15), new WeightedRandomChestContent(Items.apple, 0, 1, 3, 15), new WeightedRandomChestContent(Items.cooked_fished, 0, 1, 3, 10), new WeightedRandomChestContent(Item.getItemFromBlock((Block)Blocks.sapling), 1, 1, 1, 15), new WeightedRandomChestContent((Item)Witchery.Items.GENERIC, Witchery.Items.GENERIC.itemRowanBerries.damageValue, 1, 2, 10), new WeightedRandomChestContent(Items.iron_shovel, 0, 1, 1, 5), new WeightedRandomChestContent(Items.iron_pickaxe, 0, 1, 1, 5)};
    private boolean hasMadeChest;
    private static final String CHEST_KEY = "WITCShackChest";

    public ComponentClonedStructure() {
    }

    public ComponentClonedStructure(int direction, Random random, int x, int z, int w, int h, int d) {
        super(direction, random, x, z, w, h, d);
        this.rotation = ItemDuplicationStaff.Rotation.values()[direction];
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        BiomeGenBase biom = world.getBiomeGenForCoords(this.getXWithOffset(0, 0), this.getZWithOffset(0, 0));
        int groundAvg = this.calcGroundHeight(world, this.boundingBox);
        if (groundAvg < 0) {
            return true;
        }
        this.boundingBox.offset(0, groundAvg - this.boundingBox.maxY + this.boundingBox.getYSize() - 1, 0);
        if (this.isWaterBelow(world, 0, -1, 0, this.boundingBox) || this.isWaterBelow(world, 0, -1, this.boundingBox.getZSize() - 1, this.boundingBox) || this.isWaterBelow(world, this.boundingBox.getXSize() - 1, -1, 0, this.boundingBox) || this.isWaterBelow(world, this.boundingBox.getXSize() - 1, -1, this.boundingBox.getZSize() - 1, this.boundingBox)) {
            return false;
        }
        BlockGrass groundID = Blocks.grass;
        Block undergroundID = Blocks.dirt;
        if (biom.biomeID == BiomeGenBase.desert.biomeID || biom.biomeID == BiomeGenBase.desertHills.biomeID || biom.biomeID == BiomeGenBase.beach.biomeID) {
            groundID = Blocks.sand;
            undergroundID = Blocks.sand;
        }
        NBTTagCompound nbtSchematic = this.getSchematic(world, random);
        ItemDuplicationStaff.drawSchematicInWorld(world, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ, this.rotation, true, nbtSchematic);
        for (int i = 0; i < this.boundingBox.getXSize(); ++i) {
            for (int j = 0; j < this.boundingBox.getZSize(); ++j) {
                this.func_151554_b(world, undergroundID, 0, j, 0, i, this.boundingBox);
            }
        }
        this.spawnWitches(world, this.boundingBox, this.boundingBox.getXSize() - 3, 1, 3, 1);
        return true;
    }

    protected abstract NBTTagCompound getSchematic(World var1, Random var2);

    private void spawnWitches(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6) {
        if (this.witchesSpawned < par6) {
            int l1;
            int k1;
            int j1;
            for (int i1 = this.witchesSpawned; i1 < par6 && par2StructureBoundingBox.isVecInside(j1 = this.getXWithOffset(par3 + i1, par5), k1 = this.getYWithOffset(par4), l1 = this.getZWithOffset(par3 + i1, par5)); ++i1) {
                ++this.witchesSpawned;
                this.spawnInhabitant(par1World, par2StructureBoundingBox);
            }
        }
    }

    protected abstract void spawnInhabitant(World var1, StructureBoundingBox var2);

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean(CHEST_KEY, this.hasMadeChest);
        par1NBTTagCompound.setInteger("WITCWCount", this.witchesSpawned);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasMadeChest = par1NBTTagCompound.getBoolean(CHEST_KEY);
        this.witchesSpawned = par1NBTTagCompound.hasKey("WITCWCount") ? par1NBTTagCompound.getInteger("WITCWCount") : 0;
    }
}

