/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.worldgen;

import com.emoniph.witchery.entity.EntityCovenWitch;
import com.emoniph.witchery.worldgen.WitcheryComponent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComponentCoven
extends WitcheryComponent {
    public static final int DIM_X = 11;
    public static final int DIM_Y = 4;
    public static final int DIM_Z = 11;
    private int witchesSpawned = 0;

    public ComponentCoven() {
    }

    public ComponentCoven(int direction, Random random, int x, int z) {
        super(direction, random, x, z, 11, 4, 11);
    }

    private void spawnWitches(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6) {
        if (this.witchesSpawned < par6) {
            int l1;
            int k1;
            int j1;
            for (int i1 = this.witchesSpawned; i1 < par6 && par2StructureBoundingBox.isVecInside(j1 = this.getXWithOffset(par3 + i1, par5), k1 = this.getYWithOffset(par4), l1 = this.getZWithOffset(par3 + i1, par5)); ++i1) {
                ++this.witchesSpawned;
                if (par1World.rand.nextInt(10) == 0) continue;
                EntityCovenWitch entityvillager = new EntityCovenWitch(par1World);
                entityvillager.func_110163_bv();
                entityvillager.setLocationAndAngles((double)j1 + 0.5, k1, (double)l1 + 0.5, 0.0f, 0.0f);
                par1World.spawnEntityInWorld((Entity)entityvillager);
            }
        }
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        BlockSand undergroundID;
        BlockSand groundID;
        BiomeGenBase biom = world.getBiomeGenForCoords(this.getXWithOffset(0, 0), this.getZWithOffset(0, 0));
        int groundAvg = this.calcGroundHeight(world, this.boundingBox);
        if (groundAvg < 0) {
            return true;
        }
        this.boundingBox.offset(0, groundAvg - this.boundingBox.maxY + 4 - 1, 0);
        if (this.isWaterBelow(world, 0, -1, 0, this.boundingBox) || this.isWaterBelow(world, 0, -1, 10, this.boundingBox) || this.isWaterBelow(world, 10, -1, 0, this.boundingBox) || this.isWaterBelow(world, 10, -1, 10, this.boundingBox)) {
            return false;
        }
        Block stone = Blocks.cobblestone;
        int stoneMeta = 0;
        Block brick = Blocks.stonebrick;
        int brickMeta = 2;
        if (biom.biomeID == BiomeGenBase.desert.biomeID || biom.biomeID == BiomeGenBase.desertHills.biomeID || biom.biomeID == BiomeGenBase.beach.biomeID) {
            groundID = Blocks.sand;
            undergroundID = Blocks.sand;
            stone = Blocks.sandstone;
            stoneMeta = 0;
            brick = Blocks.sandstone;
            brickMeta = 2;
        } else {
            groundID = Blocks.grass;
            undergroundID = Blocks.dirt;
        }
        this.fillWithAir(world, this.boundingBox, 3, 1, 0, 7, 3, 10);
        this.fillWithAir(world, this.boundingBox, 0, 1, 3, 10, 3, 7);
        this.fillWithAir(world, this.boundingBox, 1, 1, 1, 9, 3, 9);
        this.fillWithBlocks(world, this.boundingBox, 3, 0, 0, 7, 0, 10, (Block)groundID, (Block)groundID, false);
        this.fillWithBlocks(world, this.boundingBox, 0, 0, 3, 10, 0, 7, (Block)groundID, (Block)groundID, false);
        this.fillWithBlocks(world, this.boundingBox, 1, 0, 1, 9, 0, 9, (Block)groundID, (Block)groundID, false);
        int ground = 1;
        Block altarBrick = Blocks.stonebrick;
        int altarMeta = 3;
        this.place(altarBrick, 3, 4, ground, 4, this.boundingBox, world);
        this.place(altarBrick, 3, 4, ground, 5, this.boundingBox, world);
        this.place(altarBrick, 3, 4, ground, 6, this.boundingBox, world);
        this.place(altarBrick, 3, 5, ground, 4, this.boundingBox, world);
        this.place(Blocks.water, 0, 5, ground, 5, this.boundingBox, world);
        this.setDispenser(5, ground - 1, 5, random, world, 5);
        this.place(altarBrick, 3, 5, ground, 6, this.boundingBox, world);
        this.place(altarBrick, 3, 6, ground, 4, this.boundingBox, world);
        this.place(altarBrick, 3, 6, ground, 5, this.boundingBox, world);
        this.place(altarBrick, 3, 6, ground, 6, this.boundingBox, world);
        String mobType = "Witch";
        this.setSpawner(4, ground - 1, 4, "Witch", world);
        this.setSpawner(6, ground - 1, 6, "Witch", world);
        this.place(stone, stoneMeta, 1, ground, 2, this.boundingBox, world);
        this.place(stone, stoneMeta, 2, ground, 1, this.boundingBox, world);
        this.place(Blocks.web, 0, 3, ground, 0, this.boundingBox, world);
        this.place(stone, stoneMeta, 4, ground, 0, this.boundingBox, world);
        this.place(stone, stoneMeta, 6, ground, 0, this.boundingBox, world);
        this.place(stone, stoneMeta, 8, ground, 1, this.boundingBox, world);
        this.place(stone, stoneMeta, 9, ground, 2, this.boundingBox, world);
        this.place(stone, stoneMeta, 10, ground, 4, this.boundingBox, world);
        this.place(stone, stoneMeta, 10, ground, 6, this.boundingBox, world);
        this.place(stone, stoneMeta, 9, ground, 8, this.boundingBox, world);
        this.place(stone, stoneMeta, 8, ground, 9, this.boundingBox, world);
        this.place(stone, stoneMeta, 6, ground, 10, this.boundingBox, world);
        this.place(stone, stoneMeta, 4, ground, 10, this.boundingBox, world);
        this.place(stone, stoneMeta, 2, ground, 9, this.boundingBox, world);
        this.place(stone, stoneMeta, 1, ground, 8, this.boundingBox, world);
        this.place(stone, stoneMeta, 0, ground, 4, this.boundingBox, world);
        this.place(stone, stoneMeta, 0, ground, 6, this.boundingBox, world);
        this.place(brick, brickMeta, 1, ++ground, 2, this.boundingBox, world);
        this.place(brick, brickMeta, 2, ground, 1, this.boundingBox, world);
        this.place(stone, stoneMeta, 4, ground, 0, this.boundingBox, world);
        this.place(stone, stoneMeta, 6, ground, 0, this.boundingBox, world);
        this.place(brick, brickMeta, 8, ground, 1, this.boundingBox, world);
        this.place(brick, brickMeta, 9, ground, 2, this.boundingBox, world);
        this.place(stone, stoneMeta, 10, ground, 4, this.boundingBox, world);
        this.place(stone, stoneMeta, 10, ground, 6, this.boundingBox, world);
        this.place(brick, brickMeta, 9, ground, 8, this.boundingBox, world);
        this.place(brick, brickMeta, 8, ground, 9, this.boundingBox, world);
        this.place(stone, stoneMeta, 6, ground, 10, this.boundingBox, world);
        this.place(stone, stoneMeta, 4, ground, 10, this.boundingBox, world);
        this.place(brick, brickMeta, 2, ground, 9, this.boundingBox, world);
        this.place(brick, brickMeta, 1, ground, 8, this.boundingBox, world);
        this.place(stone, stoneMeta, 0, ground, 4, this.boundingBox, world);
        this.place(stone, stoneMeta, 0, ground, 6, this.boundingBox, world);
        this.place(stone, stoneMeta, 1, ++ground, 2, this.boundingBox, world);
        this.place(stone, stoneMeta, 2, ground, 1, this.boundingBox, world);
        this.place(brick, brickMeta, 3, ground, 1, this.boundingBox, world);
        this.place(brick, brickMeta, 4, ground, 0, this.boundingBox, world);
        this.place(brick, brickMeta, 5, ground, 0, this.boundingBox, world);
        this.place(brick, brickMeta, 6, ground, 0, this.boundingBox, world);
        this.place(brick, brickMeta, 7, ground, 1, this.boundingBox, world);
        this.place(stone, stoneMeta, 8, ground, 1, this.boundingBox, world);
        this.place(stone, stoneMeta, 9, ground, 2, this.boundingBox, world);
        this.place(brick, brickMeta, 9, ground, 3, this.boundingBox, world);
        this.place(brick, brickMeta, 10, ground, 4, this.boundingBox, world);
        this.place(brick, brickMeta, 10, ground, 5, this.boundingBox, world);
        this.place(brick, brickMeta, 10, ground, 6, this.boundingBox, world);
        this.place(brick, brickMeta, 9, ground, 7, this.boundingBox, world);
        this.place(Blocks.web, 0, 10, ground - 1, 7, this.boundingBox, world);
        this.place(stone, stoneMeta, 9, ground, 8, this.boundingBox, world);
        this.place(stone, stoneMeta, 8, ground, 9, this.boundingBox, world);
        this.place(brick, brickMeta, 7, ground, 9, this.boundingBox, world);
        this.place(brick, brickMeta, 6, ground, 10, this.boundingBox, world);
        this.place(brick, brickMeta, 5, ground, 10, this.boundingBox, world);
        this.place(brick, brickMeta, 4, ground, 10, this.boundingBox, world);
        this.place(brick, brickMeta, 3, ground, 9, this.boundingBox, world);
        this.place(stone, stoneMeta, 2, ground, 9, this.boundingBox, world);
        this.place(stone, stoneMeta, 1, ground, 8, this.boundingBox, world);
        this.place(Blocks.web, 0, 0, ground, 7, this.boundingBox, world);
        this.place(brick, brickMeta, 1, ground, 3, this.boundingBox, world);
        this.place(brick, brickMeta, 0, ground, 4, this.boundingBox, world);
        this.place(brick, brickMeta, 0, ground, 5, this.boundingBox, world);
        this.place(brick, brickMeta, 0, ground, 6, this.boundingBox, world);
        this.place(brick, brickMeta, 1, ground, 7, this.boundingBox, world);
        for (int x = 0; x < 11; ++x) {
            for (int z = 0; z < 11; ++z) {
                this.func_151554_b(world, (Block)undergroundID, 0, x, 0, z, this.boundingBox);
                this.clearCurrentPositionBlocksUpwards(world, x, 4, z, this.boundingBox);
            }
        }
        this.spawnWitches(world, this.boundingBox, 7, 1, 4, 1);
        return true;
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("WITCWCount", this.witchesSpawned);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.witchesSpawned = par1NBTTagCompound.hasKey("WITCWCount") ? par1NBTTagCompound.getInteger("WITCWCount") : 0;
    }
}

