/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.worldgen;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityCovenWitch;
import com.emoniph.witchery.worldgen.WitcheryComponent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComponentShack
extends WitcheryComponent {
    public static final int DIM_X = 7;
    public static final int DIM_Y = 10;
    public static final int DIM_Z = 7;
    private int witchesSpawned = 0;
    public static final WeightedRandomChestContent[] shackChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.glass_bottle, 0, 1, 1, 10), new WeightedRandomChestContent(Items.bread, 0, 1, 3, 15), new WeightedRandomChestContent(Items.apple, 0, 1, 3, 15), new WeightedRandomChestContent(Items.cooked_fished, 0, 1, 3, 10), new WeightedRandomChestContent(Item.getItemFromBlock((Block)Blocks.sapling), 1, 1, 1, 15), new WeightedRandomChestContent((Item)Witchery.Items.GENERIC, Witchery.Items.GENERIC.itemRowanBerries.damageValue, 1, 2, 10), new WeightedRandomChestContent(Items.iron_shovel, 0, 1, 1, 5), new WeightedRandomChestContent(Items.iron_pickaxe, 0, 1, 1, 5)};
    private boolean hasMadeChest;
    private static final String CHEST_KEY = "WITCShackChest";

    public ComponentShack() {
    }

    public ComponentShack(int direction, Random random, int x, int z) {
        super(direction, random, x, z, 7, 10, 7);
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        BiomeGenBase biom = world.getBiomeGenForCoords(this.getXWithOffset(0, 0), this.getZWithOffset(0, 0));
        int groundAvg = this.calcGroundHeight(world, this.boundingBox);
        if (groundAvg < 0) {
            return true;
        }
        this.boundingBox.offset(0, groundAvg - this.boundingBox.maxY + 10 - 1, 0);
        if (this.isWaterBelow(world, 0, -1, 0, this.boundingBox) || this.isWaterBelow(world, 0, -1, 6, this.boundingBox) || this.isWaterBelow(world, 6, -1, 0, this.boundingBox) || this.isWaterBelow(world, 6, -1, 6, this.boundingBox)) {
            return false;
        }
        BlockGrass groundID = Blocks.grass;
        Block undergroundID = Blocks.dirt;
        if (biom.biomeID == BiomeGenBase.desert.biomeID || biom.biomeID == BiomeGenBase.desertHills.biomeID || biom.biomeID == BiomeGenBase.beach.biomeID) {
            groundID = Blocks.sand;
            undergroundID = Blocks.sand;
        }
        this.fillWithAir(world, this.boundingBox, 0, 1, 0, 6, 9, 6);
        this.fillWithBlocks(world, this.boundingBox, 0, 0, 1, 6, 1, 5, Blocks.cobblestone, Blocks.cobblestone, false);
        this.fillWithBlocks(world, this.boundingBox, 0, 2, 1, 6, 3, 5, Blocks.planks, Blocks.planks, false);
        this.fillWithAir(world, this.boundingBox, 1, 1, 2, 5, 3, 4);
        this.place(Blocks.log, 1, 0, 1, 1, this.boundingBox, world);
        this.place(Blocks.log, 1, 0, 2, 1, this.boundingBox, world);
        this.place(Blocks.log, 1, 0, 3, 1, this.boundingBox, world);
        this.place(Blocks.log, 1, 0, 1, 5, this.boundingBox, world);
        this.place(Blocks.log, 1, 0, 2, 5, this.boundingBox, world);
        this.place(Blocks.log, 1, 0, 3, 5, this.boundingBox, world);
        this.place(Blocks.log, 1, 6, 1, 1, this.boundingBox, world);
        this.place(Blocks.log, 1, 6, 2, 1, this.boundingBox, world);
        this.place(Blocks.log, 1, 6, 3, 1, this.boundingBox, world);
        this.place(Blocks.log, 1, 6, 1, 5, this.boundingBox, world);
        this.place(Blocks.log, 1, 6, 2, 5, this.boundingBox, world);
        this.place(Blocks.log, 1, 6, 3, 5, this.boundingBox, world);
        int meta = this.coordBaseMode == 3 || this.coordBaseMode == 1 ? 4 : 8;
        this.place(Blocks.log, 1 | meta, 0, 4, 2, this.boundingBox, world);
        this.place(Blocks.log, 1 | meta, 0, 4, 3, this.boundingBox, world);
        this.place(Blocks.log, 1 | meta, 0, 4, 4, this.boundingBox, world);
        this.place(Blocks.log, 1 | meta, 6, 4, 2, this.boundingBox, world);
        this.place(Blocks.log, 1 | meta, 6, 4, 3, this.boundingBox, world);
        this.place(Blocks.log, 1 | meta, 6, 4, 4, this.boundingBox, world);
        for (int x = 0; x < 7; ++x) {
            this.place(Blocks.spruce_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 3), x, 3, 0, this.boundingBox, world);
            this.place(Blocks.spruce_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 3), x, 4, 1, this.boundingBox, world);
            this.place(Blocks.spruce_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 3), x, 5, 2, this.boundingBox, world);
            this.place(Blocks.planks, 1, x, 5, 3, this.boundingBox, world);
            this.place(Blocks.spruce_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 2), x, 5, 4, this.boundingBox, world);
            this.place(Blocks.spruce_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 2), x, 4, 5, this.boundingBox, world);
            this.place(Blocks.spruce_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 2), x, 3, 6, this.boundingBox, world);
        }
        this.place(Blocks.glass_pane, 0, 2, 2, 1, this.boundingBox, world);
        this.place(Blocks.glass_pane, 0, 2, 2, 5, this.boundingBox, world);
        this.place(Blocks.glass_pane, 0, 4, 2, 5, this.boundingBox, world);
        this.place(Blocks.glass_pane, 0, 0, 2, 3, this.boundingBox, world);
        this.place(Blocks.glass_pane, 0, 6, 2, 3, this.boundingBox, world);
        this.placeDoorAtCurrentPosition(world, this.boundingBox, random, 4, 1, 1, this.getMetadataWithOffset(Blocks.wooden_door, 1));
        this.place(Blocks.planks, 2, 1, 1, 4, this.boundingBox, world);
        this.place(Blocks.torch, 0, 1, 2, 4, this.boundingBox, world);
        this.place(Blocks.birch_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 1), 1, 1, 3, this.boundingBox, world);
        this.place(Blocks.birch_stairs, this.getMetadataWithOffset(Blocks.oak_stairs, 3), 2, 1, 4, this.boundingBox, world);
        this.place(Blocks.fence, 0, 2, 1, 3, this.boundingBox, world);
        this.place(Blocks.wooden_pressure_plate, 0, 2, 2, 3, this.boundingBox, world);
        if (!this.hasMadeChest) {
            int kc;
            int ic = this.getYWithOffset(0);
            int jc = this.getXWithOffset(7, 1);
            if (this.boundingBox.isVecInside(jc, ic, kc = this.getZWithOffset(7, 1))) {
                this.hasMadeChest = true;
                this.generateStructureChestContents(world, this.boundingBox, random, 1, 1, 2, shackChestContents, 1 + random.nextInt(3));
            }
        }
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.clearCurrentPositionBlocksUpwards(world, j, 6, i, this.boundingBox);
                this.func_151554_b(world, undergroundID, 0, j, 0, i, this.boundingBox);
            }
        }
        this.spawnWitches(world, this.boundingBox, 4, 1, 3, 1);
        return true;
    }

    private void spawnWitches(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6) {
        if (this.witchesSpawned < par6) {
            int l1;
            int k1;
            int j1;
            for (int i1 = this.witchesSpawned; i1 < par6 && par2StructureBoundingBox.isVecInside(j1 = this.getXWithOffset(par3 + i1, par5), k1 = this.getYWithOffset(par4), l1 = this.getZWithOffset(par3 + i1, par5)); ++i1) {
                ++this.witchesSpawned;
                if (par1World.rand.nextInt(4) == 0) continue;
                EntityCovenWitch entityvillager = new EntityCovenWitch(par1World);
                entityvillager.func_110163_bv();
                entityvillager.setLocationAndAngles((double)j1 + 0.5, k1, (double)l1 + 0.5, 0.0f, 0.0f);
                par1World.spawnEntityInWorld((Entity)entityvillager);
            }
        }
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean(CHEST_KEY, this.hasMadeChest);
        par1NBTTagCompound.setInteger("WITCWCount", this.witchesSpawned);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasMadeChest = par1NBTTagCompound.getBoolean(CHEST_KEY);
        this.witchesSpawned = par1NBTTagCompound.hasKey("WITCWCount") ? par1NBTTagCompound.getInteger("WITCWCount") : 0;
    }
}

